package androidx.appcompat.view.menu;

import android.content.Context;
import android.content.res.Resources;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.appcompat.view.menu.m;
import androidx.appcompat.widget.y1;
import androidx.core.view.r0;
/* loaded from: classes.dex */
final class q extends k implements PopupWindow.OnDismissListener, View.OnKeyListener {
    private static final int B = g.g.abc_popup_menu_item_layout;
    private boolean A;

    /* renamed from: h  reason: collision with root package name */
    private final Context f1274h;

    /* renamed from: i  reason: collision with root package name */
    private final g f1275i;

    /* renamed from: j  reason: collision with root package name */
    private final f f1276j;

    /* renamed from: k  reason: collision with root package name */
    private final boolean f1277k;

    /* renamed from: l  reason: collision with root package name */
    private final int f1278l;

    /* renamed from: m  reason: collision with root package name */
    private final int f1279m;

    /* renamed from: n  reason: collision with root package name */
    private final int f1280n;

    /* renamed from: o  reason: collision with root package name */
    final y1 f1281o;

    /* renamed from: r  reason: collision with root package name */
    private PopupWindow.OnDismissListener f1284r;

    /* renamed from: s  reason: collision with root package name */
    private View f1285s;

    /* renamed from: t  reason: collision with root package name */
    View f1286t;

    /* renamed from: u  reason: collision with root package name */
    private m.a f1287u;

    /* renamed from: v  reason: collision with root package name */
    ViewTreeObserver f1288v;

    /* renamed from: w  reason: collision with root package name */
    private boolean f1289w;

    /* renamed from: x  reason: collision with root package name */
    private boolean f1290x;

    /* renamed from: y  reason: collision with root package name */
    private int f1291y;

    /* renamed from: p  reason: collision with root package name */
    final ViewTreeObserver.OnGlobalLayoutListener f1282p = new a();

    /* renamed from: q  reason: collision with root package name */
    private final View.OnAttachStateChangeListener f1283q = new b();

    /* renamed from: z  reason: collision with root package name */
    private int f1292z = 0;

    /* loaded from: classes.dex */
    class a implements ViewTreeObserver.OnGlobalLayoutListener {
        a() {
        }

        @Override // android.view.ViewTreeObserver.OnGlobalLayoutListener
        public void onGlobalLayout() {
            if (!q.this.a() || q.this.f1281o.w()) {
                return;
            }
            View view = q.this.f1286t;
            if (view == null || !view.isShown()) {
                q.this.dismiss();
            } else {
                q.this.f1281o.show();
            }
        }
    }

    /* loaded from: classes.dex */
    class b implements View.OnAttachStateChangeListener {
        b() {
        }

        @Override // android.view.View.OnAttachStateChangeListener
        public void onViewAttachedToWindow(View view) {
        }

        @Override // android.view.View.OnAttachStateChangeListener
        public void onViewDetachedFromWindow(View view) {
            ViewTreeObserver viewTreeObserver = q.this.f1288v;
            if (viewTreeObserver != null) {
                if (!viewTreeObserver.isAlive()) {
                    q.this.f1288v = view.getViewTreeObserver();
                }
                q qVar = q.this;
                qVar.f1288v.removeGlobalOnLayoutListener(qVar.f1282p);
            }
            view.removeOnAttachStateChangeListener(this);
        }
    }

    public q(Context context, g gVar, View view, int i10, int i11, boolean z9) {
        this.f1274h = context;
        this.f1275i = gVar;
        this.f1277k = z9;
        this.f1276j = new f(gVar, LayoutInflater.from(context), z9, B);
        this.f1279m = i10;
        this.f1280n = i11;
        Resources resources = context.getResources();
        this.f1278l = Math.max(resources.getDisplayMetrics().widthPixels / 2, resources.getDimensionPixelSize(g.d.abc_config_prefDialogWidth));
        this.f1285s = view;
        this.f1281o = new y1(context, null, i10, i11);
        gVar.c(this, context);
    }

    private boolean y() {
        View view;
        if (a()) {
            return true;
        }
        if (this.f1289w || (view = this.f1285s) == null) {
            return false;
        }
        this.f1286t = view;
        this.f1281o.F(this);
        this.f1281o.G(this);
        this.f1281o.E(true);
        View view2 = this.f1286t;
        boolean z9 = this.f1288v == null;
        ViewTreeObserver viewTreeObserver = view2.getViewTreeObserver();
        this.f1288v = viewTreeObserver;
        if (z9) {
            viewTreeObserver.addOnGlobalLayoutListener(this.f1282p);
        }
        view2.addOnAttachStateChangeListener(this.f1283q);
        this.f1281o.y(view2);
        this.f1281o.B(this.f1292z);
        if (!this.f1290x) {
            this.f1291y = k.n(this.f1276j, null, this.f1274h, this.f1278l);
            this.f1290x = true;
        }
        this.f1281o.A(this.f1291y);
        this.f1281o.D(2);
        this.f1281o.C(m());
        this.f1281o.show();
        ListView i10 = this.f1281o.i();
        i10.setOnKeyListener(this);
        if (this.A && this.f1275i.x() != null) {
            FrameLayout frameLayout = (FrameLayout) LayoutInflater.from(this.f1274h).inflate(g.g.abc_popup_menu_header_item_layout, (ViewGroup) i10, false);
            TextView textView = (TextView) frameLayout.findViewById(16908310);
            if (textView != null) {
                textView.setText(this.f1275i.x());
            }
            frameLayout.setEnabled(false);
            i10.addHeaderView(frameLayout, null, false);
        }
        this.f1281o.o(this.f1276j);
        this.f1281o.show();
        return true;
    }

    @Override // androidx.appcompat.view.menu.p
    public boolean a() {
        return !this.f1289w && this.f1281o.a();
    }

    @Override // androidx.appcompat.view.menu.m
    public void b(g gVar, boolean z9) {
        if (gVar != this.f1275i) {
            return;
        }
        dismiss();
        m.a aVar = this.f1287u;
        if (aVar != null) {
            aVar.b(gVar, z9);
        }
    }

    @Override // androidx.appcompat.view.menu.m
    public void c(boolean z9) {
        this.f1290x = false;
        f fVar = this.f1276j;
        if (fVar != null) {
            fVar.notifyDataSetChanged();
        }
    }

    @Override // androidx.appcompat.view.menu.m
    public boolean d() {
        return false;
    }

    @Override // androidx.appcompat.view.menu.p
    public void dismiss() {
        if (a()) {
            this.f1281o.dismiss();
        }
    }

    @Override // androidx.appcompat.view.menu.m
    public void g(m.a aVar) {
        this.f1287u = aVar;
    }

    @Override // androidx.appcompat.view.menu.p
    public ListView i() {
        return this.f1281o.i();
    }

    @Override // androidx.appcompat.view.menu.m
    public boolean j(r rVar) {
        if (rVar.hasVisibleItems()) {
            l lVar = new l(this.f1274h, rVar, this.f1286t, this.f1277k, this.f1279m, this.f1280n);
            lVar.j(this.f1287u);
            lVar.g(k.w(rVar));
            lVar.i(this.f1284r);
            this.f1284r = null;
            this.f1275i.e(false);
            int b10 = this.f1281o.b();
            int n10 = this.f1281o.n();
            if ((Gravity.getAbsoluteGravity(this.f1292z, r0.B(this.f1285s)) & 7) == 5) {
                b10 += this.f1285s.getWidth();
            }
            if (lVar.n(b10, n10)) {
                m.a aVar = this.f1287u;
                if (aVar != null) {
                    aVar.c(rVar);
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    @Override // androidx.appcompat.view.menu.k
    public void k(g gVar) {
    }

    @Override // androidx.appcompat.view.menu.k
    public void o(View view) {
        this.f1285s = view;
    }

    @Override // android.widget.PopupWindow.OnDismissListener
    public void onDismiss() {
        this.f1289w = true;
        this.f1275i.close();
        ViewTreeObserver viewTreeObserver = this.f1288v;
        if (viewTreeObserver != null) {
            if (!viewTreeObserver.isAlive()) {
                this.f1288v = this.f1286t.getViewTreeObserver();
            }
            this.f1288v.removeGlobalOnLayoutListener(this.f1282p);
            this.f1288v = null;
        }
        this.f1286t.removeOnAttachStateChangeListener(this.f1283q);
        PopupWindow.OnDismissListener onDismissListener = this.f1284r;
        if (onDismissListener != null) {
            onDismissListener.onDismiss();
        }
    }

    @Override // android.view.View.OnKeyListener
    public boolean onKey(View view, int i10, KeyEvent keyEvent) {
        if (keyEvent.getAction() == 1 && i10 == 82) {
            dismiss();
            return true;
        }
        return false;
    }

    @Override // androidx.appcompat.view.menu.k
    public void q(boolean z9) {
        this.f1276j.d(z9);
    }

    @Override // androidx.appcompat.view.menu.k
    public void r(int i10) {
        this.f1292z = i10;
    }

    @Override // androidx.appcompat.view.menu.k
    public void s(int i10) {
        this.f1281o.d(i10);
    }

    @Override // androidx.appcompat.view.menu.p
    public void show() {
        if (!y()) {
            throw new IllegalStateException("StandardMenuPopup cannot be used without an anchor");
        }
    }

    @Override // androidx.appcompat.view.menu.k
    public void t(PopupWindow.OnDismissListener onDismissListener) {
        this.f1284r = onDismissListener;
    }

    @Override // androidx.appcompat.view.menu.k
    public void u(boolean z9) {
        this.A = z9;
    }

    @Override // androidx.appcompat.view.menu.k
    public void v(int i10) {
        this.f1281o.k(i10);
    }
}
