package androidx.appcompat.view.menu;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.widget.PopupWindow;
import androidx.appcompat.view.menu.m;
import androidx.core.view.r0;
/* loaded from: classes.dex */
public class l {

    /* renamed from: a  reason: collision with root package name */
    private final Context f1260a;

    /* renamed from: b  reason: collision with root package name */
    private final g f1261b;

    /* renamed from: c  reason: collision with root package name */
    private final boolean f1262c;

    /* renamed from: d  reason: collision with root package name */
    private final int f1263d;

    /* renamed from: e  reason: collision with root package name */
    private final int f1264e;

    /* renamed from: f  reason: collision with root package name */
    private View f1265f;

    /* renamed from: g  reason: collision with root package name */
    private int f1266g;

    /* renamed from: h  reason: collision with root package name */
    private boolean f1267h;

    /* renamed from: i  reason: collision with root package name */
    private m.a f1268i;

    /* renamed from: j  reason: collision with root package name */
    private k f1269j;

    /* renamed from: k  reason: collision with root package name */
    private PopupWindow.OnDismissListener f1270k;

    /* renamed from: l  reason: collision with root package name */
    private final PopupWindow.OnDismissListener f1271l;

    /* loaded from: classes.dex */
    class a implements PopupWindow.OnDismissListener {
        a() {
        }

        @Override // android.widget.PopupWindow.OnDismissListener
        public void onDismiss() {
            l.this.e();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class b {
        static void a(Display display, Point point) {
            display.getRealSize(point);
        }
    }

    public l(Context context, g gVar, View view, boolean z9, int i10) {
        this(context, gVar, view, z9, i10, 0);
    }

    public l(Context context, g gVar, View view, boolean z9, int i10, int i11) {
        this.f1266g = 8388611;
        this.f1271l = new a();
        this.f1260a = context;
        this.f1261b = gVar;
        this.f1265f = view;
        this.f1262c = z9;
        this.f1263d = i10;
        this.f1264e = i11;
    }

    private k a() {
        Display defaultDisplay = ((WindowManager) this.f1260a.getSystemService("window")).getDefaultDisplay();
        Point point = new Point();
        b.a(defaultDisplay, point);
        k dVar = Math.min(point.x, point.y) >= this.f1260a.getResources().getDimensionPixelSize(g.d.abc_cascading_menus_min_smallest_width) ? new d(this.f1260a, this.f1265f, this.f1263d, this.f1264e, this.f1262c) : new q(this.f1260a, this.f1261b, this.f1265f, this.f1263d, this.f1264e, this.f1262c);
        dVar.k(this.f1261b);
        dVar.t(this.f1271l);
        dVar.o(this.f1265f);
        dVar.g(this.f1268i);
        dVar.q(this.f1267h);
        dVar.r(this.f1266g);
        return dVar;
    }

    private void l(int i10, int i11, boolean z9, boolean z10) {
        k c10 = c();
        c10.u(z10);
        if (z9) {
            if ((androidx.core.view.i.b(this.f1266g, r0.B(this.f1265f)) & 7) == 5) {
                i10 -= this.f1265f.getWidth();
            }
            c10.s(i10);
            c10.v(i11);
            int i12 = (int) ((this.f1260a.getResources().getDisplayMetrics().density * 48.0f) / 2.0f);
            c10.p(new Rect(i10 - i12, i11 - i12, i10 + i12, i11 + i12));
        }
        c10.show();
    }

    public void b() {
        if (d()) {
            this.f1269j.dismiss();
        }
    }

    public k c() {
        if (this.f1269j == null) {
            this.f1269j = a();
        }
        return this.f1269j;
    }

    public boolean d() {
        k kVar = this.f1269j;
        return kVar != null && kVar.a();
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void e() {
        this.f1269j = null;
        PopupWindow.OnDismissListener onDismissListener = this.f1270k;
        if (onDismissListener != null) {
            onDismissListener.onDismiss();
        }
    }

    public void f(View view) {
        this.f1265f = view;
    }

    public void g(boolean z9) {
        this.f1267h = z9;
        k kVar = this.f1269j;
        if (kVar != null) {
            kVar.q(z9);
        }
    }

    public void h(int i10) {
        this.f1266g = i10;
    }

    public void i(PopupWindow.OnDismissListener onDismissListener) {
        this.f1270k = onDismissListener;
    }

    public void j(m.a aVar) {
        this.f1268i = aVar;
        k kVar = this.f1269j;
        if (kVar != null) {
            kVar.g(aVar);
        }
    }

    public void k() {
        if (!m()) {
            throw new IllegalStateException("MenuPopupHelper cannot be used without an anchor");
        }
    }

    public boolean m() {
        if (d()) {
            return true;
        }
        if (this.f1265f == null) {
            return false;
        }
        l(0, 0, false, false);
        return true;
    }

    public boolean n(int i10, int i11) {
        if (d()) {
            return true;
        }
        if (this.f1265f == null) {
            return false;
        }
        l(i10, i11, true, true);
        return true;
    }
}
