package androidx.appcompat.view.menu;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.ActionProvider;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.appcompat.view.menu.n;
import androidx.core.view.b;
/* loaded from: classes.dex */
public final class i implements r.b {
    private View A;
    private androidx.core.view.b B;
    private MenuItem.OnActionExpandListener C;
    private ContextMenu.ContextMenuInfo E;

    /* renamed from: a  reason: collision with root package name */
    private final int f1221a;

    /* renamed from: b  reason: collision with root package name */
    private final int f1222b;

    /* renamed from: c  reason: collision with root package name */
    private final int f1223c;

    /* renamed from: d  reason: collision with root package name */
    private final int f1224d;

    /* renamed from: e  reason: collision with root package name */
    private CharSequence f1225e;

    /* renamed from: f  reason: collision with root package name */
    private CharSequence f1226f;

    /* renamed from: g  reason: collision with root package name */
    private Intent f1227g;

    /* renamed from: h  reason: collision with root package name */
    private char f1228h;

    /* renamed from: j  reason: collision with root package name */
    private char f1230j;

    /* renamed from: l  reason: collision with root package name */
    private Drawable f1232l;

    /* renamed from: n  reason: collision with root package name */
    g f1234n;

    /* renamed from: o  reason: collision with root package name */
    private r f1235o;

    /* renamed from: p  reason: collision with root package name */
    private Runnable f1236p;

    /* renamed from: q  reason: collision with root package name */
    private MenuItem.OnMenuItemClickListener f1237q;

    /* renamed from: r  reason: collision with root package name */
    private CharSequence f1238r;

    /* renamed from: s  reason: collision with root package name */
    private CharSequence f1239s;

    /* renamed from: z  reason: collision with root package name */
    private int f1246z;

    /* renamed from: i  reason: collision with root package name */
    private int f1229i = 4096;

    /* renamed from: k  reason: collision with root package name */
    private int f1231k = 4096;

    /* renamed from: m  reason: collision with root package name */
    private int f1233m = 0;

    /* renamed from: t  reason: collision with root package name */
    private ColorStateList f1240t = null;

    /* renamed from: u  reason: collision with root package name */
    private PorterDuff.Mode f1241u = null;

    /* renamed from: v  reason: collision with root package name */
    private boolean f1242v = false;

    /* renamed from: w  reason: collision with root package name */
    private boolean f1243w = false;

    /* renamed from: x  reason: collision with root package name */
    private boolean f1244x = false;

    /* renamed from: y  reason: collision with root package name */
    private int f1245y = 16;
    private boolean D = false;

    /* loaded from: classes.dex */
    class a implements b.InterfaceC0021b {
        a() {
        }

        @Override // androidx.core.view.b.InterfaceC0021b
        public void onActionProviderVisibilityChanged(boolean z9) {
            i iVar = i.this;
            iVar.f1234n.J(iVar);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public i(g gVar, int i10, int i11, int i12, int i13, CharSequence charSequence, int i14) {
        this.f1234n = gVar;
        this.f1221a = i11;
        this.f1222b = i10;
        this.f1223c = i12;
        this.f1224d = i13;
        this.f1225e = charSequence;
        this.f1246z = i14;
    }

    private static void d(StringBuilder sb, int i10, int i11, String str) {
        if ((i10 & i11) == i11) {
            sb.append(str);
        }
    }

    private Drawable e(Drawable drawable) {
        if (drawable != null && this.f1244x && (this.f1242v || this.f1243w)) {
            drawable = androidx.core.graphics.drawable.a.r(drawable).mutate();
            if (this.f1242v) {
                androidx.core.graphics.drawable.a.o(drawable, this.f1240t);
            }
            if (this.f1243w) {
                androidx.core.graphics.drawable.a.p(drawable, this.f1241u);
            }
            this.f1244x = false;
        }
        return drawable;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean A() {
        return this.f1234n.H() && g() != 0;
    }

    public boolean B() {
        return (this.f1246z & 4) == 4;
    }

    @Override // r.b
    public r.b a(androidx.core.view.b bVar) {
        androidx.core.view.b bVar2 = this.B;
        if (bVar2 != null) {
            bVar2.g();
        }
        this.A = null;
        this.B = bVar;
        this.f1234n.K(true);
        androidx.core.view.b bVar3 = this.B;
        if (bVar3 != null) {
            bVar3.i(new a());
        }
        return this;
    }

    @Override // r.b
    public androidx.core.view.b b() {
        return this.B;
    }

    public void c() {
        this.f1234n.I(this);
    }

    @Override // r.b, android.view.MenuItem
    public boolean collapseActionView() {
        if ((this.f1246z & 8) == 0) {
            return false;
        }
        if (this.A == null) {
            return true;
        }
        MenuItem.OnActionExpandListener onActionExpandListener = this.C;
        if (onActionExpandListener == null || onActionExpandListener.onMenuItemActionCollapse(this)) {
            return this.f1234n.f(this);
        }
        return false;
    }

    @Override // r.b, android.view.MenuItem
    public boolean expandActionView() {
        if (j()) {
            MenuItem.OnActionExpandListener onActionExpandListener = this.C;
            if (onActionExpandListener == null || onActionExpandListener.onMenuItemActionExpand(this)) {
                return this.f1234n.k(this);
            }
            return false;
        }
        return false;
    }

    public int f() {
        return this.f1224d;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public char g() {
        return this.f1234n.G() ? this.f1230j : this.f1228h;
    }

    @Override // android.view.MenuItem
    public ActionProvider getActionProvider() {
        throw new UnsupportedOperationException("This is not supported, use MenuItemCompat.getActionProvider()");
    }

    @Override // r.b, android.view.MenuItem
    public View getActionView() {
        View view = this.A;
        if (view != null) {
            return view;
        }
        androidx.core.view.b bVar = this.B;
        if (bVar != null) {
            View c10 = bVar.c(this);
            this.A = c10;
            return c10;
        }
        return null;
    }

    @Override // r.b, android.view.MenuItem
    public int getAlphabeticModifiers() {
        return this.f1231k;
    }

    @Override // android.view.MenuItem
    public char getAlphabeticShortcut() {
        return this.f1230j;
    }

    @Override // r.b, android.view.MenuItem
    public CharSequence getContentDescription() {
        return this.f1238r;
    }

    @Override // android.view.MenuItem
    public int getGroupId() {
        return this.f1222b;
    }

    @Override // android.view.MenuItem
    public Drawable getIcon() {
        Drawable drawable = this.f1232l;
        if (drawable != null) {
            return e(drawable);
        }
        if (this.f1233m != 0) {
            Drawable b10 = h.a.b(this.f1234n.u(), this.f1233m);
            this.f1233m = 0;
            this.f1232l = b10;
            return e(b10);
        }
        return null;
    }

    @Override // r.b, android.view.MenuItem
    public ColorStateList getIconTintList() {
        return this.f1240t;
    }

    @Override // r.b, android.view.MenuItem
    public PorterDuff.Mode getIconTintMode() {
        return this.f1241u;
    }

    @Override // android.view.MenuItem
    public Intent getIntent() {
        return this.f1227g;
    }

    @Override // android.view.MenuItem
    public int getItemId() {
        return this.f1221a;
    }

    @Override // android.view.MenuItem
    public ContextMenu.ContextMenuInfo getMenuInfo() {
        return this.E;
    }

    @Override // r.b, android.view.MenuItem
    public int getNumericModifiers() {
        return this.f1229i;
    }

    @Override // android.view.MenuItem
    public char getNumericShortcut() {
        return this.f1228h;
    }

    @Override // android.view.MenuItem
    public int getOrder() {
        return this.f1223c;
    }

    @Override // android.view.MenuItem
    public SubMenu getSubMenu() {
        return this.f1235o;
    }

    @Override // android.view.MenuItem
    public CharSequence getTitle() {
        return this.f1225e;
    }

    @Override // android.view.MenuItem
    public CharSequence getTitleCondensed() {
        CharSequence charSequence = this.f1226f;
        return charSequence != null ? charSequence : this.f1225e;
    }

    @Override // r.b, android.view.MenuItem
    public CharSequence getTooltipText() {
        return this.f1239s;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public String h() {
        int i10;
        char g10 = g();
        if (g10 == 0) {
            return "";
        }
        Resources resources = this.f1234n.u().getResources();
        StringBuilder sb = new StringBuilder();
        if (ViewConfiguration.get(this.f1234n.u()).hasPermanentMenuKey()) {
            sb.append(resources.getString(g.h.abc_prepend_shortcut_label));
        }
        int i11 = this.f1234n.G() ? this.f1231k : this.f1229i;
        d(sb, i11, 65536, resources.getString(g.h.abc_menu_meta_shortcut_label));
        d(sb, i11, 4096, resources.getString(g.h.abc_menu_ctrl_shortcut_label));
        d(sb, i11, 2, resources.getString(g.h.abc_menu_alt_shortcut_label));
        d(sb, i11, 1, resources.getString(g.h.abc_menu_shift_shortcut_label));
        d(sb, i11, 4, resources.getString(g.h.abc_menu_sym_shortcut_label));
        d(sb, i11, 8, resources.getString(g.h.abc_menu_function_shortcut_label));
        if (g10 == '\b') {
            i10 = g.h.abc_menu_delete_shortcut_label;
        } else if (g10 == '\n') {
            i10 = g.h.abc_menu_enter_shortcut_label;
        } else if (g10 != ' ') {
            sb.append(g10);
            return sb.toString();
        } else {
            i10 = g.h.abc_menu_space_shortcut_label;
        }
        sb.append(resources.getString(i10));
        return sb.toString();
    }

    @Override // android.view.MenuItem
    public boolean hasSubMenu() {
        return this.f1235o != null;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public CharSequence i(n.a aVar) {
        return (aVar == null || !aVar.c()) ? getTitle() : getTitleCondensed();
    }

    @Override // r.b, android.view.MenuItem
    public boolean isActionViewExpanded() {
        return this.D;
    }

    @Override // android.view.MenuItem
    public boolean isCheckable() {
        return (this.f1245y & 1) == 1;
    }

    @Override // android.view.MenuItem
    public boolean isChecked() {
        return (this.f1245y & 2) == 2;
    }

    @Override // android.view.MenuItem
    public boolean isEnabled() {
        return (this.f1245y & 16) != 0;
    }

    @Override // android.view.MenuItem
    public boolean isVisible() {
        androidx.core.view.b bVar = this.B;
        return (bVar == null || !bVar.f()) ? (this.f1245y & 8) == 0 : (this.f1245y & 8) == 0 && this.B.b();
    }

    public boolean j() {
        androidx.core.view.b bVar;
        if ((this.f1246z & 8) != 0) {
            if (this.A == null && (bVar = this.B) != null) {
                this.A = bVar.c(this);
            }
            return this.A != null;
        }
        return false;
    }

    public boolean k() {
        MenuItem.OnMenuItemClickListener onMenuItemClickListener = this.f1237q;
        if (onMenuItemClickListener == null || !onMenuItemClickListener.onMenuItemClick(this)) {
            g gVar = this.f1234n;
            if (gVar.h(gVar, this)) {
                return true;
            }
            Runnable runnable = this.f1236p;
            if (runnable != null) {
                runnable.run();
                return true;
            }
            if (this.f1227g != null) {
                try {
                    this.f1234n.u().startActivity(this.f1227g);
                    return true;
                } catch (ActivityNotFoundException e10) {
                    Log.e("MenuItemImpl", "Can't find activity to handle intent; ignoring", e10);
                }
            }
            androidx.core.view.b bVar = this.B;
            return bVar != null && bVar.d();
        }
        return true;
    }

    public boolean l() {
        return (this.f1245y & 32) == 32;
    }

    public boolean m() {
        return (this.f1245y & 4) != 0;
    }

    public boolean n() {
        return (this.f1246z & 1) == 1;
    }

    public boolean o() {
        return (this.f1246z & 2) == 2;
    }

    @Override // r.b, android.view.MenuItem
    /* renamed from: p */
    public r.b setActionView(int i10) {
        Context u9 = this.f1234n.u();
        setActionView(LayoutInflater.from(u9).inflate(i10, (ViewGroup) new LinearLayout(u9), false));
        return this;
    }

    @Override // r.b, android.view.MenuItem
    /* renamed from: q */
    public r.b setActionView(View view) {
        int i10;
        this.A = view;
        this.B = null;
        if (view != null && view.getId() == -1 && (i10 = this.f1221a) > 0) {
            view.setId(i10);
        }
        this.f1234n.I(this);
        return this;
    }

    public void r(boolean z9) {
        this.D = z9;
        this.f1234n.K(false);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void s(boolean z9) {
        int i10 = this.f1245y;
        int i11 = (z9 ? 2 : 0) | (i10 & (-3));
        this.f1245y = i11;
        if (i10 != i11) {
            this.f1234n.K(false);
        }
    }

    @Override // android.view.MenuItem
    public MenuItem setActionProvider(ActionProvider actionProvider) {
        throw new UnsupportedOperationException("This is not supported, use MenuItemCompat.setActionProvider()");
    }

    @Override // android.view.MenuItem
    public MenuItem setAlphabeticShortcut(char c10) {
        if (this.f1230j == c10) {
            return this;
        }
        this.f1230j = Character.toLowerCase(c10);
        this.f1234n.K(false);
        return this;
    }

    @Override // r.b, android.view.MenuItem
    public MenuItem setAlphabeticShortcut(char c10, int i10) {
        if (this.f1230j == c10 && this.f1231k == i10) {
            return this;
        }
        this.f1230j = Character.toLowerCase(c10);
        this.f1231k = KeyEvent.normalizeMetaState(i10);
        this.f1234n.K(false);
        return this;
    }

    @Override // android.view.MenuItem
    public MenuItem setCheckable(boolean z9) {
        int i10 = this.f1245y;
        int i11 = (z9 ? 1 : 0) | (i10 & (-2));
        this.f1245y = i11;
        if (i10 != i11) {
            this.f1234n.K(false);
        }
        return this;
    }

    @Override // android.view.MenuItem
    public MenuItem setChecked(boolean z9) {
        if ((this.f1245y & 4) != 0) {
            this.f1234n.T(this);
        } else {
            s(z9);
        }
        return this;
    }

    @Override // r.b, android.view.MenuItem
    public r.b setContentDescription(CharSequence charSequence) {
        this.f1238r = charSequence;
        this.f1234n.K(false);
        return this;
    }

    @Override // android.view.MenuItem
    public MenuItem setEnabled(boolean z9) {
        this.f1245y = z9 ? this.f1245y | 16 : this.f1245y & (-17);
        this.f1234n.K(false);
        return this;
    }

    @Override // android.view.MenuItem
    public MenuItem setIcon(int i10) {
        this.f1232l = null;
        this.f1233m = i10;
        this.f1244x = true;
        this.f1234n.K(false);
        return this;
    }

    @Override // android.view.MenuItem
    public MenuItem setIcon(Drawable drawable) {
        this.f1233m = 0;
        this.f1232l = drawable;
        this.f1244x = true;
        this.f1234n.K(false);
        return this;
    }

    @Override // r.b, android.view.MenuItem
    public MenuItem setIconTintList(ColorStateList colorStateList) {
        this.f1240t = colorStateList;
        this.f1242v = true;
        this.f1244x = true;
        this.f1234n.K(false);
        return this;
    }

    @Override // r.b, android.view.MenuItem
    public MenuItem setIconTintMode(PorterDuff.Mode mode) {
        this.f1241u = mode;
        this.f1243w = true;
        this.f1244x = true;
        this.f1234n.K(false);
        return this;
    }

    @Override // android.view.MenuItem
    public MenuItem setIntent(Intent intent) {
        this.f1227g = intent;
        return this;
    }

    @Override // android.view.MenuItem
    public MenuItem setNumericShortcut(char c10) {
        if (this.f1228h == c10) {
            return this;
        }
        this.f1228h = c10;
        this.f1234n.K(false);
        return this;
    }

    @Override // r.b, android.view.MenuItem
    public MenuItem setNumericShortcut(char c10, int i10) {
        if (this.f1228h == c10 && this.f1229i == i10) {
            return this;
        }
        this.f1228h = c10;
        this.f1229i = KeyEvent.normalizeMetaState(i10);
        this.f1234n.K(false);
        return this;
    }

    @Override // android.view.MenuItem
    public MenuItem setOnActionExpandListener(MenuItem.OnActionExpandListener onActionExpandListener) {
        this.C = onActionExpandListener;
        return this;
    }

    @Override // android.view.MenuItem
    public MenuItem setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener onMenuItemClickListener) {
        this.f1237q = onMenuItemClickListener;
        return this;
    }

    @Override // android.view.MenuItem
    public MenuItem setShortcut(char c10, char c11) {
        this.f1228h = c10;
        this.f1230j = Character.toLowerCase(c11);
        this.f1234n.K(false);
        return this;
    }

    @Override // r.b, android.view.MenuItem
    public MenuItem setShortcut(char c10, char c11, int i10, int i11) {
        this.f1228h = c10;
        this.f1229i = KeyEvent.normalizeMetaState(i10);
        this.f1230j = Character.toLowerCase(c11);
        this.f1231k = KeyEvent.normalizeMetaState(i11);
        this.f1234n.K(false);
        return this;
    }

    @Override // r.b, android.view.MenuItem
    public void setShowAsAction(int i10) {
        int i11 = i10 & 3;
        if (i11 != 0 && i11 != 1 && i11 != 2) {
            throw new IllegalArgumentException("SHOW_AS_ACTION_ALWAYS, SHOW_AS_ACTION_IF_ROOM, and SHOW_AS_ACTION_NEVER are mutually exclusive.");
        }
        this.f1246z = i10;
        this.f1234n.I(this);
    }

    @Override // android.view.MenuItem
    public MenuItem setTitle(int i10) {
        return setTitle(this.f1234n.u().getString(i10));
    }

    @Override // android.view.MenuItem
    public MenuItem setTitle(CharSequence charSequence) {
        this.f1225e = charSequence;
        this.f1234n.K(false);
        r rVar = this.f1235o;
        if (rVar != null) {
            rVar.setHeaderTitle(charSequence);
        }
        return this;
    }

    @Override // android.view.MenuItem
    public MenuItem setTitleCondensed(CharSequence charSequence) {
        this.f1226f = charSequence;
        this.f1234n.K(false);
        return this;
    }

    @Override // r.b, android.view.MenuItem
    public r.b setTooltipText(CharSequence charSequence) {
        this.f1239s = charSequence;
        this.f1234n.K(false);
        return this;
    }

    @Override // android.view.MenuItem
    public MenuItem setVisible(boolean z9) {
        if (y(z9)) {
            this.f1234n.J(this);
        }
        return this;
    }

    public void t(boolean z9) {
        this.f1245y = (z9 ? 4 : 0) | (this.f1245y & (-5));
    }

    public String toString() {
        CharSequence charSequence = this.f1225e;
        if (charSequence != null) {
            return charSequence.toString();
        }
        return null;
    }

    public void u(boolean z9) {
        this.f1245y = z9 ? this.f1245y | 32 : this.f1245y & (-33);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void v(ContextMenu.ContextMenuInfo contextMenuInfo) {
        this.E = contextMenuInfo;
    }

    @Override // r.b, android.view.MenuItem
    /* renamed from: w */
    public r.b setShowAsActionFlags(int i10) {
        setShowAsAction(i10);
        return this;
    }

    public void x(r rVar) {
        this.f1235o = rVar;
        rVar.setHeaderTitle(getTitle());
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean y(boolean z9) {
        int i10 = this.f1245y;
        int i11 = (z9 ? 0 : 8) | (i10 & (-9));
        this.f1245y = i11;
        return i10 != i11;
    }

    public boolean z() {
        return this.f1234n.A();
    }
}
