package androidx.appcompat.view.menu;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.core.view.o2;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
/* loaded from: classes.dex */
public class g implements r.a {
    private static final int[] A = {1, 4, 5, 3, 2, 0};

    /* renamed from: a  reason: collision with root package name */
    private final Context f1191a;

    /* renamed from: b  reason: collision with root package name */
    private final Resources f1192b;

    /* renamed from: c  reason: collision with root package name */
    private boolean f1193c;

    /* renamed from: d  reason: collision with root package name */
    private boolean f1194d;

    /* renamed from: e  reason: collision with root package name */
    private a f1195e;

    /* renamed from: m  reason: collision with root package name */
    private ContextMenu.ContextMenuInfo f1203m;

    /* renamed from: n  reason: collision with root package name */
    CharSequence f1204n;

    /* renamed from: o  reason: collision with root package name */
    Drawable f1205o;

    /* renamed from: p  reason: collision with root package name */
    View f1206p;

    /* renamed from: x  reason: collision with root package name */
    private i f1214x;

    /* renamed from: z  reason: collision with root package name */
    private boolean f1216z;

    /* renamed from: l  reason: collision with root package name */
    private int f1202l = 0;

    /* renamed from: q  reason: collision with root package name */
    private boolean f1207q = false;

    /* renamed from: r  reason: collision with root package name */
    private boolean f1208r = false;

    /* renamed from: s  reason: collision with root package name */
    private boolean f1209s = false;

    /* renamed from: t  reason: collision with root package name */
    private boolean f1210t = false;

    /* renamed from: u  reason: collision with root package name */
    private boolean f1211u = false;

    /* renamed from: v  reason: collision with root package name */
    private ArrayList f1212v = new ArrayList();

    /* renamed from: w  reason: collision with root package name */
    private CopyOnWriteArrayList f1213w = new CopyOnWriteArrayList();

    /* renamed from: y  reason: collision with root package name */
    private boolean f1215y = false;

    /* renamed from: f  reason: collision with root package name */
    private ArrayList f1196f = new ArrayList();

    /* renamed from: g  reason: collision with root package name */
    private ArrayList f1197g = new ArrayList();

    /* renamed from: h  reason: collision with root package name */
    private boolean f1198h = true;

    /* renamed from: i  reason: collision with root package name */
    private ArrayList f1199i = new ArrayList();

    /* renamed from: j  reason: collision with root package name */
    private ArrayList f1200j = new ArrayList();

    /* renamed from: k  reason: collision with root package name */
    private boolean f1201k = true;

    /* loaded from: classes.dex */
    public interface a {
        boolean a(g gVar, MenuItem menuItem);

        void b(g gVar);
    }

    /* loaded from: classes.dex */
    public interface b {
        boolean a(i iVar);
    }

    public g(Context context) {
        this.f1191a = context;
        this.f1192b = context.getResources();
        b0(true);
    }

    private static int B(int i10) {
        int i11 = ((-65536) & i10) >> 16;
        if (i11 >= 0) {
            int[] iArr = A;
            if (i11 < iArr.length) {
                return (i10 & 65535) | (iArr[i11] << 16);
            }
        }
        throw new IllegalArgumentException("order does not contain a valid category.");
    }

    private void N(int i10, boolean z9) {
        if (i10 < 0 || i10 >= this.f1196f.size()) {
            return;
        }
        this.f1196f.remove(i10);
        if (z9) {
            K(true);
        }
    }

    private void W(int i10, CharSequence charSequence, int i11, Drawable drawable, View view) {
        Resources C = C();
        if (view != null) {
            this.f1206p = view;
            this.f1204n = null;
            this.f1205o = null;
        } else {
            if (i10 > 0) {
                this.f1204n = C.getText(i10);
            } else if (charSequence != null) {
                this.f1204n = charSequence;
            }
            if (i11 > 0) {
                this.f1205o = androidx.core.content.a.d(u(), i11);
            } else if (drawable != null) {
                this.f1205o = drawable;
            }
            this.f1206p = null;
        }
        K(false);
    }

    private void b0(boolean z9) {
        boolean z10 = true;
        this.f1194d = (z9 && this.f1192b.getConfiguration().keyboard != 1 && o2.l(ViewConfiguration.get(this.f1191a), this.f1191a)) ? false : false;
    }

    private i g(int i10, int i11, int i12, int i13, CharSequence charSequence, int i14) {
        return new i(this, i10, i11, i12, i13, charSequence, i14);
    }

    private void i(boolean z9) {
        if (this.f1213w.isEmpty()) {
            return;
        }
        d0();
        Iterator it = this.f1213w.iterator();
        while (it.hasNext()) {
            WeakReference weakReference = (WeakReference) it.next();
            m mVar = (m) weakReference.get();
            if (mVar == null) {
                this.f1213w.remove(weakReference);
            } else {
                mVar.c(z9);
            }
        }
        c0();
    }

    private boolean j(r rVar, m mVar) {
        if (this.f1213w.isEmpty()) {
            return false;
        }
        boolean j10 = mVar != null ? mVar.j(rVar) : false;
        Iterator it = this.f1213w.iterator();
        while (it.hasNext()) {
            WeakReference weakReference = (WeakReference) it.next();
            m mVar2 = (m) weakReference.get();
            if (mVar2 == null) {
                this.f1213w.remove(weakReference);
            } else if (!j10) {
                j10 = mVar2.j(rVar);
            }
        }
        return j10;
    }

    private static int n(ArrayList arrayList, int i10) {
        for (int size = arrayList.size() - 1; size >= 0; size--) {
            if (((i) arrayList.get(size)).f() <= i10) {
                return size + 1;
            }
        }
        return 0;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean A() {
        return this.f1210t;
    }

    Resources C() {
        return this.f1192b;
    }

    public g D() {
        return this;
    }

    public ArrayList E() {
        if (this.f1198h) {
            this.f1197g.clear();
            int size = this.f1196f.size();
            for (int i10 = 0; i10 < size; i10++) {
                i iVar = (i) this.f1196f.get(i10);
                if (iVar.isVisible()) {
                    this.f1197g.add(iVar);
                }
            }
            this.f1198h = false;
            this.f1201k = true;
            return this.f1197g;
        }
        return this.f1197g;
    }

    public boolean F() {
        return this.f1215y;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean G() {
        return this.f1193c;
    }

    public boolean H() {
        return this.f1194d;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void I(i iVar) {
        this.f1201k = true;
        K(true);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void J(i iVar) {
        this.f1198h = true;
        K(true);
    }

    public void K(boolean z9) {
        if (this.f1207q) {
            this.f1208r = true;
            if (z9) {
                this.f1209s = true;
                return;
            }
            return;
        }
        if (z9) {
            this.f1198h = true;
            this.f1201k = true;
        }
        i(z9);
    }

    public boolean L(MenuItem menuItem, int i10) {
        return M(menuItem, null, i10);
    }

    /* JADX WARN: Code restructure failed: missing block: B:16:0x002b, code lost:
        if (r1 != false) goto L14;
     */
    /* JADX WARN: Code restructure failed: missing block: B:17:0x002d, code lost:
        e(true);
     */
    /* JADX WARN: Code restructure failed: missing block: B:23:0x003c, code lost:
        if ((r9 & 1) == 0) goto L14;
     */
    /* JADX WARN: Code restructure failed: missing block: B:35:0x0068, code lost:
        if (r1 == false) goto L14;
     */
    /* JADX WARN: Code restructure failed: missing block: B:37:0x006b, code lost:
        return r1;
     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public boolean M(MenuItem menuItem, m mVar, int i10) {
        i iVar = (i) menuItem;
        if (iVar == null || !iVar.isEnabled()) {
            return false;
        }
        boolean k10 = iVar.k();
        androidx.core.view.b b10 = iVar.b();
        boolean z9 = b10 != null && b10.a();
        if (iVar.j()) {
            k10 |= iVar.expandActionView();
        } else if (iVar.hasSubMenu() || z9) {
            if ((i10 & 4) == 0) {
                e(false);
            }
            if (!iVar.hasSubMenu()) {
                iVar.x(new r(u(), this, iVar));
            }
            r rVar = (r) iVar.getSubMenu();
            if (z9) {
                b10.e(rVar);
            }
            k10 |= j(rVar, mVar);
        }
    }

    public void O(m mVar) {
        Iterator it = this.f1213w.iterator();
        while (it.hasNext()) {
            WeakReference weakReference = (WeakReference) it.next();
            m mVar2 = (m) weakReference.get();
            if (mVar2 == null || mVar2 == mVar) {
                this.f1213w.remove(weakReference);
            }
        }
    }

    public void P(Bundle bundle) {
        MenuItem findItem;
        if (bundle == null) {
            return;
        }
        SparseArray<Parcelable> sparseParcelableArray = bundle.getSparseParcelableArray(t());
        int size = size();
        for (int i10 = 0; i10 < size; i10++) {
            MenuItem item = getItem(i10);
            View actionView = item.getActionView();
            if (actionView != null && actionView.getId() != -1) {
                actionView.restoreHierarchyState(sparseParcelableArray);
            }
            if (item.hasSubMenu()) {
                ((r) item.getSubMenu()).P(bundle);
            }
        }
        int i11 = bundle.getInt("android:menu:expandedactionview");
        if (i11 <= 0 || (findItem = findItem(i11)) == null) {
            return;
        }
        findItem.expandActionView();
    }

    public void Q(Bundle bundle) {
        int size = size();
        SparseArray<? extends Parcelable> sparseArray = null;
        for (int i10 = 0; i10 < size; i10++) {
            MenuItem item = getItem(i10);
            View actionView = item.getActionView();
            if (actionView != null && actionView.getId() != -1) {
                if (sparseArray == null) {
                    sparseArray = new SparseArray<>();
                }
                actionView.saveHierarchyState(sparseArray);
                if (item.isActionViewExpanded()) {
                    bundle.putInt("android:menu:expandedactionview", item.getItemId());
                }
            }
            if (item.hasSubMenu()) {
                ((r) item.getSubMenu()).Q(bundle);
            }
        }
        if (sparseArray != null) {
            bundle.putSparseParcelableArray(t(), sparseArray);
        }
    }

    public void R(a aVar) {
        this.f1195e = aVar;
    }

    public g S(int i10) {
        this.f1202l = i10;
        return this;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void T(MenuItem menuItem) {
        int groupId = menuItem.getGroupId();
        int size = this.f1196f.size();
        d0();
        for (int i10 = 0; i10 < size; i10++) {
            i iVar = (i) this.f1196f.get(i10);
            if (iVar.getGroupId() == groupId && iVar.m() && iVar.isCheckable()) {
                iVar.s(iVar == menuItem);
            }
        }
        c0();
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public g U(int i10) {
        W(0, null, i10, null, null);
        return this;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public g V(Drawable drawable) {
        W(0, null, 0, drawable, null);
        return this;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public g X(int i10) {
        W(i10, null, 0, null, null);
        return this;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public g Y(CharSequence charSequence) {
        W(0, charSequence, 0, null, null);
        return this;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public g Z(View view) {
        W(0, null, 0, null, view);
        return this;
    }

    protected MenuItem a(int i10, int i11, int i12, CharSequence charSequence) {
        int B = B(i12);
        i g10 = g(i10, i11, i12, B, charSequence, this.f1202l);
        ContextMenu.ContextMenuInfo contextMenuInfo = this.f1203m;
        if (contextMenuInfo != null) {
            g10.v(contextMenuInfo);
        }
        ArrayList arrayList = this.f1196f;
        arrayList.add(n(arrayList, B), g10);
        K(true);
        return g10;
    }

    public void a0(boolean z9) {
        this.f1216z = z9;
    }

    @Override // android.view.Menu
    public MenuItem add(int i10) {
        return a(0, 0, 0, this.f1192b.getString(i10));
    }

    @Override // android.view.Menu
    public MenuItem add(int i10, int i11, int i12, int i13) {
        return a(i10, i11, i12, this.f1192b.getString(i13));
    }

    @Override // android.view.Menu
    public MenuItem add(int i10, int i11, int i12, CharSequence charSequence) {
        return a(i10, i11, i12, charSequence);
    }

    @Override // android.view.Menu
    public MenuItem add(CharSequence charSequence) {
        return a(0, 0, 0, charSequence);
    }

    @Override // android.view.Menu
    public int addIntentOptions(int i10, int i11, int i12, ComponentName componentName, Intent[] intentArr, Intent intent, int i13, MenuItem[] menuItemArr) {
        int i14;
        PackageManager packageManager = this.f1191a.getPackageManager();
        List<ResolveInfo> queryIntentActivityOptions = packageManager.queryIntentActivityOptions(componentName, intentArr, intent, 0);
        int size = queryIntentActivityOptions != null ? queryIntentActivityOptions.size() : 0;
        if ((i13 & 1) == 0) {
            removeGroup(i10);
        }
        for (int i15 = 0; i15 < size; i15++) {
            ResolveInfo resolveInfo = queryIntentActivityOptions.get(i15);
            int i16 = resolveInfo.specificIndex;
            Intent intent2 = new Intent(i16 < 0 ? intent : intentArr[i16]);
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            intent2.setComponent(new ComponentName(activityInfo.applicationInfo.packageName, activityInfo.name));
            MenuItem intent3 = add(i10, i11, i12, resolveInfo.loadLabel(packageManager)).setIcon(resolveInfo.loadIcon(packageManager)).setIntent(intent2);
            if (menuItemArr != null && (i14 = resolveInfo.specificIndex) >= 0) {
                menuItemArr[i14] = intent3;
            }
        }
        return size;
    }

    @Override // android.view.Menu
    public SubMenu addSubMenu(int i10) {
        return addSubMenu(0, 0, 0, this.f1192b.getString(i10));
    }

    @Override // android.view.Menu
    public SubMenu addSubMenu(int i10, int i11, int i12, int i13) {
        return addSubMenu(i10, i11, i12, this.f1192b.getString(i13));
    }

    @Override // android.view.Menu
    public SubMenu addSubMenu(int i10, int i11, int i12, CharSequence charSequence) {
        i iVar = (i) a(i10, i11, i12, charSequence);
        r rVar = new r(this.f1191a, this, iVar);
        iVar.x(rVar);
        return rVar;
    }

    @Override // android.view.Menu
    public SubMenu addSubMenu(CharSequence charSequence) {
        return addSubMenu(0, 0, 0, charSequence);
    }

    public void b(m mVar) {
        c(mVar, this.f1191a);
    }

    public void c(m mVar, Context context) {
        this.f1213w.add(new WeakReference(mVar));
        mVar.h(context, this);
        this.f1201k = true;
    }

    public void c0() {
        this.f1207q = false;
        if (this.f1208r) {
            this.f1208r = false;
            K(this.f1209s);
        }
    }

    @Override // android.view.Menu
    public void clear() {
        i iVar = this.f1214x;
        if (iVar != null) {
            f(iVar);
        }
        this.f1196f.clear();
        K(true);
    }

    public void clearHeader() {
        this.f1205o = null;
        this.f1204n = null;
        this.f1206p = null;
        K(false);
    }

    @Override // android.view.Menu
    public void close() {
        e(true);
    }

    public void d() {
        a aVar = this.f1195e;
        if (aVar != null) {
            aVar.b(this);
        }
    }

    public void d0() {
        if (this.f1207q) {
            return;
        }
        this.f1207q = true;
        this.f1208r = false;
        this.f1209s = false;
    }

    public final void e(boolean z9) {
        if (this.f1211u) {
            return;
        }
        this.f1211u = true;
        Iterator it = this.f1213w.iterator();
        while (it.hasNext()) {
            WeakReference weakReference = (WeakReference) it.next();
            m mVar = (m) weakReference.get();
            if (mVar == null) {
                this.f1213w.remove(weakReference);
            } else {
                mVar.b(this, z9);
            }
        }
        this.f1211u = false;
    }

    public boolean f(i iVar) {
        boolean z9 = false;
        if (!this.f1213w.isEmpty() && this.f1214x == iVar) {
            d0();
            Iterator it = this.f1213w.iterator();
            while (it.hasNext()) {
                WeakReference weakReference = (WeakReference) it.next();
                m mVar = (m) weakReference.get();
                if (mVar == null) {
                    this.f1213w.remove(weakReference);
                } else {
                    z9 = mVar.e(this, iVar);
                    if (z9) {
                        break;
                    }
                }
            }
            c0();
            if (z9) {
                this.f1214x = null;
            }
        }
        return z9;
    }

    @Override // android.view.Menu
    public MenuItem findItem(int i10) {
        MenuItem findItem;
        int size = size();
        for (int i11 = 0; i11 < size; i11++) {
            i iVar = (i) this.f1196f.get(i11);
            if (iVar.getItemId() == i10) {
                return iVar;
            }
            if (iVar.hasSubMenu() && (findItem = iVar.getSubMenu().findItem(i10)) != null) {
                return findItem;
            }
        }
        return null;
    }

    @Override // android.view.Menu
    public MenuItem getItem(int i10) {
        return (MenuItem) this.f1196f.get(i10);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean h(g gVar, MenuItem menuItem) {
        a aVar = this.f1195e;
        return aVar != null && aVar.a(gVar, menuItem);
    }

    @Override // android.view.Menu
    public boolean hasVisibleItems() {
        if (this.f1216z) {
            return true;
        }
        int size = size();
        for (int i10 = 0; i10 < size; i10++) {
            if (((i) this.f1196f.get(i10)).isVisible()) {
                return true;
            }
        }
        return false;
    }

    @Override // android.view.Menu
    public boolean isShortcutKey(int i10, KeyEvent keyEvent) {
        return p(i10, keyEvent) != null;
    }

    public boolean k(i iVar) {
        boolean z9 = false;
        if (this.f1213w.isEmpty()) {
            return false;
        }
        d0();
        Iterator it = this.f1213w.iterator();
        while (it.hasNext()) {
            WeakReference weakReference = (WeakReference) it.next();
            m mVar = (m) weakReference.get();
            if (mVar == null) {
                this.f1213w.remove(weakReference);
            } else {
                z9 = mVar.f(this, iVar);
                if (z9) {
                    break;
                }
            }
        }
        c0();
        if (z9) {
            this.f1214x = iVar;
        }
        return z9;
    }

    public int l(int i10) {
        return m(i10, 0);
    }

    public int m(int i10, int i11) {
        int size = size();
        if (i11 < 0) {
            i11 = 0;
        }
        while (i11 < size) {
            if (((i) this.f1196f.get(i11)).getGroupId() == i10) {
                return i11;
            }
            i11++;
        }
        return -1;
    }

    public int o(int i10) {
        int size = size();
        for (int i11 = 0; i11 < size; i11++) {
            if (((i) this.f1196f.get(i11)).getItemId() == i10) {
                return i11;
            }
        }
        return -1;
    }

    i p(int i10, KeyEvent keyEvent) {
        ArrayList arrayList = this.f1212v;
        arrayList.clear();
        q(arrayList, i10, keyEvent);
        if (arrayList.isEmpty()) {
            return null;
        }
        int metaState = keyEvent.getMetaState();
        KeyCharacterMap.KeyData keyData = new KeyCharacterMap.KeyData();
        keyEvent.getKeyData(keyData);
        int size = arrayList.size();
        if (size == 1) {
            return (i) arrayList.get(0);
        }
        boolean G = G();
        for (int i11 = 0; i11 < size; i11++) {
            i iVar = (i) arrayList.get(i11);
            char alphabeticShortcut = G ? iVar.getAlphabeticShortcut() : iVar.getNumericShortcut();
            char[] cArr = keyData.meta;
            if ((alphabeticShortcut == cArr[0] && (metaState & 2) == 0) || ((alphabeticShortcut == cArr[2] && (metaState & 2) != 0) || (G && alphabeticShortcut == '\b' && i10 == 67))) {
                return iVar;
            }
        }
        return null;
    }

    @Override // android.view.Menu
    public boolean performIdentifierAction(int i10, int i11) {
        return L(findItem(i10), i11);
    }

    @Override // android.view.Menu
    public boolean performShortcut(int i10, KeyEvent keyEvent, int i11) {
        i p10 = p(i10, keyEvent);
        boolean L = p10 != null ? L(p10, i11) : false;
        if ((i11 & 2) != 0) {
            e(true);
        }
        return L;
    }

    void q(List list, int i10, KeyEvent keyEvent) {
        boolean G = G();
        int modifiers = keyEvent.getModifiers();
        KeyCharacterMap.KeyData keyData = new KeyCharacterMap.KeyData();
        if (keyEvent.getKeyData(keyData) || i10 == 67) {
            int size = this.f1196f.size();
            for (int i11 = 0; i11 < size; i11++) {
                i iVar = (i) this.f1196f.get(i11);
                if (iVar.hasSubMenu()) {
                    ((g) iVar.getSubMenu()).q(list, i10, keyEvent);
                }
                char alphabeticShortcut = G ? iVar.getAlphabeticShortcut() : iVar.getNumericShortcut();
                if (((modifiers & 69647) == ((G ? iVar.getAlphabeticModifiers() : iVar.getNumericModifiers()) & 69647)) && alphabeticShortcut != 0) {
                    char[] cArr = keyData.meta;
                    if ((alphabeticShortcut == cArr[0] || alphabeticShortcut == cArr[2] || (G && alphabeticShortcut == '\b' && i10 == 67)) && iVar.isEnabled()) {
                        list.add(iVar);
                    }
                }
            }
        }
    }

    public void r() {
        ArrayList E = E();
        if (this.f1201k) {
            Iterator it = this.f1213w.iterator();
            boolean z9 = false;
            while (it.hasNext()) {
                WeakReference weakReference = (WeakReference) it.next();
                m mVar = (m) weakReference.get();
                if (mVar == null) {
                    this.f1213w.remove(weakReference);
                } else {
                    z9 |= mVar.d();
                }
            }
            if (z9) {
                this.f1199i.clear();
                this.f1200j.clear();
                int size = E.size();
                for (int i10 = 0; i10 < size; i10++) {
                    i iVar = (i) E.get(i10);
                    (iVar.l() ? this.f1199i : this.f1200j).add(iVar);
                }
            } else {
                this.f1199i.clear();
                this.f1200j.clear();
                this.f1200j.addAll(E());
            }
            this.f1201k = false;
        }
    }

    @Override // android.view.Menu
    public void removeGroup(int i10) {
        int l10 = l(i10);
        if (l10 >= 0) {
            int size = this.f1196f.size() - l10;
            int i11 = 0;
            while (true) {
                int i12 = i11 + 1;
                if (i11 >= size || ((i) this.f1196f.get(l10)).getGroupId() != i10) {
                    break;
                }
                N(l10, false);
                i11 = i12;
            }
            K(true);
        }
    }

    @Override // android.view.Menu
    public void removeItem(int i10) {
        N(o(i10), true);
    }

    public ArrayList s() {
        r();
        return this.f1199i;
    }

    @Override // android.view.Menu
    public void setGroupCheckable(int i10, boolean z9, boolean z10) {
        int size = this.f1196f.size();
        for (int i11 = 0; i11 < size; i11++) {
            i iVar = (i) this.f1196f.get(i11);
            if (iVar.getGroupId() == i10) {
                iVar.t(z10);
                iVar.setCheckable(z9);
            }
        }
    }

    @Override // android.view.Menu
    public void setGroupDividerEnabled(boolean z9) {
        this.f1215y = z9;
    }

    @Override // android.view.Menu
    public void setGroupEnabled(int i10, boolean z9) {
        int size = this.f1196f.size();
        for (int i11 = 0; i11 < size; i11++) {
            i iVar = (i) this.f1196f.get(i11);
            if (iVar.getGroupId() == i10) {
                iVar.setEnabled(z9);
            }
        }
    }

    @Override // android.view.Menu
    public void setGroupVisible(int i10, boolean z9) {
        int size = this.f1196f.size();
        boolean z10 = false;
        for (int i11 = 0; i11 < size; i11++) {
            i iVar = (i) this.f1196f.get(i11);
            if (iVar.getGroupId() == i10 && iVar.y(z9)) {
                z10 = true;
            }
        }
        if (z10) {
            K(true);
        }
    }

    @Override // android.view.Menu
    public void setQwertyMode(boolean z9) {
        this.f1193c = z9;
        K(false);
    }

    @Override // android.view.Menu
    public int size() {
        return this.f1196f.size();
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public String t() {
        return "android:menu:actionviewstates";
    }

    public Context u() {
        return this.f1191a;
    }

    public i v() {
        return this.f1214x;
    }

    public Drawable w() {
        return this.f1205o;
    }

    public CharSequence x() {
        return this.f1204n;
    }

    public View y() {
        return this.f1206p;
    }

    public ArrayList z() {
        r();
        return this.f1200j;
    }
}
