package androidx.appcompat.view.menu;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.appcompat.view.menu.m;
import androidx.appcompat.widget.v1;
import androidx.appcompat.widget.y1;
import androidx.core.view.r0;
import java.util.ArrayList;
import java.util.List;
/* loaded from: classes.dex */
final class d extends k implements View.OnKeyListener, PopupWindow.OnDismissListener {
    private static final int H = g.g.abc_cascading_menu_item_layout;
    private int A;
    private boolean C;
    private m.a D;
    ViewTreeObserver E;
    private PopupWindow.OnDismissListener F;
    boolean G;

    /* renamed from: h  reason: collision with root package name */
    private final Context f1145h;

    /* renamed from: i  reason: collision with root package name */
    private final int f1146i;

    /* renamed from: j  reason: collision with root package name */
    private final int f1147j;

    /* renamed from: k  reason: collision with root package name */
    private final int f1148k;

    /* renamed from: l  reason: collision with root package name */
    private final boolean f1149l;

    /* renamed from: m  reason: collision with root package name */
    final Handler f1150m;

    /* renamed from: u  reason: collision with root package name */
    private View f1158u;

    /* renamed from: v  reason: collision with root package name */
    View f1159v;

    /* renamed from: x  reason: collision with root package name */
    private boolean f1161x;

    /* renamed from: y  reason: collision with root package name */
    private boolean f1162y;

    /* renamed from: z  reason: collision with root package name */
    private int f1163z;

    /* renamed from: n  reason: collision with root package name */
    private final List f1151n = new ArrayList();

    /* renamed from: o  reason: collision with root package name */
    final List f1152o = new ArrayList();

    /* renamed from: p  reason: collision with root package name */
    final ViewTreeObserver.OnGlobalLayoutListener f1153p = new a();

    /* renamed from: q  reason: collision with root package name */
    private final View.OnAttachStateChangeListener f1154q = new b();

    /* renamed from: r  reason: collision with root package name */
    private final v1 f1155r = new c();

    /* renamed from: s  reason: collision with root package name */
    private int f1156s = 0;

    /* renamed from: t  reason: collision with root package name */
    private int f1157t = 0;
    private boolean B = false;

    /* renamed from: w  reason: collision with root package name */
    private int f1160w = C();

    /* loaded from: classes.dex */
    class a implements ViewTreeObserver.OnGlobalLayoutListener {
        a() {
        }

        @Override // android.view.ViewTreeObserver.OnGlobalLayoutListener
        public void onGlobalLayout() {
            if (!d.this.a() || d.this.f1152o.size() <= 0 || ((C0006d) d.this.f1152o.get(0)).f1171a.w()) {
                return;
            }
            View view = d.this.f1159v;
            if (view == null || !view.isShown()) {
                d.this.dismiss();
                return;
            }
            for (C0006d c0006d : d.this.f1152o) {
                c0006d.f1171a.show();
            }
        }
    }

    /* loaded from: classes.dex */
    class b implements View.OnAttachStateChangeListener {
        b() {
        }

        @Override // android.view.View.OnAttachStateChangeListener
        public void onViewAttachedToWindow(View view) {
        }

        @Override // android.view.View.OnAttachStateChangeListener
        public void onViewDetachedFromWindow(View view) {
            ViewTreeObserver viewTreeObserver = d.this.E;
            if (viewTreeObserver != null) {
                if (!viewTreeObserver.isAlive()) {
                    d.this.E = view.getViewTreeObserver();
                }
                d dVar = d.this;
                dVar.E.removeGlobalOnLayoutListener(dVar.f1153p);
            }
            view.removeOnAttachStateChangeListener(this);
        }
    }

    /* loaded from: classes.dex */
    class c implements v1 {

        /* loaded from: classes.dex */
        class a implements Runnable {

            /* renamed from: g  reason: collision with root package name */
            final /* synthetic */ C0006d f1167g;

            /* renamed from: h  reason: collision with root package name */
            final /* synthetic */ MenuItem f1168h;

            /* renamed from: i  reason: collision with root package name */
            final /* synthetic */ g f1169i;

            a(C0006d c0006d, MenuItem menuItem, g gVar) {
                this.f1167g = c0006d;
                this.f1168h = menuItem;
                this.f1169i = gVar;
            }

            @Override // java.lang.Runnable
            public void run() {
                C0006d c0006d = this.f1167g;
                if (c0006d != null) {
                    d.this.G = true;
                    c0006d.f1172b.e(false);
                    d.this.G = false;
                }
                if (this.f1168h.isEnabled() && this.f1168h.hasSubMenu()) {
                    this.f1169i.L(this.f1168h, 4);
                }
            }
        }

        c() {
        }

        @Override // androidx.appcompat.widget.v1
        public void c(g gVar, MenuItem menuItem) {
            d.this.f1150m.removeCallbacksAndMessages(null);
            int size = d.this.f1152o.size();
            int i10 = 0;
            while (true) {
                if (i10 >= size) {
                    i10 = -1;
                    break;
                } else if (gVar == ((C0006d) d.this.f1152o.get(i10)).f1172b) {
                    break;
                } else {
                    i10++;
                }
            }
            if (i10 == -1) {
                return;
            }
            int i11 = i10 + 1;
            d.this.f1150m.postAtTime(new a(i11 < d.this.f1152o.size() ? (C0006d) d.this.f1152o.get(i11) : null, menuItem, gVar), gVar, SystemClock.uptimeMillis() + 200);
        }

        @Override // androidx.appcompat.widget.v1
        public void f(g gVar, MenuItem menuItem) {
            d.this.f1150m.removeCallbacksAndMessages(gVar);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* renamed from: androidx.appcompat.view.menu.d$d  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public static class C0006d {

        /* renamed from: a  reason: collision with root package name */
        public final y1 f1171a;

        /* renamed from: b  reason: collision with root package name */
        public final g f1172b;

        /* renamed from: c  reason: collision with root package name */
        public final int f1173c;

        public C0006d(y1 y1Var, g gVar, int i10) {
            this.f1171a = y1Var;
            this.f1172b = gVar;
            this.f1173c = i10;
        }

        public ListView a() {
            return this.f1171a.i();
        }
    }

    public d(Context context, View view, int i10, int i11, boolean z9) {
        this.f1145h = context;
        this.f1158u = view;
        this.f1147j = i10;
        this.f1148k = i11;
        this.f1149l = z9;
        Resources resources = context.getResources();
        this.f1146i = Math.max(resources.getDisplayMetrics().widthPixels / 2, resources.getDimensionPixelSize(g.d.abc_config_prefDialogWidth));
        this.f1150m = new Handler();
    }

    private MenuItem A(g gVar, g gVar2) {
        int size = gVar.size();
        for (int i10 = 0; i10 < size; i10++) {
            MenuItem item = gVar.getItem(i10);
            if (item.hasSubMenu() && gVar2 == item.getSubMenu()) {
                return item;
            }
        }
        return null;
    }

    private View B(C0006d c0006d, g gVar) {
        f fVar;
        int i10;
        int firstVisiblePosition;
        MenuItem A = A(c0006d.f1172b, gVar);
        if (A == null) {
            return null;
        }
        ListView a10 = c0006d.a();
        ListAdapter adapter = a10.getAdapter();
        int i11 = 0;
        if (adapter instanceof HeaderViewListAdapter) {
            HeaderViewListAdapter headerViewListAdapter = (HeaderViewListAdapter) adapter;
            i10 = headerViewListAdapter.getHeadersCount();
            fVar = (f) headerViewListAdapter.getWrappedAdapter();
        } else {
            fVar = (f) adapter;
            i10 = 0;
        }
        int count = fVar.getCount();
        while (true) {
            if (i11 >= count) {
                i11 = -1;
                break;
            } else if (A == fVar.getItem(i11)) {
                break;
            } else {
                i11++;
            }
        }
        if (i11 != -1 && (firstVisiblePosition = (i11 + i10) - a10.getFirstVisiblePosition()) >= 0 && firstVisiblePosition < a10.getChildCount()) {
            return a10.getChildAt(firstVisiblePosition);
        }
        return null;
    }

    private int C() {
        return r0.B(this.f1158u) == 1 ? 0 : 1;
    }

    private int D(int i10) {
        List list = this.f1152o;
        ListView a10 = ((C0006d) list.get(list.size() - 1)).a();
        int[] iArr = new int[2];
        a10.getLocationOnScreen(iArr);
        Rect rect = new Rect();
        this.f1159v.getWindowVisibleDisplayFrame(rect);
        return this.f1160w == 1 ? (iArr[0] + a10.getWidth()) + i10 > rect.right ? 0 : 1 : iArr[0] - i10 < 0 ? 1 : 0;
    }

    private void E(g gVar) {
        C0006d c0006d;
        View view;
        int i10;
        int i11;
        int i12;
        LayoutInflater from = LayoutInflater.from(this.f1145h);
        f fVar = new f(gVar, from, this.f1149l, H);
        if (!a() && this.B) {
            fVar.d(true);
        } else if (a()) {
            fVar.d(k.w(gVar));
        }
        int n10 = k.n(fVar, null, this.f1145h, this.f1146i);
        y1 y9 = y();
        y9.o(fVar);
        y9.A(n10);
        y9.B(this.f1157t);
        if (this.f1152o.size() > 0) {
            List list = this.f1152o;
            c0006d = (C0006d) list.get(list.size() - 1);
            view = B(c0006d, gVar);
        } else {
            c0006d = null;
            view = null;
        }
        if (view != null) {
            y9.P(false);
            y9.M(null);
            int D = D(n10);
            boolean z9 = D == 1;
            this.f1160w = D;
            if (Build.VERSION.SDK_INT >= 26) {
                y9.y(view);
                i11 = 0;
                i10 = 0;
            } else {
                int[] iArr = new int[2];
                this.f1158u.getLocationOnScreen(iArr);
                int[] iArr2 = new int[2];
                view.getLocationOnScreen(iArr2);
                if ((this.f1157t & 7) == 5) {
                    iArr[0] = iArr[0] + this.f1158u.getWidth();
                    iArr2[0] = iArr2[0] + view.getWidth();
                }
                i10 = iArr2[0] - iArr[0];
                i11 = iArr2[1] - iArr[1];
            }
            if ((this.f1157t & 5) == 5) {
                if (!z9) {
                    n10 = view.getWidth();
                    i12 = i10 - n10;
                }
                i12 = i10 + n10;
            } else {
                if (z9) {
                    n10 = view.getWidth();
                    i12 = i10 + n10;
                }
                i12 = i10 - n10;
            }
            y9.d(i12);
            y9.H(true);
            y9.k(i11);
        } else {
            if (this.f1161x) {
                y9.d(this.f1163z);
            }
            if (this.f1162y) {
                y9.k(this.A);
            }
            y9.C(m());
        }
        this.f1152o.add(new C0006d(y9, gVar, this.f1160w));
        y9.show();
        ListView i13 = y9.i();
        i13.setOnKeyListener(this);
        if (c0006d == null && this.C && gVar.x() != null) {
            FrameLayout frameLayout = (FrameLayout) from.inflate(g.g.abc_popup_menu_header_item_layout, (ViewGroup) i13, false);
            frameLayout.setEnabled(false);
            ((TextView) frameLayout.findViewById(16908310)).setText(gVar.x());
            i13.addHeaderView(frameLayout, null, false);
            y9.show();
        }
    }

    private y1 y() {
        y1 y1Var = new y1(this.f1145h, null, this.f1147j, this.f1148k);
        y1Var.O(this.f1155r);
        y1Var.G(this);
        y1Var.F(this);
        y1Var.y(this.f1158u);
        y1Var.B(this.f1157t);
        y1Var.E(true);
        y1Var.D(2);
        return y1Var;
    }

    private int z(g gVar) {
        int size = this.f1152o.size();
        for (int i10 = 0; i10 < size; i10++) {
            if (gVar == ((C0006d) this.f1152o.get(i10)).f1172b) {
                return i10;
            }
        }
        return -1;
    }

    @Override // androidx.appcompat.view.menu.p
    public boolean a() {
        return this.f1152o.size() > 0 && ((C0006d) this.f1152o.get(0)).f1171a.a();
    }

    @Override // androidx.appcompat.view.menu.m
    public void b(g gVar, boolean z9) {
        int z10 = z(gVar);
        if (z10 < 0) {
            return;
        }
        int i10 = z10 + 1;
        if (i10 < this.f1152o.size()) {
            ((C0006d) this.f1152o.get(i10)).f1172b.e(false);
        }
        C0006d c0006d = (C0006d) this.f1152o.remove(z10);
        c0006d.f1172b.O(this);
        if (this.G) {
            c0006d.f1171a.N(null);
            c0006d.f1171a.z(0);
        }
        c0006d.f1171a.dismiss();
        int size = this.f1152o.size();
        this.f1160w = size > 0 ? ((C0006d) this.f1152o.get(size - 1)).f1173c : C();
        if (size != 0) {
            if (z9) {
                ((C0006d) this.f1152o.get(0)).f1172b.e(false);
                return;
            }
            return;
        }
        dismiss();
        m.a aVar = this.D;
        if (aVar != null) {
            aVar.b(gVar, true);
        }
        ViewTreeObserver viewTreeObserver = this.E;
        if (viewTreeObserver != null) {
            if (viewTreeObserver.isAlive()) {
                this.E.removeGlobalOnLayoutListener(this.f1153p);
            }
            this.E = null;
        }
        this.f1159v.removeOnAttachStateChangeListener(this.f1154q);
        this.F.onDismiss();
    }

    @Override // androidx.appcompat.view.menu.m
    public void c(boolean z9) {
        for (C0006d c0006d : this.f1152o) {
            k.x(c0006d.a().getAdapter()).notifyDataSetChanged();
        }
    }

    @Override // androidx.appcompat.view.menu.m
    public boolean d() {
        return false;
    }

    @Override // androidx.appcompat.view.menu.p
    public void dismiss() {
        int size = this.f1152o.size();
        if (size > 0) {
            C0006d[] c0006dArr = (C0006d[]) this.f1152o.toArray(new C0006d[size]);
            for (int i10 = size - 1; i10 >= 0; i10--) {
                C0006d c0006d = c0006dArr[i10];
                if (c0006d.f1171a.a()) {
                    c0006d.f1171a.dismiss();
                }
            }
        }
    }

    @Override // androidx.appcompat.view.menu.m
    public void g(m.a aVar) {
        this.D = aVar;
    }

    @Override // androidx.appcompat.view.menu.p
    public ListView i() {
        if (this.f1152o.isEmpty()) {
            return null;
        }
        List list = this.f1152o;
        return ((C0006d) list.get(list.size() - 1)).a();
    }

    @Override // androidx.appcompat.view.menu.m
    public boolean j(r rVar) {
        for (C0006d c0006d : this.f1152o) {
            if (rVar == c0006d.f1172b) {
                c0006d.a().requestFocus();
                return true;
            }
        }
        if (rVar.hasVisibleItems()) {
            k(rVar);
            m.a aVar = this.D;
            if (aVar != null) {
                aVar.c(rVar);
            }
            return true;
        }
        return false;
    }

    @Override // androidx.appcompat.view.menu.k
    public void k(g gVar) {
        gVar.c(this, this.f1145h);
        if (a()) {
            E(gVar);
        } else {
            this.f1151n.add(gVar);
        }
    }

    @Override // androidx.appcompat.view.menu.k
    protected boolean l() {
        return false;
    }

    @Override // androidx.appcompat.view.menu.k
    public void o(View view) {
        if (this.f1158u != view) {
            this.f1158u = view;
            this.f1157t = androidx.core.view.i.b(this.f1156s, r0.B(view));
        }
    }

    @Override // android.widget.PopupWindow.OnDismissListener
    public void onDismiss() {
        C0006d c0006d;
        int size = this.f1152o.size();
        int i10 = 0;
        while (true) {
            if (i10 >= size) {
                c0006d = null;
                break;
            }
            c0006d = (C0006d) this.f1152o.get(i10);
            if (!c0006d.f1171a.a()) {
                break;
            }
            i10++;
        }
        if (c0006d != null) {
            c0006d.f1172b.e(false);
        }
    }

    @Override // android.view.View.OnKeyListener
    public boolean onKey(View view, int i10, KeyEvent keyEvent) {
        if (keyEvent.getAction() == 1 && i10 == 82) {
            dismiss();
            return true;
        }
        return false;
    }

    @Override // androidx.appcompat.view.menu.k
    public void q(boolean z9) {
        this.B = z9;
    }

    @Override // androidx.appcompat.view.menu.k
    public void r(int i10) {
        if (this.f1156s != i10) {
            this.f1156s = i10;
            this.f1157t = androidx.core.view.i.b(i10, r0.B(this.f1158u));
        }
    }

    @Override // androidx.appcompat.view.menu.k
    public void s(int i10) {
        this.f1161x = true;
        this.f1163z = i10;
    }

    @Override // androidx.appcompat.view.menu.p
    public void show() {
        if (a()) {
            return;
        }
        for (g gVar : this.f1151n) {
            E(gVar);
        }
        this.f1151n.clear();
        View view = this.f1158u;
        this.f1159v = view;
        if (view != null) {
            boolean z9 = this.E == null;
            ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
            this.E = viewTreeObserver;
            if (z9) {
                viewTreeObserver.addOnGlobalLayoutListener(this.f1153p);
            }
            this.f1159v.addOnAttachStateChangeListener(this.f1154q);
        }
    }

    @Override // androidx.appcompat.view.menu.k
    public void t(PopupWindow.OnDismissListener onDismissListener) {
        this.F = onDismissListener;
    }

    @Override // androidx.appcompat.view.menu.k
    public void u(boolean z9) {
        this.C = z9;
    }

    @Override // androidx.appcompat.view.menu.k
    public void v(int i10) {
        this.f1162y = true;
        this.A = i10;
    }
}
