package androidx.appcompat.view.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
import androidx.appcompat.view.menu.n;
import androidx.appcompat.widget.k2;
import androidx.core.view.r0;
/* loaded from: classes.dex */
public class ListMenuItemView extends LinearLayout implements n.a, AbsListView.SelectionBoundsAdjuster {

    /* renamed from: g  reason: collision with root package name */
    private i f1095g;

    /* renamed from: h  reason: collision with root package name */
    private ImageView f1096h;

    /* renamed from: i  reason: collision with root package name */
    private RadioButton f1097i;

    /* renamed from: j  reason: collision with root package name */
    private TextView f1098j;

    /* renamed from: k  reason: collision with root package name */
    private CheckBox f1099k;

    /* renamed from: l  reason: collision with root package name */
    private TextView f1100l;

    /* renamed from: m  reason: collision with root package name */
    private ImageView f1101m;

    /* renamed from: n  reason: collision with root package name */
    private ImageView f1102n;

    /* renamed from: o  reason: collision with root package name */
    private LinearLayout f1103o;

    /* renamed from: p  reason: collision with root package name */
    private Drawable f1104p;

    /* renamed from: q  reason: collision with root package name */
    private int f1105q;

    /* renamed from: r  reason: collision with root package name */
    private Context f1106r;

    /* renamed from: s  reason: collision with root package name */
    private boolean f1107s;

    /* renamed from: t  reason: collision with root package name */
    private Drawable f1108t;

    /* renamed from: u  reason: collision with root package name */
    private boolean f1109u;

    /* renamed from: v  reason: collision with root package name */
    private LayoutInflater f1110v;

    /* renamed from: w  reason: collision with root package name */
    private boolean f1111w;

    public ListMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, g.a.listMenuViewStyle);
    }

    public ListMenuItemView(Context context, AttributeSet attributeSet, int i10) {
        super(context, attributeSet);
        k2 v9 = k2.v(getContext(), attributeSet, g.j.T1, i10, 0);
        this.f1104p = v9.g(g.j.V1);
        this.f1105q = v9.n(g.j.U1, -1);
        this.f1107s = v9.a(g.j.W1, false);
        this.f1106r = context;
        this.f1108t = v9.g(g.j.X1);
        TypedArray obtainStyledAttributes = context.getTheme().obtainStyledAttributes(null, new int[]{16843049}, g.a.dropDownListViewStyle, 0);
        this.f1109u = obtainStyledAttributes.hasValue(0);
        v9.w();
        obtainStyledAttributes.recycle();
    }

    private void a(View view) {
        b(view, -1);
    }

    private void b(View view, int i10) {
        LinearLayout linearLayout = this.f1103o;
        if (linearLayout != null) {
            linearLayout.addView(view, i10);
        } else {
            addView(view, i10);
        }
    }

    private void e() {
        CheckBox checkBox = (CheckBox) getInflater().inflate(g.g.abc_list_menu_item_checkbox, (ViewGroup) this, false);
        this.f1099k = checkBox;
        a(checkBox);
    }

    private void f() {
        ImageView imageView = (ImageView) getInflater().inflate(g.g.abc_list_menu_item_icon, (ViewGroup) this, false);
        this.f1096h = imageView;
        b(imageView, 0);
    }

    private void g() {
        RadioButton radioButton = (RadioButton) getInflater().inflate(g.g.abc_list_menu_item_radio, (ViewGroup) this, false);
        this.f1097i = radioButton;
        a(radioButton);
    }

    private LayoutInflater getInflater() {
        if (this.f1110v == null) {
            this.f1110v = LayoutInflater.from(getContext());
        }
        return this.f1110v;
    }

    private void setSubMenuArrowVisible(boolean z9) {
        ImageView imageView = this.f1101m;
        if (imageView != null) {
            imageView.setVisibility(z9 ? 0 : 8);
        }
    }

    @Override // android.widget.AbsListView.SelectionBoundsAdjuster
    public void adjustListItemSelectionBounds(Rect rect) {
        ImageView imageView = this.f1102n;
        if (imageView == null || imageView.getVisibility() != 0) {
            return;
        }
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) this.f1102n.getLayoutParams();
        rect.top += this.f1102n.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
    }

    @Override // androidx.appcompat.view.menu.n.a
    public boolean c() {
        return false;
    }

    @Override // androidx.appcompat.view.menu.n.a
    public void d(i iVar, int i10) {
        this.f1095g = iVar;
        setVisibility(iVar.isVisible() ? 0 : 8);
        setTitle(iVar.i(this));
        setCheckable(iVar.isCheckable());
        h(iVar.A(), iVar.g());
        setIcon(iVar.getIcon());
        setEnabled(iVar.isEnabled());
        setSubMenuArrowVisible(iVar.hasSubMenu());
        setContentDescription(iVar.getContentDescription());
    }

    @Override // androidx.appcompat.view.menu.n.a
    public i getItemData() {
        return this.f1095g;
    }

    public void h(boolean z9, char c10) {
        int i10 = (z9 && this.f1095g.A()) ? 0 : 8;
        if (i10 == 0) {
            this.f1100l.setText(this.f1095g.h());
        }
        if (this.f1100l.getVisibility() != i10) {
            this.f1100l.setVisibility(i10);
        }
    }

    @Override // android.view.View
    protected void onFinishInflate() {
        super.onFinishInflate();
        r0.r0(this, this.f1104p);
        TextView textView = (TextView) findViewById(g.f.M);
        this.f1098j = textView;
        int i10 = this.f1105q;
        if (i10 != -1) {
            textView.setTextAppearance(this.f1106r, i10);
        }
        this.f1100l = (TextView) findViewById(g.f.shortcut);
        ImageView imageView = (ImageView) findViewById(g.f.submenuarrow);
        this.f1101m = imageView;
        if (imageView != null) {
            imageView.setImageDrawable(this.f1108t);
        }
        this.f1102n = (ImageView) findViewById(g.f.group_divider);
        this.f1103o = (LinearLayout) findViewById(g.f.content);
    }

    @Override // android.widget.LinearLayout, android.view.View
    protected void onMeasure(int i10, int i11) {
        if (this.f1096h != null && this.f1107s) {
            ViewGroup.LayoutParams layoutParams = getLayoutParams();
            LinearLayout.LayoutParams layoutParams2 = (LinearLayout.LayoutParams) this.f1096h.getLayoutParams();
            int i12 = layoutParams.height;
            if (i12 > 0 && layoutParams2.width <= 0) {
                layoutParams2.width = i12;
            }
        }
        super.onMeasure(i10, i11);
    }

    public void setCheckable(boolean z9) {
        CompoundButton compoundButton;
        View view;
        if (!z9 && this.f1097i == null && this.f1099k == null) {
            return;
        }
        if (this.f1095g.m()) {
            if (this.f1097i == null) {
                g();
            }
            compoundButton = this.f1097i;
            view = this.f1099k;
        } else {
            if (this.f1099k == null) {
                e();
            }
            compoundButton = this.f1099k;
            view = this.f1097i;
        }
        if (z9) {
            compoundButton.setChecked(this.f1095g.isChecked());
            if (compoundButton.getVisibility() != 0) {
                compoundButton.setVisibility(0);
            }
            if (view == null || view.getVisibility() == 8) {
                return;
            }
            view.setVisibility(8);
            return;
        }
        CheckBox checkBox = this.f1099k;
        if (checkBox != null) {
            checkBox.setVisibility(8);
        }
        RadioButton radioButton = this.f1097i;
        if (radioButton != null) {
            radioButton.setVisibility(8);
        }
    }

    public void setChecked(boolean z9) {
        CompoundButton compoundButton;
        if (this.f1095g.m()) {
            if (this.f1097i == null) {
                g();
            }
            compoundButton = this.f1097i;
        } else {
            if (this.f1099k == null) {
                e();
            }
            compoundButton = this.f1099k;
        }
        compoundButton.setChecked(z9);
    }

    public void setForceShowIcon(boolean z9) {
        this.f1111w = z9;
        this.f1107s = z9;
    }

    public void setGroupDividerEnabled(boolean z9) {
        ImageView imageView = this.f1102n;
        if (imageView != null) {
            imageView.setVisibility((this.f1109u || !z9) ? 8 : 0);
        }
    }

    public void setIcon(Drawable drawable) {
        boolean z9 = this.f1095g.z() || this.f1111w;
        if (z9 || this.f1107s) {
            ImageView imageView = this.f1096h;
            if (imageView == null && drawable == null && !this.f1107s) {
                return;
            }
            if (imageView == null) {
                f();
            }
            if (drawable == null && !this.f1107s) {
                this.f1096h.setVisibility(8);
                return;
            }
            ImageView imageView2 = this.f1096h;
            if (!z9) {
                drawable = null;
            }
            imageView2.setImageDrawable(drawable);
            if (this.f1096h.getVisibility() != 0) {
                this.f1096h.setVisibility(0);
            }
        }
    }

    public void setTitle(CharSequence charSequence) {
        int i10;
        TextView textView;
        if (charSequence != null) {
            this.f1098j.setText(charSequence);
            if (this.f1098j.getVisibility() == 0) {
                return;
            }
            textView = this.f1098j;
            i10 = 0;
        } else {
            i10 = 8;
            if (this.f1098j.getVisibility() == 8) {
                return;
            }
            textView = this.f1098j;
        }
        textView.setVisibility(i10);
    }
}
