package androidx.appcompat.view.menu;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import androidx.appcompat.view.menu.g;
import androidx.appcompat.view.menu.n;
import androidx.appcompat.widget.ActionMenuView;
import androidx.appcompat.widget.d1;
import androidx.appcompat.widget.p1;
import androidx.appcompat.widget.q2;
/* loaded from: classes.dex */
public class ActionMenuItemView extends d1 implements n.a, View.OnClickListener, ActionMenuView.a {

    /* renamed from: n  reason: collision with root package name */
    i f1080n;

    /* renamed from: o  reason: collision with root package name */
    private CharSequence f1081o;

    /* renamed from: p  reason: collision with root package name */
    private Drawable f1082p;

    /* renamed from: q  reason: collision with root package name */
    g.b f1083q;

    /* renamed from: r  reason: collision with root package name */
    private p1 f1084r;

    /* renamed from: s  reason: collision with root package name */
    b f1085s;

    /* renamed from: t  reason: collision with root package name */
    private boolean f1086t;

    /* renamed from: u  reason: collision with root package name */
    private boolean f1087u;

    /* renamed from: v  reason: collision with root package name */
    private int f1088v;

    /* renamed from: w  reason: collision with root package name */
    private int f1089w;

    /* renamed from: x  reason: collision with root package name */
    private int f1090x;

    /* loaded from: classes.dex */
    private class a extends p1 {
        public a() {
            super(ActionMenuItemView.this);
        }

        @Override // androidx.appcompat.widget.p1
        public p b() {
            b bVar = ActionMenuItemView.this.f1085s;
            if (bVar != null) {
                return bVar.a();
            }
            return null;
        }

        @Override // androidx.appcompat.widget.p1
        protected boolean c() {
            p b10;
            ActionMenuItemView actionMenuItemView = ActionMenuItemView.this;
            g.b bVar = actionMenuItemView.f1083q;
            return bVar != null && bVar.a(actionMenuItemView.f1080n) && (b10 = b()) != null && b10.a();
        }
    }

    /* loaded from: classes.dex */
    public static abstract class b {
        public abstract p a();
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet, int i10) {
        super(context, attributeSet, i10);
        Resources resources = context.getResources();
        this.f1086t = s();
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, g.j.f7876v, i10, 0);
        this.f1088v = obtainStyledAttributes.getDimensionPixelSize(g.j.f7881w, 0);
        obtainStyledAttributes.recycle();
        this.f1090x = (int) ((resources.getDisplayMetrics().density * 32.0f) + 0.5f);
        setOnClickListener(this);
        this.f1089w = -1;
        setSaveEnabled(false);
    }

    private boolean s() {
        Configuration configuration = getContext().getResources().getConfiguration();
        int i10 = configuration.screenWidthDp;
        return i10 >= 480 || (i10 >= 640 && configuration.screenHeightDp >= 480) || configuration.orientation == 2;
    }

    private void t() {
        boolean z9 = true;
        boolean z10 = !TextUtils.isEmpty(this.f1081o);
        if (this.f1082p != null && (!this.f1080n.B() || (!this.f1086t && !this.f1087u))) {
            z9 = false;
        }
        boolean z11 = z10 & z9;
        setText(z11 ? this.f1081o : null);
        CharSequence contentDescription = this.f1080n.getContentDescription();
        if (TextUtils.isEmpty(contentDescription)) {
            contentDescription = z11 ? null : this.f1080n.getTitle();
        }
        setContentDescription(contentDescription);
        CharSequence tooltipText = this.f1080n.getTooltipText();
        if (TextUtils.isEmpty(tooltipText)) {
            q2.a(this, z11 ? null : this.f1080n.getTitle());
        } else {
            q2.a(this, tooltipText);
        }
    }

    @Override // androidx.appcompat.widget.ActionMenuView.a
    public boolean a() {
        return r();
    }

    @Override // androidx.appcompat.widget.ActionMenuView.a
    public boolean b() {
        return r() && this.f1080n.getIcon() == null;
    }

    @Override // androidx.appcompat.view.menu.n.a
    public boolean c() {
        return true;
    }

    @Override // androidx.appcompat.view.menu.n.a
    public void d(i iVar, int i10) {
        this.f1080n = iVar;
        setIcon(iVar.getIcon());
        setTitle(iVar.i(this));
        setId(iVar.getItemId());
        setVisibility(iVar.isVisible() ? 0 : 8);
        setEnabled(iVar.isEnabled());
        if (iVar.hasSubMenu() && this.f1084r == null) {
            this.f1084r = new a();
        }
    }

    @Override // android.widget.TextView, android.view.View
    public CharSequence getAccessibilityClassName() {
        return Button.class.getName();
    }

    @Override // androidx.appcompat.view.menu.n.a
    public i getItemData() {
        return this.f1080n;
    }

    @Override // android.view.View.OnClickListener
    public void onClick(View view) {
        g.b bVar = this.f1083q;
        if (bVar != null) {
            bVar.a(this.f1080n);
        }
    }

    @Override // android.widget.TextView, android.view.View
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.f1086t = s();
        t();
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // androidx.appcompat.widget.d1, android.widget.TextView, android.view.View
    public void onMeasure(int i10, int i11) {
        int i12;
        boolean r10 = r();
        if (r10 && (i12 = this.f1089w) >= 0) {
            super.setPadding(i12, getPaddingTop(), getPaddingRight(), getPaddingBottom());
        }
        super.onMeasure(i10, i11);
        int mode = View.MeasureSpec.getMode(i10);
        int size = View.MeasureSpec.getSize(i10);
        int measuredWidth = getMeasuredWidth();
        int min = mode == Integer.MIN_VALUE ? Math.min(size, this.f1088v) : this.f1088v;
        if (mode != 1073741824 && this.f1088v > 0 && measuredWidth < min) {
            super.onMeasure(View.MeasureSpec.makeMeasureSpec(min, 1073741824), i11);
        }
        if (r10 || this.f1082p == null) {
            return;
        }
        super.setPadding((getMeasuredWidth() - this.f1082p.getBounds().width()) / 2, getPaddingTop(), getPaddingRight(), getPaddingBottom());
    }

    @Override // android.widget.TextView, android.view.View
    public void onRestoreInstanceState(Parcelable parcelable) {
        super.onRestoreInstanceState(null);
    }

    @Override // android.widget.TextView, android.view.View
    public boolean onTouchEvent(MotionEvent motionEvent) {
        p1 p1Var;
        if (this.f1080n.hasSubMenu() && (p1Var = this.f1084r) != null && p1Var.onTouch(this, motionEvent)) {
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    public boolean r() {
        return !TextUtils.isEmpty(getText());
    }

    public void setCheckable(boolean z9) {
    }

    public void setChecked(boolean z9) {
    }

    public void setExpandedFormat(boolean z9) {
        if (this.f1087u != z9) {
            this.f1087u = z9;
            i iVar = this.f1080n;
            if (iVar != null) {
                iVar.c();
            }
        }
    }

    public void setIcon(Drawable drawable) {
        this.f1082p = drawable;
        if (drawable != null) {
            int intrinsicWidth = drawable.getIntrinsicWidth();
            int intrinsicHeight = drawable.getIntrinsicHeight();
            int i10 = this.f1090x;
            if (intrinsicWidth > i10) {
                intrinsicHeight = (int) (intrinsicHeight * (i10 / intrinsicWidth));
                intrinsicWidth = i10;
            }
            if (intrinsicHeight > i10) {
                intrinsicWidth = (int) (intrinsicWidth * (i10 / intrinsicHeight));
            } else {
                i10 = intrinsicHeight;
            }
            drawable.setBounds(0, 0, intrinsicWidth, i10);
        }
        setCompoundDrawables(drawable, null, null, null);
        t();
    }

    public void setItemInvoker(g.b bVar) {
        this.f1083q = bVar;
    }

    @Override // android.widget.TextView, android.view.View
    public void setPadding(int i10, int i11, int i12, int i13) {
        this.f1089w = i10;
        super.setPadding(i10, i11, i12, i13);
    }

    public void setPopupCallback(b bVar) {
        this.f1085s = bVar;
    }

    public void setTitle(CharSequence charSequence) {
        this.f1081o = charSequence;
        t();
    }
}
