package androidx.appcompat.view;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import android.view.InflateException;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import androidx.appcompat.widget.k2;
import androidx.appcompat.widget.m1;
import androidx.core.view.c0;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
/* loaded from: classes.dex */
public class g extends MenuInflater {

    /* renamed from: e  reason: collision with root package name */
    static final Class[] f1035e;

    /* renamed from: f  reason: collision with root package name */
    static final Class[] f1036f;

    /* renamed from: a  reason: collision with root package name */
    final Object[] f1037a;

    /* renamed from: b  reason: collision with root package name */
    final Object[] f1038b;

    /* renamed from: c  reason: collision with root package name */
    Context f1039c;

    /* renamed from: d  reason: collision with root package name */
    private Object f1040d;

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class a implements MenuItem.OnMenuItemClickListener {

        /* renamed from: c  reason: collision with root package name */
        private static final Class[] f1041c = {MenuItem.class};

        /* renamed from: a  reason: collision with root package name */
        private Object f1042a;

        /* renamed from: b  reason: collision with root package name */
        private Method f1043b;

        public a(Object obj, String str) {
            this.f1042a = obj;
            Class<?> cls = obj.getClass();
            try {
                this.f1043b = cls.getMethod(str, f1041c);
            } catch (Exception e10) {
                InflateException inflateException = new InflateException("Couldn't resolve menu item onClick handler " + str + " in class " + cls.getName());
                inflateException.initCause(e10);
                throw inflateException;
            }
        }

        @Override // android.view.MenuItem.OnMenuItemClickListener
        public boolean onMenuItemClick(MenuItem menuItem) {
            try {
                if (this.f1043b.getReturnType() == Boolean.TYPE) {
                    return ((Boolean) this.f1043b.invoke(this.f1042a, menuItem)).booleanValue();
                }
                this.f1043b.invoke(this.f1042a, menuItem);
                return true;
            } catch (Exception e10) {
                throw new RuntimeException(e10);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class b {
        androidx.core.view.b A;
        private CharSequence B;
        private CharSequence C;
        private ColorStateList D = null;
        private PorterDuff.Mode E = null;

        /* renamed from: a  reason: collision with root package name */
        private Menu f1044a;

        /* renamed from: b  reason: collision with root package name */
        private int f1045b;

        /* renamed from: c  reason: collision with root package name */
        private int f1046c;

        /* renamed from: d  reason: collision with root package name */
        private int f1047d;

        /* renamed from: e  reason: collision with root package name */
        private int f1048e;

        /* renamed from: f  reason: collision with root package name */
        private boolean f1049f;

        /* renamed from: g  reason: collision with root package name */
        private boolean f1050g;

        /* renamed from: h  reason: collision with root package name */
        private boolean f1051h;

        /* renamed from: i  reason: collision with root package name */
        private int f1052i;

        /* renamed from: j  reason: collision with root package name */
        private int f1053j;

        /* renamed from: k  reason: collision with root package name */
        private CharSequence f1054k;

        /* renamed from: l  reason: collision with root package name */
        private CharSequence f1055l;

        /* renamed from: m  reason: collision with root package name */
        private int f1056m;

        /* renamed from: n  reason: collision with root package name */
        private char f1057n;

        /* renamed from: o  reason: collision with root package name */
        private int f1058o;

        /* renamed from: p  reason: collision with root package name */
        private char f1059p;

        /* renamed from: q  reason: collision with root package name */
        private int f1060q;

        /* renamed from: r  reason: collision with root package name */
        private int f1061r;

        /* renamed from: s  reason: collision with root package name */
        private boolean f1062s;

        /* renamed from: t  reason: collision with root package name */
        private boolean f1063t;

        /* renamed from: u  reason: collision with root package name */
        private boolean f1064u;

        /* renamed from: v  reason: collision with root package name */
        private int f1065v;

        /* renamed from: w  reason: collision with root package name */
        private int f1066w;

        /* renamed from: x  reason: collision with root package name */
        private String f1067x;

        /* renamed from: y  reason: collision with root package name */
        private String f1068y;

        /* renamed from: z  reason: collision with root package name */
        private String f1069z;

        public b(Menu menu) {
            this.f1044a = menu;
            h();
        }

        private char c(String str) {
            if (str == null) {
                return (char) 0;
            }
            return str.charAt(0);
        }

        private Object e(String str, Class[] clsArr, Object[] objArr) {
            try {
                Constructor<?> constructor = Class.forName(str, false, g.this.f1039c.getClassLoader()).getConstructor(clsArr);
                constructor.setAccessible(true);
                return constructor.newInstance(objArr);
            } catch (Exception e10) {
                Log.w("SupportMenuInflater", "Cannot instantiate class: " + str, e10);
                return null;
            }
        }

        private void i(MenuItem menuItem) {
            boolean z9 = false;
            menuItem.setChecked(this.f1062s).setVisible(this.f1063t).setEnabled(this.f1064u).setCheckable(this.f1061r >= 1).setTitleCondensed(this.f1055l).setIcon(this.f1056m);
            int i10 = this.f1065v;
            if (i10 >= 0) {
                menuItem.setShowAsAction(i10);
            }
            if (this.f1069z != null) {
                if (g.this.f1039c.isRestricted()) {
                    throw new IllegalStateException("The android:onClick attribute cannot be used within a restricted context");
                }
                menuItem.setOnMenuItemClickListener(new a(g.this.b(), this.f1069z));
            }
            if (this.f1061r >= 2) {
                if (menuItem instanceof androidx.appcompat.view.menu.i) {
                    ((androidx.appcompat.view.menu.i) menuItem).t(true);
                } else if (menuItem instanceof androidx.appcompat.view.menu.j) {
                    ((androidx.appcompat.view.menu.j) menuItem).h(true);
                }
            }
            String str = this.f1067x;
            if (str != null) {
                menuItem.setActionView((View) e(str, g.f1035e, g.this.f1037a));
                z9 = true;
            }
            int i11 = this.f1066w;
            if (i11 > 0) {
                if (z9) {
                    Log.w("SupportMenuInflater", "Ignoring attribute 'itemActionViewLayout'. Action view already specified.");
                } else {
                    menuItem.setActionView(i11);
                }
            }
            androidx.core.view.b bVar = this.A;
            if (bVar != null) {
                c0.a(menuItem, bVar);
            }
            c0.c(menuItem, this.B);
            c0.g(menuItem, this.C);
            c0.b(menuItem, this.f1057n, this.f1058o);
            c0.f(menuItem, this.f1059p, this.f1060q);
            PorterDuff.Mode mode = this.E;
            if (mode != null) {
                c0.e(menuItem, mode);
            }
            ColorStateList colorStateList = this.D;
            if (colorStateList != null) {
                c0.d(menuItem, colorStateList);
            }
        }

        public void a() {
            this.f1051h = true;
            i(this.f1044a.add(this.f1045b, this.f1052i, this.f1053j, this.f1054k));
        }

        public SubMenu b() {
            this.f1051h = true;
            SubMenu addSubMenu = this.f1044a.addSubMenu(this.f1045b, this.f1052i, this.f1053j, this.f1054k);
            i(addSubMenu.getItem());
            return addSubMenu;
        }

        public boolean d() {
            return this.f1051h;
        }

        public void f(AttributeSet attributeSet) {
            TypedArray obtainStyledAttributes = g.this.f1039c.obtainStyledAttributes(attributeSet, g.j.f7843o1);
            this.f1045b = obtainStyledAttributes.getResourceId(g.j.f7853q1, 0);
            this.f1046c = obtainStyledAttributes.getInt(g.j.f7863s1, 0);
            this.f1047d = obtainStyledAttributes.getInt(g.j.f7868t1, 0);
            this.f1048e = obtainStyledAttributes.getInt(g.j.f7873u1, 0);
            this.f1049f = obtainStyledAttributes.getBoolean(g.j.f7858r1, true);
            this.f1050g = obtainStyledAttributes.getBoolean(g.j.f7848p1, true);
            obtainStyledAttributes.recycle();
        }

        /* JADX WARN: Multi-variable type inference failed */
        public void g(AttributeSet attributeSet) {
            k2 u9 = k2.u(g.this.f1039c, attributeSet, g.j.f7878v1);
            this.f1052i = u9.n(g.j.f7893y1, 0);
            this.f1053j = (u9.k(g.j.B1, this.f1046c) & (-65536)) | (u9.k(g.j.C1, this.f1047d) & 65535);
            this.f1054k = u9.p(g.j.D1);
            this.f1055l = u9.p(g.j.E1);
            this.f1056m = u9.n(g.j.f7883w1, 0);
            this.f1057n = c(u9.o(g.j.F1));
            this.f1058o = u9.k(g.j.M1, 4096);
            this.f1059p = c(u9.o(g.j.G1));
            this.f1060q = u9.k(g.j.Q1, 4096);
            int i10 = g.j.H1;
            this.f1061r = u9.s(i10) ? u9.a(i10, false) : this.f1048e;
            this.f1062s = u9.a(g.j.f7898z1, false);
            this.f1063t = u9.a(g.j.A1, this.f1049f);
            this.f1064u = u9.a(g.j.f7888x1, this.f1050g);
            this.f1065v = u9.k(g.j.R1, -1);
            this.f1069z = u9.o(g.j.I1);
            this.f1066w = u9.n(g.j.J1, 0);
            this.f1067x = u9.o(g.j.L1);
            String o10 = u9.o(g.j.K1);
            this.f1068y = o10;
            boolean z9 = o10 != null;
            if (z9 && this.f1066w == 0 && this.f1067x == null) {
                this.A = (androidx.core.view.b) e(o10, g.f1036f, g.this.f1038b);
            } else {
                if (z9) {
                    Log.w("SupportMenuInflater", "Ignoring attribute 'actionProviderClass'. Action view already specified.");
                }
                this.A = null;
            }
            this.B = u9.p(g.j.N1);
            this.C = u9.p(g.j.S1);
            int i11 = g.j.P1;
            if (u9.s(i11)) {
                this.E = m1.d(u9.k(i11, -1), this.E);
            } else {
                this.E = null;
            }
            int i12 = g.j.O1;
            if (u9.s(i12)) {
                this.D = u9.c(i12);
            } else {
                this.D = null;
            }
            u9.w();
            this.f1051h = false;
        }

        public void h() {
            this.f1045b = 0;
            this.f1046c = 0;
            this.f1047d = 0;
            this.f1048e = 0;
            this.f1049f = true;
            this.f1050g = true;
        }
    }

    static {
        Class[] clsArr = {Context.class};
        f1035e = clsArr;
        f1036f = clsArr;
    }

    public g(Context context) {
        super(context);
        this.f1039c = context;
        Object[] objArr = {context};
        this.f1037a = objArr;
        this.f1038b = objArr;
    }

    private Object a(Object obj) {
        return (!(obj instanceof Activity) && (obj instanceof ContextWrapper)) ? a(((ContextWrapper) obj).getBaseContext()) : obj;
    }

    /* JADX WARN: Code restructure failed: missing block: B:12:0x003b, code lost:
        r8 = null;
        r6 = false;
        r7 = false;
     */
    /* JADX WARN: Code restructure failed: missing block: B:13:0x0040, code lost:
        if (r6 != false) goto L64;
     */
    /* JADX WARN: Code restructure failed: missing block: B:14:0x0042, code lost:
        if (r15 == 1) goto L60;
     */
    /* JADX WARN: Code restructure failed: missing block: B:16:0x0048, code lost:
        if (r15 == 2) goto L44;
     */
    /* JADX WARN: Code restructure failed: missing block: B:18:0x004b, code lost:
        if (r15 == 3) goto L14;
     */
    /* JADX WARN: Code restructure failed: missing block: B:20:0x004f, code lost:
        r15 = r13.getName();
     */
    /* JADX WARN: Code restructure failed: missing block: B:21:0x0053, code lost:
        if (r7 == false) goto L21;
     */
    /* JADX WARN: Code restructure failed: missing block: B:23:0x0059, code lost:
        if (r15.equals(r8) == false) goto L21;
     */
    /* JADX WARN: Code restructure failed: missing block: B:24:0x005b, code lost:
        r8 = null;
        r7 = false;
     */
    /* JADX WARN: Code restructure failed: missing block: B:26:0x0062, code lost:
        if (r15.equals("group") == false) goto L25;
     */
    /* JADX WARN: Code restructure failed: missing block: B:27:0x0064, code lost:
        r0.h();
     */
    /* JADX WARN: Code restructure failed: missing block: B:29:0x006c, code lost:
        if (r15.equals("item") == false) goto L38;
     */
    /* JADX WARN: Code restructure failed: missing block: B:31:0x0072, code lost:
        if (r0.d() != false) goto L37;
     */
    /* JADX WARN: Code restructure failed: missing block: B:32:0x0074, code lost:
        r15 = r0.A;
     */
    /* JADX WARN: Code restructure failed: missing block: B:33:0x0076, code lost:
        if (r15 == null) goto L35;
     */
    /* JADX WARN: Code restructure failed: missing block: B:35:0x007c, code lost:
        if (r15.a() == false) goto L35;
     */
    /* JADX WARN: Code restructure failed: missing block: B:36:0x007e, code lost:
        r0.b();
     */
    /* JADX WARN: Code restructure failed: missing block: B:37:0x0082, code lost:
        r0.a();
     */
    /* JADX WARN: Code restructure failed: missing block: B:39:0x008a, code lost:
        if (r15.equals("menu") == false) goto L42;
     */
    /* JADX WARN: Code restructure failed: missing block: B:40:0x008c, code lost:
        r6 = true;
     */
    /* JADX WARN: Code restructure failed: missing block: B:41:0x008e, code lost:
        if (r7 == false) goto L45;
     */
    /* JADX WARN: Code restructure failed: missing block: B:43:0x0091, code lost:
        r15 = r13.getName();
     */
    /* JADX WARN: Code restructure failed: missing block: B:44:0x0099, code lost:
        if (r15.equals("group") == false) goto L49;
     */
    /* JADX WARN: Code restructure failed: missing block: B:45:0x009b, code lost:
        r0.f(r14);
     */
    /* JADX WARN: Code restructure failed: missing block: B:47:0x00a3, code lost:
        if (r15.equals("item") == false) goto L53;
     */
    /* JADX WARN: Code restructure failed: missing block: B:48:0x00a5, code lost:
        r0.g(r14);
     */
    /* JADX WARN: Code restructure failed: missing block: B:50:0x00ad, code lost:
        if (r15.equals("menu") == false) goto L57;
     */
    /* JADX WARN: Code restructure failed: missing block: B:51:0x00af, code lost:
        c(r13, r14, r0.b());
     */
    /* JADX WARN: Code restructure failed: missing block: B:52:0x00b7, code lost:
        r8 = r15;
        r7 = true;
     */
    /* JADX WARN: Code restructure failed: missing block: B:53:0x00b9, code lost:
        r15 = r13.next();
     */
    /* JADX WARN: Code restructure failed: missing block: B:55:0x00c5, code lost:
        throw new java.lang.RuntimeException("Unexpected end of document");
     */
    /* JADX WARN: Code restructure failed: missing block: B:56:0x00c6, code lost:
        return;
     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private void c(XmlPullParser xmlPullParser, AttributeSet attributeSet, Menu menu) {
        b bVar = new b(menu);
        int eventType = xmlPullParser.getEventType();
        while (true) {
            if (eventType != 2) {
                eventType = xmlPullParser.next();
                if (eventType == 1) {
                    break;
                }
            } else {
                String name = xmlPullParser.getName();
                if (!name.equals("menu")) {
                    throw new RuntimeException("Expecting menu, got " + name);
                }
                eventType = xmlPullParser.next();
            }
        }
    }

    Object b() {
        if (this.f1040d == null) {
            this.f1040d = a(this.f1039c);
        }
        return this.f1040d;
    }

    @Override // android.view.MenuInflater
    public void inflate(int i10, Menu menu) {
        if (!(menu instanceof r.a)) {
            super.inflate(i10, menu);
            return;
        }
        XmlResourceParser xmlResourceParser = null;
        try {
            try {
                try {
                    xmlResourceParser = this.f1039c.getResources().getLayout(i10);
                    c(xmlResourceParser, Xml.asAttributeSet(xmlResourceParser), menu);
                } catch (XmlPullParserException e10) {
                    throw new InflateException("Error inflating menu XML", e10);
                }
            } catch (IOException e11) {
                throw new InflateException("Error inflating menu XML", e11);
            }
        } finally {
            if (xmlResourceParser != null) {
                xmlResourceParser.close();
            }
        }
    }
}
