package androidx.appcompat.view;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.view.LayoutInflater;
/* loaded from: classes.dex */
public class d extends ContextWrapper {

    /* renamed from: f  reason: collision with root package name */
    private static Configuration f1016f;

    /* renamed from: a  reason: collision with root package name */
    private int f1017a;

    /* renamed from: b  reason: collision with root package name */
    private Resources.Theme f1018b;

    /* renamed from: c  reason: collision with root package name */
    private LayoutInflater f1019c;

    /* renamed from: d  reason: collision with root package name */
    private Configuration f1020d;

    /* renamed from: e  reason: collision with root package name */
    private Resources f1021e;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class a {
        static Context a(d dVar, Configuration configuration) {
            return dVar.createConfigurationContext(configuration);
        }
    }

    public d(Context context, int i10) {
        super(context);
        this.f1017a = i10;
    }

    public d(Context context, Resources.Theme theme) {
        super(context);
        this.f1018b = theme;
    }

    private Resources b() {
        if (this.f1021e == null) {
            Configuration configuration = this.f1020d;
            this.f1021e = (configuration == null || (Build.VERSION.SDK_INT >= 26 && e(configuration))) ? super.getResources() : a.a(this, this.f1020d).getResources();
        }
        return this.f1021e;
    }

    private void d() {
        boolean z9 = this.f1018b == null;
        if (z9) {
            this.f1018b = getResources().newTheme();
            Resources.Theme theme = getBaseContext().getTheme();
            if (theme != null) {
                this.f1018b.setTo(theme);
            }
        }
        f(this.f1018b, this.f1017a, z9);
    }

    private static boolean e(Configuration configuration) {
        if (configuration == null) {
            return true;
        }
        if (f1016f == null) {
            Configuration configuration2 = new Configuration();
            configuration2.fontScale = 0.0f;
            f1016f = configuration2;
        }
        return configuration.equals(f1016f);
    }

    public void a(Configuration configuration) {
        if (this.f1021e != null) {
            throw new IllegalStateException("getResources() or getAssets() has already been called");
        }
        if (this.f1020d != null) {
            throw new IllegalStateException("Override configuration has already been set");
        }
        this.f1020d = new Configuration(configuration);
    }

    @Override // android.content.ContextWrapper
    protected void attachBaseContext(Context context) {
        super.attachBaseContext(context);
    }

    public int c() {
        return this.f1017a;
    }

    protected void f(Resources.Theme theme, int i10, boolean z9) {
        theme.applyStyle(i10, true);
    }

    @Override // android.content.ContextWrapper, android.content.Context
    public AssetManager getAssets() {
        return getResources().getAssets();
    }

    @Override // android.content.ContextWrapper, android.content.Context
    public Resources getResources() {
        return b();
    }

    @Override // android.content.ContextWrapper, android.content.Context
    public Object getSystemService(String str) {
        if ("layout_inflater".equals(str)) {
            if (this.f1019c == null) {
                this.f1019c = LayoutInflater.from(getBaseContext()).cloneInContext(this);
            }
            return this.f1019c;
        }
        return getBaseContext().getSystemService(str);
    }

    @Override // android.content.ContextWrapper, android.content.Context
    public Resources.Theme getTheme() {
        Resources.Theme theme = this.f1018b;
        if (theme != null) {
            return theme;
        }
        if (this.f1017a == 0) {
            this.f1017a = g.i.Theme_AppCompat_Light;
        }
        d();
        return this.f1018b;
    }

    @Override // android.content.ContextWrapper, android.content.Context
    public void setTheme(int i10) {
        if (this.f1017a != i10) {
            this.f1017a = i10;
            d();
        }
    }
}
