package androidx.appcompat.app;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.appcompat.app.a;
import androidx.appcompat.view.b;
import androidx.appcompat.view.menu.g;
import androidx.appcompat.widget.ActionBarContainer;
import androidx.appcompat.widget.ActionBarContextView;
import androidx.appcompat.widget.ActionBarOverlayLayout;
import androidx.appcompat.widget.Toolbar;
import androidx.appcompat.widget.l1;
import androidx.core.view.r0;
import androidx.core.view.u2;
import androidx.core.view.v2;
import androidx.core.view.w2;
import androidx.core.view.x2;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
/* loaded from: classes.dex */
public class u extends androidx.appcompat.app.a implements ActionBarOverlayLayout.d {
    private static final Interpolator D = new AccelerateInterpolator();
    private static final Interpolator E = new DecelerateInterpolator();

    /* renamed from: a  reason: collision with root package name */
    Context f979a;

    /* renamed from: b  reason: collision with root package name */
    private Context f980b;

    /* renamed from: c  reason: collision with root package name */
    private Activity f981c;

    /* renamed from: d  reason: collision with root package name */
    ActionBarOverlayLayout f982d;

    /* renamed from: e  reason: collision with root package name */
    ActionBarContainer f983e;

    /* renamed from: f  reason: collision with root package name */
    l1 f984f;

    /* renamed from: g  reason: collision with root package name */
    ActionBarContextView f985g;

    /* renamed from: h  reason: collision with root package name */
    View f986h;

    /* renamed from: k  reason: collision with root package name */
    private boolean f989k;

    /* renamed from: l  reason: collision with root package name */
    d f990l;

    /* renamed from: m  reason: collision with root package name */
    androidx.appcompat.view.b f991m;

    /* renamed from: n  reason: collision with root package name */
    b.a f992n;

    /* renamed from: o  reason: collision with root package name */
    private boolean f993o;

    /* renamed from: q  reason: collision with root package name */
    private boolean f995q;

    /* renamed from: t  reason: collision with root package name */
    boolean f998t;

    /* renamed from: u  reason: collision with root package name */
    boolean f999u;

    /* renamed from: v  reason: collision with root package name */
    private boolean f1000v;

    /* renamed from: x  reason: collision with root package name */
    androidx.appcompat.view.h f1002x;

    /* renamed from: y  reason: collision with root package name */
    private boolean f1003y;

    /* renamed from: z  reason: collision with root package name */
    boolean f1004z;

    /* renamed from: i  reason: collision with root package name */
    private ArrayList f987i = new ArrayList();

    /* renamed from: j  reason: collision with root package name */
    private int f988j = -1;

    /* renamed from: p  reason: collision with root package name */
    private ArrayList f994p = new ArrayList();

    /* renamed from: r  reason: collision with root package name */
    private int f996r = 0;

    /* renamed from: s  reason: collision with root package name */
    boolean f997s = true;

    /* renamed from: w  reason: collision with root package name */
    private boolean f1001w = true;
    final v2 A = new a();
    final v2 B = new b();
    final x2 C = new c();

    /* loaded from: classes.dex */
    class a extends w2 {
        a() {
        }

        @Override // androidx.core.view.v2
        public void b(View view) {
            View view2;
            u uVar = u.this;
            if (uVar.f997s && (view2 = uVar.f986h) != null) {
                view2.setTranslationY(0.0f);
                u.this.f983e.setTranslationY(0.0f);
            }
            u.this.f983e.setVisibility(8);
            u.this.f983e.setTransitioning(false);
            u uVar2 = u.this;
            uVar2.f1002x = null;
            uVar2.r();
            ActionBarOverlayLayout actionBarOverlayLayout = u.this.f982d;
            if (actionBarOverlayLayout != null) {
                r0.k0(actionBarOverlayLayout);
            }
        }
    }

    /* loaded from: classes.dex */
    class b extends w2 {
        b() {
        }

        @Override // androidx.core.view.v2
        public void b(View view) {
            u uVar = u.this;
            uVar.f1002x = null;
            uVar.f983e.requestLayout();
        }
    }

    /* loaded from: classes.dex */
    class c implements x2 {
        c() {
        }

        @Override // androidx.core.view.x2
        public void a(View view) {
            ((View) u.this.f983e.getParent()).invalidate();
        }
    }

    /* loaded from: classes.dex */
    public class d extends androidx.appcompat.view.b implements g.a {

        /* renamed from: i  reason: collision with root package name */
        private final Context f1008i;

        /* renamed from: j  reason: collision with root package name */
        private final androidx.appcompat.view.menu.g f1009j;

        /* renamed from: k  reason: collision with root package name */
        private b.a f1010k;

        /* renamed from: l  reason: collision with root package name */
        private WeakReference f1011l;

        public d(Context context, b.a aVar) {
            this.f1008i = context;
            this.f1010k = aVar;
            androidx.appcompat.view.menu.g S = new androidx.appcompat.view.menu.g(context).S(1);
            this.f1009j = S;
            S.R(this);
        }

        @Override // androidx.appcompat.view.menu.g.a
        public boolean a(androidx.appcompat.view.menu.g gVar, MenuItem menuItem) {
            b.a aVar = this.f1010k;
            if (aVar != null) {
                return aVar.d(this, menuItem);
            }
            return false;
        }

        @Override // androidx.appcompat.view.menu.g.a
        public void b(androidx.appcompat.view.menu.g gVar) {
            if (this.f1010k == null) {
                return;
            }
            k();
            u.this.f985g.l();
        }

        @Override // androidx.appcompat.view.b
        public void c() {
            u uVar = u.this;
            if (uVar.f990l != this) {
                return;
            }
            if (u.q(uVar.f998t, uVar.f999u, false)) {
                this.f1010k.a(this);
            } else {
                u uVar2 = u.this;
                uVar2.f991m = this;
                uVar2.f992n = this.f1010k;
            }
            this.f1010k = null;
            u.this.p(false);
            u.this.f985g.g();
            u uVar3 = u.this;
            uVar3.f982d.setHideOnContentScrollEnabled(uVar3.f1004z);
            u.this.f990l = null;
        }

        @Override // androidx.appcompat.view.b
        public View d() {
            WeakReference weakReference = this.f1011l;
            if (weakReference != null) {
                return (View) weakReference.get();
            }
            return null;
        }

        @Override // androidx.appcompat.view.b
        public Menu e() {
            return this.f1009j;
        }

        @Override // androidx.appcompat.view.b
        public MenuInflater f() {
            return new androidx.appcompat.view.g(this.f1008i);
        }

        @Override // androidx.appcompat.view.b
        public CharSequence g() {
            return u.this.f985g.getSubtitle();
        }

        @Override // androidx.appcompat.view.b
        public CharSequence i() {
            return u.this.f985g.getTitle();
        }

        @Override // androidx.appcompat.view.b
        public void k() {
            if (u.this.f990l != this) {
                return;
            }
            this.f1009j.d0();
            try {
                this.f1010k.c(this, this.f1009j);
            } finally {
                this.f1009j.c0();
            }
        }

        @Override // androidx.appcompat.view.b
        public boolean l() {
            return u.this.f985g.j();
        }

        @Override // androidx.appcompat.view.b
        public void m(View view) {
            u.this.f985g.setCustomView(view);
            this.f1011l = new WeakReference(view);
        }

        @Override // androidx.appcompat.view.b
        public void n(int i10) {
            o(u.this.f979a.getResources().getString(i10));
        }

        @Override // androidx.appcompat.view.b
        public void o(CharSequence charSequence) {
            u.this.f985g.setSubtitle(charSequence);
        }

        @Override // androidx.appcompat.view.b
        public void q(int i10) {
            r(u.this.f979a.getResources().getString(i10));
        }

        @Override // androidx.appcompat.view.b
        public void r(CharSequence charSequence) {
            u.this.f985g.setTitle(charSequence);
        }

        @Override // androidx.appcompat.view.b
        public void s(boolean z9) {
            super.s(z9);
            u.this.f985g.setTitleOptional(z9);
        }

        public boolean t() {
            this.f1009j.d0();
            try {
                return this.f1010k.b(this, this.f1009j);
            } finally {
                this.f1009j.c0();
            }
        }
    }

    public u(Activity activity, boolean z9) {
        this.f981c = activity;
        View decorView = activity.getWindow().getDecorView();
        x(decorView);
        if (z9) {
            return;
        }
        this.f986h = decorView.findViewById(16908290);
    }

    public u(Dialog dialog) {
        x(dialog.getWindow().getDecorView());
    }

    private void B(boolean z9) {
        this.f995q = z9;
        if (z9) {
            this.f983e.setTabContainer(null);
            this.f984f.i(null);
        } else {
            this.f984f.i(null);
            this.f983e.setTabContainer(null);
        }
        boolean z10 = true;
        boolean z11 = v() == 2;
        this.f984f.t(!this.f995q && z11);
        this.f982d.setHasNonEmbeddedTabs((this.f995q || !z11) ? false : false);
    }

    private boolean E() {
        return r0.R(this.f983e);
    }

    private void F() {
        if (this.f1000v) {
            return;
        }
        this.f1000v = true;
        ActionBarOverlayLayout actionBarOverlayLayout = this.f982d;
        if (actionBarOverlayLayout != null) {
            actionBarOverlayLayout.setShowingForActionMode(true);
        }
        G(false);
    }

    private void G(boolean z9) {
        if (q(this.f998t, this.f999u, this.f1000v)) {
            if (this.f1001w) {
                return;
            }
            this.f1001w = true;
            t(z9);
        } else if (this.f1001w) {
            this.f1001w = false;
            s(z9);
        }
    }

    static boolean q(boolean z9, boolean z10, boolean z11) {
        if (z11) {
            return true;
        }
        return (z9 || z10) ? false : true;
    }

    private l1 u(View view) {
        if (view instanceof l1) {
            return (l1) view;
        }
        if (view instanceof Toolbar) {
            return ((Toolbar) view).getWrapper();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Can't make a decor toolbar out of ");
        sb.append(view != null ? view.getClass().getSimpleName() : "null");
        throw new IllegalStateException(sb.toString());
    }

    private void w() {
        if (this.f1000v) {
            this.f1000v = false;
            ActionBarOverlayLayout actionBarOverlayLayout = this.f982d;
            if (actionBarOverlayLayout != null) {
                actionBarOverlayLayout.setShowingForActionMode(false);
            }
            G(false);
        }
    }

    private void x(View view) {
        ActionBarOverlayLayout actionBarOverlayLayout = (ActionBarOverlayLayout) view.findViewById(g.f.decor_content_parent);
        this.f982d = actionBarOverlayLayout;
        if (actionBarOverlayLayout != null) {
            actionBarOverlayLayout.setActionBarVisibilityCallback(this);
        }
        this.f984f = u(view.findViewById(g.f.action_bar));
        this.f985g = (ActionBarContextView) view.findViewById(g.f.action_context_bar);
        ActionBarContainer actionBarContainer = (ActionBarContainer) view.findViewById(g.f.action_bar_container);
        this.f983e = actionBarContainer;
        l1 l1Var = this.f984f;
        if (l1Var == null || this.f985g == null || actionBarContainer == null) {
            throw new IllegalStateException(getClass().getSimpleName() + " can only be used with a compatible window decor layout");
        }
        this.f979a = l1Var.getContext();
        boolean z9 = (this.f984f.q() & 4) != 0;
        if (z9) {
            this.f989k = true;
        }
        androidx.appcompat.view.a b10 = androidx.appcompat.view.a.b(this.f979a);
        D(b10.a() || z9);
        B(b10.e());
        TypedArray obtainStyledAttributes = this.f979a.obtainStyledAttributes(null, g.j.f7771a, g.a.actionBarStyle, 0);
        if (obtainStyledAttributes.getBoolean(g.j.f7821k, false)) {
            C(true);
        }
        int dimensionPixelSize = obtainStyledAttributes.getDimensionPixelSize(g.j.f7811i, 0);
        if (dimensionPixelSize != 0) {
            A(dimensionPixelSize);
        }
        obtainStyledAttributes.recycle();
    }

    public void A(float f10) {
        r0.v0(this.f983e, f10);
    }

    public void C(boolean z9) {
        if (z9 && !this.f982d.w()) {
            throw new IllegalStateException("Action bar must be in overlay mode (Window.FEATURE_OVERLAY_ACTION_BAR) to enable hide on content scroll");
        }
        this.f1004z = z9;
        this.f982d.setHideOnContentScrollEnabled(z9);
    }

    public void D(boolean z9) {
        this.f984f.p(z9);
    }

    @Override // androidx.appcompat.widget.ActionBarOverlayLayout.d
    public void a() {
        if (this.f999u) {
            this.f999u = false;
            G(true);
        }
    }

    @Override // androidx.appcompat.widget.ActionBarOverlayLayout.d
    public void b() {
    }

    @Override // androidx.appcompat.widget.ActionBarOverlayLayout.d
    public void c(boolean z9) {
        this.f997s = z9;
    }

    @Override // androidx.appcompat.widget.ActionBarOverlayLayout.d
    public void d() {
        if (this.f999u) {
            return;
        }
        this.f999u = true;
        G(true);
    }

    @Override // androidx.appcompat.widget.ActionBarOverlayLayout.d
    public void e() {
        androidx.appcompat.view.h hVar = this.f1002x;
        if (hVar != null) {
            hVar.a();
            this.f1002x = null;
        }
    }

    @Override // androidx.appcompat.app.a
    public boolean f() {
        l1 l1Var = this.f984f;
        if (l1Var == null || !l1Var.j()) {
            return false;
        }
        this.f984f.collapseActionView();
        return true;
    }

    @Override // androidx.appcompat.app.a
    public void g(boolean z9) {
        if (z9 == this.f993o) {
            return;
        }
        this.f993o = z9;
        int size = this.f994p.size();
        for (int i10 = 0; i10 < size; i10++) {
            ((a.b) this.f994p.get(i10)).onMenuVisibilityChanged(z9);
        }
    }

    @Override // androidx.appcompat.app.a
    public Context h() {
        if (this.f980b == null) {
            TypedValue typedValue = new TypedValue();
            this.f979a.getTheme().resolveAttribute(g.a.actionBarWidgetTheme, typedValue, true);
            int i10 = typedValue.resourceId;
            if (i10 != 0) {
                this.f980b = new ContextThemeWrapper(this.f979a, i10);
            } else {
                this.f980b = this.f979a;
            }
        }
        return this.f980b;
    }

    @Override // androidx.appcompat.app.a
    public boolean k(int i10, KeyEvent keyEvent) {
        Menu e10;
        d dVar = this.f990l;
        if (dVar == null || (e10 = dVar.e()) == null) {
            return false;
        }
        e10.setQwertyMode(KeyCharacterMap.load(keyEvent != null ? keyEvent.getDeviceId() : -1).getKeyboardType() != 1);
        return e10.performShortcut(i10, keyEvent, 0);
    }

    @Override // androidx.appcompat.app.a
    public void l(boolean z9) {
        if (this.f989k) {
            return;
        }
        y(z9);
    }

    @Override // androidx.appcompat.app.a
    public void m(boolean z9) {
        androidx.appcompat.view.h hVar;
        this.f1003y = z9;
        if (z9 || (hVar = this.f1002x) == null) {
            return;
        }
        hVar.a();
    }

    @Override // androidx.appcompat.app.a
    public void n(CharSequence charSequence) {
        this.f984f.setWindowTitle(charSequence);
    }

    @Override // androidx.appcompat.app.a
    public androidx.appcompat.view.b o(b.a aVar) {
        d dVar = this.f990l;
        if (dVar != null) {
            dVar.c();
        }
        this.f982d.setHideOnContentScrollEnabled(false);
        this.f985g.k();
        d dVar2 = new d(this.f985g.getContext(), aVar);
        if (dVar2.t()) {
            this.f990l = dVar2;
            dVar2.k();
            this.f985g.h(dVar2);
            p(true);
            return dVar2;
        }
        return null;
    }

    @Override // androidx.appcompat.widget.ActionBarOverlayLayout.d
    public void onWindowVisibilityChanged(int i10) {
        this.f996r = i10;
    }

    public void p(boolean z9) {
        u2 n10;
        u2 f10;
        if (z9) {
            F();
        } else {
            w();
        }
        if (!E()) {
            if (z9) {
                this.f984f.o(4);
                this.f985g.setVisibility(0);
                return;
            }
            this.f984f.o(0);
            this.f985g.setVisibility(8);
            return;
        }
        if (z9) {
            f10 = this.f984f.n(4, 100L);
            n10 = this.f985g.f(0, 200L);
        } else {
            n10 = this.f984f.n(0, 200L);
            f10 = this.f985g.f(8, 100L);
        }
        androidx.appcompat.view.h hVar = new androidx.appcompat.view.h();
        hVar.d(f10, n10);
        hVar.h();
    }

    void r() {
        b.a aVar = this.f992n;
        if (aVar != null) {
            aVar.a(this.f991m);
            this.f991m = null;
            this.f992n = null;
        }
    }

    public void s(boolean z9) {
        View view;
        int[] iArr;
        androidx.appcompat.view.h hVar = this.f1002x;
        if (hVar != null) {
            hVar.a();
        }
        if (this.f996r != 0 || (!this.f1003y && !z9)) {
            this.A.b(null);
            return;
        }
        this.f983e.setAlpha(1.0f);
        this.f983e.setTransitioning(true);
        androidx.appcompat.view.h hVar2 = new androidx.appcompat.view.h();
        float f10 = -this.f983e.getHeight();
        if (z9) {
            this.f983e.getLocationInWindow(new int[]{0, 0});
            f10 -= iArr[1];
        }
        u2 m10 = r0.d(this.f983e).m(f10);
        m10.k(this.C);
        hVar2.c(m10);
        if (this.f997s && (view = this.f986h) != null) {
            hVar2.c(r0.d(view).m(f10));
        }
        hVar2.f(D);
        hVar2.e(250L);
        hVar2.g(this.A);
        this.f1002x = hVar2;
        hVar2.h();
    }

    public void t(boolean z9) {
        View view;
        View view2;
        int[] iArr;
        androidx.appcompat.view.h hVar = this.f1002x;
        if (hVar != null) {
            hVar.a();
        }
        this.f983e.setVisibility(0);
        if (this.f996r == 0 && (this.f1003y || z9)) {
            this.f983e.setTranslationY(0.0f);
            float f10 = -this.f983e.getHeight();
            if (z9) {
                this.f983e.getLocationInWindow(new int[]{0, 0});
                f10 -= iArr[1];
            }
            this.f983e.setTranslationY(f10);
            androidx.appcompat.view.h hVar2 = new androidx.appcompat.view.h();
            u2 m10 = r0.d(this.f983e).m(0.0f);
            m10.k(this.C);
            hVar2.c(m10);
            if (this.f997s && (view2 = this.f986h) != null) {
                view2.setTranslationY(f10);
                hVar2.c(r0.d(this.f986h).m(0.0f));
            }
            hVar2.f(E);
            hVar2.e(250L);
            hVar2.g(this.B);
            this.f1002x = hVar2;
            hVar2.h();
        } else {
            this.f983e.setAlpha(1.0f);
            this.f983e.setTranslationY(0.0f);
            if (this.f997s && (view = this.f986h) != null) {
                view.setTranslationY(0.0f);
            }
            this.B.b(null);
        }
        ActionBarOverlayLayout actionBarOverlayLayout = this.f982d;
        if (actionBarOverlayLayout != null) {
            r0.k0(actionBarOverlayLayout);
        }
    }

    public int v() {
        return this.f984f.m();
    }

    public void y(boolean z9) {
        z(z9 ? 4 : 0, 4);
    }

    public void z(int i10, int i11) {
        int q10 = this.f984f.q();
        if ((i11 & 4) != 0) {
            this.f989k = true;
        }
        this.f984f.k((i10 & i11) | ((~i11) & q10));
    }
}
