package androidx.appcompat.app;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import android.util.Log;
import java.util.Calendar;
/* loaded from: classes.dex */
class t {

    /* renamed from: d  reason: collision with root package name */
    private static t f973d;

    /* renamed from: a  reason: collision with root package name */
    private final Context f974a;

    /* renamed from: b  reason: collision with root package name */
    private final LocationManager f975b;

    /* renamed from: c  reason: collision with root package name */
    private final a f976c = new a();

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class a {

        /* renamed from: a  reason: collision with root package name */
        boolean f977a;

        /* renamed from: b  reason: collision with root package name */
        long f978b;

        a() {
        }
    }

    t(Context context, LocationManager locationManager) {
        this.f974a = context;
        this.f975b = locationManager;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static t a(Context context) {
        if (f973d == null) {
            Context applicationContext = context.getApplicationContext();
            f973d = new t(applicationContext, (LocationManager) applicationContext.getSystemService("location"));
        }
        return f973d;
    }

    private Location b() {
        Location c10 = androidx.core.content.h.b(this.f974a, "android.permission.ACCESS_COARSE_LOCATION") == 0 ? c("network") : null;
        Location c11 = androidx.core.content.h.b(this.f974a, "android.permission.ACCESS_FINE_LOCATION") == 0 ? c("gps") : null;
        return (c11 == null || c10 == null) ? c11 != null ? c11 : c10 : c11.getTime() > c10.getTime() ? c11 : c10;
    }

    private Location c(String str) {
        try {
            if (this.f975b.isProviderEnabled(str)) {
                return this.f975b.getLastKnownLocation(str);
            }
            return null;
        } catch (Exception e10) {
            Log.d("TwilightManager", "Failed to get last known location", e10);
            return null;
        }
    }

    private boolean e() {
        return this.f976c.f978b > System.currentTimeMillis();
    }

    private void f(Location location) {
        long j10;
        a aVar = this.f976c;
        long currentTimeMillis = System.currentTimeMillis();
        s b10 = s.b();
        b10.a(currentTimeMillis - 86400000, location.getLatitude(), location.getLongitude());
        b10.a(currentTimeMillis, location.getLatitude(), location.getLongitude());
        boolean z9 = b10.f972c == 1;
        long j11 = b10.f971b;
        long j12 = b10.f970a;
        b10.a(currentTimeMillis + 86400000, location.getLatitude(), location.getLongitude());
        long j13 = b10.f971b;
        if (j11 == -1 || j12 == -1) {
            j10 = 43200000 + currentTimeMillis;
        } else {
            j10 = (currentTimeMillis > j12 ? j13 + 0 : currentTimeMillis > j11 ? j12 + 0 : j11 + 0) + 60000;
        }
        aVar.f977a = z9;
        aVar.f978b = j10;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean d() {
        a aVar = this.f976c;
        if (e()) {
            return aVar.f977a;
        }
        Location b10 = b();
        if (b10 != null) {
            f(b10);
            return aVar.f977a;
        }
        Log.i("TwilightManager", "Could not get last known location. This is probably because the app does not have any location permissions. Falling back to hardcoded sunrise/sunset values.");
        int i10 = Calendar.getInstance().get(11);
        return i10 < 6 || i10 >= 22;
    }
}
