package androidx.appcompat.app;

import android.app.Activity;
import android.app.Dialog;
import android.app.UiModeManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.os.Build;
import android.os.Bundle;
import android.os.LocaleList;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import android.window.OnBackInvokedCallback;
import android.window.OnBackInvokedDispatcher;
import androidx.appcompat.view.b;
import androidx.appcompat.view.f;
import androidx.appcompat.view.menu.g;
import androidx.appcompat.view.menu.m;
import androidx.appcompat.widget.ActionBarContextView;
import androidx.appcompat.widget.ContentFrameLayout;
import androidx.appcompat.widget.ViewStubCompat;
import androidx.appcompat.widget.k1;
import androidx.appcompat.widget.k2;
import androidx.appcompat.widget.v2;
import androidx.core.view.j;
import androidx.core.view.j0;
import androidx.core.view.r0;
import androidx.core.view.u2;
import androidx.core.view.w2;
import androidx.core.view.y2;
import androidx.lifecycle.h;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public class f extends androidx.appcompat.app.e implements g.a, LayoutInflater.Factory2 {

    /* renamed from: o0  reason: collision with root package name */
    private static final o.h f873o0 = new o.h();

    /* renamed from: p0  reason: collision with root package name */
    private static final boolean f874p0 = false;

    /* renamed from: q0  reason: collision with root package name */
    private static final int[] f875q0 = {16842836};

    /* renamed from: r0  reason: collision with root package name */
    private static final boolean f876r0 = !"robolectric".equals(Build.FINGERPRINT);

    /* renamed from: s0  reason: collision with root package name */
    private static final boolean f877s0 = true;
    ActionBarContextView A;
    PopupWindow B;
    Runnable C;
    u2 D;
    private boolean E;
    private boolean F;
    ViewGroup G;
    private TextView H;
    private View I;
    private boolean J;
    private boolean K;
    boolean L;
    boolean M;
    boolean N;
    boolean O;
    boolean P;
    private boolean Q;
    private r[] R;
    private r S;
    private boolean T;
    private boolean U;
    private boolean V;
    boolean W;
    private Configuration X;
    private int Y;
    private int Z;

    /* renamed from: a0  reason: collision with root package name */
    private int f878a0;

    /* renamed from: b0  reason: collision with root package name */
    private boolean f879b0;

    /* renamed from: c0  reason: collision with root package name */
    private o f880c0;

    /* renamed from: d0  reason: collision with root package name */
    private o f881d0;

    /* renamed from: e0  reason: collision with root package name */
    boolean f882e0;

    /* renamed from: f0  reason: collision with root package name */
    int f883f0;

    /* renamed from: g0  reason: collision with root package name */
    private final Runnable f884g0;

    /* renamed from: h0  reason: collision with root package name */
    private boolean f885h0;

    /* renamed from: i0  reason: collision with root package name */
    private Rect f886i0;

    /* renamed from: j0  reason: collision with root package name */
    private Rect f887j0;

    /* renamed from: k0  reason: collision with root package name */
    private androidx.appcompat.app.l f888k0;

    /* renamed from: l0  reason: collision with root package name */
    private androidx.appcompat.app.p f889l0;

    /* renamed from: m0  reason: collision with root package name */
    private OnBackInvokedDispatcher f890m0;

    /* renamed from: n0  reason: collision with root package name */
    private OnBackInvokedCallback f891n0;

    /* renamed from: p  reason: collision with root package name */
    final Object f892p;

    /* renamed from: q  reason: collision with root package name */
    final Context f893q;

    /* renamed from: r  reason: collision with root package name */
    Window f894r;

    /* renamed from: s  reason: collision with root package name */
    private m f895s;

    /* renamed from: t  reason: collision with root package name */
    final androidx.appcompat.app.d f896t;

    /* renamed from: u  reason: collision with root package name */
    androidx.appcompat.app.a f897u;

    /* renamed from: v  reason: collision with root package name */
    private CharSequence f898v;

    /* renamed from: w  reason: collision with root package name */
    private k1 f899w;

    /* renamed from: x  reason: collision with root package name */
    private g f900x;

    /* renamed from: y  reason: collision with root package name */
    private s f901y;

    /* renamed from: z  reason: collision with root package name */
    androidx.appcompat.view.b f902z;

    /* loaded from: classes.dex */
    class a implements Runnable {
        a() {
        }

        @Override // java.lang.Runnable
        public void run() {
            f fVar = f.this;
            if ((fVar.f883f0 & 1) != 0) {
                fVar.N(0);
            }
            f fVar2 = f.this;
            if ((fVar2.f883f0 & 4096) != 0) {
                fVar2.N(108);
            }
            f fVar3 = f.this;
            fVar3.f882e0 = false;
            fVar3.f883f0 = 0;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class b implements j0 {
        b() {
        }

        @Override // androidx.core.view.j0
        public y2 a(View view, y2 y2Var) {
            int k10 = y2Var.k();
            int K0 = f.this.K0(y2Var, null);
            if (k10 != K0) {
                y2Var = y2Var.o(y2Var.i(), K0, y2Var.j(), y2Var.h());
            }
            return r0.Z(view, y2Var);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class c implements ContentFrameLayout.a {
        c() {
        }

        @Override // androidx.appcompat.widget.ContentFrameLayout.a
        public void a() {
        }

        @Override // androidx.appcompat.widget.ContentFrameLayout.a
        public void onDetachedFromWindow() {
            f.this.L();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class d implements Runnable {

        /* loaded from: classes.dex */
        class a extends w2 {
            a() {
            }

            @Override // androidx.core.view.v2
            public void b(View view) {
                f.this.A.setAlpha(1.0f);
                f.this.D.h(null);
                f.this.D = null;
            }

            @Override // androidx.core.view.w2, androidx.core.view.v2
            public void c(View view) {
                f.this.A.setVisibility(0);
            }
        }

        d() {
        }

        @Override // java.lang.Runnable
        public void run() {
            f fVar = f.this;
            fVar.B.showAtLocation(fVar.A, 55, 0, 0);
            f.this.O();
            if (!f.this.z0()) {
                f.this.A.setAlpha(1.0f);
                f.this.A.setVisibility(0);
                return;
            }
            f.this.A.setAlpha(0.0f);
            f fVar2 = f.this;
            fVar2.D = r0.d(fVar2.A).b(1.0f);
            f.this.D.h(new a());
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class e extends w2 {
        e() {
        }

        @Override // androidx.core.view.v2
        public void b(View view) {
            f.this.A.setAlpha(1.0f);
            f.this.D.h(null);
            f.this.D = null;
        }

        @Override // androidx.core.view.w2, androidx.core.view.v2
        public void c(View view) {
            f.this.A.setVisibility(0);
            if (f.this.A.getParent() instanceof View) {
                r0.k0((View) f.this.A.getParent());
            }
        }
    }

    /* renamed from: androidx.appcompat.app.f$f  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    interface InterfaceC0005f {
        boolean a(int i10);

        View onCreatePanelView(int i10);
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public final class g implements m.a {
        g() {
        }

        @Override // androidx.appcompat.view.menu.m.a
        public void b(androidx.appcompat.view.menu.g gVar, boolean z9) {
            f.this.E(gVar);
        }

        @Override // androidx.appcompat.view.menu.m.a
        public boolean c(androidx.appcompat.view.menu.g gVar) {
            Window.Callback a02 = f.this.a0();
            if (a02 != null) {
                a02.onMenuOpened(108, gVar);
                return true;
            }
            return true;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class h implements b.a {

        /* renamed from: a  reason: collision with root package name */
        private b.a f910a;

        /* loaded from: classes.dex */
        class a extends w2 {
            a() {
            }

            @Override // androidx.core.view.v2
            public void b(View view) {
                f.this.A.setVisibility(8);
                f fVar = f.this;
                PopupWindow popupWindow = fVar.B;
                if (popupWindow != null) {
                    popupWindow.dismiss();
                } else if (fVar.A.getParent() instanceof View) {
                    r0.k0((View) f.this.A.getParent());
                }
                f.this.A.k();
                f.this.D.h(null);
                f fVar2 = f.this;
                fVar2.D = null;
                r0.k0(fVar2.G);
            }
        }

        public h(b.a aVar) {
            this.f910a = aVar;
        }

        @Override // androidx.appcompat.view.b.a
        public void a(androidx.appcompat.view.b bVar) {
            this.f910a.a(bVar);
            f fVar = f.this;
            if (fVar.B != null) {
                fVar.f894r.getDecorView().removeCallbacks(f.this.C);
            }
            f fVar2 = f.this;
            if (fVar2.A != null) {
                fVar2.O();
                f fVar3 = f.this;
                fVar3.D = r0.d(fVar3.A).b(0.0f);
                f.this.D.h(new a());
            }
            f fVar4 = f.this;
            androidx.appcompat.app.d dVar = fVar4.f896t;
            if (dVar != null) {
                dVar.b(fVar4.f902z);
            }
            f fVar5 = f.this;
            fVar5.f902z = null;
            r0.k0(fVar5.G);
            f.this.I0();
        }

        @Override // androidx.appcompat.view.b.a
        public boolean b(androidx.appcompat.view.b bVar, Menu menu) {
            return this.f910a.b(bVar, menu);
        }

        @Override // androidx.appcompat.view.b.a
        public boolean c(androidx.appcompat.view.b bVar, Menu menu) {
            r0.k0(f.this.G);
            return this.f910a.c(bVar, menu);
        }

        @Override // androidx.appcompat.view.b.a
        public boolean d(androidx.appcompat.view.b bVar, MenuItem menuItem) {
            return this.f910a.d(bVar, menuItem);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class i {
        static void a(Configuration configuration, Locale locale) {
            configuration.setLayoutDirection(locale);
        }

        static void b(Configuration configuration, Locale locale) {
            configuration.setLocale(locale);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class j {
        static boolean a(PowerManager powerManager) {
            return powerManager.isPowerSaveMode();
        }

        static String b(Locale locale) {
            return locale.toLanguageTag();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class k {
        static void a(Configuration configuration, Configuration configuration2, Configuration configuration3) {
            LocaleList locales;
            LocaleList locales2;
            locales = configuration.getLocales();
            locales2 = configuration2.getLocales();
            if (locales.equals(locales2)) {
                return;
            }
            configuration3.setLocales(locales2);
            configuration3.locale = configuration2.locale;
        }

        static androidx.core.os.h b(Configuration configuration) {
            LocaleList locales;
            locales = configuration.getLocales();
            return androidx.core.os.h.c(locales.toLanguageTags());
        }

        public static void c(androidx.core.os.h hVar) {
            LocaleList.setDefault(LocaleList.forLanguageTags(hVar.h()));
        }

        static void d(Configuration configuration, androidx.core.os.h hVar) {
            configuration.setLocales(LocaleList.forLanguageTags(hVar.h()));
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class l {
        static OnBackInvokedDispatcher a(Activity activity) {
            return activity.getOnBackInvokedDispatcher();
        }

        static OnBackInvokedCallback b(Object obj, final f fVar) {
            Objects.requireNonNull(fVar);
            OnBackInvokedCallback onBackInvokedCallback = new OnBackInvokedCallback() { // from class: androidx.appcompat.app.i
                public final void onBackInvoked() {
                    f.this.i0();
                }
            };
            ((OnBackInvokedDispatcher) obj).registerOnBackInvokedCallback(1000000, onBackInvokedCallback);
            return onBackInvokedCallback;
        }

        static void c(Object obj, Object obj2) {
            ((OnBackInvokedDispatcher) obj).unregisterOnBackInvokedCallback((OnBackInvokedCallback) obj2);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class m extends androidx.appcompat.view.k {

        /* renamed from: h  reason: collision with root package name */
        private InterfaceC0005f f913h;

        /* renamed from: i  reason: collision with root package name */
        private boolean f914i;

        /* renamed from: j  reason: collision with root package name */
        private boolean f915j;

        /* renamed from: k  reason: collision with root package name */
        private boolean f916k;

        m(Window.Callback callback) {
            super(callback);
        }

        public boolean b(Window.Callback callback, KeyEvent keyEvent) {
            try {
                this.f915j = true;
                return callback.dispatchKeyEvent(keyEvent);
            } finally {
                this.f915j = false;
            }
        }

        public void c(Window.Callback callback) {
            try {
                this.f914i = true;
                callback.onContentChanged();
            } finally {
                this.f914i = false;
            }
        }

        public void d(Window.Callback callback, int i10, Menu menu) {
            try {
                this.f916k = true;
                callback.onPanelClosed(i10, menu);
            } finally {
                this.f916k = false;
            }
        }

        @Override // androidx.appcompat.view.k, android.view.Window.Callback
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            return this.f915j ? a().dispatchKeyEvent(keyEvent) : f.this.M(keyEvent) || super.dispatchKeyEvent(keyEvent);
        }

        @Override // androidx.appcompat.view.k, android.view.Window.Callback
        public boolean dispatchKeyShortcutEvent(KeyEvent keyEvent) {
            return super.dispatchKeyShortcutEvent(keyEvent) || f.this.l0(keyEvent.getKeyCode(), keyEvent);
        }

        final ActionMode e(ActionMode.Callback callback) {
            f.a aVar = new f.a(f.this.f893q, callback);
            androidx.appcompat.view.b C0 = f.this.C0(aVar);
            if (C0 != null) {
                return aVar.e(C0);
            }
            return null;
        }

        @Override // android.view.Window.Callback
        public void onContentChanged() {
            if (this.f914i) {
                a().onContentChanged();
            }
        }

        @Override // androidx.appcompat.view.k, android.view.Window.Callback
        public boolean onCreatePanelMenu(int i10, Menu menu) {
            if (i10 != 0 || (menu instanceof androidx.appcompat.view.menu.g)) {
                return super.onCreatePanelMenu(i10, menu);
            }
            return false;
        }

        @Override // androidx.appcompat.view.k, android.view.Window.Callback
        public View onCreatePanelView(int i10) {
            View onCreatePanelView;
            InterfaceC0005f interfaceC0005f = this.f913h;
            return (interfaceC0005f == null || (onCreatePanelView = interfaceC0005f.onCreatePanelView(i10)) == null) ? super.onCreatePanelView(i10) : onCreatePanelView;
        }

        @Override // androidx.appcompat.view.k, android.view.Window.Callback
        public boolean onMenuOpened(int i10, Menu menu) {
            super.onMenuOpened(i10, menu);
            f.this.o0(i10);
            return true;
        }

        @Override // androidx.appcompat.view.k, android.view.Window.Callback
        public void onPanelClosed(int i10, Menu menu) {
            if (this.f916k) {
                a().onPanelClosed(i10, menu);
                return;
            }
            super.onPanelClosed(i10, menu);
            f.this.p0(i10);
        }

        @Override // androidx.appcompat.view.k, android.view.Window.Callback
        public boolean onPreparePanel(int i10, View view, Menu menu) {
            androidx.appcompat.view.menu.g gVar = menu instanceof androidx.appcompat.view.menu.g ? (androidx.appcompat.view.menu.g) menu : null;
            if (i10 == 0 && gVar == null) {
                return false;
            }
            boolean z9 = true;
            if (gVar != null) {
                gVar.a0(true);
            }
            InterfaceC0005f interfaceC0005f = this.f913h;
            z9 = (interfaceC0005f == null || !interfaceC0005f.a(i10)) ? false : false;
            if (!z9) {
                z9 = super.onPreparePanel(i10, view, menu);
            }
            if (gVar != null) {
                gVar.a0(false);
            }
            return z9;
        }

        @Override // androidx.appcompat.view.k, android.view.Window.Callback
        public void onProvideKeyboardShortcuts(List list, Menu menu, int i10) {
            androidx.appcompat.view.menu.g gVar;
            r X = f.this.X(0, true);
            if (X == null || (gVar = X.f935j) == null) {
                super.onProvideKeyboardShortcuts(list, menu, i10);
            } else {
                super.onProvideKeyboardShortcuts(list, gVar, i10);
            }
        }

        @Override // androidx.appcompat.view.k, android.view.Window.Callback
        public ActionMode onWindowStartingActionMode(ActionMode.Callback callback) {
            if (Build.VERSION.SDK_INT >= 23) {
                return null;
            }
            return f.this.g0() ? e(callback) : super.onWindowStartingActionMode(callback);
        }

        @Override // androidx.appcompat.view.k, android.view.Window.Callback
        public ActionMode onWindowStartingActionMode(ActionMode.Callback callback, int i10) {
            return (f.this.g0() && i10 == 0) ? e(callback) : super.onWindowStartingActionMode(callback, i10);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class n extends o {

        /* renamed from: c  reason: collision with root package name */
        private final PowerManager f918c;

        n(Context context) {
            super();
            this.f918c = (PowerManager) context.getApplicationContext().getSystemService("power");
        }

        @Override // androidx.appcompat.app.f.o
        IntentFilter b() {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.os.action.POWER_SAVE_MODE_CHANGED");
            return intentFilter;
        }

        @Override // androidx.appcompat.app.f.o
        public int c() {
            return j.a(this.f918c) ? 2 : 1;
        }

        @Override // androidx.appcompat.app.f.o
        public void d() {
            f.this.y();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public abstract class o {

        /* renamed from: a  reason: collision with root package name */
        private BroadcastReceiver f920a;

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public class a extends BroadcastReceiver {
            a() {
            }

            @Override // android.content.BroadcastReceiver
            public void onReceive(Context context, Intent intent) {
                o.this.d();
            }
        }

        o() {
        }

        void a() {
            BroadcastReceiver broadcastReceiver = this.f920a;
            if (broadcastReceiver != null) {
                try {
                    f.this.f893q.unregisterReceiver(broadcastReceiver);
                } catch (IllegalArgumentException unused) {
                }
                this.f920a = null;
            }
        }

        abstract IntentFilter b();

        abstract int c();

        abstract void d();

        void e() {
            a();
            IntentFilter b10 = b();
            if (b10 == null || b10.countActions() == 0) {
                return;
            }
            if (this.f920a == null) {
                this.f920a = new a();
            }
            f.this.f893q.registerReceiver(this.f920a, b10);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class p extends o {

        /* renamed from: c  reason: collision with root package name */
        private final t f923c;

        p(t tVar) {
            super();
            this.f923c = tVar;
        }

        @Override // androidx.appcompat.app.f.o
        IntentFilter b() {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.TIME_SET");
            intentFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
            intentFilter.addAction("android.intent.action.TIME_TICK");
            return intentFilter;
        }

        @Override // androidx.appcompat.app.f.o
        public int c() {
            return this.f923c.d() ? 2 : 1;
        }

        @Override // androidx.appcompat.app.f.o
        public void d() {
            f.this.y();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class q extends ContentFrameLayout {
        public q(Context context) {
            super(context);
        }

        private boolean b(int i10, int i11) {
            return i10 < -5 || i11 < -5 || i10 > getWidth() + 5 || i11 > getHeight() + 5;
        }

        @Override // android.view.ViewGroup, android.view.View
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            return f.this.M(keyEvent) || super.dispatchKeyEvent(keyEvent);
        }

        @Override // android.view.ViewGroup
        public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
            if (motionEvent.getAction() == 0 && b((int) motionEvent.getX(), (int) motionEvent.getY())) {
                f.this.G(0);
                return true;
            }
            return super.onInterceptTouchEvent(motionEvent);
        }

        @Override // android.view.View
        public void setBackgroundResource(int i10) {
            setBackgroundDrawable(h.a.b(getContext(), i10));
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    /* loaded from: classes.dex */
    public static final class r {

        /* renamed from: a  reason: collision with root package name */
        int f926a;

        /* renamed from: b  reason: collision with root package name */
        int f927b;

        /* renamed from: c  reason: collision with root package name */
        int f928c;

        /* renamed from: d  reason: collision with root package name */
        int f929d;

        /* renamed from: e  reason: collision with root package name */
        int f930e;

        /* renamed from: f  reason: collision with root package name */
        int f931f;

        /* renamed from: g  reason: collision with root package name */
        ViewGroup f932g;

        /* renamed from: h  reason: collision with root package name */
        View f933h;

        /* renamed from: i  reason: collision with root package name */
        View f934i;

        /* renamed from: j  reason: collision with root package name */
        androidx.appcompat.view.menu.g f935j;

        /* renamed from: k  reason: collision with root package name */
        androidx.appcompat.view.menu.e f936k;

        /* renamed from: l  reason: collision with root package name */
        Context f937l;

        /* renamed from: m  reason: collision with root package name */
        boolean f938m;

        /* renamed from: n  reason: collision with root package name */
        boolean f939n;

        /* renamed from: o  reason: collision with root package name */
        boolean f940o;

        /* renamed from: p  reason: collision with root package name */
        public boolean f941p;

        /* renamed from: q  reason: collision with root package name */
        boolean f942q = false;

        /* renamed from: r  reason: collision with root package name */
        boolean f943r;

        /* renamed from: s  reason: collision with root package name */
        Bundle f944s;

        r(int i10) {
            this.f926a = i10;
        }

        androidx.appcompat.view.menu.n a(m.a aVar) {
            if (this.f935j == null) {
                return null;
            }
            if (this.f936k == null) {
                androidx.appcompat.view.menu.e eVar = new androidx.appcompat.view.menu.e(this.f937l, g.g.abc_list_menu_item_layout);
                this.f936k = eVar;
                eVar.g(aVar);
                this.f935j.b(this.f936k);
            }
            return this.f936k.i(this.f932g);
        }

        public boolean b() {
            if (this.f933h == null) {
                return false;
            }
            return this.f934i != null || this.f936k.a().getCount() > 0;
        }

        void c(androidx.appcompat.view.menu.g gVar) {
            androidx.appcompat.view.menu.e eVar;
            androidx.appcompat.view.menu.g gVar2 = this.f935j;
            if (gVar == gVar2) {
                return;
            }
            if (gVar2 != null) {
                gVar2.O(this.f936k);
            }
            this.f935j = gVar;
            if (gVar == null || (eVar = this.f936k) == null) {
                return;
            }
            gVar.b(eVar);
        }

        void d(Context context) {
            TypedValue typedValue = new TypedValue();
            Resources.Theme newTheme = context.getResources().newTheme();
            newTheme.setTo(context.getTheme());
            newTheme.resolveAttribute(g.a.actionBarPopupTheme, typedValue, true);
            int i10 = typedValue.resourceId;
            if (i10 != 0) {
                newTheme.applyStyle(i10, true);
            }
            newTheme.resolveAttribute(g.a.panelMenuListTheme, typedValue, true);
            int i11 = typedValue.resourceId;
            if (i11 == 0) {
                i11 = g.i.Theme_AppCompat_CompactMenu;
            }
            newTheme.applyStyle(i11, true);
            androidx.appcompat.view.d dVar = new androidx.appcompat.view.d(context, 0);
            dVar.getTheme().setTo(newTheme);
            this.f937l = dVar;
            TypedArray obtainStyledAttributes = dVar.obtainStyledAttributes(g.j.f7892y0);
            this.f927b = obtainStyledAttributes.getResourceId(g.j.B0, 0);
            this.f931f = obtainStyledAttributes.getResourceId(g.j.A0, 0);
            obtainStyledAttributes.recycle();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public final class s implements m.a {
        s() {
        }

        @Override // androidx.appcompat.view.menu.m.a
        public void b(androidx.appcompat.view.menu.g gVar, boolean z9) {
            androidx.appcompat.view.menu.g D = gVar.D();
            boolean z10 = D != gVar;
            f fVar = f.this;
            if (z10) {
                gVar = D;
            }
            r R = fVar.R(gVar);
            if (R != null) {
                if (!z10) {
                    f.this.H(R, z9);
                    return;
                }
                f.this.D(R.f926a, R, D);
                f.this.H(R, true);
            }
        }

        @Override // androidx.appcompat.view.menu.m.a
        public boolean c(androidx.appcompat.view.menu.g gVar) {
            Window.Callback a02;
            if (gVar == gVar.D()) {
                f fVar = f.this;
                if (!fVar.L || (a02 = fVar.a0()) == null || f.this.W) {
                    return true;
                }
                a02.onMenuOpened(108, gVar);
                return true;
            }
            return true;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public f(Dialog dialog, androidx.appcompat.app.d dVar) {
        this(dialog.getContext(), dialog.getWindow(), dVar, dialog);
    }

    private f(Context context, Window window, androidx.appcompat.app.d dVar, Object obj) {
        this.D = null;
        this.E = true;
        this.Y = -100;
        this.f884g0 = new a();
        this.f893q = context;
        this.f896t = dVar;
        this.f892p = obj;
        if (this.Y == -100 && (obj instanceof Dialog)) {
            F0();
        }
        if (this.Y == -100) {
            o.h hVar = f873o0;
            Integer num = (Integer) hVar.get(obj.getClass().getName());
            if (num != null) {
                this.Y = num.intValue();
                hVar.remove(obj.getClass().getName());
            }
        }
        if (window != null) {
            A(window);
        }
        androidx.appcompat.widget.k.g();
    }

    private void A(Window window) {
        if (this.f894r != null) {
            throw new IllegalStateException("AppCompat has already installed itself into the Window");
        }
        Window.Callback callback = window.getCallback();
        if (callback instanceof m) {
            throw new IllegalStateException("AppCompat has already installed itself into the Window");
        }
        m mVar = new m(callback);
        this.f895s = mVar;
        window.setCallback(mVar);
        k2 u9 = k2.u(this.f893q, null, f875q0);
        Drawable h10 = u9.h(0);
        if (h10 != null) {
            window.setBackgroundDrawable(h10);
        }
        u9.w();
        this.f894r = window;
        if (Build.VERSION.SDK_INT < 33 || this.f890m0 != null) {
            return;
        }
        t(null);
    }

    private boolean A0(ViewParent viewParent) {
        if (viewParent == null) {
            return false;
        }
        View decorView = this.f894r.getDecorView();
        while (viewParent != null) {
            if (viewParent == decorView || !(viewParent instanceof View) || r0.Q((View) viewParent)) {
                return false;
            }
            viewParent = viewParent.getParent();
        }
        return true;
    }

    private int C() {
        int i10 = this.Y;
        return i10 != -100 ? i10 : androidx.appcompat.app.e.g();
    }

    private void E0() {
        if (this.F) {
            throw new AndroidRuntimeException("Window feature must be requested before adding content");
        }
    }

    private void F() {
        o oVar = this.f880c0;
        if (oVar != null) {
            oVar.a();
        }
        o oVar2 = this.f881d0;
        if (oVar2 != null) {
            oVar2.a();
        }
    }

    private androidx.appcompat.app.c F0() {
        for (Context context = this.f893q; context != null && (context instanceof ContextWrapper); context = ((ContextWrapper) context).getBaseContext()) {
        }
        return null;
    }

    private void G0(Configuration configuration) {
        Activity activity = (Activity) this.f892p;
        if (activity instanceof androidx.lifecycle.m) {
            if (!((androidx.lifecycle.m) activity).getLifecycle().b().g(h.b.CREATED)) {
                return;
            }
        } else if (!this.V || this.W) {
            return;
        }
        activity.onConfigurationChanged(configuration);
    }

    private boolean H0(int i10, androidx.core.os.h hVar, boolean z9) {
        boolean z10;
        Configuration I = I(this.f893q, i10, hVar, null, false);
        int T = T(this.f893q);
        Configuration configuration = this.X;
        if (configuration == null) {
            configuration = this.f893q.getResources().getConfiguration();
        }
        int i11 = configuration.uiMode & 48;
        int i12 = I.uiMode & 48;
        androidx.core.os.h W = W(configuration);
        androidx.core.os.h W2 = hVar == null ? null : W(I);
        int i13 = i11 != i12 ? 512 : 0;
        if (W2 != null && !W.equals(W2)) {
            i13 = i13 | 4 | 8192;
        }
        boolean z11 = true;
        if (((~T) & i13) != 0 && z9 && this.U && (f876r0 || this.V)) {
            Object obj = this.f892p;
            if ((obj instanceof Activity) && !((Activity) obj).isChild()) {
                androidx.core.app.b.q((Activity) this.f892p);
                z10 = true;
                if (!z10 || i13 == 0) {
                    z11 = z10;
                } else {
                    J0(i12, W2, (i13 & T) == i13, null);
                }
                if (z11 && W2 != null) {
                    y0(W(this.f893q.getResources().getConfiguration()));
                }
                return z11;
            }
        }
        z10 = false;
        if (z10) {
        }
        z11 = z10;
        if (z11) {
            y0(W(this.f893q.getResources().getConfiguration()));
        }
        return z11;
    }

    private Configuration I(Context context, int i10, androidx.core.os.h hVar, Configuration configuration, boolean z9) {
        int i11 = i10 != 1 ? i10 != 2 ? z9 ? 0 : context.getApplicationContext().getResources().getConfiguration().uiMode & 48 : 32 : 16;
        Configuration configuration2 = new Configuration();
        configuration2.fontScale = 0.0f;
        if (configuration != null) {
            configuration2.setTo(configuration);
        }
        configuration2.uiMode = i11 | (configuration2.uiMode & (-49));
        if (hVar != null) {
            x0(configuration2, hVar);
        }
        return configuration2;
    }

    private ViewGroup J() {
        ViewGroup viewGroup;
        TypedArray obtainStyledAttributes = this.f893q.obtainStyledAttributes(g.j.f7892y0);
        int i10 = g.j.D0;
        if (!obtainStyledAttributes.hasValue(i10)) {
            obtainStyledAttributes.recycle();
            throw new IllegalStateException("You need to use a Theme.AppCompat theme (or descendant) with this activity.");
        }
        if (obtainStyledAttributes.getBoolean(g.j.M0, false)) {
            p(1);
        } else if (obtainStyledAttributes.getBoolean(i10, false)) {
            p(108);
        }
        if (obtainStyledAttributes.getBoolean(g.j.E0, false)) {
            p(109);
        }
        if (obtainStyledAttributes.getBoolean(g.j.F0, false)) {
            p(10);
        }
        this.O = obtainStyledAttributes.getBoolean(g.j.f7897z0, false);
        obtainStyledAttributes.recycle();
        Q();
        this.f894r.getDecorView();
        LayoutInflater from = LayoutInflater.from(this.f893q);
        if (this.P) {
            viewGroup = (ViewGroup) from.inflate(this.N ? g.g.abc_screen_simple_overlay_action_mode : g.g.abc_screen_simple, (ViewGroup) null);
        } else if (this.O) {
            viewGroup = (ViewGroup) from.inflate(g.g.abc_dialog_title_material, (ViewGroup) null);
            this.M = false;
            this.L = false;
        } else if (this.L) {
            TypedValue typedValue = new TypedValue();
            this.f893q.getTheme().resolveAttribute(g.a.actionBarTheme, typedValue, true);
            viewGroup = (ViewGroup) LayoutInflater.from(typedValue.resourceId != 0 ? new androidx.appcompat.view.d(this.f893q, typedValue.resourceId) : this.f893q).inflate(g.g.abc_screen_toolbar, (ViewGroup) null);
            k1 k1Var = (k1) viewGroup.findViewById(g.f.decor_content_parent);
            this.f899w = k1Var;
            k1Var.setWindowCallback(a0());
            if (this.M) {
                this.f899w.h(109);
            }
            if (this.J) {
                this.f899w.h(2);
            }
            if (this.K) {
                this.f899w.h(5);
            }
        } else {
            viewGroup = null;
        }
        if (viewGroup == null) {
            throw new IllegalArgumentException("AppCompat does not support the current theme features: { windowActionBar: " + this.L + ", windowActionBarOverlay: " + this.M + ", android:windowIsFloating: " + this.O + ", windowActionModeOverlay: " + this.N + ", windowNoTitle: " + this.P + " }");
        }
        r0.A0(viewGroup, new b());
        if (this.f899w == null) {
            this.H = (TextView) viewGroup.findViewById(g.f.M);
        }
        androidx.appcompat.widget.w2.c(viewGroup);
        ContentFrameLayout contentFrameLayout = (ContentFrameLayout) viewGroup.findViewById(g.f.action_bar_activity_content);
        ViewGroup viewGroup2 = (ViewGroup) this.f894r.findViewById(16908290);
        if (viewGroup2 != null) {
            while (viewGroup2.getChildCount() > 0) {
                View childAt = viewGroup2.getChildAt(0);
                viewGroup2.removeViewAt(0);
                contentFrameLayout.addView(childAt);
            }
            viewGroup2.setId(-1);
            contentFrameLayout.setId(16908290);
            if (viewGroup2 instanceof FrameLayout) {
                ((FrameLayout) viewGroup2).setForeground(null);
            }
        }
        this.f894r.setContentView(viewGroup);
        contentFrameLayout.setAttachListener(new c());
        return viewGroup;
    }

    private void J0(int i10, androidx.core.os.h hVar, boolean z9, Configuration configuration) {
        Resources resources = this.f893q.getResources();
        Configuration configuration2 = new Configuration(resources.getConfiguration());
        if (configuration != null) {
            configuration2.updateFrom(configuration);
        }
        configuration2.uiMode = i10 | (resources.getConfiguration().uiMode & (-49));
        if (hVar != null) {
            x0(configuration2, hVar);
        }
        resources.updateConfiguration(configuration2, null);
        int i11 = Build.VERSION.SDK_INT;
        if (i11 < 26) {
            androidx.appcompat.app.r.a(resources);
        }
        int i12 = this.Z;
        if (i12 != 0) {
            this.f893q.setTheme(i12);
            if (i11 >= 23) {
                this.f893q.getTheme().applyStyle(this.Z, true);
            }
        }
        if (z9 && (this.f892p instanceof Activity)) {
            G0(configuration2);
        }
    }

    private void L0(View view) {
        Context context;
        int i10;
        if ((r0.K(view) & 8192) != 0) {
            context = this.f893q;
            i10 = g.c.abc_decor_view_status_guard_light;
        } else {
            context = this.f893q;
            i10 = g.c.abc_decor_view_status_guard;
        }
        view.setBackgroundColor(androidx.core.content.a.b(context, i10));
    }

    private void P() {
        if (this.F) {
            return;
        }
        this.G = J();
        CharSequence Z = Z();
        if (!TextUtils.isEmpty(Z)) {
            k1 k1Var = this.f899w;
            if (k1Var != null) {
                k1Var.setWindowTitle(Z);
            } else if (s0() != null) {
                s0().n(Z);
            } else {
                TextView textView = this.H;
                if (textView != null) {
                    textView.setText(Z);
                }
            }
        }
        z();
        q0(this.G);
        this.F = true;
        r X = X(0, false);
        if (this.W) {
            return;
        }
        if (X == null || X.f935j == null) {
            f0(108);
        }
    }

    private void Q() {
        if (this.f894r == null) {
            Object obj = this.f892p;
            if (obj instanceof Activity) {
                A(((Activity) obj).getWindow());
            }
        }
        if (this.f894r == null) {
            throw new IllegalStateException("We have not been given a Window");
        }
    }

    private int T(Context context) {
        if (!this.f879b0 && (this.f892p instanceof Activity)) {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return 0;
            }
            try {
                int i10 = Build.VERSION.SDK_INT;
                ActivityInfo activityInfo = packageManager.getActivityInfo(new ComponentName(context, this.f892p.getClass()), i10 >= 29 ? 269221888 : i10 >= 24 ? 786432 : 0);
                if (activityInfo != null) {
                    this.f878a0 = activityInfo.configChanges;
                }
            } catch (PackageManager.NameNotFoundException e10) {
                Log.d("AppCompatDelegate", "Exception while getting ActivityInfo", e10);
                this.f878a0 = 0;
            }
        }
        this.f879b0 = true;
        return this.f878a0;
    }

    private o U(Context context) {
        if (this.f881d0 == null) {
            this.f881d0 = new n(context);
        }
        return this.f881d0;
    }

    private o V(Context context) {
        if (this.f880c0 == null) {
            this.f880c0 = new p(t.a(context));
        }
        return this.f880c0;
    }

    /* JADX WARN: Removed duplicated region for block: B:16:0x0032  */
    /* JADX WARN: Removed duplicated region for block: B:19:? A[RETURN, SYNTHETIC] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private void b0() {
        u uVar;
        androidx.appcompat.app.a aVar;
        P();
        if (!this.L || this.f897u != null) {
            return;
        }
        Object obj = this.f892p;
        if (!(obj instanceof Activity)) {
            if (obj instanceof Dialog) {
                uVar = new u((Dialog) this.f892p);
            }
            aVar = this.f897u;
            if (aVar == null) {
                aVar.l(this.f885h0);
                return;
            }
            return;
        }
        uVar = new u((Activity) this.f892p, this.M);
        this.f897u = uVar;
        aVar = this.f897u;
        if (aVar == null) {
        }
    }

    private boolean c0(r rVar) {
        View view = rVar.f934i;
        if (view != null) {
            rVar.f933h = view;
            return true;
        } else if (rVar.f935j == null) {
            return false;
        } else {
            if (this.f901y == null) {
                this.f901y = new s();
            }
            View view2 = (View) rVar.a(this.f901y);
            rVar.f933h = view2;
            return view2 != null;
        }
    }

    private boolean d0(r rVar) {
        rVar.d(S());
        rVar.f932g = new q(rVar.f937l);
        rVar.f928c = 81;
        return true;
    }

    private boolean e0(r rVar) {
        Context context = this.f893q;
        int i10 = rVar.f926a;
        if ((i10 == 0 || i10 == 108) && this.f899w != null) {
            TypedValue typedValue = new TypedValue();
            Resources.Theme theme = context.getTheme();
            theme.resolveAttribute(g.a.actionBarTheme, typedValue, true);
            Resources.Theme theme2 = null;
            if (typedValue.resourceId != 0) {
                theme2 = context.getResources().newTheme();
                theme2.setTo(theme);
                theme2.applyStyle(typedValue.resourceId, true);
                theme2.resolveAttribute(g.a.actionBarWidgetTheme, typedValue, true);
            } else {
                theme.resolveAttribute(g.a.actionBarWidgetTheme, typedValue, true);
            }
            if (typedValue.resourceId != 0) {
                if (theme2 == null) {
                    theme2 = context.getResources().newTheme();
                    theme2.setTo(theme);
                }
                theme2.applyStyle(typedValue.resourceId, true);
            }
            if (theme2 != null) {
                androidx.appcompat.view.d dVar = new androidx.appcompat.view.d(context, 0);
                dVar.getTheme().setTo(theme2);
                context = dVar;
            }
        }
        androidx.appcompat.view.menu.g gVar = new androidx.appcompat.view.menu.g(context);
        gVar.R(this);
        rVar.c(gVar);
        return true;
    }

    private void f0(int i10) {
        this.f883f0 = (1 << i10) | this.f883f0;
        if (this.f882e0) {
            return;
        }
        r0.f0(this.f894r.getDecorView(), this.f884g0);
        this.f882e0 = true;
    }

    private boolean k0(int i10, KeyEvent keyEvent) {
        if (keyEvent.getRepeatCount() == 0) {
            r X = X(i10, true);
            if (X.f940o) {
                return false;
            }
            return u0(X, keyEvent);
        }
        return false;
    }

    private boolean n0(int i10, KeyEvent keyEvent) {
        boolean z9;
        k1 k1Var;
        if (this.f902z != null) {
            return false;
        }
        boolean z10 = true;
        r X = X(i10, true);
        if (i10 != 0 || (k1Var = this.f899w) == null || !k1Var.d() || ViewConfiguration.get(this.f893q).hasPermanentMenuKey()) {
            boolean z11 = X.f940o;
            if (z11 || X.f939n) {
                H(X, true);
                z10 = z11;
            } else {
                if (X.f938m) {
                    if (X.f943r) {
                        X.f938m = false;
                        z9 = u0(X, keyEvent);
                    } else {
                        z9 = true;
                    }
                    if (z9) {
                        r0(X, keyEvent);
                    }
                }
                z10 = false;
            }
        } else if (this.f899w.b()) {
            z10 = this.f899w.f();
        } else {
            if (!this.W && u0(X, keyEvent)) {
                z10 = this.f899w.g();
            }
            z10 = false;
        }
        if (z10) {
            AudioManager audioManager = (AudioManager) this.f893q.getApplicationContext().getSystemService("audio");
            if (audioManager != null) {
                audioManager.playSoundEffect(0);
            } else {
                Log.w("AppCompatDelegate", "Couldn't get audio manager");
            }
        }
        return z10;
    }

    /* JADX WARN: Removed duplicated region for block: B:67:0x00f2  */
    /* JADX WARN: Removed duplicated region for block: B:72:? A[RETURN, SYNTHETIC] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private void r0(r rVar, KeyEvent keyEvent) {
        int i10;
        ViewGroup.LayoutParams layoutParams;
        if (rVar.f940o || this.W) {
            return;
        }
        if (rVar.f926a == 0) {
            if ((this.f893q.getResources().getConfiguration().screenLayout & 15) == 4) {
                return;
            }
        }
        Window.Callback a02 = a0();
        if (a02 != null && !a02.onMenuOpened(rVar.f926a, rVar.f935j)) {
            H(rVar, true);
            return;
        }
        WindowManager windowManager = (WindowManager) this.f893q.getSystemService("window");
        if (windowManager == null || !u0(rVar, keyEvent)) {
            return;
        }
        ViewGroup viewGroup = rVar.f932g;
        if (viewGroup == null || rVar.f942q) {
            if (viewGroup == null) {
                if (!d0(rVar) || rVar.f932g == null) {
                    return;
                }
            } else if (rVar.f942q && viewGroup.getChildCount() > 0) {
                rVar.f932g.removeAllViews();
            }
            if (!c0(rVar) || !rVar.b()) {
                rVar.f942q = true;
                return;
            }
            ViewGroup.LayoutParams layoutParams2 = rVar.f933h.getLayoutParams();
            if (layoutParams2 == null) {
                layoutParams2 = new ViewGroup.LayoutParams(-2, -2);
            }
            rVar.f932g.setBackgroundResource(rVar.f927b);
            ViewParent parent = rVar.f933h.getParent();
            if (parent instanceof ViewGroup) {
                ((ViewGroup) parent).removeView(rVar.f933h);
            }
            rVar.f932g.addView(rVar.f933h, layoutParams2);
            if (!rVar.f933h.hasFocus()) {
                rVar.f933h.requestFocus();
            }
        } else {
            View view = rVar.f934i;
            if (view != null && (layoutParams = view.getLayoutParams()) != null && layoutParams.width == -1) {
                i10 = -1;
                rVar.f939n = false;
                WindowManager.LayoutParams layoutParams3 = new WindowManager.LayoutParams(i10, -2, rVar.f929d, rVar.f930e, 1002, 8519680, -3);
                layoutParams3.gravity = rVar.f928c;
                layoutParams3.windowAnimations = rVar.f931f;
                windowManager.addView(rVar.f932g, layoutParams3);
                rVar.f940o = true;
                if (rVar.f926a != 0) {
                    I0();
                    return;
                }
                return;
            }
        }
        i10 = -2;
        rVar.f939n = false;
        WindowManager.LayoutParams layoutParams32 = new WindowManager.LayoutParams(i10, -2, rVar.f929d, rVar.f930e, 1002, 8519680, -3);
        layoutParams32.gravity = rVar.f928c;
        layoutParams32.windowAnimations = rVar.f931f;
        windowManager.addView(rVar.f932g, layoutParams32);
        rVar.f940o = true;
        if (rVar.f926a != 0) {
        }
    }

    private boolean t0(r rVar, int i10, KeyEvent keyEvent, int i11) {
        androidx.appcompat.view.menu.g gVar;
        boolean z9 = false;
        if (keyEvent.isSystem()) {
            return false;
        }
        if ((rVar.f938m || u0(rVar, keyEvent)) && (gVar = rVar.f935j) != null) {
            z9 = gVar.performShortcut(i10, keyEvent, i11);
        }
        if (z9 && (i11 & 1) == 0 && this.f899w == null) {
            H(rVar, true);
        }
        return z9;
    }

    private boolean u0(r rVar, KeyEvent keyEvent) {
        k1 k1Var;
        k1 k1Var2;
        k1 k1Var3;
        if (this.W) {
            return false;
        }
        if (rVar.f938m) {
            return true;
        }
        r rVar2 = this.S;
        if (rVar2 != null && rVar2 != rVar) {
            H(rVar2, false);
        }
        Window.Callback a02 = a0();
        if (a02 != null) {
            rVar.f934i = a02.onCreatePanelView(rVar.f926a);
        }
        int i10 = rVar.f926a;
        boolean z9 = i10 == 0 || i10 == 108;
        if (z9 && (k1Var3 = this.f899w) != null) {
            k1Var3.c();
        }
        if (rVar.f934i == null) {
            if (z9) {
                s0();
            }
            androidx.appcompat.view.menu.g gVar = rVar.f935j;
            if (gVar == null || rVar.f943r) {
                if (gVar == null && (!e0(rVar) || rVar.f935j == null)) {
                    return false;
                }
                if (z9 && this.f899w != null) {
                    if (this.f900x == null) {
                        this.f900x = new g();
                    }
                    this.f899w.a(rVar.f935j, this.f900x);
                }
                rVar.f935j.d0();
                if (!a02.onCreatePanelMenu(rVar.f926a, rVar.f935j)) {
                    rVar.c(null);
                    if (z9 && (k1Var = this.f899w) != null) {
                        k1Var.a(null, this.f900x);
                    }
                    return false;
                }
                rVar.f943r = false;
            }
            rVar.f935j.d0();
            Bundle bundle = rVar.f944s;
            if (bundle != null) {
                rVar.f935j.P(bundle);
                rVar.f944s = null;
            }
            if (!a02.onPreparePanel(0, rVar.f934i, rVar.f935j)) {
                if (z9 && (k1Var2 = this.f899w) != null) {
                    k1Var2.a(null, this.f900x);
                }
                rVar.f935j.c0();
                return false;
            }
            boolean z10 = KeyCharacterMap.load(keyEvent != null ? keyEvent.getDeviceId() : -1).getKeyboardType() != 1;
            rVar.f941p = z10;
            rVar.f935j.setQwertyMode(z10);
            rVar.f935j.c0();
        }
        rVar.f938m = true;
        rVar.f939n = false;
        this.S = rVar;
        return true;
    }

    private void v0(boolean z9) {
        k1 k1Var = this.f899w;
        if (k1Var == null || !k1Var.d() || (ViewConfiguration.get(this.f893q).hasPermanentMenuKey() && !this.f899w.e())) {
            r X = X(0, true);
            X.f942q = true;
            H(X, false);
            r0(X, null);
            return;
        }
        Window.Callback a02 = a0();
        if (this.f899w.b() && z9) {
            this.f899w.f();
            if (this.W) {
                return;
            }
            a02.onPanelClosed(108, X(0, true).f935j);
        } else if (a02 == null || this.W) {
        } else {
            if (this.f882e0 && (this.f883f0 & 1) != 0) {
                this.f894r.getDecorView().removeCallbacks(this.f884g0);
                this.f884g0.run();
            }
            r X2 = X(0, true);
            androidx.appcompat.view.menu.g gVar = X2.f935j;
            if (gVar == null || X2.f943r || !a02.onPreparePanel(0, X2.f934i, gVar)) {
                return;
            }
            a02.onMenuOpened(108, X2.f935j);
            this.f899w.g();
        }
    }

    private boolean w(boolean z9) {
        return x(z9, true);
    }

    private int w0(int i10) {
        if (i10 == 8) {
            Log.i("AppCompatDelegate", "You should now use the AppCompatDelegate.FEATURE_SUPPORT_ACTION_BAR id when requesting this feature.");
            return 108;
        } else if (i10 == 9) {
            Log.i("AppCompatDelegate", "You should now use the AppCompatDelegate.FEATURE_SUPPORT_ACTION_BAR_OVERLAY id when requesting this feature.");
            return 109;
        } else {
            return i10;
        }
    }

    private boolean x(boolean z9, boolean z10) {
        if (this.W) {
            return false;
        }
        int C = C();
        int h02 = h0(this.f893q, C);
        androidx.core.os.h B = Build.VERSION.SDK_INT < 33 ? B(this.f893q) : null;
        if (!z10 && B != null) {
            B = W(this.f893q.getResources().getConfiguration());
        }
        boolean H0 = H0(h02, B, z9);
        if (C == 0) {
            V(this.f893q).e();
        } else {
            o oVar = this.f880c0;
            if (oVar != null) {
                oVar.a();
            }
        }
        if (C == 3) {
            U(this.f893q).e();
        } else {
            o oVar2 = this.f881d0;
            if (oVar2 != null) {
                oVar2.a();
            }
        }
        return H0;
    }

    private void z() {
        ContentFrameLayout contentFrameLayout = (ContentFrameLayout) this.G.findViewById(16908290);
        View decorView = this.f894r.getDecorView();
        contentFrameLayout.a(decorView.getPaddingLeft(), decorView.getPaddingTop(), decorView.getPaddingRight(), decorView.getPaddingBottom());
        TypedArray obtainStyledAttributes = this.f893q.obtainStyledAttributes(g.j.f7892y0);
        obtainStyledAttributes.getValue(g.j.K0, contentFrameLayout.getMinWidthMajor());
        obtainStyledAttributes.getValue(g.j.L0, contentFrameLayout.getMinWidthMinor());
        int i10 = g.j.I0;
        if (obtainStyledAttributes.hasValue(i10)) {
            obtainStyledAttributes.getValue(i10, contentFrameLayout.getFixedWidthMajor());
        }
        int i11 = g.j.J0;
        if (obtainStyledAttributes.hasValue(i11)) {
            obtainStyledAttributes.getValue(i11, contentFrameLayout.getFixedWidthMinor());
        }
        int i12 = g.j.G0;
        if (obtainStyledAttributes.hasValue(i12)) {
            obtainStyledAttributes.getValue(i12, contentFrameLayout.getFixedHeightMajor());
        }
        int i13 = g.j.H0;
        if (obtainStyledAttributes.hasValue(i13)) {
            obtainStyledAttributes.getValue(i13, contentFrameLayout.getFixedHeightMinor());
        }
        obtainStyledAttributes.recycle();
        contentFrameLayout.requestLayout();
    }

    androidx.core.os.h B(Context context) {
        androidx.core.os.h h10;
        int i10 = Build.VERSION.SDK_INT;
        if (i10 < 33 && (h10 = androidx.appcompat.app.e.h()) != null) {
            androidx.core.os.h W = W(context.getApplicationContext().getResources().getConfiguration());
            androidx.core.os.h b10 = i10 >= 24 ? androidx.appcompat.app.q.b(h10, W) : h10.f() ? androidx.core.os.h.e() : androidx.core.os.h.c(h10.d(0).toString());
            return b10.f() ? W : b10;
        }
        return null;
    }

    boolean B0() {
        if (this.f890m0 == null) {
            return false;
        }
        r X = X(0, false);
        return (X != null && X.f940o) || this.f902z != null;
    }

    public androidx.appcompat.view.b C0(b.a aVar) {
        androidx.appcompat.app.d dVar;
        if (aVar != null) {
            androidx.appcompat.view.b bVar = this.f902z;
            if (bVar != null) {
                bVar.c();
            }
            h hVar = new h(aVar);
            androidx.appcompat.app.a Y = Y();
            if (Y != null) {
                androidx.appcompat.view.b o10 = Y.o(hVar);
                this.f902z = o10;
                if (o10 != null && (dVar = this.f896t) != null) {
                    dVar.a(o10);
                }
            }
            if (this.f902z == null) {
                this.f902z = D0(hVar);
            }
            I0();
            return this.f902z;
        }
        throw new IllegalArgumentException("ActionMode callback can not be null.");
    }

    void D(int i10, r rVar, Menu menu) {
        if (menu == null) {
            if (rVar == null && i10 >= 0) {
                r[] rVarArr = this.R;
                if (i10 < rVarArr.length) {
                    rVar = rVarArr[i10];
                }
            }
            if (rVar != null) {
                menu = rVar.f935j;
            }
        }
        if ((rVar == null || rVar.f940o) && !this.W) {
            this.f895s.d(this.f894r.getCallback(), i10, menu);
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:17:0x0026  */
    /* JADX WARN: Removed duplicated region for block: B:18:0x002a  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    androidx.appcompat.view.b D0(b.a aVar) {
        androidx.appcompat.view.b bVar;
        Context context;
        androidx.appcompat.view.b bVar2;
        androidx.appcompat.app.d dVar;
        O();
        androidx.appcompat.view.b bVar3 = this.f902z;
        if (bVar3 != null) {
            bVar3.c();
        }
        if (!(aVar instanceof h)) {
            aVar = new h(aVar);
        }
        androidx.appcompat.app.d dVar2 = this.f896t;
        if (dVar2 != null && !this.W) {
            try {
                bVar = dVar2.c(aVar);
            } catch (AbstractMethodError unused) {
            }
            if (bVar == null) {
                this.f902z = bVar;
            } else {
                if (this.A == null) {
                    if (this.O) {
                        TypedValue typedValue = new TypedValue();
                        Resources.Theme theme = this.f893q.getTheme();
                        theme.resolveAttribute(g.a.actionBarTheme, typedValue, true);
                        if (typedValue.resourceId != 0) {
                            Resources.Theme newTheme = this.f893q.getResources().newTheme();
                            newTheme.setTo(theme);
                            newTheme.applyStyle(typedValue.resourceId, true);
                            context = new androidx.appcompat.view.d(this.f893q, 0);
                            context.getTheme().setTo(newTheme);
                        } else {
                            context = this.f893q;
                        }
                        this.A = new ActionBarContextView(context);
                        PopupWindow popupWindow = new PopupWindow(context, (AttributeSet) null, g.a.actionModePopupWindowStyle);
                        this.B = popupWindow;
                        androidx.core.widget.n.b(popupWindow, 2);
                        this.B.setContentView(this.A);
                        this.B.setWidth(-1);
                        context.getTheme().resolveAttribute(g.a.actionBarSize, typedValue, true);
                        this.A.setContentHeight(TypedValue.complexToDimensionPixelSize(typedValue.data, context.getResources().getDisplayMetrics()));
                        this.B.setHeight(-2);
                        this.C = new d();
                    } else {
                        ViewStubCompat viewStubCompat = (ViewStubCompat) this.G.findViewById(g.f.action_mode_bar_stub);
                        if (viewStubCompat != null) {
                            viewStubCompat.setLayoutInflater(LayoutInflater.from(S()));
                            this.A = (ActionBarContextView) viewStubCompat.a();
                        }
                    }
                }
                if (this.A != null) {
                    O();
                    this.A.k();
                    androidx.appcompat.view.e eVar = new androidx.appcompat.view.e(this.A.getContext(), this.A, aVar, this.B == null);
                    if (aVar.b(eVar, eVar.e())) {
                        eVar.k();
                        this.A.h(eVar);
                        this.f902z = eVar;
                        if (z0()) {
                            this.A.setAlpha(0.0f);
                            u2 b10 = r0.d(this.A).b(1.0f);
                            this.D = b10;
                            b10.h(new e());
                        } else {
                            this.A.setAlpha(1.0f);
                            this.A.setVisibility(0);
                            if (this.A.getParent() instanceof View) {
                                r0.k0((View) this.A.getParent());
                            }
                        }
                        if (this.B != null) {
                            this.f894r.getDecorView().post(this.C);
                        }
                    } else {
                        this.f902z = null;
                    }
                }
            }
            bVar2 = this.f902z;
            if (bVar2 != null && (dVar = this.f896t) != null) {
                dVar.a(bVar2);
            }
            I0();
            return this.f902z;
        }
        bVar = null;
        if (bVar == null) {
        }
        bVar2 = this.f902z;
        if (bVar2 != null) {
            dVar.a(bVar2);
        }
        I0();
        return this.f902z;
    }

    void E(androidx.appcompat.view.menu.g gVar) {
        if (this.Q) {
            return;
        }
        this.Q = true;
        this.f899w.i();
        Window.Callback a02 = a0();
        if (a02 != null && !this.W) {
            a02.onPanelClosed(108, gVar);
        }
        this.Q = false;
    }

    void G(int i10) {
        H(X(i10, true), true);
    }

    void H(r rVar, boolean z9) {
        ViewGroup viewGroup;
        k1 k1Var;
        if (z9 && rVar.f926a == 0 && (k1Var = this.f899w) != null && k1Var.b()) {
            E(rVar.f935j);
            return;
        }
        WindowManager windowManager = (WindowManager) this.f893q.getSystemService("window");
        if (windowManager != null && rVar.f940o && (viewGroup = rVar.f932g) != null) {
            windowManager.removeView(viewGroup);
            if (z9) {
                D(rVar.f926a, rVar, null);
            }
        }
        rVar.f938m = false;
        rVar.f939n = false;
        rVar.f940o = false;
        rVar.f933h = null;
        rVar.f942q = true;
        if (this.S == rVar) {
            this.S = null;
        }
        if (rVar.f926a == 0) {
            I0();
        }
    }

    void I0() {
        OnBackInvokedCallback onBackInvokedCallback;
        if (Build.VERSION.SDK_INT >= 33) {
            boolean B0 = B0();
            if (B0 && this.f891n0 == null) {
                this.f891n0 = l.b(this.f890m0, this);
            } else if (B0 || (onBackInvokedCallback = this.f891n0) == null) {
            } else {
                l.c(this.f890m0, onBackInvokedCallback);
            }
        }
    }

    public View K(View view, String str, Context context, AttributeSet attributeSet) {
        boolean z9;
        androidx.appcompat.app.l lVar;
        boolean z10 = false;
        if (this.f888k0 == null) {
            String string = this.f893q.obtainStyledAttributes(g.j.f7892y0).getString(g.j.C0);
            if (string == null) {
                lVar = new androidx.appcompat.app.l();
            } else {
                try {
                    this.f888k0 = (androidx.appcompat.app.l) this.f893q.getClassLoader().loadClass(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } catch (Throwable th) {
                    Log.i("AppCompatDelegate", "Failed to instantiate custom view inflater " + string + ". Falling back to default.", th);
                    lVar = new androidx.appcompat.app.l();
                }
            }
            this.f888k0 = lVar;
        }
        boolean z11 = f874p0;
        if (z11) {
            if (this.f889l0 == null) {
                this.f889l0 = new androidx.appcompat.app.p();
            }
            if (this.f889l0.a(attributeSet)) {
                z9 = true;
            } else {
                if (!(attributeSet instanceof XmlPullParser)) {
                    z10 = A0((ViewParent) view);
                } else if (((XmlPullParser) attributeSet).getDepth() > 1) {
                    z10 = true;
                }
                z9 = z10;
            }
        } else {
            z9 = false;
        }
        return this.f888k0.createView(view, str, context, attributeSet, z9, z11, true, v2.c());
    }

    final int K0(y2 y2Var, Rect rect) {
        boolean z9;
        boolean z10;
        int k10 = y2Var != null ? y2Var.k() : rect != null ? rect.top : 0;
        ActionBarContextView actionBarContextView = this.A;
        if (actionBarContextView == null || !(actionBarContextView.getLayoutParams() instanceof ViewGroup.MarginLayoutParams)) {
            z9 = false;
        } else {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) this.A.getLayoutParams();
            if (this.A.isShown()) {
                if (this.f886i0 == null) {
                    this.f886i0 = new Rect();
                    this.f887j0 = new Rect();
                }
                Rect rect2 = this.f886i0;
                Rect rect3 = this.f887j0;
                if (y2Var == null) {
                    rect2.set(rect);
                } else {
                    rect2.set(y2Var.i(), y2Var.k(), y2Var.j(), y2Var.h());
                }
                androidx.appcompat.widget.w2.a(this.G, rect2, rect3);
                int i10 = rect2.top;
                int i11 = rect2.left;
                int i12 = rect2.right;
                y2 H = r0.H(this.G);
                int i13 = H == null ? 0 : H.i();
                int j10 = H == null ? 0 : H.j();
                if (marginLayoutParams.topMargin == i10 && marginLayoutParams.leftMargin == i11 && marginLayoutParams.rightMargin == i12) {
                    z10 = false;
                } else {
                    marginLayoutParams.topMargin = i10;
                    marginLayoutParams.leftMargin = i11;
                    marginLayoutParams.rightMargin = i12;
                    z10 = true;
                }
                if (i10 <= 0 || this.I != null) {
                    View view = this.I;
                    if (view != null) {
                        ViewGroup.MarginLayoutParams marginLayoutParams2 = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
                        int i14 = marginLayoutParams2.height;
                        int i15 = marginLayoutParams.topMargin;
                        if (i14 != i15 || marginLayoutParams2.leftMargin != i13 || marginLayoutParams2.rightMargin != j10) {
                            marginLayoutParams2.height = i15;
                            marginLayoutParams2.leftMargin = i13;
                            marginLayoutParams2.rightMargin = j10;
                            this.I.setLayoutParams(marginLayoutParams2);
                        }
                    }
                } else {
                    View view2 = new View(this.f893q);
                    this.I = view2;
                    view2.setVisibility(8);
                    FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, marginLayoutParams.topMargin, 51);
                    layoutParams.leftMargin = i13;
                    layoutParams.rightMargin = j10;
                    this.G.addView(this.I, -1, layoutParams);
                }
                View view3 = this.I;
                r5 = view3 != null;
                if (r5 && view3.getVisibility() != 0) {
                    L0(this.I);
                }
                if (!this.N && r5) {
                    k10 = 0;
                }
                z9 = r5;
                r5 = z10;
            } else if (marginLayoutParams.topMargin != 0) {
                marginLayoutParams.topMargin = 0;
                z9 = false;
            } else {
                z9 = false;
                r5 = false;
            }
            if (r5) {
                this.A.setLayoutParams(marginLayoutParams);
            }
        }
        View view4 = this.I;
        if (view4 != null) {
            view4.setVisibility(z9 ? 0 : 8);
        }
        return k10;
    }

    void L() {
        androidx.appcompat.view.menu.g gVar;
        k1 k1Var = this.f899w;
        if (k1Var != null) {
            k1Var.i();
        }
        if (this.B != null) {
            this.f894r.getDecorView().removeCallbacks(this.C);
            if (this.B.isShowing()) {
                try {
                    this.B.dismiss();
                } catch (IllegalArgumentException unused) {
                }
            }
            this.B = null;
        }
        O();
        r X = X(0, false);
        if (X == null || (gVar = X.f935j) == null) {
            return;
        }
        gVar.close();
    }

    boolean M(KeyEvent keyEvent) {
        View decorView;
        Object obj = this.f892p;
        if (((obj instanceof j.a) || (obj instanceof androidx.appcompat.app.k)) && (decorView = this.f894r.getDecorView()) != null && androidx.core.view.j.d(decorView, keyEvent)) {
            return true;
        }
        if (keyEvent.getKeyCode() == 82 && this.f895s.b(this.f894r.getCallback(), keyEvent)) {
            return true;
        }
        int keyCode = keyEvent.getKeyCode();
        return keyEvent.getAction() == 0 ? j0(keyCode, keyEvent) : m0(keyCode, keyEvent);
    }

    void N(int i10) {
        r X;
        r X2 = X(i10, true);
        if (X2.f935j != null) {
            Bundle bundle = new Bundle();
            X2.f935j.Q(bundle);
            if (bundle.size() > 0) {
                X2.f944s = bundle;
            }
            X2.f935j.d0();
            X2.f935j.clear();
        }
        X2.f943r = true;
        X2.f942q = true;
        if ((i10 != 108 && i10 != 0) || this.f899w == null || (X = X(0, false)) == null) {
            return;
        }
        X.f938m = false;
        u0(X, null);
    }

    void O() {
        u2 u2Var = this.D;
        if (u2Var != null) {
            u2Var.c();
        }
    }

    r R(Menu menu) {
        r[] rVarArr = this.R;
        int length = rVarArr != null ? rVarArr.length : 0;
        for (int i10 = 0; i10 < length; i10++) {
            r rVar = rVarArr[i10];
            if (rVar != null && rVar.f935j == menu) {
                return rVar;
            }
        }
        return null;
    }

    final Context S() {
        androidx.appcompat.app.a Y = Y();
        Context h10 = Y != null ? Y.h() : null;
        return h10 == null ? this.f893q : h10;
    }

    androidx.core.os.h W(Configuration configuration) {
        return Build.VERSION.SDK_INT >= 24 ? k.b(configuration) : androidx.core.os.h.c(j.b(configuration.locale));
    }

    protected r X(int i10, boolean z9) {
        r[] rVarArr = this.R;
        if (rVarArr == null || rVarArr.length <= i10) {
            r[] rVarArr2 = new r[i10 + 1];
            if (rVarArr != null) {
                System.arraycopy(rVarArr, 0, rVarArr2, 0, rVarArr.length);
            }
            this.R = rVarArr2;
            rVarArr = rVarArr2;
        }
        r rVar = rVarArr[i10];
        if (rVar == null) {
            r rVar2 = new r(i10);
            rVarArr[i10] = rVar2;
            return rVar2;
        }
        return rVar;
    }

    public androidx.appcompat.app.a Y() {
        b0();
        return this.f897u;
    }

    final CharSequence Z() {
        Object obj = this.f892p;
        return obj instanceof Activity ? ((Activity) obj).getTitle() : this.f898v;
    }

    @Override // androidx.appcompat.view.menu.g.a
    public boolean a(androidx.appcompat.view.menu.g gVar, MenuItem menuItem) {
        r R;
        Window.Callback a02 = a0();
        if (a02 == null || this.W || (R = R(gVar.D())) == null) {
            return false;
        }
        return a02.onMenuItemSelected(R.f926a, menuItem);
    }

    final Window.Callback a0() {
        return this.f894r.getCallback();
    }

    @Override // androidx.appcompat.view.menu.g.a
    public void b(androidx.appcompat.view.menu.g gVar) {
        v0(true);
    }

    @Override // androidx.appcompat.app.e
    public void d(View view, ViewGroup.LayoutParams layoutParams) {
        P();
        ((ViewGroup) this.G.findViewById(16908290)).addView(view, layoutParams);
        this.f895s.c(this.f894r.getCallback());
    }

    @Override // androidx.appcompat.app.e
    public View f(int i10) {
        P();
        return this.f894r.findViewById(i10);
    }

    public boolean g0() {
        return this.E;
    }

    int h0(Context context, int i10) {
        o V;
        if (i10 != -100) {
            if (i10 != -1) {
                if (i10 != 0) {
                    if (i10 != 1 && i10 != 2) {
                        if (i10 != 3) {
                            throw new IllegalStateException("Unknown value set for night mode. Please use one of the MODE_NIGHT values from AppCompatDelegate.");
                        }
                        V = U(context);
                    }
                } else if (Build.VERSION.SDK_INT >= 23 && ((UiModeManager) context.getApplicationContext().getSystemService("uimode")).getNightMode() == 0) {
                    return -1;
                } else {
                    V = V(context);
                }
                return V.c();
            }
            return i10;
        }
        return -1;
    }

    @Override // androidx.appcompat.app.e
    public void i() {
        LayoutInflater from = LayoutInflater.from(this.f893q);
        if (from.getFactory() == null) {
            androidx.core.view.k.a(from, this);
        } else if (from.getFactory2() instanceof f) {
        } else {
            Log.i("AppCompatDelegate", "The Activity's LayoutInflater already has a Factory installed so we can not install AppCompat's");
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean i0() {
        boolean z9 = this.T;
        this.T = false;
        r X = X(0, false);
        if (X != null && X.f940o) {
            if (!z9) {
                H(X, true);
            }
            return true;
        }
        androidx.appcompat.view.b bVar = this.f902z;
        if (bVar != null) {
            bVar.c();
            return true;
        }
        androidx.appcompat.app.a Y = Y();
        return Y != null && Y.f();
    }

    @Override // androidx.appcompat.app.e
    public void j() {
        if (s0() == null || Y().i()) {
            return;
        }
        f0(0);
    }

    boolean j0(int i10, KeyEvent keyEvent) {
        if (i10 == 4) {
            this.T = (keyEvent.getFlags() & 128) != 0;
        } else if (i10 == 82) {
            k0(0, keyEvent);
            return true;
        }
        return false;
    }

    @Override // androidx.appcompat.app.e
    public void k(Bundle bundle) {
        this.U = true;
        w(false);
        Q();
        Object obj = this.f892p;
        if (obj instanceof Activity) {
            String str = null;
            try {
                str = androidx.core.app.o.a((Activity) obj);
            } catch (IllegalArgumentException unused) {
            }
            if (str != null) {
                androidx.appcompat.app.a s02 = s0();
                if (s02 == null) {
                    this.f885h0 = true;
                } else {
                    s02.l(true);
                }
            }
            androidx.appcompat.app.e.c(this);
        }
        this.X = new Configuration(this.f893q.getResources().getConfiguration());
        this.V = true;
    }

    /* JADX WARN: Removed duplicated region for block: B:18:0x0058  */
    @Override // androidx.appcompat.app.e
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public void l() {
        androidx.appcompat.app.a aVar;
        if (this.f892p instanceof Activity) {
            androidx.appcompat.app.e.n(this);
        }
        if (this.f882e0) {
            this.f894r.getDecorView().removeCallbacks(this.f884g0);
        }
        this.W = true;
        if (this.Y != -100) {
            Object obj = this.f892p;
            if ((obj instanceof Activity) && ((Activity) obj).isChangingConfigurations()) {
                f873o0.put(this.f892p.getClass().getName(), Integer.valueOf(this.Y));
                aVar = this.f897u;
                if (aVar != null) {
                    aVar.j();
                }
                F();
            }
        }
        f873o0.remove(this.f892p.getClass().getName());
        aVar = this.f897u;
        if (aVar != null) {
        }
        F();
    }

    boolean l0(int i10, KeyEvent keyEvent) {
        androidx.appcompat.app.a Y = Y();
        if (Y == null || !Y.k(i10, keyEvent)) {
            r rVar = this.S;
            if (rVar != null && t0(rVar, keyEvent.getKeyCode(), keyEvent, 1)) {
                r rVar2 = this.S;
                if (rVar2 != null) {
                    rVar2.f939n = true;
                }
                return true;
            }
            if (this.S == null) {
                r X = X(0, true);
                u0(X, keyEvent);
                boolean t02 = t0(X, keyEvent.getKeyCode(), keyEvent, 1);
                X.f938m = false;
                if (t02) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override // androidx.appcompat.app.e
    public void m() {
        androidx.appcompat.app.a Y = Y();
        if (Y != null) {
            Y.m(false);
        }
    }

    boolean m0(int i10, KeyEvent keyEvent) {
        if (i10 != 4) {
            if (i10 == 82) {
                n0(0, keyEvent);
                return true;
            }
        } else if (i0()) {
            return true;
        }
        return false;
    }

    void o0(int i10) {
        androidx.appcompat.app.a Y;
        if (i10 != 108 || (Y = Y()) == null) {
            return;
        }
        Y.g(true);
    }

    @Override // android.view.LayoutInflater.Factory2
    public final View onCreateView(View view, String str, Context context, AttributeSet attributeSet) {
        return K(view, str, context, attributeSet);
    }

    @Override // android.view.LayoutInflater.Factory
    public View onCreateView(String str, Context context, AttributeSet attributeSet) {
        return onCreateView(null, str, context, attributeSet);
    }

    @Override // androidx.appcompat.app.e
    public boolean p(int i10) {
        int w02 = w0(i10);
        if (this.P && w02 == 108) {
            return false;
        }
        if (this.L && w02 == 1) {
            this.L = false;
        }
        if (w02 == 1) {
            E0();
            this.P = true;
            return true;
        } else if (w02 == 2) {
            E0();
            this.J = true;
            return true;
        } else if (w02 == 5) {
            E0();
            this.K = true;
            return true;
        } else if (w02 == 10) {
            E0();
            this.N = true;
            return true;
        } else if (w02 == 108) {
            E0();
            this.L = true;
            return true;
        } else if (w02 != 109) {
            return this.f894r.requestFeature(w02);
        } else {
            E0();
            this.M = true;
            return true;
        }
    }

    void p0(int i10) {
        if (i10 == 108) {
            androidx.appcompat.app.a Y = Y();
            if (Y != null) {
                Y.g(false);
            }
        } else if (i10 == 0) {
            r X = X(i10, true);
            if (X.f940o) {
                H(X, false);
            }
        }
    }

    @Override // androidx.appcompat.app.e
    public void q(int i10) {
        P();
        ViewGroup viewGroup = (ViewGroup) this.G.findViewById(16908290);
        viewGroup.removeAllViews();
        LayoutInflater.from(this.f893q).inflate(i10, viewGroup);
        this.f895s.c(this.f894r.getCallback());
    }

    void q0(ViewGroup viewGroup) {
    }

    @Override // androidx.appcompat.app.e
    public void r(View view) {
        P();
        ViewGroup viewGroup = (ViewGroup) this.G.findViewById(16908290);
        viewGroup.removeAllViews();
        viewGroup.addView(view);
        this.f895s.c(this.f894r.getCallback());
    }

    @Override // androidx.appcompat.app.e
    public void s(View view, ViewGroup.LayoutParams layoutParams) {
        P();
        ViewGroup viewGroup = (ViewGroup) this.G.findViewById(16908290);
        viewGroup.removeAllViews();
        viewGroup.addView(view, layoutParams);
        this.f895s.c(this.f894r.getCallback());
    }

    final androidx.appcompat.app.a s0() {
        return this.f897u;
    }

    @Override // androidx.appcompat.app.e
    public void t(OnBackInvokedDispatcher onBackInvokedDispatcher) {
        OnBackInvokedCallback onBackInvokedCallback;
        super.t(onBackInvokedDispatcher);
        OnBackInvokedDispatcher onBackInvokedDispatcher2 = this.f890m0;
        if (onBackInvokedDispatcher2 != null && (onBackInvokedCallback = this.f891n0) != null) {
            l.c(onBackInvokedDispatcher2, onBackInvokedCallback);
            this.f891n0 = null;
        }
        if (onBackInvokedDispatcher == null) {
            Object obj = this.f892p;
            if ((obj instanceof Activity) && ((Activity) obj).getWindow() != null) {
                onBackInvokedDispatcher = l.a((Activity) this.f892p);
            }
        }
        this.f890m0 = onBackInvokedDispatcher;
        I0();
    }

    @Override // androidx.appcompat.app.e
    public void u(int i10) {
        this.Z = i10;
    }

    @Override // androidx.appcompat.app.e
    public final void v(CharSequence charSequence) {
        this.f898v = charSequence;
        k1 k1Var = this.f899w;
        if (k1Var != null) {
            k1Var.setWindowTitle(charSequence);
        } else if (s0() != null) {
            s0().n(charSequence);
        } else {
            TextView textView = this.H;
            if (textView != null) {
                textView.setText(charSequence);
            }
        }
    }

    void x0(Configuration configuration, androidx.core.os.h hVar) {
        if (Build.VERSION.SDK_INT >= 24) {
            k.d(configuration, hVar);
            return;
        }
        i.b(configuration, hVar.d(0));
        i.a(configuration, hVar.d(0));
    }

    public boolean y() {
        return w(true);
    }

    void y0(androidx.core.os.h hVar) {
        if (Build.VERSION.SDK_INT >= 24) {
            k.c(hVar);
        } else {
            Locale.setDefault(hVar.d(0));
        }
    }

    final boolean z0() {
        ViewGroup viewGroup;
        return this.F && (viewGroup = this.G) != null && r0.R(viewGroup);
    }
}
