package androidx.appcompat.app;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.appcompat.app.AlertController;
/* loaded from: classes.dex */
public class b extends k {

    /* renamed from: l  reason: collision with root package name */
    final AlertController f861l;

    /* loaded from: classes.dex */
    public static class a {

        /* renamed from: a  reason: collision with root package name */
        private final AlertController.f f862a;

        /* renamed from: b  reason: collision with root package name */
        private final int f863b;

        public a(Context context) {
            this(context, b.l(context, 0));
        }

        public a(Context context, int i10) {
            this.f862a = new AlertController.f(new ContextThemeWrapper(context, b.l(context, i10)));
            this.f863b = i10;
        }

        public b a() {
            b bVar = new b(this.f862a.f821a, this.f863b);
            this.f862a.a(bVar.f861l);
            bVar.setCancelable(this.f862a.f838r);
            if (this.f862a.f838r) {
                bVar.setCanceledOnTouchOutside(true);
            }
            bVar.setOnCancelListener(this.f862a.f839s);
            bVar.setOnDismissListener(this.f862a.f840t);
            DialogInterface.OnKeyListener onKeyListener = this.f862a.f841u;
            if (onKeyListener != null) {
                bVar.setOnKeyListener(onKeyListener);
            }
            return bVar;
        }

        public Context b() {
            return this.f862a.f821a;
        }

        public a c(ListAdapter listAdapter, DialogInterface.OnClickListener onClickListener) {
            AlertController.f fVar = this.f862a;
            fVar.f843w = listAdapter;
            fVar.f844x = onClickListener;
            return this;
        }

        public a d(View view) {
            this.f862a.f827g = view;
            return this;
        }

        public a e(Drawable drawable) {
            this.f862a.f824d = drawable;
            return this;
        }

        public a f(DialogInterface.OnKeyListener onKeyListener) {
            this.f862a.f841u = onKeyListener;
            return this;
        }

        public a g(ListAdapter listAdapter, int i10, DialogInterface.OnClickListener onClickListener) {
            AlertController.f fVar = this.f862a;
            fVar.f843w = listAdapter;
            fVar.f844x = onClickListener;
            fVar.I = i10;
            fVar.H = true;
            return this;
        }

        public a h(CharSequence charSequence) {
            this.f862a.f826f = charSequence;
            return this;
        }
    }

    protected b(Context context, int i10) {
        super(context, l(context, i10));
        this.f861l = new AlertController(getContext(), this, getWindow());
    }

    static int l(Context context, int i10) {
        if (((i10 >>> 24) & 255) >= 1) {
            return i10;
        }
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(g.a.alertDialogTheme, typedValue, true);
        return typedValue.resourceId;
    }

    public ListView k() {
        return this.f861l.d();
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // androidx.appcompat.app.k, androidx.activity.p, android.app.Dialog
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.f861l.e();
    }

    @Override // android.app.Dialog, android.view.KeyEvent.Callback
    public boolean onKeyDown(int i10, KeyEvent keyEvent) {
        if (this.f861l.g(i10, keyEvent)) {
            return true;
        }
        return super.onKeyDown(i10, keyEvent);
    }

    @Override // android.app.Dialog, android.view.KeyEvent.Callback
    public boolean onKeyUp(int i10, KeyEvent keyEvent) {
        if (this.f861l.h(i10, keyEvent)) {
            return true;
        }
        return super.onKeyUp(i10, keyEvent);
    }

    @Override // androidx.appcompat.app.k, android.app.Dialog
    public void setTitle(CharSequence charSequence) {
        super.setTitle(charSequence);
        this.f861l.q(charSequence);
    }
}
