package androidx.appcompat.app;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewStub;
import android.view.Window;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.CursorAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;
import androidx.appcompat.widget.q1;
import androidx.core.view.r0;
import androidx.core.widget.NestedScrollView;
import java.lang.ref.WeakReference;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public class AlertController {
    NestedScrollView A;
    private Drawable C;
    private ImageView D;
    private TextView E;
    private TextView F;
    private View G;
    ListAdapter H;
    private int J;
    private int K;
    int L;
    int M;
    int N;
    int O;
    private boolean P;
    Handler R;

    /* renamed from: a  reason: collision with root package name */
    private final Context f780a;

    /* renamed from: b  reason: collision with root package name */
    final k f781b;

    /* renamed from: c  reason: collision with root package name */
    private final Window f782c;

    /* renamed from: d  reason: collision with root package name */
    private final int f783d;

    /* renamed from: e  reason: collision with root package name */
    private CharSequence f784e;

    /* renamed from: f  reason: collision with root package name */
    private CharSequence f785f;

    /* renamed from: g  reason: collision with root package name */
    ListView f786g;

    /* renamed from: h  reason: collision with root package name */
    private View f787h;

    /* renamed from: i  reason: collision with root package name */
    private int f788i;

    /* renamed from: j  reason: collision with root package name */
    private int f789j;

    /* renamed from: k  reason: collision with root package name */
    private int f790k;

    /* renamed from: l  reason: collision with root package name */
    private int f791l;

    /* renamed from: m  reason: collision with root package name */
    private int f792m;

    /* renamed from: o  reason: collision with root package name */
    Button f794o;

    /* renamed from: p  reason: collision with root package name */
    private CharSequence f795p;

    /* renamed from: q  reason: collision with root package name */
    Message f796q;

    /* renamed from: r  reason: collision with root package name */
    private Drawable f797r;

    /* renamed from: s  reason: collision with root package name */
    Button f798s;

    /* renamed from: t  reason: collision with root package name */
    private CharSequence f799t;

    /* renamed from: u  reason: collision with root package name */
    Message f800u;

    /* renamed from: v  reason: collision with root package name */
    private Drawable f801v;

    /* renamed from: w  reason: collision with root package name */
    Button f802w;

    /* renamed from: x  reason: collision with root package name */
    private CharSequence f803x;

    /* renamed from: y  reason: collision with root package name */
    Message f804y;

    /* renamed from: z  reason: collision with root package name */
    private Drawable f805z;

    /* renamed from: n  reason: collision with root package name */
    private boolean f793n = false;
    private int B = 0;
    int I = -1;
    private int Q = 0;
    private final View.OnClickListener S = new a();

    /* loaded from: classes.dex */
    public static class RecycleListView extends ListView {

        /* renamed from: g  reason: collision with root package name */
        private final int f806g;

        /* renamed from: h  reason: collision with root package name */
        private final int f807h;

        public RecycleListView(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, g.j.f7784c2);
            this.f807h = obtainStyledAttributes.getDimensionPixelOffset(g.j.f7789d2, -1);
            this.f806g = obtainStyledAttributes.getDimensionPixelOffset(g.j.f7794e2, -1);
        }

        public void a(boolean z9, boolean z10) {
            if (z10 && z9) {
                return;
            }
            setPadding(getPaddingLeft(), z9 ? getPaddingTop() : this.f806g, getPaddingRight(), z10 ? getPaddingBottom() : this.f807h);
        }
    }

    /* loaded from: classes.dex */
    class a implements View.OnClickListener {
        a() {
        }

        @Override // android.view.View.OnClickListener
        public void onClick(View view) {
            Message message;
            Message message2;
            AlertController alertController = AlertController.this;
            Message obtain = ((view != alertController.f794o || (message2 = alertController.f796q) == null) && (view != alertController.f798s || (message2 = alertController.f800u) == null)) ? (view != alertController.f802w || (message = alertController.f804y) == null) ? null : Message.obtain(message) : Message.obtain(message2);
            if (obtain != null) {
                obtain.sendToTarget();
            }
            AlertController alertController2 = AlertController.this;
            alertController2.R.obtainMessage(1, alertController2.f781b).sendToTarget();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class b implements NestedScrollView.d {

        /* renamed from: a  reason: collision with root package name */
        final /* synthetic */ View f809a;

        /* renamed from: b  reason: collision with root package name */
        final /* synthetic */ View f810b;

        b(View view, View view2) {
            this.f809a = view;
            this.f810b = view2;
        }

        @Override // androidx.core.widget.NestedScrollView.d
        public void a(NestedScrollView nestedScrollView, int i10, int i11, int i12, int i13) {
            AlertController.f(nestedScrollView, this.f809a, this.f810b);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class c implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ View f812g;

        /* renamed from: h  reason: collision with root package name */
        final /* synthetic */ View f813h;

        c(View view, View view2) {
            this.f812g = view;
            this.f813h = view2;
        }

        @Override // java.lang.Runnable
        public void run() {
            AlertController.f(AlertController.this.A, this.f812g, this.f813h);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class d implements AbsListView.OnScrollListener {

        /* renamed from: a  reason: collision with root package name */
        final /* synthetic */ View f815a;

        /* renamed from: b  reason: collision with root package name */
        final /* synthetic */ View f816b;

        d(View view, View view2) {
            this.f815a = view;
            this.f816b = view2;
        }

        @Override // android.widget.AbsListView.OnScrollListener
        public void onScroll(AbsListView absListView, int i10, int i11, int i12) {
            AlertController.f(absListView, this.f815a, this.f816b);
        }

        @Override // android.widget.AbsListView.OnScrollListener
        public void onScrollStateChanged(AbsListView absListView, int i10) {
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class e implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ View f818g;

        /* renamed from: h  reason: collision with root package name */
        final /* synthetic */ View f819h;

        e(View view, View view2) {
            this.f818g = view;
            this.f819h = view2;
        }

        @Override // java.lang.Runnable
        public void run() {
            AlertController.f(AlertController.this.f786g, this.f818g, this.f819h);
        }
    }

    /* loaded from: classes.dex */
    public static class f {
        public int A;
        public int B;
        public int C;
        public int D;
        public boolean[] F;
        public boolean G;
        public boolean H;
        public DialogInterface.OnMultiChoiceClickListener J;
        public Cursor K;
        public String L;
        public String M;
        public AdapterView.OnItemSelectedListener N;
        public e O;

        /* renamed from: a  reason: collision with root package name */
        public final Context f821a;

        /* renamed from: b  reason: collision with root package name */
        public final LayoutInflater f822b;

        /* renamed from: d  reason: collision with root package name */
        public Drawable f824d;

        /* renamed from: f  reason: collision with root package name */
        public CharSequence f826f;

        /* renamed from: g  reason: collision with root package name */
        public View f827g;

        /* renamed from: h  reason: collision with root package name */
        public CharSequence f828h;

        /* renamed from: i  reason: collision with root package name */
        public CharSequence f829i;

        /* renamed from: j  reason: collision with root package name */
        public Drawable f830j;

        /* renamed from: k  reason: collision with root package name */
        public DialogInterface.OnClickListener f831k;

        /* renamed from: l  reason: collision with root package name */
        public CharSequence f832l;

        /* renamed from: m  reason: collision with root package name */
        public Drawable f833m;

        /* renamed from: n  reason: collision with root package name */
        public DialogInterface.OnClickListener f834n;

        /* renamed from: o  reason: collision with root package name */
        public CharSequence f835o;

        /* renamed from: p  reason: collision with root package name */
        public Drawable f836p;

        /* renamed from: q  reason: collision with root package name */
        public DialogInterface.OnClickListener f837q;

        /* renamed from: s  reason: collision with root package name */
        public DialogInterface.OnCancelListener f839s;

        /* renamed from: t  reason: collision with root package name */
        public DialogInterface.OnDismissListener f840t;

        /* renamed from: u  reason: collision with root package name */
        public DialogInterface.OnKeyListener f841u;

        /* renamed from: v  reason: collision with root package name */
        public CharSequence[] f842v;

        /* renamed from: w  reason: collision with root package name */
        public ListAdapter f843w;

        /* renamed from: x  reason: collision with root package name */
        public DialogInterface.OnClickListener f844x;

        /* renamed from: y  reason: collision with root package name */
        public int f845y;

        /* renamed from: z  reason: collision with root package name */
        public View f846z;

        /* renamed from: c  reason: collision with root package name */
        public int f823c = 0;

        /* renamed from: e  reason: collision with root package name */
        public int f825e = 0;
        public boolean E = false;
        public int I = -1;
        public boolean P = true;

        /* renamed from: r  reason: collision with root package name */
        public boolean f838r = true;

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public class a extends ArrayAdapter {

            /* renamed from: g  reason: collision with root package name */
            final /* synthetic */ RecycleListView f847g;

            /* JADX WARN: 'super' call moved to the top of the method (can break code semantics) */
            a(Context context, int i10, int i11, CharSequence[] charSequenceArr, RecycleListView recycleListView) {
                super(context, i10, i11, charSequenceArr);
                this.f847g = recycleListView;
            }

            @Override // android.widget.ArrayAdapter, android.widget.Adapter
            public View getView(int i10, View view, ViewGroup viewGroup) {
                View view2 = super.getView(i10, view, viewGroup);
                boolean[] zArr = f.this.F;
                if (zArr != null && zArr[i10]) {
                    this.f847g.setItemChecked(i10, true);
                }
                return view2;
            }
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public class b extends CursorAdapter {

            /* renamed from: g  reason: collision with root package name */
            private final int f849g;

            /* renamed from: h  reason: collision with root package name */
            private final int f850h;

            /* renamed from: i  reason: collision with root package name */
            final /* synthetic */ RecycleListView f851i;

            /* renamed from: j  reason: collision with root package name */
            final /* synthetic */ AlertController f852j;

            /* JADX WARN: 'super' call moved to the top of the method (can break code semantics) */
            b(Context context, Cursor cursor, boolean z9, RecycleListView recycleListView, AlertController alertController) {
                super(context, cursor, z9);
                this.f851i = recycleListView;
                this.f852j = alertController;
                Cursor cursor2 = getCursor();
                this.f849g = cursor2.getColumnIndexOrThrow(f.this.L);
                this.f850h = cursor2.getColumnIndexOrThrow(f.this.M);
            }

            @Override // android.widget.CursorAdapter
            public void bindView(View view, Context context, Cursor cursor) {
                ((CheckedTextView) view.findViewById(16908308)).setText(cursor.getString(this.f849g));
                this.f851i.setItemChecked(cursor.getPosition(), cursor.getInt(this.f850h) == 1);
            }

            @Override // android.widget.CursorAdapter
            public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
                return f.this.f822b.inflate(this.f852j.M, viewGroup, false);
            }
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public class c implements AdapterView.OnItemClickListener {

            /* renamed from: g  reason: collision with root package name */
            final /* synthetic */ AlertController f854g;

            c(AlertController alertController) {
                this.f854g = alertController;
            }

            @Override // android.widget.AdapterView.OnItemClickListener
            public void onItemClick(AdapterView adapterView, View view, int i10, long j10) {
                f.this.f844x.onClick(this.f854g.f781b, i10);
                if (f.this.H) {
                    return;
                }
                this.f854g.f781b.dismiss();
            }
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public class d implements AdapterView.OnItemClickListener {

            /* renamed from: g  reason: collision with root package name */
            final /* synthetic */ RecycleListView f856g;

            /* renamed from: h  reason: collision with root package name */
            final /* synthetic */ AlertController f857h;

            d(RecycleListView recycleListView, AlertController alertController) {
                this.f856g = recycleListView;
                this.f857h = alertController;
            }

            @Override // android.widget.AdapterView.OnItemClickListener
            public void onItemClick(AdapterView adapterView, View view, int i10, long j10) {
                boolean[] zArr = f.this.F;
                if (zArr != null) {
                    zArr[i10] = this.f856g.isItemChecked(i10);
                }
                f.this.J.onClick(this.f857h.f781b, i10, this.f856g.isItemChecked(i10));
            }
        }

        /* loaded from: classes.dex */
        public interface e {
            void a(ListView listView);
        }

        public f(Context context) {
            this.f821a = context;
            this.f822b = (LayoutInflater) context.getSystemService("layout_inflater");
        }

        /* JADX WARN: Removed duplicated region for block: B:31:0x0093  */
        /* JADX WARN: Removed duplicated region for block: B:34:0x009a  */
        /* JADX WARN: Removed duplicated region for block: B:35:0x009e  */
        /*
            Code decompiled incorrectly, please refer to instructions dump.
        */
        private void b(AlertController alertController) {
            ListAdapter listAdapter;
            AdapterView.OnItemClickListener dVar;
            AdapterView.OnItemSelectedListener onItemSelectedListener;
            RecycleListView recycleListView = (RecycleListView) this.f822b.inflate(alertController.L, (ViewGroup) null);
            if (this.G) {
                listAdapter = this.K == null ? new a(this.f821a, alertController.M, 16908308, this.f842v, recycleListView) : new b(this.f821a, this.K, false, recycleListView, alertController);
            } else {
                int i10 = this.H ? alertController.N : alertController.O;
                if (this.K != null) {
                    listAdapter = new SimpleCursorAdapter(this.f821a, i10, this.K, new String[]{this.L}, new int[]{16908308});
                } else {
                    listAdapter = this.f843w;
                    if (listAdapter == null) {
                        listAdapter = new h(this.f821a, i10, 16908308, this.f842v);
                    }
                }
            }
            e eVar = this.O;
            if (eVar != null) {
                eVar.a(recycleListView);
            }
            alertController.H = listAdapter;
            alertController.I = this.I;
            if (this.f844x == null) {
                if (this.J != null) {
                    dVar = new d(recycleListView, alertController);
                }
                onItemSelectedListener = this.N;
                if (onItemSelectedListener != null) {
                    recycleListView.setOnItemSelectedListener(onItemSelectedListener);
                }
                if (!this.H) {
                    recycleListView.setChoiceMode(1);
                } else if (this.G) {
                    recycleListView.setChoiceMode(2);
                }
                alertController.f786g = recycleListView;
            }
            dVar = new c(alertController);
            recycleListView.setOnItemClickListener(dVar);
            onItemSelectedListener = this.N;
            if (onItemSelectedListener != null) {
            }
            if (!this.H) {
            }
            alertController.f786g = recycleListView;
        }

        public void a(AlertController alertController) {
            View view = this.f827g;
            if (view != null) {
                alertController.l(view);
            } else {
                CharSequence charSequence = this.f826f;
                if (charSequence != null) {
                    alertController.q(charSequence);
                }
                Drawable drawable = this.f824d;
                if (drawable != null) {
                    alertController.n(drawable);
                }
                int i10 = this.f823c;
                if (i10 != 0) {
                    alertController.m(i10);
                }
                int i11 = this.f825e;
                if (i11 != 0) {
                    alertController.m(alertController.c(i11));
                }
            }
            CharSequence charSequence2 = this.f828h;
            if (charSequence2 != null) {
                alertController.o(charSequence2);
            }
            CharSequence charSequence3 = this.f829i;
            if (charSequence3 != null || this.f830j != null) {
                alertController.k(-1, charSequence3, this.f831k, null, this.f830j);
            }
            CharSequence charSequence4 = this.f832l;
            if (charSequence4 != null || this.f833m != null) {
                alertController.k(-2, charSequence4, this.f834n, null, this.f833m);
            }
            CharSequence charSequence5 = this.f835o;
            if (charSequence5 != null || this.f836p != null) {
                alertController.k(-3, charSequence5, this.f837q, null, this.f836p);
            }
            if (this.f842v != null || this.K != null || this.f843w != null) {
                b(alertController);
            }
            View view2 = this.f846z;
            if (view2 != null) {
                if (this.E) {
                    alertController.t(view2, this.A, this.B, this.C, this.D);
                    return;
                } else {
                    alertController.s(view2);
                    return;
                }
            }
            int i12 = this.f845y;
            if (i12 != 0) {
                alertController.r(i12);
            }
        }
    }

    /* loaded from: classes.dex */
    private static final class g extends Handler {

        /* renamed from: a  reason: collision with root package name */
        private WeakReference f859a;

        public g(DialogInterface dialogInterface) {
            this.f859a = new WeakReference(dialogInterface);
        }

        @Override // android.os.Handler
        public void handleMessage(Message message) {
            int i10 = message.what;
            if (i10 == -3 || i10 == -2 || i10 == -1) {
                ((DialogInterface.OnClickListener) message.obj).onClick((DialogInterface) this.f859a.get(), message.what);
            } else if (i10 != 1) {
            } else {
                ((DialogInterface) message.obj).dismiss();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class h extends ArrayAdapter {
        public h(Context context, int i10, int i11, CharSequence[] charSequenceArr) {
            super(context, i10, i11, charSequenceArr);
        }

        @Override // android.widget.ArrayAdapter, android.widget.Adapter
        public long getItemId(int i10) {
            return i10;
        }

        @Override // android.widget.BaseAdapter, android.widget.Adapter
        public boolean hasStableIds() {
            return true;
        }
    }

    public AlertController(Context context, k kVar, Window window) {
        this.f780a = context;
        this.f781b = kVar;
        this.f782c = window;
        this.R = new g(kVar);
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(null, g.j.F, g.a.alertDialogStyle, 0);
        this.J = obtainStyledAttributes.getResourceId(g.j.G, 0);
        this.K = obtainStyledAttributes.getResourceId(g.j.I, 0);
        this.L = obtainStyledAttributes.getResourceId(g.j.K, 0);
        this.M = obtainStyledAttributes.getResourceId(g.j.L, 0);
        this.N = obtainStyledAttributes.getResourceId(g.j.N, 0);
        this.O = obtainStyledAttributes.getResourceId(g.j.J, 0);
        this.P = obtainStyledAttributes.getBoolean(g.j.M, true);
        this.f783d = obtainStyledAttributes.getDimensionPixelSize(g.j.H, 0);
        obtainStyledAttributes.recycle();
        kVar.j(1);
    }

    static boolean a(View view) {
        if (view.onCheckIsTextEditor()) {
            return true;
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup) view;
            int childCount = viewGroup.getChildCount();
            while (childCount > 0) {
                childCount--;
                if (a(viewGroup.getChildAt(childCount))) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void b(Button button) {
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) button.getLayoutParams();
        layoutParams.gravity = 1;
        layoutParams.weight = 0.5f;
        button.setLayoutParams(layoutParams);
    }

    static void f(View view, View view2, View view3) {
        if (view2 != null) {
            view2.setVisibility(view.canScrollVertically(-1) ? 0 : 4);
        }
        if (view3 != null) {
            view3.setVisibility(view.canScrollVertically(1) ? 0 : 4);
        }
    }

    private ViewGroup i(View view, View view2) {
        if (view == null) {
            if (view2 instanceof ViewStub) {
                view2 = ((ViewStub) view2).inflate();
            }
            return (ViewGroup) view2;
        }
        if (view2 != null) {
            ViewParent parent = view2.getParent();
            if (parent instanceof ViewGroup) {
                ((ViewGroup) parent).removeView(view2);
            }
        }
        if (view instanceof ViewStub) {
            view = ((ViewStub) view).inflate();
        }
        return (ViewGroup) view;
    }

    private int j() {
        int i10 = this.K;
        return (i10 != 0 && this.Q == 1) ? i10 : this.J;
    }

    private void p(ViewGroup viewGroup, View view, int i10, int i11) {
        View view2;
        Runnable eVar;
        View findViewById = this.f782c.findViewById(g.f.scrollIndicatorUp);
        View findViewById2 = this.f782c.findViewById(g.f.scrollIndicatorDown);
        if (Build.VERSION.SDK_INT < 23) {
            if (findViewById != null && (i10 & 1) == 0) {
                viewGroup.removeView(findViewById);
                findViewById = null;
            }
            if (findViewById2 != null && (i10 & 2) == 0) {
                viewGroup.removeView(findViewById2);
                findViewById2 = null;
            }
            if (findViewById == null && findViewById2 == null) {
                return;
            }
            if (this.f785f != null) {
                this.A.setOnScrollChangeListener(new b(findViewById, findViewById2));
                view2 = this.A;
                eVar = new c(findViewById, findViewById2);
            } else {
                ListView listView = this.f786g;
                if (listView != null) {
                    listView.setOnScrollListener(new d(findViewById, findViewById2));
                    view2 = this.f786g;
                    eVar = new e(findViewById, findViewById2);
                } else {
                    if (findViewById != null) {
                        viewGroup.removeView(findViewById);
                    }
                    if (findViewById2 == null) {
                        return;
                    }
                }
            }
            view2.post(eVar);
            return;
        }
        r0.D0(view, i10, i11);
        if (findViewById != null) {
            viewGroup.removeView(findViewById);
        }
        if (findViewById2 == null) {
            return;
        }
        viewGroup.removeView(findViewById2);
    }

    private void u(ViewGroup viewGroup) {
        boolean z9;
        Button button;
        Button button2 = (Button) viewGroup.findViewById(16908313);
        this.f794o = button2;
        button2.setOnClickListener(this.S);
        if (TextUtils.isEmpty(this.f795p) && this.f797r == null) {
            this.f794o.setVisibility(8);
            z9 = false;
        } else {
            this.f794o.setText(this.f795p);
            Drawable drawable = this.f797r;
            if (drawable != null) {
                int i10 = this.f783d;
                drawable.setBounds(0, 0, i10, i10);
                this.f794o.setCompoundDrawables(this.f797r, null, null, null);
            }
            this.f794o.setVisibility(0);
            z9 = true;
        }
        Button button3 = (Button) viewGroup.findViewById(16908314);
        this.f798s = button3;
        button3.setOnClickListener(this.S);
        if (TextUtils.isEmpty(this.f799t) && this.f801v == null) {
            this.f798s.setVisibility(8);
        } else {
            this.f798s.setText(this.f799t);
            Drawable drawable2 = this.f801v;
            if (drawable2 != null) {
                int i11 = this.f783d;
                drawable2.setBounds(0, 0, i11, i11);
                this.f798s.setCompoundDrawables(this.f801v, null, null, null);
            }
            this.f798s.setVisibility(0);
            z9 |= true;
        }
        Button button4 = (Button) viewGroup.findViewById(16908315);
        this.f802w = button4;
        button4.setOnClickListener(this.S);
        if (TextUtils.isEmpty(this.f803x) && this.f805z == null) {
            this.f802w.setVisibility(8);
        } else {
            this.f802w.setText(this.f803x);
            Drawable drawable3 = this.f805z;
            if (drawable3 != null) {
                int i12 = this.f783d;
                drawable3.setBounds(0, 0, i12, i12);
                this.f802w.setCompoundDrawables(this.f805z, null, null, null);
            }
            this.f802w.setVisibility(0);
            z9 |= true;
        }
        if (z(this.f780a)) {
            if (z9) {
                button = this.f794o;
            } else if (z9) {
                button = this.f798s;
            } else if (z9) {
                button = this.f802w;
            }
            b(button);
        }
        if (z9) {
            return;
        }
        viewGroup.setVisibility(8);
    }

    private void v(ViewGroup viewGroup) {
        NestedScrollView nestedScrollView = (NestedScrollView) this.f782c.findViewById(g.f.scrollView);
        this.A = nestedScrollView;
        nestedScrollView.setFocusable(false);
        this.A.setNestedScrollingEnabled(false);
        TextView textView = (TextView) viewGroup.findViewById(16908299);
        this.F = textView;
        if (textView == null) {
            return;
        }
        CharSequence charSequence = this.f785f;
        if (charSequence != null) {
            textView.setText(charSequence);
            return;
        }
        textView.setVisibility(8);
        this.A.removeView(this.F);
        if (this.f786g == null) {
            viewGroup.setVisibility(8);
            return;
        }
        ViewGroup viewGroup2 = (ViewGroup) this.A.getParent();
        int indexOfChild = viewGroup2.indexOfChild(this.A);
        viewGroup2.removeViewAt(indexOfChild);
        viewGroup2.addView(this.f786g, indexOfChild, new ViewGroup.LayoutParams(-1, -1));
    }

    private void w(ViewGroup viewGroup) {
        View view = this.f787h;
        if (view == null) {
            view = this.f788i != 0 ? LayoutInflater.from(this.f780a).inflate(this.f788i, viewGroup, false) : null;
        }
        boolean z9 = view != null;
        if (!z9 || !a(view)) {
            this.f782c.setFlags(131072, 131072);
        }
        if (!z9) {
            viewGroup.setVisibility(8);
            return;
        }
        FrameLayout frameLayout = (FrameLayout) this.f782c.findViewById(g.f.custom);
        frameLayout.addView(view, new ViewGroup.LayoutParams(-1, -1));
        if (this.f793n) {
            frameLayout.setPadding(this.f789j, this.f790k, this.f791l, this.f792m);
        }
        if (this.f786g != null) {
            ((LinearLayout.LayoutParams) ((q1.a) viewGroup.getLayoutParams())).weight = 0.0f;
        }
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Type inference failed for: r6v10, types: [android.view.View] */
    private void x(ViewGroup viewGroup) {
        ViewGroup viewGroup2;
        if (this.G != null) {
            viewGroup.addView(this.G, 0, new ViewGroup.LayoutParams(-1, -2));
            viewGroup2 = this.f782c.findViewById(g.f.title_template);
        } else {
            this.D = (ImageView) this.f782c.findViewById(16908294);
            if ((!TextUtils.isEmpty(this.f784e)) && this.P) {
                TextView textView = (TextView) this.f782c.findViewById(g.f.alertTitle);
                this.E = textView;
                textView.setText(this.f784e);
                int i10 = this.B;
                if (i10 != 0) {
                    this.D.setImageResource(i10);
                    return;
                }
                Drawable drawable = this.C;
                if (drawable != null) {
                    this.D.setImageDrawable(drawable);
                    return;
                }
                this.E.setPadding(this.D.getPaddingLeft(), this.D.getPaddingTop(), this.D.getPaddingRight(), this.D.getPaddingBottom());
                this.D.setVisibility(8);
                return;
            }
            this.f782c.findViewById(g.f.title_template).setVisibility(8);
            this.D.setVisibility(8);
            viewGroup2 = viewGroup;
        }
        viewGroup2.setVisibility(8);
    }

    /* JADX WARN: Multi-variable type inference failed */
    private void y() {
        View findViewById;
        ListAdapter listAdapter;
        View findViewById2;
        View findViewById3 = this.f782c.findViewById(g.f.parentPanel);
        int i10 = g.f.topPanel;
        View findViewById4 = findViewById3.findViewById(i10);
        int i11 = g.f.contentPanel;
        View findViewById5 = findViewById3.findViewById(i11);
        int i12 = g.f.buttonPanel;
        View findViewById6 = findViewById3.findViewById(i12);
        ViewGroup viewGroup = (ViewGroup) findViewById3.findViewById(g.f.customPanel);
        w(viewGroup);
        View findViewById7 = viewGroup.findViewById(i10);
        View findViewById8 = viewGroup.findViewById(i11);
        View findViewById9 = viewGroup.findViewById(i12);
        ViewGroup i13 = i(findViewById7, findViewById4);
        ViewGroup i14 = i(findViewById8, findViewById5);
        ViewGroup i15 = i(findViewById9, findViewById6);
        v(i14);
        u(i15);
        x(i13);
        boolean z9 = viewGroup.getVisibility() != 8;
        boolean z10 = (i13 == null || i13.getVisibility() == 8) ? 0 : 1;
        boolean z11 = (i15 == null || i15.getVisibility() == 8) ? false : true;
        if (!z11 && i14 != null && (findViewById2 = i14.findViewById(g.f.textSpacerNoButtons)) != null) {
            findViewById2.setVisibility(0);
        }
        if (z10) {
            NestedScrollView nestedScrollView = this.A;
            if (nestedScrollView != null) {
                nestedScrollView.setClipToPadding(true);
            }
            View view = null;
            if (this.f785f != null || this.f786g != null) {
                view = i13.findViewById(g.f.titleDividerNoCustom);
            }
            if (view != null) {
                view.setVisibility(0);
            }
        } else if (i14 != null && (findViewById = i14.findViewById(g.f.textSpacerNoTitle)) != null) {
            findViewById.setVisibility(0);
        }
        ListView listView = this.f786g;
        if (listView instanceof RecycleListView) {
            ((RecycleListView) listView).a(z10, z11);
        }
        if (!z9) {
            View view2 = this.f786g;
            if (view2 == null) {
                view2 = this.A;
            }
            if (view2 != null) {
                p(i14, view2, z10 | (z11 ? 2 : 0), 3);
            }
        }
        ListView listView2 = this.f786g;
        if (listView2 == null || (listAdapter = this.H) == null) {
            return;
        }
        listView2.setAdapter(listAdapter);
        int i16 = this.I;
        if (i16 > -1) {
            listView2.setItemChecked(i16, true);
            listView2.setSelection(i16);
        }
    }

    private static boolean z(Context context) {
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(g.a.alertDialogCenterButtons, typedValue, true);
        return typedValue.data != 0;
    }

    public int c(int i10) {
        TypedValue typedValue = new TypedValue();
        this.f780a.getTheme().resolveAttribute(i10, typedValue, true);
        return typedValue.resourceId;
    }

    public ListView d() {
        return this.f786g;
    }

    public void e() {
        this.f781b.setContentView(j());
        y();
    }

    public boolean g(int i10, KeyEvent keyEvent) {
        NestedScrollView nestedScrollView = this.A;
        return nestedScrollView != null && nestedScrollView.t(keyEvent);
    }

    public boolean h(int i10, KeyEvent keyEvent) {
        NestedScrollView nestedScrollView = this.A;
        return nestedScrollView != null && nestedScrollView.t(keyEvent);
    }

    public void k(int i10, CharSequence charSequence, DialogInterface.OnClickListener onClickListener, Message message, Drawable drawable) {
        if (message == null && onClickListener != null) {
            message = this.R.obtainMessage(i10, onClickListener);
        }
        if (i10 == -3) {
            this.f803x = charSequence;
            this.f804y = message;
            this.f805z = drawable;
        } else if (i10 == -2) {
            this.f799t = charSequence;
            this.f800u = message;
            this.f801v = drawable;
        } else if (i10 != -1) {
            throw new IllegalArgumentException("Button does not exist");
        } else {
            this.f795p = charSequence;
            this.f796q = message;
            this.f797r = drawable;
        }
    }

    public void l(View view) {
        this.G = view;
    }

    public void m(int i10) {
        this.C = null;
        this.B = i10;
        ImageView imageView = this.D;
        if (imageView != null) {
            if (i10 == 0) {
                imageView.setVisibility(8);
                return;
            }
            imageView.setVisibility(0);
            this.D.setImageResource(this.B);
        }
    }

    public void n(Drawable drawable) {
        this.C = drawable;
        this.B = 0;
        ImageView imageView = this.D;
        if (imageView != null) {
            if (drawable == null) {
                imageView.setVisibility(8);
                return;
            }
            imageView.setVisibility(0);
            this.D.setImageDrawable(drawable);
        }
    }

    public void o(CharSequence charSequence) {
        this.f785f = charSequence;
        TextView textView = this.F;
        if (textView != null) {
            textView.setText(charSequence);
        }
    }

    public void q(CharSequence charSequence) {
        this.f784e = charSequence;
        TextView textView = this.E;
        if (textView != null) {
            textView.setText(charSequence);
        }
    }

    public void r(int i10) {
        this.f787h = null;
        this.f788i = i10;
        this.f793n = false;
    }

    public void s(View view) {
        this.f787h = view;
        this.f788i = 0;
        this.f793n = false;
    }

    public void t(View view, int i10, int i11, int i12, int i13) {
        this.f787h = view;
        this.f788i = 0;
        this.f793n = true;
        this.f789j = i10;
        this.f790k = i11;
        this.f791l = i12;
        this.f792m = i13;
    }
}
