package androidx.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.window.OnBackInvokedDispatcher;
import androidx.activity.ComponentActivity;
import androidx.core.app.x0;
import androidx.lifecycle.a0;
import androidx.lifecycle.d0;
import androidx.lifecycle.h;
import androidx.lifecycle.h0;
import androidx.lifecycle.k0;
import androidx.lifecycle.l0;
import androidx.lifecycle.m0;
import androidx.lifecycle.n0;
import androidx.savedstate.a;
import f.a;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import o0.a;
/* loaded from: classes.dex */
public abstract class ComponentActivity extends androidx.core.app.m implements l0, androidx.lifecycle.g, h3.d, v, e.f, s {
    private static final String ACTIVITY_RESULT_TAG = "android:support:activity-result";
    private static final b Companion = new b(null);
    private k0 _viewModelStore;
    private final e.e activityResultRegistry;
    private int contentLayoutId;
    private final g8.e defaultViewModelProviderFactory$delegate;
    private boolean dispatchingOnMultiWindowModeChanged;
    private boolean dispatchingOnPictureInPictureModeChanged;
    private final g8.e fullyDrawnReporter$delegate;
    private final AtomicInteger nextLocalRequestCode;
    private final g8.e onBackPressedDispatcher$delegate;
    private final CopyOnWriteArrayList<v.a> onConfigurationChangedListeners;
    private final CopyOnWriteArrayList<v.a> onMultiWindowModeChangedListeners;
    private final CopyOnWriteArrayList<v.a> onNewIntentListeners;
    private final CopyOnWriteArrayList<v.a> onPictureInPictureModeChangedListeners;
    private final CopyOnWriteArrayList<v.a> onTrimMemoryListeners;
    private final CopyOnWriteArrayList<Runnable> onUserLeaveHintListeners;
    private final d reportFullyDrawnExecutor;
    private final h3.c savedStateRegistryController;
    private final d.a contextAwareHelper = new d.a();
    private final androidx.core.view.o menuHostHelper = new androidx.core.view.o(new Runnable() { // from class: androidx.activity.e
        @Override // java.lang.Runnable
        public final void run() {
            ComponentActivity.s(ComponentActivity.this);
        }
    });

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class a {

        /* renamed from: a  reason: collision with root package name */
        public static final a f696a = new a();

        private a() {
        }

        public final OnBackInvokedDispatcher a(Activity activity) {
            kotlin.jvm.internal.k.e(activity, "activity");
            OnBackInvokedDispatcher onBackInvokedDispatcher = activity.getOnBackInvokedDispatcher();
            kotlin.jvm.internal.k.d(onBackInvokedDispatcher, "activity.getOnBackInvokedDispatcher()");
            return onBackInvokedDispatcher;
        }
    }

    /* loaded from: classes.dex */
    private static final class b {
        private b() {
        }

        public /* synthetic */ b(kotlin.jvm.internal.g gVar) {
            this();
        }
    }

    /* loaded from: classes.dex */
    public static final class c {

        /* renamed from: a  reason: collision with root package name */
        private Object f697a;

        /* renamed from: b  reason: collision with root package name */
        private k0 f698b;

        public final Object a() {
            return this.f697a;
        }

        public final k0 b() {
            return this.f698b;
        }

        public final void c(Object obj) {
            this.f697a = obj;
        }

        public final void d(k0 k0Var) {
            this.f698b = k0Var;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public interface d extends Executor {
        void E(View view);

        void g();
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public final class e implements d, ViewTreeObserver.OnDrawListener, Runnable {

        /* renamed from: g  reason: collision with root package name */
        private final long f699g = SystemClock.uptimeMillis() + 10000;

        /* renamed from: h  reason: collision with root package name */
        private Runnable f700h;

        /* renamed from: i  reason: collision with root package name */
        private boolean f701i;

        public e() {
        }

        /* JADX INFO: Access modifiers changed from: private */
        public static final void b(e this$0) {
            kotlin.jvm.internal.k.e(this$0, "this$0");
            Runnable runnable = this$0.f700h;
            if (runnable != null) {
                kotlin.jvm.internal.k.b(runnable);
                runnable.run();
                this$0.f700h = null;
            }
        }

        @Override // androidx.activity.ComponentActivity.d
        public void E(View view) {
            kotlin.jvm.internal.k.e(view, "view");
            if (this.f701i) {
                return;
            }
            this.f701i = true;
            view.getViewTreeObserver().addOnDrawListener(this);
        }

        @Override // java.util.concurrent.Executor
        public void execute(Runnable runnable) {
            kotlin.jvm.internal.k.e(runnable, "runnable");
            this.f700h = runnable;
            View decorView = ComponentActivity.this.getWindow().getDecorView();
            kotlin.jvm.internal.k.d(decorView, "window.decorView");
            if (!this.f701i) {
                decorView.postOnAnimation(new Runnable() { // from class: androidx.activity.j
                    @Override // java.lang.Runnable
                    public final void run() {
                        ComponentActivity.e.b(ComponentActivity.e.this);
                    }
                });
            } else if (kotlin.jvm.internal.k.a(Looper.myLooper(), Looper.getMainLooper())) {
                decorView.invalidate();
            } else {
                decorView.postInvalidate();
            }
        }

        @Override // androidx.activity.ComponentActivity.d
        public void g() {
            ComponentActivity.this.getWindow().getDecorView().removeCallbacks(this);
            ComponentActivity.this.getWindow().getDecorView().getViewTreeObserver().removeOnDrawListener(this);
        }

        @Override // android.view.ViewTreeObserver.OnDrawListener
        public void onDraw() {
            Runnable runnable = this.f700h;
            if (runnable != null) {
                runnable.run();
                this.f700h = null;
                if (!ComponentActivity.this.getFullyDrawnReporter().c()) {
                    return;
                }
            } else if (SystemClock.uptimeMillis() <= this.f699g) {
                return;
            }
            this.f701i = false;
            ComponentActivity.this.getWindow().getDecorView().post(this);
        }

        @Override // java.lang.Runnable
        public void run() {
            ComponentActivity.this.getWindow().getDecorView().getViewTreeObserver().removeOnDrawListener(this);
        }
    }

    /* loaded from: classes.dex */
    public static final class f extends e.e {
        f() {
        }

        /* JADX INFO: Access modifiers changed from: private */
        public static final void s(f this$0, int i10, a.C0120a c0120a) {
            kotlin.jvm.internal.k.e(this$0, "this$0");
            this$0.f(i10, c0120a.a());
        }

        /* JADX INFO: Access modifiers changed from: private */
        public static final void t(f this$0, int i10, IntentSender.SendIntentException e10) {
            kotlin.jvm.internal.k.e(this$0, "this$0");
            kotlin.jvm.internal.k.e(e10, "$e");
            this$0.e(i10, 0, new Intent().setAction("androidx.activity.result.contract.action.INTENT_SENDER_REQUEST").putExtra("androidx.activity.result.contract.extra.SEND_INTENT_EXCEPTION", e10));
        }

        @Override // e.e
        public void i(final int i10, f.a contract, Object obj, androidx.core.app.f fVar) {
            kotlin.jvm.internal.k.e(contract, "contract");
            ComponentActivity componentActivity = ComponentActivity.this;
            final a.C0120a b10 = contract.b(componentActivity, obj);
            if (b10 != null) {
                new Handler(Looper.getMainLooper()).post(new Runnable() { // from class: androidx.activity.k
                    @Override // java.lang.Runnable
                    public final void run() {
                        ComponentActivity.f.s(ComponentActivity.f.this, i10, b10);
                    }
                });
                return;
            }
            Intent a10 = contract.a(componentActivity, obj);
            Bundle bundle = null;
            if (a10.getExtras() != null) {
                Bundle extras = a10.getExtras();
                kotlin.jvm.internal.k.b(extras);
                if (extras.getClassLoader() == null) {
                    a10.setExtrasClassLoader(componentActivity.getClassLoader());
                }
            }
            if (a10.hasExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE")) {
                bundle = a10.getBundleExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE");
                a10.removeExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE");
            }
            Bundle bundle2 = bundle;
            if (kotlin.jvm.internal.k.a("androidx.activity.result.contract.action.REQUEST_PERMISSIONS", a10.getAction())) {
                String[] stringArrayExtra = a10.getStringArrayExtra("androidx.activity.result.contract.extra.PERMISSIONS");
                if (stringArrayExtra == null) {
                    stringArrayExtra = new String[0];
                }
                androidx.core.app.b.r(componentActivity, stringArrayExtra, i10);
            } else if (!kotlin.jvm.internal.k.a("androidx.activity.result.contract.action.INTENT_SENDER_REQUEST", a10.getAction())) {
                androidx.core.app.b.v(componentActivity, a10, i10, bundle2);
            } else {
                e.g gVar = (e.g) a10.getParcelableExtra("androidx.activity.result.contract.extra.INTENT_SENDER_REQUEST");
                try {
                    kotlin.jvm.internal.k.b(gVar);
                    androidx.core.app.b.w(componentActivity, gVar.e(), i10, gVar.a(), gVar.c(), gVar.d(), 0, bundle2);
                } catch (IntentSender.SendIntentException e10) {
                    new Handler(Looper.getMainLooper()).post(new Runnable() { // from class: androidx.activity.l
                        @Override // java.lang.Runnable
                        public final void run() {
                            ComponentActivity.f.t(ComponentActivity.f.this, i10, e10);
                        }
                    });
                }
            }
        }
    }

    /* loaded from: classes.dex */
    static final class g extends kotlin.jvm.internal.l implements q8.a {
        g() {
            super(0);
        }

        @Override // q8.a
        /* renamed from: c */
        public final d0 invoke() {
            Application application = ComponentActivity.this.getApplication();
            ComponentActivity componentActivity = ComponentActivity.this;
            return new d0(application, componentActivity, componentActivity.getIntent() != null ? ComponentActivity.this.getIntent().getExtras() : null);
        }
    }

    /* loaded from: classes.dex */
    static final class h extends kotlin.jvm.internal.l implements q8.a {

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public static final class a extends kotlin.jvm.internal.l implements q8.a {

            /* renamed from: g  reason: collision with root package name */
            final /* synthetic */ ComponentActivity f706g;

            /* JADX WARN: 'super' call moved to the top of the method (can break code semantics) */
            a(ComponentActivity componentActivity) {
                super(0);
                this.f706g = componentActivity;
            }

            public final void c() {
                this.f706g.reportFullyDrawn();
            }

            @Override // q8.a
            public /* bridge */ /* synthetic */ Object invoke() {
                c();
                return g8.q.f8031a;
            }
        }

        h() {
            super(0);
        }

        @Override // q8.a
        /* renamed from: c */
        public final r invoke() {
            return new r(ComponentActivity.this.reportFullyDrawnExecutor, new a(ComponentActivity.this));
        }
    }

    /* loaded from: classes.dex */
    static final class i extends kotlin.jvm.internal.l implements q8.a {
        i() {
            super(0);
        }

        /* JADX INFO: Access modifiers changed from: private */
        public static final void h(ComponentActivity this$0) {
            kotlin.jvm.internal.k.e(this$0, "this$0");
            try {
                ComponentActivity.super.onBackPressed();
            } catch (IllegalStateException e10) {
                if (!kotlin.jvm.internal.k.a(e10.getMessage(), "Can not perform this action after onSaveInstanceState")) {
                    throw e10;
                }
            } catch (NullPointerException e11) {
                if (!kotlin.jvm.internal.k.a(e11.getMessage(), "Attempt to invoke virtual method 'android.os.Handler android.app.FragmentHostCallback.getHandler()' on a null object reference")) {
                    throw e11;
                }
            }
        }

        /* JADX INFO: Access modifiers changed from: private */
        public static final void i(ComponentActivity this$0, OnBackPressedDispatcher dispatcher) {
            kotlin.jvm.internal.k.e(this$0, "this$0");
            kotlin.jvm.internal.k.e(dispatcher, "$dispatcher");
            this$0.o(dispatcher);
        }

        @Override // q8.a
        /* renamed from: e */
        public final OnBackPressedDispatcher invoke() {
            final ComponentActivity componentActivity = ComponentActivity.this;
            final OnBackPressedDispatcher onBackPressedDispatcher = new OnBackPressedDispatcher(new Runnable() { // from class: androidx.activity.m
                @Override // java.lang.Runnable
                public final void run() {
                    ComponentActivity.i.h(ComponentActivity.this);
                }
            });
            final ComponentActivity componentActivity2 = ComponentActivity.this;
            if (Build.VERSION.SDK_INT >= 33) {
                if (kotlin.jvm.internal.k.a(Looper.myLooper(), Looper.getMainLooper())) {
                    componentActivity2.o(onBackPressedDispatcher);
                } else {
                    new Handler(Looper.getMainLooper()).post(new Runnable() { // from class: androidx.activity.n
                        @Override // java.lang.Runnable
                        public final void run() {
                            ComponentActivity.i.i(ComponentActivity.this, onBackPressedDispatcher);
                        }
                    });
                }
            }
            return onBackPressedDispatcher;
        }
    }

    public ComponentActivity() {
        g8.e a10;
        g8.e a11;
        g8.e a12;
        h3.c a13 = h3.c.f8119d.a(this);
        this.savedStateRegistryController = a13;
        this.reportFullyDrawnExecutor = q();
        a10 = g8.g.a(new h());
        this.fullyDrawnReporter$delegate = a10;
        this.nextLocalRequestCode = new AtomicInteger();
        this.activityResultRegistry = new f();
        this.onConfigurationChangedListeners = new CopyOnWriteArrayList<>();
        this.onTrimMemoryListeners = new CopyOnWriteArrayList<>();
        this.onNewIntentListeners = new CopyOnWriteArrayList<>();
        this.onMultiWindowModeChangedListeners = new CopyOnWriteArrayList<>();
        this.onPictureInPictureModeChangedListeners = new CopyOnWriteArrayList<>();
        this.onUserLeaveHintListeners = new CopyOnWriteArrayList<>();
        if (getLifecycle() == null) {
            throw new IllegalStateException("getLifecycle() returned null in ComponentActivity's constructor. Please make sure you are lazily constructing your Lifecycle in the first call to getLifecycle() rather than relying on field initialization.".toString());
        }
        getLifecycle().a(new androidx.lifecycle.k() { // from class: androidx.activity.f
            @Override // androidx.lifecycle.k
            public final void a(androidx.lifecycle.m mVar, h.a aVar) {
                ComponentActivity.k(ComponentActivity.this, mVar, aVar);
            }
        });
        getLifecycle().a(new androidx.lifecycle.k() { // from class: androidx.activity.g
            @Override // androidx.lifecycle.k
            public final void a(androidx.lifecycle.m mVar, h.a aVar) {
                ComponentActivity.l(ComponentActivity.this, mVar, aVar);
            }
        });
        getLifecycle().a(new androidx.lifecycle.k() { // from class: androidx.activity.ComponentActivity.4
            @Override // androidx.lifecycle.k
            public void a(androidx.lifecycle.m source, h.a event) {
                kotlin.jvm.internal.k.e(source, "source");
                kotlin.jvm.internal.k.e(event, "event");
                ComponentActivity.this.r();
                ComponentActivity.this.getLifecycle().c(this);
            }
        });
        a13.c();
        a0.c(this);
        if (Build.VERSION.SDK_INT <= 23) {
            getLifecycle().a(new ImmLeaksCleaner(this));
        }
        getSavedStateRegistry().h(ACTIVITY_RESULT_TAG, new a.c() { // from class: androidx.activity.h
            @Override // androidx.savedstate.a.c
            public final Bundle a() {
                Bundle m10;
                m10 = ComponentActivity.m(ComponentActivity.this);
                return m10;
            }
        });
        addOnContextAvailableListener(new d.b() { // from class: androidx.activity.i
            @Override // d.b
            public final void a(Context context) {
                ComponentActivity.n(ComponentActivity.this, context);
            }
        });
        a11 = g8.g.a(new g());
        this.defaultViewModelProviderFactory$delegate = a11;
        a12 = g8.g.a(new i());
        this.onBackPressedDispatcher$delegate = a12;
    }

    public static /* synthetic */ void getOnBackPressedDispatcher$annotations() {
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static final void k(ComponentActivity this$0, androidx.lifecycle.m mVar, h.a event) {
        Window window;
        View peekDecorView;
        kotlin.jvm.internal.k.e(this$0, "this$0");
        kotlin.jvm.internal.k.e(mVar, "<anonymous parameter 0>");
        kotlin.jvm.internal.k.e(event, "event");
        if (event != h.a.ON_STOP || (window = this$0.getWindow()) == null || (peekDecorView = window.peekDecorView()) == null) {
            return;
        }
        peekDecorView.cancelPendingInputEvents();
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static final void l(ComponentActivity this$0, androidx.lifecycle.m mVar, h.a event) {
        kotlin.jvm.internal.k.e(this$0, "this$0");
        kotlin.jvm.internal.k.e(mVar, "<anonymous parameter 0>");
        kotlin.jvm.internal.k.e(event, "event");
        if (event == h.a.ON_DESTROY) {
            this$0.contextAwareHelper.b();
            if (!this$0.isChangingConfigurations()) {
                this$0.getViewModelStore().a();
            }
            this$0.reportFullyDrawnExecutor.g();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static final Bundle m(ComponentActivity this$0) {
        kotlin.jvm.internal.k.e(this$0, "this$0");
        Bundle bundle = new Bundle();
        this$0.activityResultRegistry.k(bundle);
        return bundle;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static final void n(ComponentActivity this$0, Context it) {
        kotlin.jvm.internal.k.e(this$0, "this$0");
        kotlin.jvm.internal.k.e(it, "it");
        Bundle b10 = this$0.getSavedStateRegistry().b(ACTIVITY_RESULT_TAG);
        if (b10 != null) {
            this$0.activityResultRegistry.j(b10);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public final void o(final OnBackPressedDispatcher onBackPressedDispatcher) {
        getLifecycle().a(new androidx.lifecycle.k() { // from class: androidx.activity.d
            @Override // androidx.lifecycle.k
            public final void a(androidx.lifecycle.m mVar, h.a aVar) {
                ComponentActivity.p(OnBackPressedDispatcher.this, this, mVar, aVar);
            }
        });
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static final void p(OnBackPressedDispatcher dispatcher, ComponentActivity this$0, androidx.lifecycle.m mVar, h.a event) {
        kotlin.jvm.internal.k.e(dispatcher, "$dispatcher");
        kotlin.jvm.internal.k.e(this$0, "this$0");
        kotlin.jvm.internal.k.e(mVar, "<anonymous parameter 0>");
        kotlin.jvm.internal.k.e(event, "event");
        if (event == h.a.ON_CREATE) {
            dispatcher.n(a.f696a.a(this$0));
        }
    }

    private final d q() {
        return new e();
    }

    /* JADX INFO: Access modifiers changed from: private */
    public final void r() {
        if (this._viewModelStore == null) {
            c cVar = (c) getLastNonConfigurationInstance();
            if (cVar != null) {
                this._viewModelStore = cVar.b();
            }
            if (this._viewModelStore == null) {
                this._viewModelStore = new k0();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static final void s(ComponentActivity this$0) {
        kotlin.jvm.internal.k.e(this$0, "this$0");
        this$0.invalidateMenu();
    }

    @Override // android.app.Activity
    public void addContentView(View view, ViewGroup.LayoutParams layoutParams) {
        initializeViewTreeOwners();
        d dVar = this.reportFullyDrawnExecutor;
        View decorView = getWindow().getDecorView();
        kotlin.jvm.internal.k.d(decorView, "window.decorView");
        dVar.E(decorView);
        super.addContentView(view, layoutParams);
    }

    public void addMenuProvider(androidx.core.view.d0 provider) {
        kotlin.jvm.internal.k.e(provider, "provider");
        this.menuHostHelper.c(provider);
    }

    public void addMenuProvider(androidx.core.view.d0 provider, androidx.lifecycle.m owner) {
        kotlin.jvm.internal.k.e(provider, "provider");
        kotlin.jvm.internal.k.e(owner, "owner");
        this.menuHostHelper.d(provider, owner);
    }

    @SuppressLint({"LambdaLast"})
    public void addMenuProvider(androidx.core.view.d0 provider, androidx.lifecycle.m owner, h.b state) {
        kotlin.jvm.internal.k.e(provider, "provider");
        kotlin.jvm.internal.k.e(owner, "owner");
        kotlin.jvm.internal.k.e(state, "state");
        this.menuHostHelper.e(provider, owner, state);
    }

    public final void addOnConfigurationChangedListener(v.a listener) {
        kotlin.jvm.internal.k.e(listener, "listener");
        this.onConfigurationChangedListeners.add(listener);
    }

    public final void addOnContextAvailableListener(d.b listener) {
        kotlin.jvm.internal.k.e(listener, "listener");
        this.contextAwareHelper.a(listener);
    }

    public final void addOnMultiWindowModeChangedListener(v.a listener) {
        kotlin.jvm.internal.k.e(listener, "listener");
        this.onMultiWindowModeChangedListeners.add(listener);
    }

    public final void addOnNewIntentListener(v.a listener) {
        kotlin.jvm.internal.k.e(listener, "listener");
        this.onNewIntentListeners.add(listener);
    }

    public final void addOnPictureInPictureModeChangedListener(v.a listener) {
        kotlin.jvm.internal.k.e(listener, "listener");
        this.onPictureInPictureModeChangedListeners.add(listener);
    }

    public final void addOnTrimMemoryListener(v.a listener) {
        kotlin.jvm.internal.k.e(listener, "listener");
        this.onTrimMemoryListeners.add(listener);
    }

    public final void addOnUserLeaveHintListener(Runnable listener) {
        kotlin.jvm.internal.k.e(listener, "listener");
        this.onUserLeaveHintListeners.add(listener);
    }

    @Override // e.f
    public final e.e getActivityResultRegistry() {
        return this.activityResultRegistry;
    }

    @Override // androidx.lifecycle.g
    public o0.a getDefaultViewModelCreationExtras() {
        o0.d dVar = new o0.d(null, 1, null);
        if (getApplication() != null) {
            a.b bVar = h0.a.f3344g;
            Application application = getApplication();
            kotlin.jvm.internal.k.d(application, "application");
            dVar.c(bVar, application);
        }
        dVar.c(a0.f3297a, this);
        dVar.c(a0.f3298b, this);
        Intent intent = getIntent();
        Bundle extras = intent != null ? intent.getExtras() : null;
        if (extras != null) {
            dVar.c(a0.f3299c, extras);
        }
        return dVar;
    }

    public h0.b getDefaultViewModelProviderFactory() {
        return (h0.b) this.defaultViewModelProviderFactory$delegate.getValue();
    }

    public r getFullyDrawnReporter() {
        return (r) this.fullyDrawnReporter$delegate.getValue();
    }

    public Object getLastCustomNonConfigurationInstance() {
        c cVar = (c) getLastNonConfigurationInstance();
        if (cVar != null) {
            return cVar.a();
        }
        return null;
    }

    @Override // androidx.core.app.m, androidx.lifecycle.m
    public androidx.lifecycle.h getLifecycle() {
        return super.getLifecycle();
    }

    @Override // androidx.activity.v
    public final OnBackPressedDispatcher getOnBackPressedDispatcher() {
        return (OnBackPressedDispatcher) this.onBackPressedDispatcher$delegate.getValue();
    }

    @Override // h3.d
    public final androidx.savedstate.a getSavedStateRegistry() {
        return this.savedStateRegistryController.b();
    }

    @Override // androidx.lifecycle.l0
    public k0 getViewModelStore() {
        if (getApplication() != null) {
            r();
            k0 k0Var = this._viewModelStore;
            kotlin.jvm.internal.k.b(k0Var);
            return k0Var;
        }
        throw new IllegalStateException("Your activity is not yet attached to the Application instance. You can't request ViewModel before onCreate call.".toString());
    }

    public void initializeViewTreeOwners() {
        View decorView = getWindow().getDecorView();
        kotlin.jvm.internal.k.d(decorView, "window.decorView");
        m0.a(decorView, this);
        View decorView2 = getWindow().getDecorView();
        kotlin.jvm.internal.k.d(decorView2, "window.decorView");
        n0.a(decorView2, this);
        View decorView3 = getWindow().getDecorView();
        kotlin.jvm.internal.k.d(decorView3, "window.decorView");
        h3.e.a(decorView3, this);
        View decorView4 = getWindow().getDecorView();
        kotlin.jvm.internal.k.d(decorView4, "window.decorView");
        y.a(decorView4, this);
        View decorView5 = getWindow().getDecorView();
        kotlin.jvm.internal.k.d(decorView5, "window.decorView");
        x.a(decorView5, this);
    }

    public void invalidateMenu() {
        invalidateOptionsMenu();
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // android.app.Activity
    public void onActivityResult(int i10, int i11, Intent intent) {
        if (this.activityResultRegistry.e(i10, i11, intent)) {
            return;
        }
        super.onActivityResult(i10, i11, intent);
    }

    @Override // android.app.Activity
    public void onBackPressed() {
        getOnBackPressedDispatcher().k();
    }

    @Override // android.app.Activity, android.content.ComponentCallbacks
    public void onConfigurationChanged(Configuration newConfig) {
        kotlin.jvm.internal.k.e(newConfig, "newConfig");
        super.onConfigurationChanged(newConfig);
        Iterator<v.a> it = this.onConfigurationChangedListeners.iterator();
        while (it.hasNext()) {
            it.next().accept(newConfig);
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // androidx.core.app.m, android.app.Activity
    public void onCreate(Bundle bundle) {
        this.savedStateRegistryController.d(bundle);
        this.contextAwareHelper.c(this);
        super.onCreate(bundle);
        androidx.lifecycle.x.f3383h.c(this);
        int i10 = this.contentLayoutId;
        if (i10 != 0) {
            setContentView(i10);
        }
    }

    @Override // android.app.Activity, android.view.Window.Callback
    public boolean onCreatePanelMenu(int i10, Menu menu) {
        kotlin.jvm.internal.k.e(menu, "menu");
        if (i10 == 0) {
            super.onCreatePanelMenu(i10, menu);
            this.menuHostHelper.h(menu, getMenuInflater());
            return true;
        }
        return true;
    }

    @Override // android.app.Activity, android.view.Window.Callback
    public boolean onMenuItemSelected(int i10, MenuItem item) {
        kotlin.jvm.internal.k.e(item, "item");
        if (super.onMenuItemSelected(i10, item)) {
            return true;
        }
        if (i10 == 0) {
            return this.menuHostHelper.j(item);
        }
        return false;
    }

    @Override // android.app.Activity
    public void onMultiWindowModeChanged(boolean z9, Configuration newConfig) {
        kotlin.jvm.internal.k.e(newConfig, "newConfig");
        this.dispatchingOnMultiWindowModeChanged = true;
        try {
            super.onMultiWindowModeChanged(z9, newConfig);
            this.dispatchingOnMultiWindowModeChanged = false;
            Iterator<v.a> it = this.onMultiWindowModeChangedListeners.iterator();
            while (it.hasNext()) {
                it.next().accept(new androidx.core.app.n(z9, newConfig));
            }
        } catch (Throwable th) {
            this.dispatchingOnMultiWindowModeChanged = false;
            throw th;
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // android.app.Activity
    public void onNewIntent(Intent intent) {
        kotlin.jvm.internal.k.e(intent, "intent");
        super.onNewIntent(intent);
        Iterator<v.a> it = this.onNewIntentListeners.iterator();
        while (it.hasNext()) {
            it.next().accept(intent);
        }
    }

    @Override // android.app.Activity, android.view.Window.Callback
    public void onPanelClosed(int i10, Menu menu) {
        kotlin.jvm.internal.k.e(menu, "menu");
        this.menuHostHelper.i(menu);
        super.onPanelClosed(i10, menu);
    }

    @Override // android.app.Activity
    public void onPictureInPictureModeChanged(boolean z9, Configuration newConfig) {
        kotlin.jvm.internal.k.e(newConfig, "newConfig");
        this.dispatchingOnPictureInPictureModeChanged = true;
        try {
            super.onPictureInPictureModeChanged(z9, newConfig);
            this.dispatchingOnPictureInPictureModeChanged = false;
            Iterator<v.a> it = this.onPictureInPictureModeChangedListeners.iterator();
            while (it.hasNext()) {
                it.next().accept(new x0(z9, newConfig));
            }
        } catch (Throwable th) {
            this.dispatchingOnPictureInPictureModeChanged = false;
            throw th;
        }
    }

    @Override // android.app.Activity, android.view.Window.Callback
    public boolean onPreparePanel(int i10, View view, Menu menu) {
        kotlin.jvm.internal.k.e(menu, "menu");
        if (i10 == 0) {
            super.onPreparePanel(i10, view, menu);
            this.menuHostHelper.k(menu);
            return true;
        }
        return true;
    }

    @Override // android.app.Activity
    public void onRequestPermissionsResult(int i10, String[] permissions, int[] grantResults) {
        kotlin.jvm.internal.k.e(permissions, "permissions");
        kotlin.jvm.internal.k.e(grantResults, "grantResults");
        if (this.activityResultRegistry.e(i10, -1, new Intent().putExtra("androidx.activity.result.contract.extra.PERMISSIONS", permissions).putExtra("androidx.activity.result.contract.extra.PERMISSION_GRANT_RESULTS", grantResults)) || Build.VERSION.SDK_INT < 23) {
            return;
        }
        super.onRequestPermissionsResult(i10, permissions, grantResults);
    }

    public Object onRetainCustomNonConfigurationInstance() {
        return null;
    }

    @Override // android.app.Activity
    public final Object onRetainNonConfigurationInstance() {
        c cVar;
        Object onRetainCustomNonConfigurationInstance = onRetainCustomNonConfigurationInstance();
        k0 k0Var = this._viewModelStore;
        if (k0Var == null && (cVar = (c) getLastNonConfigurationInstance()) != null) {
            k0Var = cVar.b();
        }
        if (k0Var == null && onRetainCustomNonConfigurationInstance == null) {
            return null;
        }
        c cVar2 = new c();
        cVar2.c(onRetainCustomNonConfigurationInstance);
        cVar2.d(k0Var);
        return cVar2;
    }

    @Override // androidx.core.app.m, android.app.Activity
    protected void onSaveInstanceState(Bundle outState) {
        kotlin.jvm.internal.k.e(outState, "outState");
        if (getLifecycle() instanceof androidx.lifecycle.n) {
            androidx.lifecycle.h lifecycle = getLifecycle();
            kotlin.jvm.internal.k.c(lifecycle, "null cannot be cast to non-null type androidx.lifecycle.LifecycleRegistry");
            ((androidx.lifecycle.n) lifecycle).m(h.b.CREATED);
        }
        super.onSaveInstanceState(outState);
        this.savedStateRegistryController.e(outState);
    }

    @Override // android.app.Activity, android.content.ComponentCallbacks2
    public void onTrimMemory(int i10) {
        super.onTrimMemory(i10);
        Iterator<v.a> it = this.onTrimMemoryListeners.iterator();
        while (it.hasNext()) {
            it.next().accept(Integer.valueOf(i10));
        }
    }

    public Context peekAvailableContext() {
        return this.contextAwareHelper.d();
    }

    public final <I, O> e.c registerForActivityResult(f.a contract, e.b callback) {
        kotlin.jvm.internal.k.e(contract, "contract");
        kotlin.jvm.internal.k.e(callback, "callback");
        return registerForActivityResult(contract, this.activityResultRegistry, callback);
    }

    public final <I, O> e.c registerForActivityResult(f.a contract, e.e registry, e.b callback) {
        kotlin.jvm.internal.k.e(contract, "contract");
        kotlin.jvm.internal.k.e(registry, "registry");
        kotlin.jvm.internal.k.e(callback, "callback");
        return registry.l("activity_rq#" + this.nextLocalRequestCode.getAndIncrement(), this, contract, callback);
    }

    public void removeMenuProvider(androidx.core.view.d0 provider) {
        kotlin.jvm.internal.k.e(provider, "provider");
        this.menuHostHelper.l(provider);
    }

    public final void removeOnConfigurationChangedListener(v.a listener) {
        kotlin.jvm.internal.k.e(listener, "listener");
        this.onConfigurationChangedListeners.remove(listener);
    }

    public final void removeOnContextAvailableListener(d.b listener) {
        kotlin.jvm.internal.k.e(listener, "listener");
        this.contextAwareHelper.e(listener);
    }

    public final void removeOnMultiWindowModeChangedListener(v.a listener) {
        kotlin.jvm.internal.k.e(listener, "listener");
        this.onMultiWindowModeChangedListeners.remove(listener);
    }

    public final void removeOnNewIntentListener(v.a listener) {
        kotlin.jvm.internal.k.e(listener, "listener");
        this.onNewIntentListeners.remove(listener);
    }

    public final void removeOnPictureInPictureModeChangedListener(v.a listener) {
        kotlin.jvm.internal.k.e(listener, "listener");
        this.onPictureInPictureModeChangedListeners.remove(listener);
    }

    public final void removeOnTrimMemoryListener(v.a listener) {
        kotlin.jvm.internal.k.e(listener, "listener");
        this.onTrimMemoryListeners.remove(listener);
    }

    public final void removeOnUserLeaveHintListener(Runnable listener) {
        kotlin.jvm.internal.k.e(listener, "listener");
        this.onUserLeaveHintListeners.remove(listener);
    }

    @Override // android.app.Activity
    public void reportFullyDrawn() {
        try {
            if (m3.b.h()) {
                m3.b.c("reportFullyDrawn() for ComponentActivity");
            }
            super.reportFullyDrawn();
            getFullyDrawnReporter().b();
        } finally {
            m3.b.f();
        }
    }

    @Override // android.app.Activity
    public void setContentView(int i10) {
        initializeViewTreeOwners();
        d dVar = this.reportFullyDrawnExecutor;
        View decorView = getWindow().getDecorView();
        kotlin.jvm.internal.k.d(decorView, "window.decorView");
        dVar.E(decorView);
        super.setContentView(i10);
    }

    @Override // android.app.Activity
    public void setContentView(View view) {
        initializeViewTreeOwners();
        d dVar = this.reportFullyDrawnExecutor;
        View decorView = getWindow().getDecorView();
        kotlin.jvm.internal.k.d(decorView, "window.decorView");
        dVar.E(decorView);
        super.setContentView(view);
    }

    @Override // android.app.Activity
    public void setContentView(View view, ViewGroup.LayoutParams layoutParams) {
        initializeViewTreeOwners();
        d dVar = this.reportFullyDrawnExecutor;
        View decorView = getWindow().getDecorView();
        kotlin.jvm.internal.k.d(decorView, "window.decorView");
        dVar.E(decorView);
        super.setContentView(view, layoutParams);
    }

    @Override // android.app.Activity
    public void startActivityForResult(Intent intent, int i10) {
        kotlin.jvm.internal.k.e(intent, "intent");
        super.startActivityForResult(intent, i10);
    }

    @Override // android.app.Activity
    public void startActivityForResult(Intent intent, int i10, Bundle bundle) {
        kotlin.jvm.internal.k.e(intent, "intent");
        super.startActivityForResult(intent, i10, bundle);
    }

    @Override // android.app.Activity
    public void startIntentSenderForResult(IntentSender intent, int i10, Intent intent2, int i11, int i12, int i13) {
        kotlin.jvm.internal.k.e(intent, "intent");
        super.startIntentSenderForResult(intent, i10, intent2, i11, i12, i13);
    }

    @Override // android.app.Activity
    public void startIntentSenderForResult(IntentSender intent, int i10, Intent intent2, int i11, int i12, int i13, Bundle bundle) {
        kotlin.jvm.internal.k.e(intent, "intent");
        super.startIntentSenderForResult(intent, i10, intent2, i11, i12, i13, bundle);
    }
}
