package io.grpc;

import io.grpc.ServerCall;

public abstract class ForwardingServerCallListener<ReqT> extends PartialForwardingServerCallListener<ReqT> {
    /* access modifiers changed from: protected */
    @Override // io.grpc.PartialForwardingServerCallListener
    public abstract ServerCall.Listener<ReqT> delegate();

    @Override // io.grpc.PartialForwardingServerCallListener, io.grpc.ServerCall.Listener
    public /* bridge */ /* synthetic */ void onCancel() {
        super.onCancel();
    }

    @Override // io.grpc.PartialForwardingServerCallListener, io.grpc.ServerCall.Listener
    public /* bridge */ /* synthetic */ void onComplete() {
        super.onComplete();
    }

    @Override // io.grpc.PartialForwardingServerCallListener, io.grpc.ServerCall.Listener
    public /* bridge */ /* synthetic */ void onHalfClose() {
        super.onHalfClose();
    }

    @Override // io.grpc.PartialForwardingServerCallListener, io.grpc.ServerCall.Listener
    public /* bridge */ /* synthetic */ void onReady() {
        super.onReady();
    }

    @Override // io.grpc.PartialForwardingServerCallListener
    public /* bridge */ /* synthetic */ String toString() {
        return super.toString();
    }

    @Override // io.grpc.ServerCall.Listener
    public void onMessage(ReqT reqt) {
        delegate().onMessage(reqt);
    }

    public static abstract class SimpleForwardingServerCallListener<ReqT> extends ForwardingServerCallListener<ReqT> {
        private final ServerCall.Listener<ReqT> delegate;

        @Override // io.grpc.PartialForwardingServerCallListener, io.grpc.ServerCall.Listener, io.grpc.ForwardingServerCallListener
        public /* bridge */ /* synthetic */ void onCancel() {
            ForwardingServerCallListener.super.onCancel();
        }

        @Override // io.grpc.PartialForwardingServerCallListener, io.grpc.ServerCall.Listener, io.grpc.ForwardingServerCallListener
        public /* bridge */ /* synthetic */ void onComplete() {
            ForwardingServerCallListener.super.onComplete();
        }

        @Override // io.grpc.PartialForwardingServerCallListener, io.grpc.ServerCall.Listener, io.grpc.ForwardingServerCallListener
        public /* bridge */ /* synthetic */ void onHalfClose() {
            ForwardingServerCallListener.super.onHalfClose();
        }

        @Override // io.grpc.PartialForwardingServerCallListener, io.grpc.ServerCall.Listener, io.grpc.ForwardingServerCallListener
        public /* bridge */ /* synthetic */ void onReady() {
            ForwardingServerCallListener.super.onReady();
        }

        @Override // io.grpc.PartialForwardingServerCallListener, io.grpc.ForwardingServerCallListener
        public /* bridge */ /* synthetic */ String toString() {
            return ForwardingServerCallListener.super.toString();
        }

        protected SimpleForwardingServerCallListener(ServerCall.Listener<ReqT> listener) {
            this.delegate = listener;
        }

        /* access modifiers changed from: protected */
        @Override // io.grpc.PartialForwardingServerCallListener, io.grpc.ForwardingServerCallListener
        public ServerCall.Listener<ReqT> delegate() {
            return this.delegate;
        }
    }
}
