package io.grpc;

public abstract class ForwardingServerCall<ReqT, RespT> extends PartialForwardingServerCall<ReqT, RespT> {
    /* access modifiers changed from: protected */
    @Override // io.grpc.PartialForwardingServerCall
    public abstract ServerCall<ReqT, RespT> delegate();

    @Override // io.grpc.ServerCall, io.grpc.PartialForwardingServerCall
    public /* bridge */ /* synthetic */ void close(Status status, Metadata metadata) {
        super.close(status, metadata);
    }

    @Override // io.grpc.ServerCall, io.grpc.PartialForwardingServerCall
    public /* bridge */ /* synthetic */ Attributes getAttributes() {
        return super.getAttributes();
    }

    @Override // io.grpc.ServerCall, io.grpc.PartialForwardingServerCall
    public /* bridge */ /* synthetic */ String getAuthority() {
        return super.getAuthority();
    }

    @Override // io.grpc.ServerCall, io.grpc.PartialForwardingServerCall
    public /* bridge */ /* synthetic */ boolean isCancelled() {
        return super.isCancelled();
    }

    @Override // io.grpc.ServerCall, io.grpc.PartialForwardingServerCall
    public /* bridge */ /* synthetic */ boolean isReady() {
        return super.isReady();
    }

    @Override // io.grpc.ServerCall, io.grpc.PartialForwardingServerCall
    public /* bridge */ /* synthetic */ void request(int i) {
        super.request(i);
    }

    @Override // io.grpc.ServerCall, io.grpc.PartialForwardingServerCall
    public /* bridge */ /* synthetic */ void sendHeaders(Metadata metadata) {
        super.sendHeaders(metadata);
    }

    @Override // io.grpc.ServerCall, io.grpc.PartialForwardingServerCall
    public /* bridge */ /* synthetic */ void setCompression(String str) {
        super.setCompression(str);
    }

    @Override // io.grpc.ServerCall, io.grpc.PartialForwardingServerCall
    public /* bridge */ /* synthetic */ void setMessageCompression(boolean z) {
        super.setMessageCompression(z);
    }

    @Override // io.grpc.PartialForwardingServerCall
    public /* bridge */ /* synthetic */ String toString() {
        return super.toString();
    }

    @Override // io.grpc.ServerCall
    public void sendMessage(RespT respt) {
        delegate().sendMessage(respt);
    }

    public static abstract class SimpleForwardingServerCall<ReqT, RespT> extends ForwardingServerCall<ReqT, RespT> {
        private final ServerCall<ReqT, RespT> delegate;

        @Override // io.grpc.ServerCall, io.grpc.ForwardingServerCall, io.grpc.PartialForwardingServerCall
        public /* bridge */ /* synthetic */ void close(Status status, Metadata metadata) {
            ForwardingServerCall.super.close(status, metadata);
        }

        @Override // io.grpc.ServerCall, io.grpc.ForwardingServerCall, io.grpc.PartialForwardingServerCall
        public /* bridge */ /* synthetic */ Attributes getAttributes() {
            return ForwardingServerCall.super.getAttributes();
        }

        @Override // io.grpc.ServerCall, io.grpc.ForwardingServerCall, io.grpc.PartialForwardingServerCall
        public /* bridge */ /* synthetic */ String getAuthority() {
            return ForwardingServerCall.super.getAuthority();
        }

        @Override // io.grpc.ServerCall, io.grpc.ForwardingServerCall, io.grpc.PartialForwardingServerCall
        public /* bridge */ /* synthetic */ boolean isCancelled() {
            return ForwardingServerCall.super.isCancelled();
        }

        @Override // io.grpc.ServerCall, io.grpc.ForwardingServerCall, io.grpc.PartialForwardingServerCall
        public /* bridge */ /* synthetic */ boolean isReady() {
            return ForwardingServerCall.super.isReady();
        }

        @Override // io.grpc.ServerCall, io.grpc.ForwardingServerCall, io.grpc.PartialForwardingServerCall
        public /* bridge */ /* synthetic */ void request(int i) {
            ForwardingServerCall.super.request(i);
        }

        @Override // io.grpc.ServerCall, io.grpc.ForwardingServerCall, io.grpc.PartialForwardingServerCall
        public /* bridge */ /* synthetic */ void sendHeaders(Metadata metadata) {
            ForwardingServerCall.super.sendHeaders(metadata);
        }

        @Override // io.grpc.ServerCall, io.grpc.ForwardingServerCall, io.grpc.PartialForwardingServerCall
        public /* bridge */ /* synthetic */ void setCompression(String str) {
            ForwardingServerCall.super.setCompression(str);
        }

        @Override // io.grpc.ServerCall, io.grpc.ForwardingServerCall, io.grpc.PartialForwardingServerCall
        public /* bridge */ /* synthetic */ void setMessageCompression(boolean z) {
            ForwardingServerCall.super.setMessageCompression(z);
        }

        @Override // io.grpc.ForwardingServerCall, io.grpc.PartialForwardingServerCall
        public /* bridge */ /* synthetic */ String toString() {
            return ForwardingServerCall.super.toString();
        }

        protected SimpleForwardingServerCall(ServerCall<ReqT, RespT> serverCall) {
            this.delegate = serverCall;
        }

        /* access modifiers changed from: protected */
        @Override // io.grpc.ForwardingServerCall, io.grpc.PartialForwardingServerCall
        public ServerCall<ReqT, RespT> delegate() {
            return this.delegate;
        }

        @Override // io.grpc.ServerCall
        public MethodDescriptor<ReqT, RespT> getMethodDescriptor() {
            return this.delegate.getMethodDescriptor();
        }
    }
}
