package io.grpc;

import a.b.a.f.h;
import com.google.common.base.Preconditions;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ClientInterceptors {
    private static final ClientCall<Object, Object> NOOP_CALL = new ClientCall<Object, Object>() {
        /* class io.grpc.ClientInterceptors.AnonymousClass2 */

        @Override // io.grpc.ClientCall
        public void cancel(String str, Throwable th) {
        }

        @Override // io.grpc.ClientCall
        public void halfClose() {
        }

        @Override // io.grpc.ClientCall
        public boolean isReady() {
            return false;
        }

        @Override // io.grpc.ClientCall
        public void request(int i) {
        }

        @Override // io.grpc.ClientCall
        public void sendMessage(Object obj) {
        }

        @Override // io.grpc.ClientCall
        public void start(ClientCall.Listener<Object> listener, Metadata metadata) {
        }
    };

    private ClientInterceptors() {
    }

    public static Channel interceptForward(Channel channel, ClientInterceptor... clientInterceptorArr) {
        return interceptForward(channel, Arrays.asList(clientInterceptorArr));
    }

    public static Channel interceptForward(Channel channel, List<? extends ClientInterceptor> list) {
        ArrayList arrayList = new ArrayList(list);
        Collections.reverse(arrayList);
        return intercept(channel, arrayList);
    }

    public static Channel intercept(Channel channel, ClientInterceptor... clientInterceptorArr) {
        return intercept(channel, Arrays.asList(clientInterceptorArr));
    }

    public static Channel intercept(Channel channel, List<? extends ClientInterceptor> list) {
        Preconditions.checkNotNull(channel, h.a.n);
        for (ClientInterceptor clientInterceptor : list) {
            channel = new InterceptorChannel(channel, clientInterceptor);
        }
        return channel;
    }

    static <WReqT, WRespT> ClientInterceptor wrapClientInterceptor(final ClientInterceptor clientInterceptor, final MethodDescriptor.Marshaller<WReqT> marshaller, final MethodDescriptor.Marshaller<WRespT> marshaller2) {
        return new ClientInterceptor() {
            /* class io.grpc.ClientInterceptors.AnonymousClass1 */

            @Override // io.grpc.ClientInterceptor
            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
                final ClientCall<ReqT, RespT> interceptCall = clientInterceptor.interceptCall(methodDescriptor.toBuilder(MethodDescriptor.Marshaller.this, marshaller2).build(), callOptions, channel);
                return new PartialForwardingClientCall<ReqT, RespT>() {
                    /* class io.grpc.ClientInterceptors.AnonymousClass1.AnonymousClass1 */

                    @Override // io.grpc.ClientCall
                    public void start(final ClientCall.Listener<RespT> listener, Metadata metadata) {
                        interceptCall.start(new PartialForwardingClientCallListener<WRespT>() {
                            /* class io.grpc.ClientInterceptors.AnonymousClass1.AnonymousClass1.AnonymousClass1 */

                            @Override // io.grpc.ClientCall.Listener
                            public void onMessage(WRespT wrespt) {
                                listener.onMessage(methodDescriptor.getResponseMarshaller().parse(marshaller2.stream(wrespt)));
                            }

                            /* access modifiers changed from: protected */
                            @Override // io.grpc.PartialForwardingClientCallListener
                            public ClientCall.Listener<?> delegate() {
                                return listener;
                            }
                        }, metadata);
                    }

                    @Override // io.grpc.ClientCall
                    public void sendMessage(ReqT reqt) {
                        interceptCall.sendMessage(MethodDescriptor.Marshaller.this.parse(methodDescriptor.getRequestMarshaller().stream(reqt)));
                    }

                    /* access modifiers changed from: protected */
                    @Override // io.grpc.PartialForwardingClientCall
                    public ClientCall<?, ?> delegate() {
                        return interceptCall;
                    }
                };
            }
        };
    }

    /* access modifiers changed from: private */
    public static class InterceptorChannel extends Channel {
        private final Channel channel;
        private final ClientInterceptor interceptor;

        private InterceptorChannel(Channel channel2, ClientInterceptor clientInterceptor) {
            this.channel = channel2;
            this.interceptor = (ClientInterceptor) Preconditions.checkNotNull(clientInterceptor, "interceptor");
        }

        @Override // io.grpc.Channel
        public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions) {
            return this.interceptor.interceptCall(methodDescriptor, callOptions, this.channel);
        }

        @Override // io.grpc.Channel
        public String authority() {
            return this.channel.authority();
        }
    }

    public static abstract class CheckedForwardingClientCall<ReqT, RespT> extends ForwardingClientCall<ReqT, RespT> {
        private ClientCall<ReqT, RespT> delegate;

        /* access modifiers changed from: protected */
        public abstract void checkedStart(ClientCall.Listener<RespT> listener, Metadata metadata) throws Exception;

        protected CheckedForwardingClientCall(ClientCall<ReqT, RespT> clientCall) {
            this.delegate = clientCall;
        }

        /* access modifiers changed from: protected */
        @Override // io.grpc.ForwardingClientCall, io.grpc.PartialForwardingClientCall
        public final ClientCall<ReqT, RespT> delegate() {
            return this.delegate;
        }

        @Override // io.grpc.ForwardingClientCall, io.grpc.ClientCall
        public final void start(ClientCall.Listener<RespT> listener, Metadata metadata) {
            try {
                checkedStart(listener, metadata);
            } catch (Exception e) {
                this.delegate = ClientInterceptors.NOOP_CALL;
                listener.onClose(Status.fromThrowable(e), new Metadata());
            }
        }
    }
}
