package com.ucarhu.demo.widget;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.ucarhu.demo.R;

public class UCarProgressBar {
    private Activity mActivity;
    private Animation mAnimation;
    private ImageView mImageView;
    private boolean mIsShowing = false;
    private FrameLayout mParentLayout;
    private TextView mPhoneModel;
    private TextView mProgress;
    private View mRootView;

    public UCarProgressBar(Activity activity, FrameLayout frameLayout) {
        this.mActivity = activity;
        View inflate = LayoutInflater.from(activity).inflate(R.layout.dialog_progess, (ViewGroup) null);
        this.mRootView = inflate;
        this.mImageView = (ImageView) inflate.findViewById(R.id.img);
        this.mProgress = (TextView) this.mRootView.findViewById(R.id.tv_progress);
        this.mPhoneModel = (TextView) this.mRootView.findViewById(R.id.tv_model);
        this.mAnimation = AnimationUtils.loadAnimation(activity, R.anim.progress);
        this.mParentLayout = frameLayout;
    }

    public void updateProgress(String str, int i) {
        this.mPhoneModel.setText(str);
        if (i < 0 || i > 100) {
            this.mProgress.setText("");
        } else {
            this.mProgress.setText(i + "%");
        }
    }

    public void show() {
        if (!this.mIsShowing) {
            this.mParentLayout.addView(this.mRootView, new FrameLayout.LayoutParams(-2, -2, 17));
            this.mIsShowing = true;
        }
        this.mImageView.startAnimation(this.mAnimation);
    }

    public void hide() {
        if (this.mIsShowing) {
            this.mParentLayout.removeView(this.mRootView);
            this.mIsShowing = false;
        }
        this.mImageView.clearAnimation();
    }
}
