package com.ucarhu.demo.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ucarhu.demo.R;

public class UCarPinCodeView extends LinearLayout {
    private static final int CODE_LENGTH = 6;
    private static final float DEFAULT_PERCENT = 0.45f;
    private String mPinCode;
    private int mSize;
    private final TextView[] mTextViews;
    private int mWidth;
    private float mWidthPercent;

    public UCarPinCodeView(Context context) {
        this(context, null);
    }

    public UCarPinCodeView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public UCarPinCodeView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.mTextViews = new TextView[6];
        setOrientation(0);
        int i2 = getResources().getDisplayMetrics().widthPixels;
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R.styleable.UCarPinCodeView, i, 0);
        float f = DEFAULT_PERCENT;
        if (obtainStyledAttributes != null) {
            try {
                f = obtainStyledAttributes.getFloat(0, DEFAULT_PERCENT);
            } finally {
                obtainStyledAttributes.recycle();
            }
        }
        float min = Math.min(f, 1.0f);
        this.mWidthPercent = min;
        int i3 = (int) (((float) i2) * min);
        this.mWidth = i3;
        this.mSize = (int) (((float) i3) / 8.0f);
        Rect rect = new Rect();
        int i4 = -1;
        for (int i5 = 0; i5 < 6; i5++) {
            TextView textView = new TextView(context, null, 0, R.style.UCarPinCode_Style);
            if (i4 == -1) {
                TextPaint paint = textView.getPaint();
                paint.getTextBounds("0", 0, 1, rect);
                i4 = (int) ((((float) this.mSize) / (((float) rect.height()) * 2.0f)) * paint.getTextSize());
            }
            textView.setTextSize(0, (float) i4);
            textView.setGravity(17);
            int i6 = this.mSize;
            ViewGroup.MarginLayoutParams marginLayoutParams = new ViewGroup.MarginLayoutParams(i6, i6);
            if (i5 == 0) {
                marginLayoutParams.rightMargin = ((this.mSize * 2) / 5) / 2;
            } else if (i5 == 5) {
                marginLayoutParams.leftMargin = ((this.mSize * 2) / 5) / 2;
            } else {
                marginLayoutParams.leftMargin = ((this.mSize * 2) / 5) / 2;
                marginLayoutParams.rightMargin = ((this.mSize * 2) / 5) / 2;
            }
            addView(textView, marginLayoutParams);
            this.mTextViews[i5] = textView;
        }
    }

    /* access modifiers changed from: protected */
    public void onMeasure(int i, int i2) {
        if (getChildCount() == 6) {
            super.onMeasure(View.MeasureSpec.makeMeasureSpec(this.mWidth, 1073741824), View.MeasureSpec.makeMeasureSpec(this.mSize, 1073741824));
            return;
        }
        throw new RuntimeException("pin code must be length 6");
    }

    public void setPinCode(String str) {
        if (str.length() == 6) {
            this.mPinCode = str;
            int i = 0;
            while (i < 6) {
                int i2 = i + 1;
                this.mTextViews[i].setText(str.substring(i, i2));
                i = i2;
            }
            return;
        }
        throw new IllegalArgumentException("pin code must be length 6");
    }

    public String getPinCode() {
        return this.mPinCode;
    }
}
