package com.ucarhu.demo.widget;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageButton;
import android.widget.TextView;
import com.ucar.vehiclesdk.UCarCommon;
import com.ucarhu.demo.R;

public class UCarCallWindow implements View.OnClickListener {
    private static final int ACTION_ICON_WIDTH_PERCENT_BY_WIDTH = 20;
    private static final int HOUR_IN_SECONDS = 3600;
    private static final int MINUTE_IN_SECONDS = 60;
    private static final int SECOND_IN_MILLISECONDS = 1000;
    private ImageButton mAcceptCall;
    private int mBaseConnectedTime;
    private TextView mCallNumber;
    private TextView mCallState;
    private ViewGroup mContainer;
    private Context mContext;
    private ImageButton mEndCall;
    private Handler mHandler;
    private int mInCallAppId;
    private long mStartTime;
    private final Runnable mUpdateTime = new Runnable() {
        /* class com.ucarhu.demo.widget.UCarCallWindow.AnonymousClass1 */

        public void run() {
            UCarCallWindow.this.updateDuration(((long) UCarCallWindow.this.mBaseConnectedTime) + ((SystemClock.uptimeMillis() - UCarCallWindow.this.mStartTime) / 1000));
            UCarCallWindow.this.mHandler.postDelayed(this, 1000);
        }
    };
    private View mView;
    private WindowManager mWindowManager;
    private WindowManager.LayoutParams mWindowParams;

    public UCarCallWindow(Context context, Handler handler) {
        this.mContext = context;
        this.mHandler = handler;
        View inflate = LayoutInflater.from(context).inflate(R.layout.layout_ucar_in_call, (ViewGroup) null);
        this.mView = inflate;
        this.mContainer = (ViewGroup) inflate.findViewById(R.id.cstl_call_container);
        this.mCallNumber = (TextView) this.mView.findViewById(R.id.tv_call_user_info);
        this.mCallState = (TextView) this.mView.findViewById(R.id.tv_call_state_desc);
        this.mAcceptCall = (ImageButton) this.mView.findViewById(R.id.ib_call_accept);
        this.mEndCall = (ImageButton) this.mView.findViewById(R.id.ib_call_end);
        this.mView.setOnClickListener(this);
        this.mAcceptCall.setOnClickListener(this);
        this.mEndCall.setOnClickListener(this);
        this.mWindowManager = (WindowManager) context.getSystemService("window");
    }

    public void onClick(View view) {
        Message obtainMessage = this.mHandler.obtainMessage();
        switch (view.getId()) {
            case R.id.cv_call_container:
                obtainMessage.what = 108;
                obtainMessage.arg1 = this.mInCallAppId;
                this.mHandler.sendMessage(obtainMessage);
                return;
            case R.id.ib_call_accept:
                obtainMessage.what = 109;
                this.mHandler.sendMessage(obtainMessage);
                return;
            case R.id.ib_call_end:
                obtainMessage.what = 110;
                this.mHandler.sendMessage(obtainMessage);
                return;
            default:
                return;
        }
    }

    /* access modifiers changed from: package-private */
    /* renamed from: com.ucarhu.demo.widget.UCarCallWindow$2  reason: invalid class name */
    public static /* synthetic */ class AnonymousClass2 {
        static final /* synthetic */ int[] $SwitchMap$com$ucar$vehiclesdk$UCarCommon$CallState;

        /* JADX WARNING: Can't wrap try/catch for region: R(14:0|1|2|3|4|5|6|7|8|9|10|11|12|(3:13|14|16)) */
        /* JADX WARNING: Can't wrap try/catch for region: R(16:0|1|2|3|4|5|6|7|8|9|10|11|12|13|14|16) */
        /* JADX WARNING: Failed to process nested try/catch */
        /* JADX WARNING: Missing exception handler attribute for start block: B:11:0x003e */
        /* JADX WARNING: Missing exception handler attribute for start block: B:13:0x0049 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:3:0x0012 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:5:0x001d */
        /* JADX WARNING: Missing exception handler attribute for start block: B:7:0x0028 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:9:0x0033 */
        static {
            int[] iArr = new int[UCarCommon.CallState.values().length];
            $SwitchMap$com$ucar$vehiclesdk$UCarCommon$CallState = iArr;
            iArr[UCarCommon.CallState.UNKNOWN_STATE.ordinal()] = 1;
            $SwitchMap$com$ucar$vehiclesdk$UCarCommon$CallState[UCarCommon.CallState.IDLE.ordinal()] = 2;
            $SwitchMap$com$ucar$vehiclesdk$UCarCommon$CallState[UCarCommon.CallState.INCOMING.ordinal()] = 3;
            $SwitchMap$com$ucar$vehiclesdk$UCarCommon$CallState[UCarCommon.CallState.DIALING.ordinal()] = 4;
            $SwitchMap$com$ucar$vehiclesdk$UCarCommon$CallState[UCarCommon.CallState.ALERTING.ordinal()] = 5;
            $SwitchMap$com$ucar$vehiclesdk$UCarCommon$CallState[UCarCommon.CallState.ACTIVE.ordinal()] = 6;
            try {
                $SwitchMap$com$ucar$vehiclesdk$UCarCommon$CallState[UCarCommon.CallState.HOLDING.ordinal()] = 7;
            } catch (NoSuchFieldError unused) {
            }
        }
    }

    public void update(UCarCommon.CallInfo callInfo) {
        this.mInCallAppId = callInfo.getInCallAppId();
        switch (AnonymousClass2.$SwitchMap$com$ucar$vehiclesdk$UCarCommon$CallState[callInfo.getCallState().ordinal()]) {
            case 1:
                return;
            case 2:
                hide();
                return;
            case 3:
                updateNameAndPhone(callInfo);
                this.mHandler.removeCallbacks(this.mUpdateTime);
                this.mCallState.setText(R.string.call_incoming);
                this.mAcceptCall.setVisibility(0);
                break;
            case 4:
                updateNameAndPhone(callInfo);
                this.mCallState.setText(R.string.call_outgoing);
                this.mAcceptCall.setVisibility(8);
                break;
            case 5:
                updateNameAndPhone(callInfo);
                this.mCallState.setText(R.string.call_alerting);
                this.mAcceptCall.setVisibility(8);
                break;
            case 6:
                updateNameAndPhone(callInfo);
                this.mStartTime = SystemClock.uptimeMillis();
                int connectedTime = callInfo.getConnectedTime();
                this.mBaseConnectedTime = connectedTime;
                updateDuration((long) connectedTime);
                this.mAcceptCall.setVisibility(8);
                this.mHandler.removeCallbacks(this.mUpdateTime);
                this.mHandler.postDelayed(this.mUpdateTime, 1000);
                break;
            case 7:
                updateNameAndPhone(callInfo);
                this.mCallState.setText(R.string.call_holding);
                this.mHandler.removeCallbacks(this.mUpdateTime);
                this.mAcceptCall.setVisibility(8);
                break;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.mWindowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
        int i = displayMetrics.widthPixels / 20;
        int i2 = i / 2;
        int i3 = i2 / 2;
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) this.mAcceptCall.getLayoutParams();
        marginLayoutParams.width = i;
        marginLayoutParams.height = i;
        ViewGroup.MarginLayoutParams marginLayoutParams2 = (ViewGroup.MarginLayoutParams) this.mEndCall.getLayoutParams();
        marginLayoutParams2.width = i;
        marginLayoutParams2.height = i;
        if (this.mAcceptCall.getVisibility() == 0) {
            marginLayoutParams.leftMargin = i2;
            marginLayoutParams.rightMargin = i3;
            marginLayoutParams2.leftMargin = i3;
        } else {
            marginLayoutParams2.leftMargin = i2;
        }
        this.mContainer.setPadding(i3, i3, i3, i3);
        this.mAcceptCall.setPadding(i3, i3, i3, i3);
        this.mEndCall.setPadding(i3, i3, i3, i3);
        this.mView.measure(View.MeasureSpec.makeMeasureSpec(displayMetrics.widthPixels, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(displayMetrics.heightPixels, Integer.MIN_VALUE));
        if (this.mWindowParams == null) {
            WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
            this.mWindowParams = layoutParams;
            layoutParams.type = 2038;
            this.mWindowParams.format = 1;
            this.mWindowParams.flags = 8;
            this.mWindowParams.gravity = 8388659;
            this.mWindowParams.width = -2;
            this.mWindowParams.height = -2;
        }
        this.mWindowParams.x = (displayMetrics.widthPixels / 2) - (this.mView.getMeasuredWidth() / 2);
        this.mWindowParams.y = this.mContext.getResources().getDimensionPixelSize(R.dimen.tab_item_padding);
        if (this.mView.getParent() == null) {
            this.mWindowManager.addView(this.mView, this.mWindowParams);
        } else {
            this.mWindowManager.updateViewLayout(this.mView, this.mWindowParams);
        }
    }

    private void updateNameAndPhone(UCarCommon.CallInfo callInfo) {
        if (TextUtils.isEmpty(callInfo.getNumber())) {
            this.mCallNumber.setText(callInfo.getName());
        } else if (TextUtils.isEmpty(callInfo.getName())) {
            this.mCallNumber.setText(callInfo.getNumber());
        } else if (TextUtils.isEmpty(callInfo.getName()) && TextUtils.isEmpty(callInfo.getNumber())) {
            this.mCallNumber.setText(R.string.unknown);
        } else if (TextUtils.equals(callInfo.getName(), callInfo.getNumber())) {
            this.mCallNumber.setText(callInfo.getNumber());
        } else {
            this.mCallNumber.setText(String.format(this.mContext.getString(R.string.call_name_and_phone_number), callInfo.getName(), callInfo.getNumber()));
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void updateDuration(long j) {
        if (j >= 3600) {
            this.mCallState.setText(String.format(this.mContext.getString(R.string.call_active_format_hour_minute_second), Long.valueOf(j / 3600), Long.valueOf((j % 3600) / 60), Long.valueOf(j % 60)));
            return;
        }
        this.mCallState.setText(String.format(this.mContext.getString(R.string.call_active_format_minute_second), Long.valueOf((j % 3600) / 60), Long.valueOf(j % 60)));
    }

    public void hide() {
        this.mHandler.removeCallbacks(this.mUpdateTime);
        if (this.mView.getParent() != null) {
            this.mWindowManager.removeView(this.mView);
        }
    }
}
