package com.ucarhu.demo.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Editable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import androidx.appcompat.widget.AppCompatTextView;
import com.ucarhu.demo.R;

public class UCarAutoScaleTextView extends AppCompatTextView {
    private static final String CALCULATION_STRING = "正";
    private static final int MODE_BY_SIZE = 1;
    private static final int MODE_BY_WIDTH = 0;
    private CharSequence mLastText;
    private int mLengthByChar;
    private final int mMode;
    private final TextWatcher mTextWatcher;
    private int mWidthCalcBySize;
    private float mWidthPercent;

    public UCarAutoScaleTextView(Context context) {
        this(context, null);
    }

    public UCarAutoScaleTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public UCarAutoScaleTextView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        int i2;
        int i3;
        float f;
        int i4;
        this.mTextWatcher = new TextWatcher() {
            /* class com.ucarhu.demo.widget.UCarAutoScaleTextView.AnonymousClass1 */

            public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }

            public void afterTextChanged(Editable editable) {
                UCarAutoScaleTextView.this.calcTextSize();
            }
        };
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R.styleable.UCarAutoScaleTextView, i, 0);
        if (obtainStyledAttributes != null) {
            try {
                i4 = obtainStyledAttributes.getInt(0, 0);
                f = obtainStyledAttributes.getFloat(3, 1.0f);
                i3 = obtainStyledAttributes.getInt(2, 0);
                i2 = obtainStyledAttributes.getInt(1, 0);
            } finally {
                obtainStyledAttributes.recycle();
            }
        } else {
            f = 1.0f;
            i4 = 0;
            i3 = 0;
            i2 = 0;
        }
        this.mMode = i4;
        this.mLengthByChar = i3;
        this.mWidthPercent = Math.min(f, 1.0f);
        this.mWidthCalcBySize = getResources().getDisplayMetrics().widthPixels;
        if (i4 == 1 && i2 > 0) {
            setTextSize(0, getTextSize() * ((((float) this.mWidthCalcBySize) * 1.0f) / ((float) i2)));
        }
    }

    /* access modifiers changed from: protected */
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mMode == 0) {
            calcTextSize();
            addTextChangedListener(this.mTextWatcher);
        }
    }

    /* access modifiers changed from: protected */
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mMode == 0) {
            removeTextChangedListener(this.mTextWatcher);
        }
    }

    /* access modifiers changed from: protected */
    @Override // androidx.appcompat.widget.AppCompatTextView
    public void onMeasure(int i, int i2) {
        if (this.mMode == 0 && View.MeasureSpec.getMode(i) != 1073741824) {
            i = View.MeasureSpec.makeMeasureSpec((int) ((((float) this.mWidthCalcBySize) * this.mWidthPercent) + ((float) getPaddingLeft()) + ((float) getPaddingRight())), 1073741824);
        }
        super.onMeasure(i, i2);
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void calcTextSize() {
        float f;
        float f2;
        CharSequence text = getText();
        if (!(text == null || TextUtils.isEmpty(text) || TextUtils.equals(this.mLastText, text))) {
            this.mLastText = text;
            int i = (int) (((float) this.mWidthCalcBySize) * this.mWidthPercent);
            int i2 = this.mLengthByChar;
            TextPaint paint = getPaint();
            String[] split = text.toString().split("\n");
            int i3 = 0;
            for (String str : split) {
                i3 = Math.max(i3, str.length());
            }
            if (i2 > i3) {
                f = measureText(paint, i2);
            } else {
                f = measureText(paint, split);
            }
            float f3 = (float) i;
            paint.setTextSize((f3 / f) * paint.getTextSize());
            if (i2 > i3) {
                f2 = measureText(paint, i2);
            } else {
                f2 = measureText(paint, split);
            }
            while (f2 > f3) {
                paint.setTextSize(paint.getTextSize() - 1.0f);
                if (i2 > i3) {
                    f2 = measureText(paint, i2);
                } else {
                    f2 = measureText(paint, split);
                }
            }
        }
    }

    private float measureText(TextPaint textPaint, String[] strArr) {
        float f = 0.0f;
        for (String str : strArr) {
            float measureText = textPaint.measureText(str);
            if (measureText > f) {
                f = measureText;
            }
        }
        return f;
    }

    private float measureText(TextPaint textPaint, int i) {
        return textPaint.measureText(CALCULATION_STRING) * ((float) i);
    }
}
