package com.ucarhu.demo.widget;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.FrameLayout;

public class UCarAlertView {
    private Activity mActivity;
    private boolean mIsShown = false;
    private View mView;

    public UCarAlertView(Context context) {
        if (context instanceof Activity) {
            this.mActivity = (Activity) context;
            return;
        }
        throw new IllegalArgumentException("context must be activity");
    }

    public void setContentView(View view) {
        if (isShowing()) {
            dismiss();
            this.mView = view;
            show();
            return;
        }
        this.mView = view;
    }

    public void show() {
        if (isShowing()) {
            dismiss();
        }
        FrameLayout frameLayout = (FrameLayout) this.mActivity.findViewById(16908290);
        if (frameLayout != null && this.mView != null) {
            frameLayout.addView(this.mView, new FrameLayout.LayoutParams(-1, -1));
            this.mIsShown = true;
        }
    }

    public boolean isShowing() {
        return this.mIsShown;
    }

    public void dismiss() {
        if (this.mIsShown && this.mView != null) {
            FrameLayout frameLayout = (FrameLayout) this.mActivity.findViewById(16908290);
            if (frameLayout != null) {
                frameLayout.removeView(this.mView);
            }
            this.mIsShown = false;
        }
    }
}
