package com.ucarhu.demo.widget;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.os.SystemClock;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.core.view.InputDeviceCompat;
import androidx.core.view.ViewCompat;
import com.ucarhu.demo.R;

public class DragFrameLayout extends FrameLayout {
    private static final int DRAG_THRESHOLD_TIME = 300;
    private static final String POSITIONS_SP_KEY_LEFT = "_left";
    private static final String POSITIONS_SP_KEY_TOP = "_top";
    private static final String POSITIONS_SP_NAME = "Dfl_Positions";
    private static final int VIBRATE_AMPLITUDE = 200;
    private static final int VIBRATE_MILLS = 100;
    private boolean mDetect;
    private long mDownTime;
    private float mLastX;
    private float mLastY;
    private int mTouchPointerId;
    private View mTouchedView;

    public DragFrameLayout(Context context) {
        this(context, null);
    }

    public DragFrameLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public DragFrameLayout(Context context, AttributeSet attributeSet, int i) {
        this(context, attributeSet, i, 0);
    }

    public DragFrameLayout(Context context, AttributeSet attributeSet, int i, int i2) {
        super(context, attributeSet, i, i2);
        this.mDetect = false;
    }

    /* access modifiers changed from: protected */
    /* JADX WARNING: Removed duplicated region for block: B:17:0x0068  */
    /* JADX WARNING: Removed duplicated region for block: B:21:0x0075  */
    /* JADX WARNING: Removed duplicated region for block: B:25:0x0085  */
    /* JADX WARNING: Removed duplicated region for block: B:26:0x008b  */
    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        int i5;
        int i6;
        int i7;
        int i8;
        int i9;
        int i10;
        int childCount = getChildCount();
        int paddingLeft = getPaddingLeft();
        int paddingRight = (i3 - i) - getPaddingRight();
        int paddingTop = getPaddingTop();
        int paddingBottom = (i4 - i2) - getPaddingBottom();
        for (int i11 = 0; i11 < childCount; i11++) {
            View childAt = getChildAt(i11);
            if (childAt.getVisibility() != 8) {
                LayoutParams layoutParams = (LayoutParams) childAt.getLayoutParams();
                int measuredWidth = childAt.getMeasuredWidth();
                int measuredHeight = childAt.getMeasuredHeight();
                int i12 = layoutParams.gravity;
                if (i12 == -1) {
                    i12 = 8388659;
                }
                int absoluteGravity = Gravity.getAbsoluteGravity(i12, getLayoutDirection());
                int i13 = i12 & 112;
                int i14 = absoluteGravity & 7;
                if (i14 == 1) {
                    i10 = (((paddingRight - paddingLeft) - measuredWidth) / 2) + paddingLeft + layoutParams.leftMargin;
                    i9 = layoutParams.rightMargin;
                } else if (i14 != 5) {
                    i5 = layoutParams.leftMargin + paddingLeft;
                    if (i13 != 16) {
                        i8 = (((paddingBottom - paddingTop) - measuredHeight) / 2) + paddingTop + layoutParams.topMargin;
                        i7 = layoutParams.bottomMargin;
                    } else if (i13 != 80) {
                        i6 = layoutParams.topMargin + paddingTop;
                        if (layoutParams.ignored) {
                            childAt.layout(i5, i6, measuredWidth + i5, measuredHeight + i6);
                        } else {
                            childAt.layout(layoutParams.nowLeft + i5, layoutParams.nowTop + i6, layoutParams.nowLeft + i5 + measuredWidth, layoutParams.nowTop + i6 + measuredHeight);
                        }
                    } else {
                        i8 = paddingBottom - measuredHeight;
                        i7 = layoutParams.bottomMargin;
                    }
                    i6 = i8 - i7;
                    if (layoutParams.ignored) {
                    }
                } else {
                    i10 = paddingRight - measuredWidth;
                    i9 = layoutParams.rightMargin;
                }
                i5 = i10 - i9;
                if (i13 != 16) {
                }
                i6 = i8 - i7;
                if (layoutParams.ignored) {
                }
            }
        }
    }

    @Override // android.view.ViewGroup
    public void addView(View view, int i, ViewGroup.LayoutParams layoutParams) {
        ViewGroup.LayoutParams layoutParams2;
        if (layoutParams == null) {
            layoutParams2 = generateDefaultLayoutParams();
        } else {
            layoutParams2 = generateLayoutParams(layoutParams);
        }
        super.addView(view, i, layoutParams2);
    }

    /* access modifiers changed from: protected */
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        SharedPreferences.Editor edit = getContext().getSharedPreferences(POSITIONS_SP_NAME, 0).edit();
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            if (childAt.getVisibility() != 8) {
                LayoutParams layoutParams = (LayoutParams) childAt.getLayoutParams();
                if (!layoutParams.ignored) {
                    edit.putInt(childAt.getId() + POSITIONS_SP_KEY_TOP, layoutParams.nowTop);
                    edit.putInt(childAt.getId() + POSITIONS_SP_KEY_LEFT, layoutParams.nowLeft);
                }
            }
        }
        edit.apply();
    }

    /* access modifiers changed from: protected */
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        SharedPreferences sharedPreferences = getContext().getSharedPreferences(POSITIONS_SP_NAME, 0);
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            if (childAt.getVisibility() != 8) {
                LayoutParams layoutParams = (LayoutParams) childAt.getLayoutParams();
                if (!layoutParams.ignored) {
                    layoutParams.nowTop = sharedPreferences.getInt(childAt.getId() + POSITIONS_SP_KEY_TOP, layoutParams.nowTop);
                    layoutParams.nowLeft = sharedPreferences.getInt(childAt.getId() + POSITIONS_SP_KEY_LEFT, layoutParams.nowLeft);
                }
            }
        }
    }

    /* access modifiers changed from: protected */
    @Override // android.widget.FrameLayout, android.widget.FrameLayout
    public FrameLayout.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2);
    }

    /* access modifiers changed from: protected */
    public boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    /* access modifiers changed from: protected */
    @Override // android.widget.FrameLayout, android.view.ViewGroup
    public ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof LayoutParams) {
            return layoutParams;
        }
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams) layoutParams);
        }
        return new LayoutParams(layoutParams);
    }

    @Override // android.widget.FrameLayout, android.widget.FrameLayout, android.view.ViewGroup
    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(getContext(), attributeSet);
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked != 0) {
            if (actionMasked == 1) {
                this.mTouchedView = null;
                this.mDetect = false;
            } else if (actionMasked == 2 && this.mTouchedView != null) {
                int findPointerIndex = motionEvent.findPointerIndex(this.mTouchPointerId);
                float x = motionEvent.getX(findPointerIndex);
                float y = motionEvent.getY(findPointerIndex);
                if (this.mDetect) {
                    this.mLastX = x;
                    this.mLastY = y;
                    ViewCompat.offsetLeftAndRight(this.mTouchedView, (int) (x - this.mLastX));
                    ViewCompat.offsetTopAndBottom(this.mTouchedView, (int) (y - this.mLastY));
                    LayoutParams layoutParams = (LayoutParams) this.mTouchedView.getLayoutParams();
                    layoutParams.nowLeft = this.mTouchedView.getLeft();
                    layoutParams.nowTop = this.mTouchedView.getTop();
                    return true;
                } else if (((float) this.mTouchedView.getLeft()) > x || ((float) this.mTouchedView.getRight()) < x || ((float) this.mTouchedView.getTop()) > y || ((float) this.mTouchedView.getBottom()) < y) {
                    this.mTouchedView = null;
                } else if (SystemClock.uptimeMillis() - this.mDownTime > 300) {
                    ((Vibrator) getContext().getSystemService("vibrator")).vibrate(VibrationEffect.createOneShot(100, 200));
                    this.mDetect = true;
                    this.mLastX = x;
                    this.mLastY = y;
                    sendCancelEvent(motionEvent);
                    return true;
                }
            }
            return super.dispatchTouchEvent(motionEvent);
        }
        int pointerId = motionEvent.getPointerId(0);
        this.mTouchPointerId = pointerId;
        int findPointerIndex2 = motionEvent.findPointerIndex(pointerId);
        float x2 = motionEvent.getX(findPointerIndex2);
        float y2 = motionEvent.getY(findPointerIndex2);
        for (int i = 0; i < getChildCount(); i++) {
            View childAt = getChildAt(i);
            if (((float) childAt.getLeft()) <= x2 && ((float) childAt.getRight()) >= x2 && ((float) childAt.getTop()) <= y2 && ((float) childAt.getBottom()) >= y2) {
                LayoutParams layoutParams2 = (LayoutParams) childAt.getLayoutParams();
                if (!layoutParams2.ignored) {
                    if (layoutParams2.dragTargetId != -1 && (childAt instanceof ViewGroup)) {
                        View findViewById = childAt.findViewById(layoutParams2.dragTargetId);
                        if (((float) findViewById.getLeft()) <= x2 - ((float) childAt.getLeft()) && ((float) findViewById.getRight()) >= x2 - ((float) childAt.getLeft()) && ((float) findViewById.getTop()) <= y2 - ((float) childAt.getTop()) && ((float) findViewById.getBottom()) >= y2 - ((float) childAt.getTop())) {
                        }
                    }
                    this.mTouchedView = childAt;
                    this.mDownTime = SystemClock.uptimeMillis();
                    super.dispatchTouchEvent(motionEvent);
                    return true;
                }
                continue;
            }
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    /* access modifiers changed from: protected */
    public void sendCancelEvent(MotionEvent motionEvent) {
        long uptimeMillis = SystemClock.uptimeMillis();
        MotionEvent obtain = MotionEvent.obtain(uptimeMillis, uptimeMillis, 3, motionEvent.getX(), motionEvent.getY(), 0);
        obtain.setSource(InputDeviceCompat.SOURCE_TOUCHSCREEN);
        super.dispatchTouchEvent(obtain);
        obtain.recycle();
    }

    public static class LayoutParams extends FrameLayout.LayoutParams {
        public int dragTargetId = -1;
        public boolean ignored;
        public int nowLeft;
        public int nowTop;

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            DisplayMetrics displayMetrics = new DisplayMetrics();
            ((WindowManager) context.getSystemService("window")).getDefaultDisplay().getRealMetrics(displayMetrics);
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R.styleable.DragFrameLayout_Layout);
            this.nowTop = (int) (obtainStyledAttributes.getFloat(3, 0.0f) * ((float) displayMetrics.heightPixels));
            this.nowLeft = (int) (obtainStyledAttributes.getFloat(2, 0.0f) * ((float) displayMetrics.widthPixels));
            this.ignored = obtainStyledAttributes.getBoolean(1, true);
            this.dragTargetId = obtainStyledAttributes.getResourceId(0, -1);
            obtainStyledAttributes.recycle();
        }

        public LayoutParams(int i, int i2) {
            super(i, i2);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }
    }
}
