package com.ucarhu.demo.util;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.ucar.vehiclesdk.UCarCommon;

public class CoordinateUtil {
    private static final String PACKAGE_NAME_BAIDU = "com.baidu.BaiduMap";
    private static final String PACKAGE_NAME_GAODE = "com.autonavi.minimap";
    private static final String TAG = "CoordinateUtil";
    private static final double x_PI = 52.35987755982988d;

    private static double[] transformBD09ToGCJ02(double d, double d2) {
        double d3 = d - 0.0065d;
        double d4 = d2 - 0.006d;
        double sqrt = Math.sqrt((d3 * d3) + (d4 * d4)) - (Math.sin(d4 * x_PI) * 2.0E-5d);
        double atan2 = Math.atan2(d4, d3) - (Math.cos(d3 * x_PI) * 3.0E-6d);
        return new double[]{Math.cos(atan2) * sqrt, sqrt * Math.sin(atan2)};
    }

    public static boolean tryLaunchGaodeMap(Context context, UCarCommon.POIAddress pOIAddress) {
        if (!PackageUtil.isInstalled(context, PACKAGE_NAME_GAODE)) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        UCarCommon.POIDetailInfo detailInfo = pOIAddress.getDetailInfo();
        if (detailInfo != null) {
            if (detailInfo.getType() == UCarCommon.CoordinateType.BD09) {
                double[] transformBD09ToGCJ02 = transformBD09ToGCJ02(detailInfo.getLongitude(), detailInfo.getLatitude());
                detailInfo = new UCarCommon.POIDetailInfo(UCarCommon.CoordinateType.GCJ02, transformBD09ToGCJ02[1], transformBD09ToGCJ02[0]);
            }
            sb.append("androidamap://navi?sourceApplication=amap").append("&dev=").append(detailInfo.getType() == UCarCommon.CoordinateType.WGS84 ? 1 : 0).append("&lat=").append(detailInfo.getLatitude()).append("&lon=").append(detailInfo.getLongitude());
            if (!TextUtils.isEmpty(pOIAddress.getName())) {
                sb.append("&keywords=").append(pOIAddress.getName());
            }
        } else {
            sb.append("androidamap://poi?sourceApplication=amap").append("&keywords=").append(pOIAddress.getName());
        }
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse(sb.toString()));
        intent.setPackage(PACKAGE_NAME_GAODE);
        intent.setFlags(268435456);
        try {
            context.startActivity(intent);
            return true;
        } catch (Exception e) {
            Log.e(TAG, "start gaode map failed", e);
            return false;
        }
    }

    public static boolean tryLaunchBaiduMap(Context context, UCarCommon.POIAddress pOIAddress) {
        if (!PackageUtil.isInstalled(context, PACKAGE_NAME_BAIDU)) {
            return false;
        }
        UCarCommon.POIDetailInfo detailInfo = pOIAddress.getDetailInfo();
        StringBuilder sb = new StringBuilder();
        if (detailInfo == null) {
            sb.append("baidumap://map/place/search?query=").append(pOIAddress.getName());
        } else {
            sb.append("baidumap://map/direction?destination=");
            if (!TextUtils.isEmpty(pOIAddress.getName())) {
                sb.append("name:").append(pOIAddress.getName()).append("|").append("latlng:");
            }
            sb.append(detailInfo.getLatitude()).append(",").append(detailInfo.getLongitude());
            if (detailInfo.getType() == UCarCommon.CoordinateType.WGS84) {
                sb.append("&coord_type=wgs84");
            } else if (detailInfo.getType() == UCarCommon.CoordinateType.GCJ02) {
                sb.append("&coord_type=gcj02");
            } else {
                sb.append("&coord_type=bd09ll");
            }
        }
        sb.append("&src=andr.baidu.openAPIdemo");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse(sb.toString()));
        intent.setPackage(PACKAGE_NAME_BAIDU);
        intent.setFlags(268435456);
        try {
            context.startActivity(intent);
            return true;
        } catch (Exception e) {
            Log.e(TAG, "start baidu map failed", e);
            return false;
        }
    }
}
