package com.ucarhu.demo.drawable;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import androidx.core.graphics.drawable.RoundedBitmapDrawable;
import androidx.core.graphics.drawable.RoundedBitmapDrawableFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class RoundedDrawable extends Drawable {
    private static final int BORDER_COLOR = 855638016;
    private final Paint mBGPaint;
    private final float mCornerRadius;
    private RectF mDstRectF;
    private final Paint mPaint;
    private final RoundedBitmapDrawable mRoundedBitmapDrawable;

    public RoundedDrawable(Resources resources, Bitmap bitmap, float f) {
        this.mCornerRadius = f;
        RoundedBitmapDrawable create = RoundedBitmapDrawableFactory.create(resources, bitmap);
        this.mRoundedBitmapDrawable = create;
        create.setCornerRadius(f);
        Paint paint = new Paint(1);
        this.mBGPaint = paint;
        paint.setColor(-1);
        paint.setStyle(Paint.Style.FILL);
        Paint paint2 = new Paint(1);
        this.mPaint = paint2;
        paint2.setStyle(Paint.Style.STROKE);
        paint2.setStrokeWidth(1.0f);
        paint2.setColor(BORDER_COLOR);
        try {
            Field declaredField = RoundedBitmapDrawable.class.getDeclaredField("mDstRectF");
            declaredField.setAccessible(true);
            this.mDstRectF = (RectF) declaredField.get(create);
        } catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public void invalidateSelf() {
        super.invalidateSelf();
        this.mRoundedBitmapDrawable.invalidateSelf();
    }

    public void setFilterBitmap(boolean z) {
        this.mRoundedBitmapDrawable.setFilterBitmap(z);
    }

    public void setDither(boolean z) {
        this.mRoundedBitmapDrawable.setDither(z);
    }

    public void setBounds(int i, int i2, int i3, int i4) {
        this.mRoundedBitmapDrawable.setBounds(i, i2, i3, i4);
        super.setBounds(i, i2, i3, i4);
    }

    public void draw(Canvas canvas) {
        RectF rectF = this.mDstRectF;
        if (rectF != null) {
            float f = this.mCornerRadius;
            canvas.drawRoundRect(rectF, f, f, this.mBGPaint);
        }
        this.mRoundedBitmapDrawable.draw(canvas);
        RectF rectF2 = this.mDstRectF;
        if (rectF2 != null) {
            float f2 = this.mCornerRadius;
            canvas.drawRoundRect(rectF2, f2, f2, this.mPaint);
        }
    }

    public void setAlpha(int i) {
        this.mRoundedBitmapDrawable.setAlpha(i);
    }

    public int getAlpha() {
        return this.mRoundedBitmapDrawable.getAlpha();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mRoundedBitmapDrawable.setColorFilter(colorFilter);
    }

    public ColorFilter getColorFilter() {
        return this.mRoundedBitmapDrawable.getColorFilter();
    }

    public int getOpacity() {
        return this.mRoundedBitmapDrawable.getOpacity();
    }

    public int getIntrinsicWidth() {
        return this.mRoundedBitmapDrawable.getIntrinsicWidth();
    }

    public int getMinimumWidth() {
        return this.mRoundedBitmapDrawable.getMinimumWidth();
    }

    public int getIntrinsicHeight() {
        return this.mRoundedBitmapDrawable.getIntrinsicHeight();
    }

    public int getMinimumHeight() {
        return this.mRoundedBitmapDrawable.getMinimumHeight();
    }

    /* access modifiers changed from: protected */
    public void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        try {
            Method declaredMethod = RoundedBitmapDrawable.class.getDeclaredMethod("onBoundsChange", Rect.class);
            declaredMethod.setAccessible(true);
            declaredMethod.invoke(this.mRoundedBitmapDrawable, rect);
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e2) {
            e2.printStackTrace();
        } catch (IllegalAccessException e3) {
            e3.printStackTrace();
        }
    }
}
