package com.ucarhu.demo.app;

import a.c.d.a;
import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.FrameLayout;
import androidx.fragment.app.Fragment;
import com.ucar.vehiclesdk.UCarAdapter;
import com.ucarhu.demo.R;

public class UCarSurfaceFragment extends Fragment {
    private static final int ANIMATION_DURATION = 150;
    private static final String TAG = "UCarSurfaceFragment";
    private int mAppId;
    private boolean mDestroyByRemote = false;
    private String mDeviceId;
    private int mExpectedDisplayHeight;
    private int mExpectedDisplayWidth;
    private boolean mIsWorkInNormalCast;
    private View mSplashView;
    private final SurfaceHolder.Callback mSurfaceHolderCallback = new SurfaceHolder.Callback() {
        /* class com.ucarhu.demo.app.UCarSurfaceFragment.AnonymousClass1 */

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            Log.d(UCarSurfaceFragment.TAG, "surfaceCreated");
            surfaceHolder.setSizeFromLayout();
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i2, int i3) {
            Log.i(UCarSurfaceFragment.TAG, "surfaceChanged, width:" + i2 + ",height:" + i3);
            if (!UCarSurfaceFragment.this.startCast(surfaceHolder)) {
                Log.i(UCarSurfaceFragment.TAG, "SurfaceHolder or Surface is null or invalid");
                UCarAdapter.getInstance().pauseCast();
            }
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            Log.d(UCarSurfaceFragment.TAG, "surfaceDestroyed");
            UCarAdapter.getInstance().pauseCast();
        }
    };
    private SurfaceView mSurfaceView;

    public void setParams(String str, int i, int i2, int i3, boolean z) {
        this.mDeviceId = str;
        this.mAppId = i;
        this.mIsWorkInNormalCast = z;
        if (getView() == null) {
            this.mExpectedDisplayWidth = i2;
            this.mExpectedDisplayHeight = i3;
            return;
        }
        resetSurfaceContainerSize(getView().findViewById(R.id.surface_view));
        UCarAdapter.getInstance().allowGainAudioFocus();
    }

    @Override // androidx.fragment.app.Fragment
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View inflate = layoutInflater.inflate(R.layout.fragment_ucar_surface, viewGroup, false);
        this.mSplashView = inflate.findViewById(R.id.fl_splash_container);
        SurfaceView surfaceView = (SurfaceView) inflate.findViewById(R.id.surface_view);
        this.mSurfaceView = surfaceView;
        surfaceView.getHolder().addCallback(this.mSurfaceHolderCallback);
        resetSurfaceContainerSize(inflate.findViewById(R.id.surface_view));
        UCarAdapter.getInstance().allowGainAudioFocus();
        return inflate;
    }

    @Override // androidx.fragment.app.Fragment
    public void onResume() {
        super.onResume();
        startCast(this.mSurfaceView.getHolder());
        UCarAdapter.getInstance().resumeApp(this.mDeviceId, this.mAppId);
        UCarAdapter.getInstance().allowGainAudioFocus();
    }

    @Override // androidx.fragment.app.Fragment
    public void onPause() {
        super.onPause();
        if (!this.mDestroyByRemote) {
            UCarAdapter.getInstance().pauseApp(this.mDeviceId, this.mAppId);
        }
    }

    private void resetSurfaceContainerSize(View view) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) view.getLayoutParams();
        layoutParams.width = this.mExpectedDisplayWidth;
        layoutParams.height = this.mExpectedDisplayHeight;
        layoutParams.gravity = 17;
        view.setLayoutParams(layoutParams);
        if (this.mIsWorkInNormalCast) {
            this.mSplashView.setVisibility(8);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private boolean startCast(SurfaceHolder surfaceHolder) {
        if (surfaceHolder == null || surfaceHolder.getSurface() == null || !surfaceHolder.getSurface().isValid()) {
            return false;
        }
        UCarAdapter.getInstance().startCast(surfaceHolder.getSurface(), this.mExpectedDisplayWidth, this.mExpectedDisplayHeight, new a() {
            /* class com.ucarhu.demo.app.$$Lambda$UCarSurfaceFragment$sGhKNBYHnp2jzRjDqKHnJ2NSptU */

            @Override // a.c.d.a
            public final void a() {
                UCarSurfaceFragment.this.lambda$startCast$5$UCarSurfaceFragment();
            }
        });
        return true;
    }

    public /* synthetic */ void lambda$startCast$5$UCarSurfaceFragment() {
        if (!this.mIsWorkInNormalCast) {
            this.mSurfaceView.post(new Runnable() {
                /* class com.ucarhu.demo.app.$$Lambda$UCarSurfaceFragment$mSt25bFvq2xjAC1qldZJXi7UwcE */

                public final void run() {
                    UCarSurfaceFragment.this.lambda$null$4$UCarSurfaceFragment();
                }
            });
        }
    }

    public /* synthetic */ void lambda$null$4$UCarSurfaceFragment() {
        this.mSplashView.animate().alpha(0.0f).setDuration(150).setInterpolator(new AccelerateDecelerateInterpolator()).setListener(new AnimatorListenerAdapter() {
            /* class com.ucarhu.demo.app.UCarSurfaceFragment.AnonymousClass2 */

            public void onAnimationEnd(Animator animator) {
                UCarSurfaceFragment.this.mSplashView.setVisibility(8);
                UCarSurfaceFragment.this.mSplashView.setAlpha(1.0f);
            }

            public void onAnimationCancel(Animator animator) {
                UCarSurfaceFragment.this.mSplashView.setVisibility(8);
                UCarSurfaceFragment.this.mSplashView.setAlpha(1.0f);
            }
        }).start();
    }

    public void closeByRemote() {
        this.mDestroyByRemote = true;
    }

    @Override // androidx.fragment.app.Fragment
    public void onDestroy() {
        super.onDestroy();
        this.mSurfaceView.getHolder().removeCallback(this.mSurfaceHolderCallback);
    }
}
