package com.ucarhu.demo.app;

import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import com.ucar.sdk.BuildConfig;
import com.ucarhu.demo.R;
import com.ucarhu.demo.widget.UCarPinCodeView;

public class UCarGuideFragment extends Fragment {
    private static final String TAG = "UCarGuideFragment";
    private TextView mDeviceName;
    private Handler mHandler;
    private View.OnClickListener mListener;
    private UCarPinCodeView mPinCodeView;

    public void setParams(Handler handler, View.OnClickListener onClickListener) {
        this.mHandler = handler;
        this.mListener = onClickListener;
    }

    @Override // androidx.fragment.app.Fragment
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View inflate = layoutInflater.inflate(R.layout.fragment_ucar_guide, viewGroup, false);
        inflate.findViewById(R.id.tv_exit).setOnClickListener(new View.OnClickListener() {
            /* class com.ucarhu.demo.app.$$Lambda$UCarGuideFragment$lXVeqPIMX916nqmWFsqPLHe0E */

            public final void onClick(View view) {
                UCarGuideFragment.this.lambda$onCreateView$2$UCarGuideFragment(view);
            }
        });
        this.mDeviceName = (TextView) inflate.findViewById(R.id.tv_device_name);
        this.mPinCodeView = (UCarPinCodeView) inflate.findViewById(R.id.upc_pin_code);
        ((TextView) inflate.findViewById(R.id.tv_sdk_version)).setText(BuildConfig.SDK_VERSION);
        inflate.findViewById(R.id.tv_ucar_title).setOnClickListener(new View.OnClickListener() {
            /* class com.ucarhu.demo.app.$$Lambda$UCarGuideFragment$MC74EAPKJc_0vEWOrVCil2wMmk */

            public final void onClick(View view) {
                UCarGuideFragment.this.lambda$onCreateView$3$UCarGuideFragment(view);
            }
        });
        return inflate;
    }

    public /* synthetic */ void lambda$onCreateView$2$UCarGuideFragment(View view) {
        this.mHandler.sendEmptyMessage(107);
    }

    public /* synthetic */ void lambda$onCreateView$3$UCarGuideFragment(View view) {
        View.OnClickListener onClickListener = this.mListener;
        if (onClickListener != null) {
            onClickListener.onClick(view);
        }
    }

    public void updateUI(String str, String str2) {
        this.mPinCodeView.setPinCode(str);
        this.mDeviceName.setText(str2);
    }
}
