package com.ucarhu.demo.app;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.Lifecycle;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.adapter.FragmentStateAdapter;
import androidx.viewpager2.widget.ViewPager2;
import com.ucarhu.demo.R;
import com.ucarhu.demo.UCarPackageInfo;
import com.ucarhu.demo.app.UCarAppListFragment;
import com.ucarhu.demo.drawable.RoundedDrawable;
import java.util.ArrayList;
import java.util.List;

public class UCarAppListFragment extends Fragment {
    private static final String TAG = "UCarAppListFragment";
    private int mCellHeight;
    private Handler mHandler;
    private PagerAdapter mPagerAdapter;
    private List<List<UCarPackageInfo>> mPages = new ArrayList();
    private String mProductName;
    private int mSizeOfColumn;
    private int mSizeOfRow;
    private TextView mTab;
    private ViewPager2 mViewPager;

    public interface IPackageOnClickListener {
        void onClick(UCarPackageInfo uCarPackageInfo);
    }

    public void setParams(Context context, Handler handler, int i, int i2, String str, List<UCarPackageInfo> list) {
        this.mHandler = handler;
        int dimensionPixelSize = i - context.getResources().getDimensionPixelSize(R.dimen.tab_height);
        if (i > i2) {
            this.mCellHeight = dimensionPixelSize / 6;
            this.mSizeOfRow = 6;
            this.mSizeOfColumn = 4;
        } else {
            this.mCellHeight = dimensionPixelSize / 4;
            this.mSizeOfRow = 4;
            this.mSizeOfColumn = 6;
        }
        ArrayList arrayList = new ArrayList();
        int i3 = this.mSizeOfRow * this.mSizeOfColumn;
        int i4 = 0;
        for (int i5 = 0; i5 < list.size(); i5++) {
            if (i4 / i3 > arrayList.size() - 1) {
                ArrayList arrayList2 = new ArrayList();
                arrayList2.add(list.get(i5));
                arrayList.add(arrayList2);
            } else {
                ((List) arrayList.get(arrayList.size() - 1)).add(list.get(i5));
            }
            i4++;
        }
        this.mProductName = str;
        this.mPages.clear();
        this.mPages.addAll(arrayList);
        TextView textView = this.mTab;
        if (!(textView == null || this.mViewPager == null)) {
            textView.setText(str);
            if (!arrayList.isEmpty()) {
                this.mViewPager.setOffscreenPageLimit(arrayList.size());
            }
            this.mPagerAdapter.updateData(arrayList);
        }
    }

    @Override // androidx.fragment.app.Fragment
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View inflate = layoutInflater.inflate(R.layout.fragment_ucar_app_list, viewGroup, false);
        this.mTab = (TextView) inflate.findViewById(R.id.tv_remote_apps);
        this.mViewPager = (ViewPager2) inflate.findViewById(R.id.vp_app_list);
        this.mTab.setText(this.mProductName);
        if (!this.mPages.isEmpty()) {
            this.mViewPager.setOffscreenPageLimit(this.mPages.size());
        }
        PagerAdapter pagerAdapter = new PagerAdapter(this.mCellHeight, this.mSizeOfColumn, getChildFragmentManager(), getLifecycle(), new IPackageOnClickListener() {
            /* class com.ucarhu.demo.app.$$Lambda$UCarAppListFragment$zQJv84c8KQBB7f7UXxTSKMkcjwo */

            @Override // com.ucarhu.demo.app.UCarAppListFragment.IPackageOnClickListener
            public final void onClick(UCarPackageInfo uCarPackageInfo) {
                UCarAppListFragment.this.lambda$onCreateView$0$UCarAppListFragment(uCarPackageInfo);
            }
        });
        this.mPagerAdapter = pagerAdapter;
        pagerAdapter.updateData(this.mPages);
        this.mViewPager.setAdapter(this.mPagerAdapter);
        return inflate;
    }

    public /* synthetic */ void lambda$onCreateView$0$UCarAppListFragment(UCarPackageInfo uCarPackageInfo) {
        Message obtainMessage = this.mHandler.obtainMessage();
        obtainMessage.what = 111;
        obtainMessage.arg1 = uCarPackageInfo.getId();
        this.mHandler.sendMessage(obtainMessage);
    }

    /* access modifiers changed from: private */
    public static class PagerAdapter extends FragmentStateAdapter {
        private final int mCellHeight;
        private final List<UCarAppListPageFragment> mFragments = new ArrayList();
        private final IPackageOnClickListener mListener;
        private final int mSizeOfColumn;

        public PagerAdapter(int i, int i2, FragmentManager fragmentManager, Lifecycle lifecycle, IPackageOnClickListener iPackageOnClickListener) {
            super(fragmentManager, lifecycle);
            this.mCellHeight = i;
            this.mSizeOfColumn = i2;
            this.mListener = iPackageOnClickListener;
        }

        public void updateData(List<List<UCarPackageInfo>> list) {
            int i;
            int size = this.mFragments.size();
            int size2 = list.size();
            if (size != size2) {
                if (size > size2) {
                    this.mFragments.subList(size2, size).clear();
                    notifyItemRangeRemoved(size2, size - size2);
                } else {
                    int i2 = 0;
                    while (true) {
                        i = size2 - size;
                        if (i2 >= i) {
                            break;
                        }
                        UCarAppListPageFragment uCarAppListPageFragment = new UCarAppListPageFragment();
                        uCarAppListPageFragment.setParams(this.mCellHeight, this.mSizeOfColumn, this.mListener);
                        this.mFragments.add(uCarAppListPageFragment);
                        i2++;
                    }
                    notifyItemRangeInserted(size, i);
                }
            }
            for (int i3 = 0; i3 < size2; i3++) {
                this.mFragments.get(i3).updateData(list.get(i3));
            }
        }

        @Override // androidx.viewpager2.adapter.FragmentStateAdapter
        public Fragment createFragment(int i) {
            return this.mFragments.get(i);
        }

        @Override // androidx.recyclerview.widget.RecyclerView.Adapter
        public int getItemCount() {
            return this.mFragments.size();
        }
    }

    public static class UCarAppListPageFragment extends Fragment {
        private static final String TAG = "UCarAppListPageFragment";
        private AppListAdapter mAppListAdapter;
        private int mCellHeight;
        private List<UCarPackageInfo> mList = new ArrayList();
        private IPackageOnClickListener mListener;
        private RecyclerView mRecyclerView;
        private int mSizeOfColumn;

        public void setParams(int i, int i2, IPackageOnClickListener iPackageOnClickListener) {
            this.mSizeOfColumn = i2;
            this.mCellHeight = i;
            this.mListener = iPackageOnClickListener;
        }

        @Override // androidx.fragment.app.Fragment
        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            View inflate = layoutInflater.inflate(R.layout.fragment_ucar_app_list_page, viewGroup, false);
            RecyclerView recyclerView = (RecyclerView) inflate.findViewById(R.id.rv_app_list_page);
            this.mRecyclerView = recyclerView;
            recyclerView.setLayoutManager(new GridLayoutManager(inflate.getContext(), this.mSizeOfColumn));
            AppListAdapter appListAdapter = new AppListAdapter(layoutInflater, this.mCellHeight, this.mListener);
            this.mAppListAdapter = appListAdapter;
            this.mRecyclerView.setAdapter(appListAdapter);
            this.mAppListAdapter.updateData(this.mList);
            return inflate;
        }

        public void updateData(List<UCarPackageInfo> list) {
            AppListAdapter appListAdapter = this.mAppListAdapter;
            if (appListAdapter == null) {
                this.mList = list;
                return;
            }
            this.mList = list;
            appListAdapter.updateData(list);
        }

        /* access modifiers changed from: private */
        public static final class AppListAdapter extends RecyclerView.Adapter<ViewHolder> {
            private final int mCellHeight;
            private final LayoutInflater mLayoutInflater;
            private final List<UCarPackageInfo> mList = new ArrayList();
            private final IPackageOnClickListener mListener;

            public AppListAdapter(LayoutInflater layoutInflater, int i, IPackageOnClickListener iPackageOnClickListener) {
                this.mLayoutInflater = layoutInflater;
                this.mCellHeight = i;
                this.mListener = iPackageOnClickListener;
            }

            public void updateData(List<UCarPackageInfo> list) {
                DiffUtil.DiffResult calculateDiff = DiffUtil.calculateDiff(new DiffCallback(this.mList, list), true);
                this.mList.clear();
                this.mList.addAll(list);
                calculateDiff.dispatchUpdatesTo(this);
            }

            @Override // androidx.recyclerview.widget.RecyclerView.Adapter
            public ViewHolder onCreateViewHolder(ViewGroup viewGroup, int i) {
                View inflate = this.mLayoutInflater.inflate(R.layout.layout_item_app_list, viewGroup, false);
                inflate.setLayoutParams(new ViewGroup.LayoutParams(-1, this.mCellHeight));
                return new ViewHolder(inflate, this.mCellHeight);
            }

            public void onBindViewHolder(ViewHolder viewHolder, int i) {
                UCarPackageInfo uCarPackageInfo = this.mList.get(i);
                viewHolder.itemView.setOnClickListener(new View.OnClickListener(uCarPackageInfo) {
                    /* class com.ucarhu.demo.app.$$Lambda$UCarAppListFragment$UCarAppListPageFragment$AppListAdapter$teHFn9CUlHq4LX44NxNz5WhVHTg */
                    public final /* synthetic */ UCarPackageInfo f$1;

                    {
                        this.f$1 = r2;
                    }

                    public final void onClick(View view) {
                        UCarAppListFragment.UCarAppListPageFragment.AppListAdapter.this.lambda$onBindViewHolder$1$UCarAppListFragment$UCarAppListPageFragment$AppListAdapter(this.f$1, view);
                    }
                });
                viewHolder.updateData(uCarPackageInfo);
            }

            public /* synthetic */ void lambda$onBindViewHolder$1$UCarAppListFragment$UCarAppListPageFragment$AppListAdapter(UCarPackageInfo uCarPackageInfo, View view) {
                this.mListener.onClick(uCarPackageInfo);
            }

            @Override // androidx.recyclerview.widget.RecyclerView.Adapter
            public int getItemCount() {
                return this.mList.size();
            }
        }

        /* access modifiers changed from: private */
        public static final class ViewHolder extends RecyclerView.ViewHolder {
            private static final float CORNER_RADIUS_FACTOR = 4.0f;
            private final ImageView mAppLogo;
            private final TextView mAppName;
            private final int mCellHeight;

            public ViewHolder(View view, int i) {
                super(view);
                this.mCellHeight = i;
                this.mAppLogo = (ImageView) view.findViewById(R.id.iv_app_logo);
                this.mAppName = (TextView) view.findViewById(R.id.tv_app_name);
            }

            /* access modifiers changed from: private */
            /* access modifiers changed from: public */
            private void updateData(UCarPackageInfo uCarPackageInfo) {
                this.mAppName.setText(uCarPackageInfo.getName());
                if (uCarPackageInfo.getIcon() != null) {
                    this.mAppLogo.setImageDrawable(new RoundedDrawable(this.mAppLogo.getResources(), uCarPackageInfo.getIcon(), (((float) this.mCellHeight) / CORNER_RADIUS_FACTOR) * ((((float) uCarPackageInfo.getIcon().getHeight()) * 1.0f) / ((float) this.mCellHeight))));
                    return;
                }
                this.mAppLogo.setImageDrawable(null);
            }
        }

        /* access modifiers changed from: private */
        public static final class DiffCallback extends DiffUtil.Callback {
            private final List<UCarPackageInfo> mNewList;
            private final List<UCarPackageInfo> mOldList;

            public DiffCallback(List<UCarPackageInfo> list, List<UCarPackageInfo> list2) {
                ArrayList arrayList = new ArrayList();
                this.mOldList = arrayList;
                ArrayList arrayList2 = new ArrayList();
                this.mNewList = arrayList2;
                arrayList.addAll(list);
                arrayList2.addAll(list2);
            }

            @Override // androidx.recyclerview.widget.DiffUtil.Callback
            public int getOldListSize() {
                return this.mOldList.size();
            }

            @Override // androidx.recyclerview.widget.DiffUtil.Callback
            public int getNewListSize() {
                return this.mNewList.size();
            }

            @Override // androidx.recyclerview.widget.DiffUtil.Callback
            public boolean areItemsTheSame(int i, int i2) {
                return this.mOldList.get(i).isSame(this.mNewList.get(i2));
            }

            @Override // androidx.recyclerview.widget.DiffUtil.Callback
            public boolean areContentsTheSame(int i, int i2) {
                return this.mOldList.get(i).isSameIcon(this.mNewList.get(i2));
            }
        }
    }
}
