package com.ucarhu.demo;

import android.content.Intent;
import android.graphics.Bitmap;
import android.text.TextUtils;

public class UCarPackageInfo {
    private Bitmap icon;
    private int iconSize;
    private int id = -1;
    private Intent intent;
    private String name;
    private String packageName;

    public Bitmap getIcon() {
        return this.icon;
    }

    public void setIcon(Bitmap bitmap) {
        this.icon = bitmap;
    }

    public Intent getIntent() {
        return this.intent;
    }

    public void setIntent(Intent intent2) {
        this.intent = intent2;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String str) {
        this.packageName = str;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String str) {
        this.name = str;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int i) {
        this.id = i;
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(int i) {
        this.iconSize = i;
    }

    public boolean isSame(UCarPackageInfo uCarPackageInfo) {
        if (uCarPackageInfo != null && uCarPackageInfo.id == this.id && TextUtils.equals(uCarPackageInfo.packageName, this.packageName) && TextUtils.equals(uCarPackageInfo.name, this.name)) {
            return true;
        }
        return false;
    }

    public boolean isSameIcon(UCarPackageInfo uCarPackageInfo) {
        if (uCarPackageInfo == null) {
            return false;
        }
        Bitmap bitmap = uCarPackageInfo.icon;
        if (bitmap == null && this.icon == null) {
            return true;
        }
        return (bitmap == null || this.icon == null || uCarPackageInfo.iconSize != this.iconSize) ? false : true;
    }
}
