package com.ucarhu.demo;

import a.b.a.k.e;
import android.bluetooth.BluetoothManager;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.provider.Settings;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.ActionBar;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import com.ucar.vehiclesdk.ICameraInfoListener;
import com.ucar.vehiclesdk.ICarConnectListener;
import com.ucar.vehiclesdk.ICarInitCallback;
import com.ucar.vehiclesdk.IPhoneDataListener;
import com.ucar.vehiclesdk.UCarAdapter;
import com.ucar.vehiclesdk.UCarCommon;
import com.ucar.vehiclesdk.UCarConfig;
import com.ucar.vehiclesdk.camera.AbstractCamera;
import com.ucarhu.demo.CarBt.CarBtConnector;
import com.ucarhu.demo.UCarAlertUtil;
import com.ucarhu.demo.UCarDemoActivity;
import com.ucarhu.demo.app.UCarAppListFragment;
import com.ucarhu.demo.app.UCarGuideFragment;
import com.ucarhu.demo.app.UCarSurfaceFragment;
import com.ucarhu.demo.util.CoordinateUtil;
import com.ucarhu.demo.util.TransTool;
import com.ucarhu.demo.widget.UCarAlertView;
import com.ucarhu.demo.widget.UCarCallWindow;
import com.ucarhu.demo.widget.UCarProgressBar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Predicate;

public class UCarDemoActivity extends PermissionsReqActivity {
    private static final int ALIGNMENT = 16;
    private static final int APP_DETAIL_PAGE_SIZE_LIMIT = 20;
    private static final String CAMERA_ID = "1";
    private static final String CAMERA_NAME = "Car_Camera_1";
    private static final String CAR_ID_KEY = "car_id_key";
    private static final String CAR_ID_PREFS = "car_id_prefs";
    private static final int CAR_ID_SIZE = 6;
    private static final int CLICK_COUNT_OF_SHOW_EMULATOR_DIALOG = 3;
    private static final int CLICK_INTERVAL_OF_SHOW_EMULATOR_DIALOG = 550;
    public static final int[] DEFAULT_ALLOWED_5G_CHANNELS = {36, 40, 44, 48, 149, 153, 157, 161, e.e};
    public static final int DISPLAY_DENSITY_DPI = 320;
    public static final int DISPLAY_FPS = 30;
    public static final int DISPLAY_FPS_MULTIPLE = 15;
    public static final int DISPLAY_MAX_FPS = 60;
    public static final int DISPLAY_MIN_DENSITY_DPI = 120;
    private static final String KEY_EMULATOR_ALLOWED_5G_CHANNELS = "allowed5gChannels";
    private static final String KEY_EMULATOR_CONFIGURE = "configure";
    private static final String KEY_EMULATOR_DPI_BY_USER = "dpiByUser";
    private static final String KEY_EMULATOR_FPS_BY_USER = "fpsByUser";
    private static final String KEY_EMULATOR_HEIGHT_BY_USER = "heightByUser";
    private static final String KEY_EMULATOR_SUPPORT_APP_FUSION = "supportAppFusion";
    private static final String KEY_EMULATOR_SUPPORT_AP_CONNECT = "supportApConnect";
    private static final String KEY_EMULATOR_SUPPORT_HEVC = "supportHevc";
    private static final String KEY_EMULATOR_SUPPORT_POI_NAVI = "supportPOINavi";
    private static final String KEY_EMULATOR_WIDTH_BY_USER = "widthByUser";
    public static final int MSG_ACCEPT_CALL_CLICKED = 109;
    public static final int MSG_CLOSE_PROGRESS = 105;
    public static final int MSG_END_CALL_CLICKED = 110;
    public static final int MSG_EXIT_GUID_FRAGMENT = 107;
    public static final int MSG_IN_CALL_CLICKED = 108;
    public static final int MSG_ON_CONNECT_STATE_CHANGED = 101;
    public static final int MSG_REMOTE_APP_CLICKED = 111;
    public static final int MSG_SHOW_PIN_CODE = 106;
    public static final int MSG_SHOW_PROGRESS = 104;
    public static final int MSG_START_ADVERTISE_SCAN_DEVICE = 102;
    public static final int MSG_STOP_ADVERTISE_SCAN_DEVICE = 103;
    private static final int PROCESS_0 = 0;
    private static final int PROCESS_COMPLETE = 100;
    private static final String SP_NAME_EMULATOR = "test";
    public static final int START_CAST_DELAY = 100;
    private static final String TAG = "UCarDemoActivity";
    private static final String TAG_APP_LIST_FRAGMENT = "AppListFragment";
    private static final String TAG_GUIDE_FRAGMENT = "GuideFragment";
    private static final String TAG_SURFACE_FRAGMENT = "SurfaceFragment";
    private static boolean sIsServiceInitialized = false;
    private int[] mAllowed5GChannels = DEFAULT_ALLOWED_5G_CHANNELS;
    private UCarCallWindow mCallWindow;
    private ICameraInfoListener mCameraInfoCallback;
    private CarBtConnector mCarBtConnector;
    private boolean mConfigure = false;
    private ICarConnectListener mConnectCallback;
    private String mDeviceId;
    private UCarAlertView mDialog;
    private int mDisplayDensityDpi;
    private int mExpectedDisplayHeight;
    private int mExpectedDisplayHeightByUser = 0;
    private int mExpectedDisplayWidth;
    private int mExpectedDisplayWidthByUser = 0;
    private int mExpectedDpiByUser = 0;
    private int mExpectedFpsByUser = 30;
    private int mFullDisplayHeight;
    private int mFullDisplayWidth;
    private final Handler mHandler = new Handler(Looper.getMainLooper()) {
        /* class com.ucarhu.demo.UCarDemoActivity.AnonymousClass11 */

        public void handleMessage(Message message) {
            super.handleMessage(message);
            switch (message.what) {
                case 101:
                    UCarDemoActivity.this.handleConnectStateChangedMessage(message);
                    return;
                case 102:
                    UCarAdapter.getInstance().startAdvertise();
                    UCarAdapter.getInstance().enableUsbDeviceDetection(true);
                    return;
                case 103:
                    UCarAdapter.getInstance().stopAdvertise();
                    UCarAdapter.getInstance().enableUsbDeviceDetection(false);
                    return;
                case 104:
                    Bundle bundle = (Bundle) message.obj;
                    String string = bundle.getString("NAME");
                    int i = bundle.getInt("PROGRESS");
                    if (i == 0) {
                        UCarDemoActivity.this.mHandler.sendEmptyMessage(105);
                        return;
                    } else if (i == 100) {
                        UCarDemoActivity.this.mHandler.sendEmptyMessage(105);
                        return;
                    } else {
                        UCarDemoActivity.this.mIsProgressShown = true;
                        UCarDemoActivity.this.mProgress.updateProgress(string, i);
                        UCarDemoActivity.this.mProgress.show();
                        if (UCarDemoActivity.this.mDialog != null && UCarDemoActivity.this.mDialog.isShowing()) {
                            UCarDemoActivity.this.mDialog.dismiss();
                            return;
                        }
                        return;
                    }
                case 105:
                    UCarDemoActivity.this.mProgress.hide();
                    UCarDemoActivity.this.mIsProgressShown = false;
                    return;
                case 106:
                    Bundle bundle2 = (Bundle) message.obj;
                    String string2 = bundle2.getString("PIN_CODE");
                    String string3 = bundle2.getString("DEVICE_NAME");
                    Fragment findFragmentByTag = UCarDemoActivity.this.getSupportFragmentManager().findFragmentByTag(UCarDemoActivity.TAG_GUIDE_FRAGMENT);
                    if (findFragmentByTag instanceof UCarGuideFragment) {
                        ((UCarGuideFragment) findFragmentByTag).updateUI(string2, string3);
                        return;
                    }
                    return;
                case 107:
                    UCarDemoActivity.this.finish();
                    return;
                case 108:
                    if (!UCarDemoActivity.this.mIsActivityOnForeground) {
                        UCarDemoActivity.this.backToForeground();
                    }
                    UCarAdapter.getInstance().startApp(UCarDemoActivity.this.mDeviceId, message.arg1, true);
                    return;
                case 109:
                    UCarAdapter.getInstance().notifyPickUpCall();
                    return;
                case 110:
                    UCarAdapter.getInstance().notifyHungUpCall();
                    return;
                case 111:
                    UCarAdapter.getInstance().startApp(UCarDemoActivity.this.mDeviceId, message.arg1, true);
                    return;
                default:
                    return;
            }
        }
    };
    private boolean mIsActivityOnForeground = false;
    private boolean mIsCastSucceed = false;
    private boolean mIsProgressShown;
    private boolean mIsSupportApConnect = true;
    private boolean mIsSupportAppFusion = true;
    private boolean mIsSupportHevc = false;
    private boolean mIsSupportPOINavi = true;
    private boolean mIsWorkInNormalCast = false;
    private final Object mLock = new Object();
    private int mMusicAppId = 0;
    private String mMusicPackageLabel;
    private int mOriginalVisibility = 0;
    private IPhoneDataListener mPhoneDataCallback;
    private UCarCommon.PhoneStateInfo mPhoneStateInfo = new UCarCommon.PhoneStateInfo();
    private UCarProgressBar mProgress;
    private final ArrayList<UCarCommon.AppDetailInfo> mRemoteApps = new ArrayList<>();
    private FrameLayout mRootLayout;
    private final ExecutorService mService = Executors.newSingleThreadExecutor();
    private UCarConfig mUCarConfig;

    static /* synthetic */ Integer lambda$null$32(Integer num) {
        return num;
    }

    static /* synthetic */ Integer lambda$null$36(Integer num) {
        return num;
    }

    /* access modifiers changed from: protected */
    @Override // com.ucarhu.demo.PermissionsReqActivity
    public String[] getPermissions() {
        return new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.RECORD_AUDIO", "android.permission.CAMERA"};
    }

    /* access modifiers changed from: protected */
    @Override // com.ucarhu.demo.PermissionsReqActivity
    public void onPermissionsGranted() {
        checkCanDrawOverlays();
    }

    /* access modifiers changed from: protected */
    @Override // com.ucarhu.demo.PermissionsReqActivity
    public void onPermissionsDenied() {
        finish();
    }

    /* access modifiers changed from: protected */
    @Override // androidx.activity.ComponentActivity, androidx.core.app.ComponentActivity, androidx.appcompat.app.AppCompatActivity, androidx.fragment.app.FragmentActivity
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Log.i(TAG, "onCreate");
        requestWindowFeature(1);
        setContentView(R.layout.activity_ucar_cast);
        ((ActionBar) Objects.requireNonNull(getSupportActionBar())).hide();
        initViews();
        initEmulatorConfig();
    }

    private void initViews() {
        this.mOriginalVisibility = getWindow().getDecorView().getVisibility();
        this.mMusicPackageLabel = getString(R.string.app_name);
        this.mRootLayout = (FrameLayout) findViewById(R.id.fl_root);
        this.mProgress = new UCarProgressBar(this, this.mRootLayout);
        showGuideFragment();
    }

    private void initEmulatorConfig() {
        SharedPreferences sharedPreferences = getSharedPreferences(SP_NAME_EMULATOR, 0);
        this.mConfigure = sharedPreferences.getBoolean(KEY_EMULATOR_CONFIGURE, false);
        this.mExpectedDisplayWidthByUser = sharedPreferences.getInt(KEY_EMULATOR_WIDTH_BY_USER, -1);
        this.mExpectedDisplayHeightByUser = sharedPreferences.getInt(KEY_EMULATOR_HEIGHT_BY_USER, -1);
        this.mExpectedDpiByUser = sharedPreferences.getInt(KEY_EMULATOR_DPI_BY_USER, DISPLAY_DENSITY_DPI);
        this.mExpectedFpsByUser = sharedPreferences.getInt(KEY_EMULATOR_FPS_BY_USER, 30);
        this.mIsSupportHevc = sharedPreferences.getBoolean(KEY_EMULATOR_SUPPORT_HEVC, false);
        this.mIsSupportAppFusion = sharedPreferences.getBoolean(KEY_EMULATOR_SUPPORT_APP_FUSION, true);
        this.mIsSupportApConnect = sharedPreferences.getBoolean(KEY_EMULATOR_SUPPORT_AP_CONNECT, true);
        this.mIsSupportPOINavi = sharedPreferences.getBoolean(KEY_EMULATOR_SUPPORT_POI_NAVI, true);
        int[] splitStringWithSpaceToIntArray = TransTool.splitStringWithSpaceToIntArray(sharedPreferences.getString(KEY_EMULATOR_ALLOWED_5G_CHANNELS, ""));
        if (splitStringWithSpaceToIntArray != null) {
            this.mAllowed5GChannels = splitStringWithSpaceToIntArray;
        } else {
            this.mAllowed5GChannels = DEFAULT_ALLOWED_5G_CHANNELS;
        }
        if (this.mIsSupportAppFusion) {
            showSystemUi();
        } else {
            hideSystemUi();
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void showEmulatorDialog() {
        UCarAlertView uCarAlertView = new UCarAlertView(this);
        View inflate = LayoutInflater.from(this).inflate(R.layout.dialog_emulator_config, (ViewGroup) null, false);
        ConstraintLayout constraintLayout = (ConstraintLayout) inflate.findViewById(R.id.cl_dialog_config_root_container);
        constraintLayout.setOnClickListener(new View.OnClickListener() {
            /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$_bVs6KWYxwnaPk0t6DQXmKgbIvI */

            public final void onClick(View view) {
                UCarDemoActivity.this.lambda$showEmulatorDialog$19$UCarDemoActivity(view);
            }
        });
        final EditText editText = (EditText) inflate.findViewById(R.id.et_dialog_video_width);
        String valueOf = String.valueOf(this.mConfigure ? this.mExpectedDisplayWidthByUser : this.mExpectedDisplayWidth);
        editText.addTextChangedListener(new TextWatcher() {
            /* class com.ucarhu.demo.UCarDemoActivity.AnonymousClass1 */

            public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }

            public void afterTextChanged(Editable editable) {
                try {
                    UCarDemoActivity.this.mExpectedDisplayWidthByUser = Integer.parseInt(editable.toString());
                } catch (NumberFormatException unused) {
                }
            }
        });
        editText.setText(valueOf);
        editText.setSelection(valueOf.length());
        final EditText editText2 = (EditText) inflate.findViewById(R.id.et_dialog_video_height);
        String valueOf2 = String.valueOf(this.mConfigure ? this.mExpectedDisplayHeightByUser : this.mExpectedDisplayHeight);
        editText2.addTextChangedListener(new TextWatcher() {
            /* class com.ucarhu.demo.UCarDemoActivity.AnonymousClass2 */

            public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }

            public void afterTextChanged(Editable editable) {
                try {
                    UCarDemoActivity.this.mExpectedDisplayHeightByUser = Integer.parseInt(editable.toString());
                } catch (NumberFormatException unused) {
                }
            }
        });
        editText2.setText(valueOf2);
        editText2.setSelection(valueOf2.length());
        EditText editText3 = (EditText) inflate.findViewById(R.id.et_dialog_video_dpi);
        String valueOf3 = String.valueOf(this.mConfigure ? this.mExpectedDpiByUser : DISPLAY_DENSITY_DPI);
        editText3.addTextChangedListener(new TextWatcher() {
            /* class com.ucarhu.demo.UCarDemoActivity.AnonymousClass3 */

            public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }

            public void afterTextChanged(Editable editable) {
                try {
                    UCarDemoActivity.this.mExpectedDpiByUser = Integer.parseInt(editable.toString());
                } catch (NumberFormatException unused) {
                }
            }
        });
        editText3.setText(valueOf3);
        editText3.setSelection(valueOf3.length());
        EditText editText4 = (EditText) inflate.findViewById(R.id.et_dialog_video_fps);
        String valueOf4 = String.valueOf(this.mConfigure ? this.mExpectedFpsByUser : 30);
        editText4.addTextChangedListener(new TextWatcher() {
            /* class com.ucarhu.demo.UCarDemoActivity.AnonymousClass4 */

            public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }

            public void afterTextChanged(Editable editable) {
                try {
                    UCarDemoActivity.this.mExpectedFpsByUser = Integer.parseInt(editable.toString());
                } catch (NumberFormatException unused) {
                }
            }
        });
        editText4.setText(valueOf4);
        editText4.setSelection(valueOf4.length());
        EditText editText5 = (EditText) inflate.findViewById(R.id.et_dialog_allowed_channels);
        String joinIntArrayWithSpace = TransTool.joinIntArrayWithSpace(this.mAllowed5GChannels);
        editText5.addTextChangedListener(new TextWatcher() {
            /* class com.ucarhu.demo.UCarDemoActivity.AnonymousClass5 */

            public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }

            public void afterTextChanged(Editable editable) {
                int[] splitStringWithSpaceToIntArray = TransTool.splitStringWithSpaceToIntArray(editable.toString());
                if (splitStringWithSpaceToIntArray != null) {
                    UCarDemoActivity.this.mAllowed5GChannels = splitStringWithSpaceToIntArray;
                }
            }
        });
        editText5.setText(joinIntArrayWithSpace);
        editText5.setSelection(joinIntArrayWithSpace.length());
        CheckBox checkBox = (CheckBox) inflate.findViewById(R.id.cb_dialog_support_hevc);
        checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$6n35MfBmNDRXdqqgg79HfoG7aok */

            public final void onCheckedChanged(CompoundButton compoundButton, boolean z) {
                UCarDemoActivity.this.lambda$showEmulatorDialog$20$UCarDemoActivity(compoundButton, z);
            }
        });
        checkBox.setChecked(this.mIsSupportHevc);
        CheckBox checkBox2 = (CheckBox) inflate.findViewById(R.id.cb_dialog_support_app_fusion);
        checkBox2.setOnTouchListener(new View.OnTouchListener() {
            /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$5W5mvyEWilNmZp0n0fM_0Bqg8Y */

            public final boolean onTouch(View view, MotionEvent motionEvent) {
                return UCarDemoActivity.lambda$showEmulatorDialog$21(ConstraintLayout.this, view, motionEvent);
            }
        });
        checkBox2.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            /* class com.ucarhu.demo.UCarDemoActivity.AnonymousClass6 */
            private static final int DELAY_REMOVE_TIME_MS = 100;
            private final Runnable mDelayRemoveRunnable = new Runnable() {
                /* class com.ucarhu.demo.UCarDemoActivity.AnonymousClass6.AnonymousClass1 */

                public void run() {
                    if (AnonymousClass6.this.mIsAddLayoutChangedListener) {
                        AnonymousClass6.this.mIsAddLayoutChangedListener = false;
                        UCarDemoActivity.this.mRootLayout.removeOnLayoutChangeListener(AnonymousClass6.this.mOnLayoutChangeListener);
                    }
                }
            };
            private boolean mIsAddLayoutChangedListener = false;
            private final View.OnLayoutChangeListener mOnLayoutChangeListener = new View.OnLayoutChangeListener() {
                /* class com.ucarhu.demo.UCarDemoActivity.AnonymousClass6.AnonymousClass2 */

                public void onLayoutChange(View view, int i, int i2, int i3, int i4, int i5, int i6, int i7, int i8) {
                    Rect rect = new Rect();
                    UCarDemoActivity.this.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
                    String valueOf = String.valueOf((Math.max(rect.width(), rect.height()) / 16) * 16);
                    String valueOf2 = String.valueOf((Math.min(rect.width(), rect.height()) / 16) * 16);
                    editText.setText(valueOf);
                    editText.setSelection(valueOf.length());
                    editText2.setText(valueOf2);
                    editText2.setSelection(valueOf2.length());
                    UCarDemoActivity.this.mRootLayout.removeCallbacks(AnonymousClass6.this.mDelayRemoveRunnable);
                    UCarDemoActivity.this.mRootLayout.postDelayed(AnonymousClass6.this.mDelayRemoveRunnable, 100);
                }
            };

            public void onCheckedChanged(CompoundButton compoundButton, boolean z) {
                if (!this.mIsAddLayoutChangedListener) {
                    UCarDemoActivity.this.mRootLayout.addOnLayoutChangeListener(this.mOnLayoutChangeListener);
                    this.mIsAddLayoutChangedListener = true;
                }
                if (z) {
                    UCarDemoActivity.this.showSystemUi();
                } else {
                    UCarDemoActivity.this.hideSystemUi();
                }
                UCarDemoActivity.this.mIsSupportAppFusion = z;
            }
        });
        checkBox2.setChecked(this.mIsSupportAppFusion);
        CheckBox checkBox3 = (CheckBox) inflate.findViewById(R.id.cb_dialog_support_ap_connect);
        checkBox3.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$lUwVviRLj1XCbTA_0LrpMSW7nyQ */

            public final void onCheckedChanged(CompoundButton compoundButton, boolean z) {
                UCarDemoActivity.this.lambda$showEmulatorDialog$22$UCarDemoActivity(compoundButton, z);
            }
        });
        checkBox3.setChecked(this.mIsSupportApConnect);
        CheckBox checkBox4 = (CheckBox) inflate.findViewById(R.id.cb_dialog_support_poi_navi);
        checkBox4.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$lMPsVfl6ltCPTDxNuyamqKt2L7c */

            public final void onCheckedChanged(CompoundButton compoundButton, boolean z) {
                UCarDemoActivity.this.lambda$showEmulatorDialog$23$UCarDemoActivity(compoundButton, z);
            }
        });
        checkBox4.setChecked(this.mIsSupportPOINavi);
        ((TextView) inflate.findViewById(R.id.tv_dialog_done)).setOnClickListener(new View.OnClickListener(uCarAlertView) {
            /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$Nq6PdNzuevKJg7_9Lbp8XrAzVT8 */
            public final /* synthetic */ UCarAlertView f$1;

            {
                this.f$1 = r2;
            }

            public final void onClick(View view) {
                UCarDemoActivity.this.lambda$showEmulatorDialog$24$UCarDemoActivity(this.f$1, view);
            }
        });
        ((TextView) inflate.findViewById(R.id.tv_dialog_cancel)).setOnClickListener(new View.OnClickListener(uCarAlertView) {
            /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$VsQwWTfQ0jTJ0GSp8zk5QxsV4C0 */
            public final /* synthetic */ UCarAlertView f$1;

            {
                this.f$1 = r2;
            }

            public final void onClick(View view) {
                UCarDemoActivity.this.lambda$showEmulatorDialog$25$UCarDemoActivity(this.f$1, view);
            }
        });
        uCarAlertView.setContentView(inflate);
        uCarAlertView.show();
    }

    public /* synthetic */ void lambda$showEmulatorDialog$19$UCarDemoActivity(View view) {
        ((InputMethodManager) getSystemService("input_method")).hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public /* synthetic */ void lambda$showEmulatorDialog$20$UCarDemoActivity(CompoundButton compoundButton, boolean z) {
        this.mIsSupportHevc = z;
    }

    static /* synthetic */ boolean lambda$showEmulatorDialog$21(ConstraintLayout constraintLayout, View view, MotionEvent motionEvent) {
        if (motionEvent.getActionMasked() != 0) {
            return false;
        }
        constraintLayout.performClick();
        return false;
    }

    public /* synthetic */ void lambda$showEmulatorDialog$22$UCarDemoActivity(CompoundButton compoundButton, boolean z) {
        this.mIsSupportApConnect = z;
    }

    public /* synthetic */ void lambda$showEmulatorDialog$23$UCarDemoActivity(CompoundButton compoundButton, boolean z) {
        this.mIsSupportPOINavi = z;
    }

    public /* synthetic */ void lambda$showEmulatorDialog$24$UCarDemoActivity(UCarAlertView uCarAlertView, View view) {
        validateEmulatorConfig(uCarAlertView);
    }

    public /* synthetic */ void lambda$showEmulatorDialog$25$UCarDemoActivity(UCarAlertView uCarAlertView, View view) {
        uCarAlertView.dismiss();
        initEmulatorConfig();
        this.mHandler.sendEmptyMessage(102);
    }

    private void validateEmulatorConfig(UCarAlertView uCarAlertView) {
        if (this.mExpectedDisplayWidthByUser <= 0) {
            Toast.makeText(this, (int) R.string.please_input_video_width, 1).show();
        } else if (this.mExpectedDisplayHeightByUser <= 0) {
            Toast.makeText(this, (int) R.string.please_input_video_height, 1).show();
        } else if (this.mExpectedDpiByUser < 120) {
            Toast.makeText(this, (int) R.string.video_dpi_cannot_be_less_than_120, 1).show();
        } else {
            int i = this.mExpectedFpsByUser;
            if (i > 60) {
                Toast.makeText(this, (int) R.string.video_fps_cannot_be_larger_than_60, 1).show();
            } else if (i % 15 != 0) {
                Toast.makeText(this, (int) R.string.video_fps_must_be_multiple_of_15, 1).show();
            } else {
                this.mConfigure = true;
                initDisplayMetrics();
                getSharedPreferences(SP_NAME_EMULATOR, 0).edit().putBoolean(KEY_EMULATOR_CONFIGURE, this.mConfigure).putInt(KEY_EMULATOR_DPI_BY_USER, this.mExpectedDpiByUser).putInt(KEY_EMULATOR_WIDTH_BY_USER, this.mExpectedDisplayWidthByUser).putInt(KEY_EMULATOR_HEIGHT_BY_USER, this.mExpectedDisplayHeightByUser).putInt(KEY_EMULATOR_FPS_BY_USER, this.mExpectedFpsByUser).putBoolean(KEY_EMULATOR_SUPPORT_HEVC, this.mIsSupportHevc).putBoolean(KEY_EMULATOR_SUPPORT_APP_FUSION, this.mIsSupportAppFusion).putBoolean(KEY_EMULATOR_SUPPORT_AP_CONNECT, this.mIsSupportApConnect).putBoolean(KEY_EMULATOR_SUPPORT_POI_NAVI, this.mIsSupportPOINavi).putString(KEY_EMULATOR_ALLOWED_5G_CHANNELS, TransTool.joinIntArrayWithSpace(this.mAllowed5GChannels)).apply();
                this.mUCarConfig = new UCarConfig.Builder().from(this.mUCarConfig).setScreenWidth(this.mFullDisplayWidth).setScreenHeight(this.mFullDisplayHeight).setDpi(this.mExpectedDpiByUser).setVideoDisplayWidth(this.mExpectedDisplayWidthByUser).setVideoDisplayHeight(this.mExpectedDisplayHeightByUser).setFps(this.mExpectedFpsByUser).setSupportHevc(this.mIsSupportHevc).setSupportSoftAP(this.mIsSupportApConnect).setSupportPOINav(this.mIsSupportPOINavi).setAllowed5gChannels(this.mAllowed5GChannels).setSupportedWorkModes(new UCarCommon.WorkMode.Builder().setSupportNormalCast(true).setSupportAppFullScreenCast(this.mIsSupportAppFusion).setSupportAppWindowCast(this.mIsSupportAppFusion).build()).build();
                new Thread(new Runnable() {
                    /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$NJYKBBz5pDIqTG_TvG45SpgJ7a0 */

                    public final void run() {
                        UCarDemoActivity.this.lambda$validateEmulatorConfig$28$UCarDemoActivity();
                    }
                }).start();
                uCarAlertView.dismiss();
            }
        }
    }

    public /* synthetic */ void lambda$validateEmulatorConfig$28$UCarDemoActivity() {
        UCarAdapter.getInstance().deInit();
        this.mHandler.post(new Runnable(UCarAdapter.getInstance().init(getApplicationContext(), this.mUCarConfig, new ICarInitCallback() {
            /* class com.ucarhu.demo.UCarDemoActivity.AnonymousClass7 */

            @Override // com.ucar.vehiclesdk.ICarInitCallback
            public void onInitSuccess() {
                Log.i(UCarDemoActivity.TAG, "UCarAdapter init success");
                boolean unused = UCarDemoActivity.sIsServiceInitialized = true;
                UCarDemoActivity.this.registerCarEventListener();
                UCarDemoActivity.this.mHandler.sendEmptyMessage(102);
            }

            @Override // com.ucar.vehiclesdk.ICarInitCallback
            public void onInitFailed(int i) {
                Log.e(UCarDemoActivity.TAG, "UCarAdapter init failed");
                UCarDemoActivity.this.mHandler.post(new Runnable(i) {
                    /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$7$S59ZiVG6QtIfMB5JcsI_bxXhAVU */
                    public final /* synthetic */ int f$1;

                    {
                        this.f$1 = r2;
                    }

                    public final void run() {
                        UCarDemoActivity.AnonymousClass7.this.lambda$onInitFailed$26$UCarDemoActivity$7(this.f$1);
                    }
                });
            }

            public /* synthetic */ void lambda$onInitFailed$26$UCarDemoActivity$7(int i) {
                UCarDemoActivity.this.handleConnectFailed(i);
            }
        })) {
            /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$CRqP0EgL2yscjaOaM8L8_jBwVso */
            public final /* synthetic */ boolean f$1;

            {
                this.f$1 = r2;
            }

            public final void run() {
                UCarDemoActivity.this.lambda$null$27$UCarDemoActivity(this.f$1);
            }
        });
    }

    public /* synthetic */ void lambda$null$27$UCarDemoActivity(boolean z) {
        if (!z) {
            Log.e(TAG, "init ucar sdk failed");
            finish();
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void hideSystemUi() {
        getWindow().addFlags(1024);
        getWindow().getDecorView().setSystemUiVisibility(4102);
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void showSystemUi() {
        getWindow().clearFlags(1024);
        getWindow().getDecorView().setSystemUiVisibility(this.mOriginalVisibility);
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void registerCarEventListener() {
        this.mConnectCallback = new ICarConnectListener() {
            /* class com.ucarhu.demo.UCarDemoActivity.AnonymousClass8 */

            @Override // com.ucar.vehiclesdk.ICarConnectListener
            public void onPinCode(String str, String str2) {
                Log.i(UCarDemoActivity.TAG, "onPinCode, pin code: " + str + ", device name: " + str2);
                Message obtain = Message.obtain();
                obtain.what = 106;
                Bundle bundle = new Bundle();
                bundle.putString("PIN_CODE", str);
                bundle.putString("DEVICE_NAME", str2);
                obtain.obj = bundle;
                UCarDemoActivity.this.mHandler.sendMessage(obtain);
            }

            @Override // com.ucar.vehiclesdk.ICarConnectListener
            public void onConnectingProgress(String str, int i) {
                Log.i(UCarDemoActivity.TAG, "onConnectingProgress: " + i);
                UCarDemoActivity.this.mDeviceId = str;
                Bundle bundle = new Bundle();
                bundle.putString("ID", str);
                bundle.putString("NAME", UCarAdapter.getInstance().getMobileDevice(UCarDemoActivity.this.mDeviceId).getModel());
                bundle.putInt("PROGRESS", i);
                Message obtain = Message.obtain();
                obtain.what = 104;
                obtain.obj = bundle;
                UCarDemoActivity.this.mHandler.sendMessage(obtain);
            }

            @Override // com.ucar.vehiclesdk.ICarConnectListener
            public void onConnectStateChanged(String str, int i, int i2) {
                UCarDemoActivity.this.mDeviceId = str;
                Bundle bundle = new Bundle();
                bundle.putString("ID", str);
                bundle.putInt("STATE", i);
                bundle.putInt("PARAMETER", i2);
                Message obtain = Message.obtain();
                obtain.what = 101;
                obtain.obj = bundle;
                UCarDemoActivity.this.mHandler.sendMessage(obtain);
            }

            @Override // com.ucar.vehiclesdk.ICarConnectListener
            public UCarCommon.WorkMode onSelectWorkMode(String str, UCarCommon.WorkMode workMode) {
                UCarDemoActivity.this.mDeviceId = str;
                if (workMode.isSupportAppWindowCast()) {
                    return UCarCommon.WorkMode.APP_WINDOW_CAST;
                }
                if (workMode.isSupportAppFullScreenCast()) {
                    return UCarCommon.WorkMode.APP_FULLSCREEN_CAST;
                }
                if (workMode.isSupportNormalCast()) {
                    return UCarCommon.WorkMode.NORMAL_CAST;
                }
                if (workMode.isSupportDataTransfer()) {
                    return UCarCommon.WorkMode.DATA_TRANSFER;
                }
                return UCarCommon.WorkMode.NONE;
            }

            @Override // com.ucar.vehiclesdk.ICarConnectListener
            public void onRethinkBluetoothConnect(boolean z) {
                Log.i(UCarDemoActivity.TAG, "rethink bluetooth connect, carlink connect: " + z);
                if (UCarDemoActivity.this.mCarBtConnector == null) {
                    UCarDemoActivity.this.mCarBtConnector = new CarBtConnector(UCarDemoActivity.this);
                }
                if (!z) {
                    UCarDemoActivity.this.mCarBtConnector.tryReconnectHFPIfNeed();
                    UCarDemoActivity.this.mCarBtConnector.tryReconnectA2DPIfNeed();
                    UCarDemoActivity.this.mCarBtConnector.clearStatus();
                } else if (UCarDemoActivity.this.mIsWorkInNormalCast) {
                    UCarDemoActivity.this.mCarBtConnector.stopHFP();
                    UCarDemoActivity.this.mCarBtConnector.stopA2DP();
                } else {
                    UCarDemoActivity.this.mCarBtConnector.tryConnectHFPToCarlinkPhone();
                    UCarDemoActivity.this.mCarBtConnector.stopA2DP();
                }
            }
        };
        UCarAdapter.getInstance().registerCarConnectListener(this.mConnectCallback);
        this.mPhoneDataCallback = new IPhoneDataListener() {
            /* class com.ucarhu.demo.UCarDemoActivity.AnonymousClass9 */

            @Override // com.ucar.vehiclesdk.IPhoneDataListener
            public void onPhoneStateInfoReceived(String str, UCarCommon.PhoneStateInfo phoneStateInfo) {
                UCarDemoActivity.this.handlePhoneStateInfoReceived(phoneStateInfo);
            }

            @Override // com.ucar.vehiclesdk.IPhoneDataListener
            public UCarCommon.AudioAttributes getAudioAttributesByType(UCarCommon.AudioType audioType) {
                int i;
                int i2 = 5;
                int i3 = 4;
                int i4 = 3;
                switch (AnonymousClass14.$SwitchMap$com$ucar$vehiclesdk$UCarCommon$AudioType[audioType.ordinal()]) {
                    case 1:
                    case 2:
                        i = 0;
                        i2 = 2;
                        i4 = 2;
                        i3 = 1;
                        break;
                    case 3:
                        i2 = 16;
                        i = 10;
                        i4 = 4;
                        i3 = 1;
                        break;
                    case 4:
                        i2 = 6;
                        i = 2;
                        break;
                    case 5:
                        i = 5;
                        break;
                    case 6:
                        i3 = 1;
                        i2 = 12;
                        i = 5;
                        break;
                    case 7:
                        i2 = 13;
                        i = 1;
                        break;
                    default:
                        i3 = 2;
                        i = 3;
                        i2 = 1;
                        i4 = 1;
                        break;
                }
                return new UCarCommon.AudioAttributes(new AudioAttributes.Builder().setUsage(i2).setContentType(i3).build(), i4, i);
            }

            @Override // com.ucar.vehiclesdk.IPhoneDataListener
            public void onAudioFocusChanged(UCarCommon.AudioType audioType, int i) {
                Log.i(UCarDemoActivity.TAG, "carlink audio focus changed, audioType: " + audioType + ", focusChange: " + i);
            }

            @Override // com.ucar.vehiclesdk.IPhoneDataListener
            public void onMusicInfoReceived(String str, UCarCommon.MusicInfo musicInfo) {
                if (musicInfo.getAppId() != UCarDemoActivity.this.mMusicAppId) {
                    UCarDemoActivity.this.mMusicAppId = musicInfo.getAppId();
                    UCarDemoActivity uCarDemoActivity = UCarDemoActivity.this;
                    uCarDemoActivity.mMusicPackageLabel = uCarDemoActivity.getString(R.string.app_name);
                    Iterator it = UCarDemoActivity.this.mRemoteApps.iterator();
                    while (true) {
                        if (!it.hasNext()) {
                            break;
                        }
                        UCarCommon.AppDetailInfo appDetailInfo = (UCarCommon.AppDetailInfo) it.next();
                        if (appDetailInfo.getGeneraIInfo().getAppId() == musicInfo.getAppId()) {
                            UCarDemoActivity.this.mMusicPackageLabel = appDetailInfo.getGeneraIInfo().getLabel();
                            break;
                        }
                    }
                }
                if (musicInfo.isDestroyed()) {
                    Log.i(UCarDemoActivity.TAG, "ucar music is destroyed, name：" + UCarDemoActivity.this.mMusicPackageLabel + " title:" + musicInfo.getTitle());
                } else if (musicInfo.isPlaying()) {
                    Log.i(UCarDemoActivity.TAG, "ucar music is playing, name：" + UCarDemoActivity.this.mMusicPackageLabel + " title:" + musicInfo.getTitle());
                } else {
                    Log.i(UCarDemoActivity.TAG, "ucar music is idle, name：" + UCarDemoActivity.this.mMusicPackageLabel + " title:" + musicInfo.getTitle());
                }
            }

            @Override // com.ucar.vehiclesdk.IPhoneDataListener
            public void onNavigationInfoReceived(String str, UCarCommon.NavigationInfo navigationInfo) {
                if (navigationInfo.isNavigating()) {
                    Log.i(UCarDemoActivity.TAG, "ucar navigation is active");
                } else {
                    Log.i(UCarDemoActivity.TAG, "ucar navigation is idle");
                }
            }

            @Override // com.ucar.vehiclesdk.IPhoneDataListener
            public void onAppListStateChanged(String str, List<Integer> list, UCarCommon.AppListState appListState) {
                Log.i(UCarDemoActivity.TAG, "app list changed");
                int i = AnonymousClass14.$SwitchMap$com$ucar$vehiclesdk$UCarCommon$AppListState[appListState.ordinal()];
                if (i == 1) {
                    UCarDemoActivity.this.handleAppInstalled(str, list);
                } else if (i == 2) {
                    UCarDemoActivity.this.handleAppRemoved(list);
                } else if (i == 3) {
                    UCarDemoActivity.this.handleAppUpdated(str, list);
                } else if (i == 4) {
                    UCarDemoActivity.this.handleAppReordered(list);
                }
            }

            @Override // com.ucar.vehiclesdk.IPhoneDataListener
            public void onAppStateChanged(String str, int i, boolean z, int i2, int i3, UCarCommon.AppState appState) {
                Log.i(UCarDemoActivity.TAG, "app state changed");
                if (appState != UCarCommon.AppState.RESUMED && appState != UCarCommon.AppState.PAUSED) {
                    if (z) {
                        if (UCarDemoActivity.this.mIsWorkInNormalCast) {
                            UCarDemoActivity.this.hideGuideFragment();
                        }
                        UCarDemoActivity.this.showSurfaceFragment(i, i2, i3);
                        return;
                    }
                    UCarDemoActivity.this.hideSurfaceFragment();
                }
            }

            @Override // com.ucar.vehiclesdk.IPhoneDataListener
            public void onCallInfoReceived(String str, UCarCommon.CallInfo callInfo) {
                Log.i(UCarDemoActivity.TAG, "call info received");
                if (callInfo.isNeedShowFloatingWindow()) {
                    if (callInfo.isIPCall() || UCarDemoActivity.this.mIsWorkInNormalCast) {
                        if (UCarDemoActivity.this.mCallWindow == null) {
                            UCarDemoActivity uCarDemoActivity = UCarDemoActivity.this;
                            UCarDemoActivity uCarDemoActivity2 = UCarDemoActivity.this;
                            uCarDemoActivity.mCallWindow = new UCarCallWindow(uCarDemoActivity2, uCarDemoActivity2.mHandler);
                        }
                        UCarDemoActivity.this.mCallWindow.update(callInfo);
                    }
                } else if (UCarDemoActivity.this.mCallWindow != null) {
                    UCarDemoActivity.this.mCallWindow.hide();
                }
            }

            @Override // com.ucar.vehiclesdk.IPhoneDataListener
            public void onPOIReceived(String str, UCarCommon.POIAddress pOIAddress) {
                Log.i(UCarDemoActivity.TAG, "poi received");
                UCarDemoActivity.this.handlePOIReceived(pOIAddress);
            }
        };
        UCarAdapter.getInstance().registerPhoneDataListener(this.mPhoneDataCallback);
        if (this.mUCarConfig.isSupportCamera()) {
            this.mCameraInfoCallback = new ICameraInfoListener() {
                /* class com.ucarhu.demo.UCarDemoActivity.AnonymousClass10 */

                @Override // com.ucar.vehiclesdk.ICameraInfoListener
                public ArrayList<AbstractCamera> getNativeCamera() {
                    return null;
                }

                @Override // com.ucar.vehiclesdk.ICameraInfoListener
                public ArrayList<UCarCommon.CameraInfo> getAndroidCameraInfo() {
                    ArrayList<UCarCommon.CameraInfo> arrayList = new ArrayList<>();
                    arrayList.add(new UCarCommon.CameraInfo(UCarDemoActivity.CAMERA_ID, UCarDemoActivity.CAMERA_NAME, UCarCommon.LensFacing.LENS_FACING_BACK));
                    return arrayList;
                }
            };
            UCarAdapter.getInstance().registerCameraInfoListener(this.mCameraInfoCallback);
        }
    }

    /* renamed from: com.ucarhu.demo.UCarDemoActivity$14  reason: invalid class name */
    static /* synthetic */ class AnonymousClass14 {
        static final /* synthetic */ int[] $SwitchMap$com$ucar$vehiclesdk$UCarCommon$AppListState;
        static final /* synthetic */ int[] $SwitchMap$com$ucar$vehiclesdk$UCarCommon$AudioType;

        /* JADX WARNING: Can't wrap try/catch for region: R(27:0|(2:1|2)|3|(2:5|6)|7|9|10|11|(2:13|14)|15|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31|32|34) */
        /* JADX WARNING: Can't wrap try/catch for region: R(29:0|1|2|3|(2:5|6)|7|9|10|11|13|14|15|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31|32|34) */
        /* JADX WARNING: Can't wrap try/catch for region: R(30:0|1|2|3|5|6|7|9|10|11|13|14|15|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31|32|34) */
        /* JADX WARNING: Code restructure failed: missing block: B:35:?, code lost:
            return;
         */
        /* JADX WARNING: Failed to process nested try/catch */
        /* JADX WARNING: Missing exception handler attribute for start block: B:19:0x0044 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:21:0x004e */
        /* JADX WARNING: Missing exception handler attribute for start block: B:23:0x0058 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:25:0x0062 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:27:0x006d */
        /* JADX WARNING: Missing exception handler attribute for start block: B:29:0x0078 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:31:0x0083 */
        static {
            int[] iArr = new int[UCarCommon.AppListState.values().length];
            $SwitchMap$com$ucar$vehiclesdk$UCarCommon$AppListState = iArr;
            try {
                iArr[UCarCommon.AppListState.INSTALLED.ordinal()] = 1;
            } catch (NoSuchFieldError unused) {
            }
            try {
                $SwitchMap$com$ucar$vehiclesdk$UCarCommon$AppListState[UCarCommon.AppListState.REMOVED.ordinal()] = 2;
            } catch (NoSuchFieldError unused2) {
            }
            try {
                $SwitchMap$com$ucar$vehiclesdk$UCarCommon$AppListState[UCarCommon.AppListState.UPDATED.ordinal()] = 3;
            } catch (NoSuchFieldError unused3) {
            }
            try {
                $SwitchMap$com$ucar$vehiclesdk$UCarCommon$AppListState[UCarCommon.AppListState.REORDERED.ordinal()] = 4;
            } catch (NoSuchFieldError unused4) {
            }
            int[] iArr2 = new int[UCarCommon.AudioType.values().length];
            $SwitchMap$com$ucar$vehiclesdk$UCarCommon$AudioType = iArr2;
            iArr2[UCarCommon.AudioType.STREAM_IP_CALL.ordinal()] = 1;
            $SwitchMap$com$ucar$vehiclesdk$UCarCommon$AudioType[UCarCommon.AudioType.STREAM_MODEM_CALL.ordinal()] = 2;
            $SwitchMap$com$ucar$vehiclesdk$UCarCommon$AudioType[UCarCommon.AudioType.STREAM_AI_ASSISTANT.ordinal()] = 3;
            $SwitchMap$com$ucar$vehiclesdk$UCarCommon$AudioType[UCarCommon.AudioType.STREAM_RING.ordinal()] = 4;
            $SwitchMap$com$ucar$vehiclesdk$UCarCommon$AudioType[UCarCommon.AudioType.STREAM_NOTIFICATION.ordinal()] = 5;
            $SwitchMap$com$ucar$vehiclesdk$UCarCommon$AudioType[UCarCommon.AudioType.STREAM_TTS.ordinal()] = 6;
            $SwitchMap$com$ucar$vehiclesdk$UCarCommon$AudioType[UCarCommon.AudioType.STREAM_SYSTEM.ordinal()] = 7;
            $SwitchMap$com$ucar$vehiclesdk$UCarCommon$AudioType[UCarCommon.AudioType.STREAM_CAST_MUSIC.ordinal()] = 8;
        }
    }

    private void unregisterCarEventListener() {
        UCarAdapter.getInstance().unregisterCarConnectListener(this.mConnectCallback);
        UCarAdapter.getInstance().unregisterPhoneDataListener(this.mPhoneDataCallback);
        UCarAdapter.getInstance().unregisterCameraInfoListener(this.mCameraInfoCallback);
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void handleConnectStateChangedMessage(Message message) {
        Bundle bundle = (Bundle) message.obj;
        String string = bundle.getString("ID");
        int i = bundle.getInt("STATE");
        int i2 = bundle.getInt("PARAMETER");
        boolean z = true;
        switch (i) {
            case 1:
                if (i2 != 11) {
                    z = false;
                }
                Log.i(TAG, "ucar device disconnected, is disconnect by user : " + z);
                this.mIsCastSucceed = false;
                handleDisconnected(string, z);
                return;
            case 2:
                Log.i(TAG, "ucar device connected");
                if (this.mIsActivityOnForeground) {
                    UCarAdapter.getInstance().allowGainAudioFocus();
                    return;
                } else {
                    UCarAdapter.getInstance().pauseCast();
                    return;
                }
            case 3:
                handleConnectFailed(i2);
                return;
            case 4:
                Log.d(TAG, "cast connected");
                this.mIsCastSucceed = true;
                updateViewStateByConnectionState(true);
                return;
            case 5:
                Log.d(TAG, "cast disconnected");
                this.mIsCastSucceed = false;
                updateViewStateByConnectionState(false);
                return;
            case 6:
                backToHome();
                return;
            case 7:
                backToForeground();
                return;
            default:
                return;
        }
    }

    private void handleDisconnected(String str, boolean z) {
        int connectType = UCarAdapter.getInstance().getConnectType(str);
        boolean z2 = false;
        updateViewStateByConnectionState(false);
        if (connectType == 1 || connectType == 3) {
            z2 = true;
        }
        if (z || !z2) {
            Log.i(TAG, "move the activity to the end of its task stack");
            moveTaskToBack(true);
        } else {
            Log.i(TAG, "prepare for auto reconnection");
            this.mHandler.sendEmptyMessage(102);
        }
        if (this.mIsProgressShown) {
            this.mHandler.sendEmptyMessage(105);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void handleConnectFailed(int i) {
        String str = TAG;
        Log.i(str, "ucar connect failed, error code:" + i);
        UCarAlertView uCarAlertView = this.mDialog;
        if (uCarAlertView != null) {
            uCarAlertView.show();
            return;
        }
        String string = getString(R.string.connect_failed);
        String str2 = "\n" + getString(R.string.wireless_reconnect_method) + "\n" + getString(R.string.usb_reconnect_method) + "\n" + getString(R.string.need_user_intervention_method) + "\n" + getString(R.string.unsupport_wireless_method) + "\n" + getString(R.string.restart_car_method) + "\n";
        Log.i(str, "error message:" + str2);
        if (this.mIsProgressShown) {
            this.mHandler.sendEmptyMessage(105);
        }
        UCarAlertView makeDialog = UCarAlertUtil.makeDialog(this, R.layout.dialog_connect_failed_notice, 0, string, str2, getString(R.string.reconnect), getString(R.string.cancel), new UCarAlertUtil.OnClickListener() {
            /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$asMCWH1J5V1mpgErjXO_SqyHivs */

            @Override // com.ucarhu.demo.UCarAlertUtil.OnClickListener
            public final boolean onClick() {
                return UCarDemoActivity.this.lambda$handleConnectFailed$29$UCarDemoActivity();
            }
        }, new UCarAlertUtil.OnClickListener() {
            /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$xz3xsmEPuLvd4F8ZLWKgF1_7aI */

            @Override // com.ucarhu.demo.UCarAlertUtil.OnClickListener
            public final boolean onClick() {
                return UCarDemoActivity.this.lambda$handleConnectFailed$30$UCarDemoActivity();
            }
        });
        this.mDialog = makeDialog;
        makeDialog.show();
    }

    public /* synthetic */ boolean lambda$handleConnectFailed$29$UCarDemoActivity() {
        this.mHandler.sendEmptyMessage(102);
        return false;
    }

    public /* synthetic */ boolean lambda$handleConnectFailed$30$UCarDemoActivity() {
        finish();
        return false;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void handlePhoneStateInfoReceived(UCarCommon.PhoneStateInfo phoneStateInfo) {
        this.mHandler.post(new Runnable(phoneStateInfo) {
            /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$_cUHSz9yZ3ltNC8RkvMryJ4VCqo */
            public final /* synthetic */ UCarCommon.PhoneStateInfo f$1;

            {
                this.f$1 = r2;
            }

            public final void run() {
                UCarDemoActivity.this.lambda$handlePhoneStateInfoReceived$31$UCarDemoActivity(this.f$1);
            }
        });
    }

    public /* synthetic */ void lambda$handlePhoneStateInfoReceived$31$UCarDemoActivity(UCarCommon.PhoneStateInfo phoneStateInfo) {
        boolean isUseMicrophone = phoneStateInfo.isUseMicrophone();
        if (isUseMicrophone != this.mPhoneStateInfo.isUseMicrophone()) {
            if (phoneStateInfo.isUseMicrophone()) {
                Log.i(TAG, "ucar request use mic");
            } else {
                Log.i(TAG, "ucar has released mic");
            }
            this.mPhoneStateInfo.setUseMicrophone(isUseMicrophone);
        }
        UCarCommon.CallState modemCallState = phoneStateInfo.getModemCallState();
        if (modemCallState != this.mPhoneStateInfo.getModemCallState()) {
            if (modemCallState == UCarCommon.CallState.INCOMING || modemCallState == UCarCommon.CallState.DIALING || modemCallState == UCarCommon.CallState.ALERTING || modemCallState == UCarCommon.CallState.ACTIVE || modemCallState == UCarCommon.CallState.HOLDING) {
                Log.i(TAG, "modem call state changed : " + modemCallState);
            } else if (modemCallState == UCarCommon.CallState.IDLE) {
                Log.i(TAG, "modem call state is idle");
            }
            this.mPhoneStateInfo.setModemCallState(modemCallState);
        }
        boolean isVoipCall = phoneStateInfo.isVoipCall();
        if (isVoipCall != this.mPhoneStateInfo.isVoipCall()) {
            if (isVoipCall) {
                Log.i(TAG, "voip call state is active");
            } else {
                Log.i(TAG, "voip call state is idle");
            }
            this.mPhoneStateInfo.setVoipCall(isVoipCall);
        }
        boolean isVoiceAssistantActive = phoneStateInfo.isVoiceAssistantActive();
        if (isVoiceAssistantActive != this.mPhoneStateInfo.isVoiceAssistantActive()) {
            if (isVoiceAssistantActive) {
                Log.i(TAG, "voice assistant state is active");
            } else {
                Log.i(TAG, "voice assistant state is idle");
            }
            this.mPhoneStateInfo.setVoiceAssistantActive(isVoiceAssistantActive);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void handleAppInstalled(String str, List<Integer> list) {
        runOnAsyncThread(new Runnable(str, list) {
            /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$RhO6ePuzd8Iyw5s5QBjCvOrdVc */
            public final /* synthetic */ String f$1;
            public final /* synthetic */ List f$2;

            {
                this.f$1 = r2;
                this.f$2 = r3;
            }

            public final void run() {
                UCarDemoActivity.this.lambda$handleAppInstalled$33$UCarDemoActivity(this.f$1, this.f$2);
            }
        });
    }

    public /* synthetic */ void lambda$handleAppInstalled$33$UCarDemoActivity(String str, List list) {
        ArrayList<UCarCommon.AppDetailInfo> remoteAppDetailInfo = getRemoteAppDetailInfo(str, list, $$Lambda$UCarDemoActivity$IBraA5LsDreCmn5wuULrnD2T6ac.INSTANCE);
        if (remoteAppDetailInfo == null || remoteAppDetailInfo.size() <= 0) {
            Log.e(TAG, "app detail is null or empty");
            return;
        }
        synchronized (this.mLock) {
            this.mRemoteApps.addAll(remoteAppDetailInfo);
        }
        updateRemoteAppList();
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void handleAppRemoved(List<Integer> list) {
        runOnAsyncThread(new Runnable(list) {
            /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$Ji7wxYVr_g5e25SaXTlvjY6ckuw */
            public final /* synthetic */ List f$1;

            {
                this.f$1 = r2;
            }

            public final void run() {
                UCarDemoActivity.this.lambda$handleAppRemoved$35$UCarDemoActivity(this.f$1);
            }
        });
    }

    public /* synthetic */ void lambda$handleAppRemoved$35$UCarDemoActivity(List list) {
        synchronized (this.mLock) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.mRemoteApps.removeIf(new Predicate((Integer) it.next()) {
                    /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$GkKkRevb2_iDrf7ygwGp7gL0Ss */
                    public final /* synthetic */ Integer f$0;

                    {
                        this.f$0 = r1;
                    }

                    @Override // java.util.function.Predicate
                    public final boolean test(Object obj) {
                        return UCarDemoActivity.lambda$null$34(this.f$0, (UCarCommon.AppDetailInfo) obj);
                    }
                });
            }
        }
        updateRemoteAppList();
    }

    static /* synthetic */ boolean lambda$null$34(Integer num, UCarCommon.AppDetailInfo appDetailInfo) {
        return appDetailInfo.getGeneraIInfo().getAppId() == num.intValue();
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void handleAppUpdated(String str, List<Integer> list) {
        runOnAsyncThread(new Runnable(str, list) {
            /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$S3BEB67IIZay7CSulSq6typFAw */
            public final /* synthetic */ String f$1;
            public final /* synthetic */ List f$2;

            {
                this.f$1 = r2;
                this.f$2 = r3;
            }

            public final void run() {
                UCarDemoActivity.this.lambda$handleAppUpdated$37$UCarDemoActivity(this.f$1, this.f$2);
            }
        });
    }

    public /* synthetic */ void lambda$handleAppUpdated$37$UCarDemoActivity(String str, List list) {
        ArrayList<UCarCommon.AppDetailInfo> remoteAppDetailInfo = getRemoteAppDetailInfo(str, list, $$Lambda$UCarDemoActivity$N2oMxSwiwJzaYYUVDnhtxAUoAs0.INSTANCE);
        if (remoteAppDetailInfo == null || remoteAppDetailInfo.size() <= 0) {
            Log.e(TAG, "app detail is null or empty");
            return;
        }
        synchronized (this.mLock) {
            Iterator<UCarCommon.AppDetailInfo> it = remoteAppDetailInfo.iterator();
            while (it.hasNext()) {
                UCarCommon.AppDetailInfo next = it.next();
                int i = 0;
                while (true) {
                    if (i >= this.mRemoteApps.size()) {
                        break;
                    } else if (this.mRemoteApps.get(i).getGeneraIInfo().getAppId() == next.getGeneraIInfo().getAppId()) {
                        this.mRemoteApps.set(i, next);
                        break;
                    } else {
                        i++;
                    }
                }
            }
        }
        updateRemoteAppList();
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void handleAppReordered(List<Integer> list) {
        runOnAsyncThread(new Runnable(list) {
            /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$jHTsrVR6JoTOxYCKckRuh9Og95E */
            public final /* synthetic */ List f$1;

            {
                this.f$1 = r2;
            }

            public final void run() {
                UCarDemoActivity.this.lambda$handleAppReordered$38$UCarDemoActivity(this.f$1);
            }
        });
    }

    public /* synthetic */ void lambda$handleAppReordered$38$UCarDemoActivity(List list) {
        if (list == null || list.size() != this.mRemoteApps.size()) {
            Log.e(TAG, "the sorted app id list size must be equals to cached app list size");
            return;
        }
        synchronized (this.mLock) {
            ArrayList arrayList = new ArrayList(this.mRemoteApps.size());
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Integer num = (Integer) it.next();
                int i = 0;
                while (true) {
                    if (i >= this.mRemoteApps.size()) {
                        break;
                    }
                    UCarCommon.AppDetailInfo appDetailInfo = this.mRemoteApps.get(i);
                    if (appDetailInfo.getGeneraIInfo().getAppId() == num.intValue()) {
                        arrayList.add(appDetailInfo);
                        break;
                    }
                    i++;
                }
            }
            this.mRemoteApps.clear();
            this.mRemoteApps.addAll(arrayList);
        }
        updateRemoteAppList();
    }

    private void updateViewStateByConnectionState(boolean z) {
        Log.d(TAG, "updateViewStateByConnectionState : " + z);
        if (z) {
            refreshRemoteApps();
            return;
        }
        UCarCallWindow uCarCallWindow = this.mCallWindow;
        if (uCarCallWindow != null) {
            uCarCallWindow.hide();
        }
        synchronized (this.mLock) {
            this.mRemoteApps.clear();
        }
        showGuideFragment();
    }

    private void refreshRemoteApps() {
        Log.i(TAG, "refreshRemoteApps");
        runOnAsyncThread(new Runnable() {
            /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$DCphKecDGbFijcMeta8Vv8psYs */

            public final void run() {
                UCarDemoActivity.this.lambda$refreshRemoteApps$39$UCarDemoActivity();
            }
        });
    }

    public /* synthetic */ void lambda$refreshRemoteApps$39$UCarDemoActivity() {
        String str = this.mDeviceId;
        ArrayList<UCarCommon.AppGeneralInfo> appList = UCarAdapter.getInstance().getAppList(str);
        if (appList == null || appList.isEmpty()) {
            Log.e(TAG, "app list is null or empty");
            updateRemoteAppList();
            return;
        }
        ArrayList<UCarCommon.AppDetailInfo> remoteAppDetailInfo = getRemoteAppDetailInfo(str, appList, $$Lambda$UCarDemoActivity$MdlWLFYG6PnoxpnDgi2t531Qbo.INSTANCE);
        synchronized (this.mLock) {
            this.mRemoteApps.clear();
            if (remoteAppDetailInfo != null) {
                this.mRemoteApps.addAll(remoteAppDetailInfo);
            }
        }
        updateRemoteAppList();
    }

    private <T> ArrayList<UCarCommon.AppDetailInfo> getRemoteAppDetailInfo(String str, List<T> list, Function<T, Integer> function) {
        if (list.size() <= 20) {
            ArrayList arrayList = new ArrayList(list.size());
            for (T t : list) {
                arrayList.add(function.apply(t));
            }
            return UCarAdapter.getInstance().getAppDetailInfo(str, arrayList);
        }
        ArrayList<UCarCommon.AppDetailInfo> arrayList2 = new ArrayList<>();
        int size = list.size();
        int i = 0;
        while (i < size) {
            ArrayList arrayList3 = new ArrayList(Math.min(20, size - i));
            int i2 = 0;
            while (i < size && i2 < 20) {
                arrayList3.add(function.apply(list.get(i)));
                i++;
                i2++;
            }
            ArrayList<UCarCommon.AppDetailInfo> appDetailInfo = UCarAdapter.getInstance().getAppDetailInfo(str, arrayList3);
            if (appDetailInfo != null && appDetailInfo.size() > 0) {
                arrayList2.addAll(appDetailInfo);
            }
        }
        return arrayList2;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void handlePOIReceived(UCarCommon.POIAddress pOIAddress) {
        UCarCommon.POIDetailInfo detailInfo = pOIAddress.getDetailInfo();
        if (detailInfo == null || detailInfo.getType() != UCarCommon.CoordinateType.BD09) {
            if (!CoordinateUtil.tryLaunchGaodeMap(getApplicationContext(), pOIAddress) && !CoordinateUtil.tryLaunchBaiduMap(getApplicationContext(), pOIAddress)) {
                Toast.makeText(getApplicationContext(), (int) R.string.launch_map_app_failed, 0).show();
            }
        } else if (!CoordinateUtil.tryLaunchBaiduMap(getApplicationContext(), pOIAddress) && !CoordinateUtil.tryLaunchGaodeMap(getApplicationContext(), pOIAddress)) {
            Toast.makeText(getApplicationContext(), (int) R.string.launch_map_app_failed, 0).show();
        }
    }

    /* access modifiers changed from: protected */
    @Override // androidx.appcompat.app.AppCompatActivity, androidx.fragment.app.FragmentActivity
    public void onStart() {
        super.onStart();
        Log.d(TAG, "onStart");
    }

    /* access modifiers changed from: protected */
    @Override // androidx.fragment.app.FragmentActivity
    public void onResume() {
        super.onResume();
        String str = TAG;
        Log.i(str, "onResume");
        this.mIsActivityOnForeground = true;
        if (sIsServiceInitialized && !this.mIsCastSucceed && !this.mIsProgressShown) {
            Log.d(str, "start advertise and scan device");
            this.mHandler.sendEmptyMessage(102);
        }
        if (!this.mIsSupportAppFusion) {
            hideSystemUi();
        }
    }

    /* access modifiers changed from: protected */
    @Override // androidx.appcompat.app.AppCompatActivity, androidx.fragment.app.FragmentActivity
    public void onStop() {
        super.onStop();
        String str = TAG;
        Log.i(str, "onStop");
        this.mIsActivityOnForeground = false;
        if (!this.mIsCastSucceed) {
            Log.d(str, "stop advertise and scan device");
            this.mHandler.sendEmptyMessage(103);
        }
    }

    /* access modifiers changed from: protected */
    @Override // androidx.appcompat.app.AppCompatActivity, androidx.fragment.app.FragmentActivity
    public void onDestroy() {
        super.onDestroy();
        String str = TAG;
        Log.d(str, "onDestroy");
        UCarAlertView uCarAlertView = this.mDialog;
        if (uCarAlertView != null && uCarAlertView.isShowing()) {
            this.mDialog.dismiss();
        }
        this.mService.shutdown();
        CarBtConnector carBtConnector = this.mCarBtConnector;
        if (carBtConnector != null) {
            carBtConnector.release();
            this.mCarBtConnector = null;
        }
        unregisterCarEventListener();
        UCarAdapter.getInstance().deInit();
        Log.d(str, "exit process");
        System.exit(0);
    }

    /* access modifiers changed from: protected */
    @Override // androidx.fragment.app.FragmentActivity
    public void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        Log.i(TAG, "onNewIntent");
    }

    public void onWindowFocusChanged(boolean z) {
        super.onWindowFocusChanged(z);
        Log.d(TAG, "onWindowFocusChanged: " + z);
        if (z) {
            this.mHandler.postDelayed(new Runnable() {
                /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$RsoTGWu7jL0c14W72qdGVgpGvcM */

                public final void run() {
                    UCarDemoActivity.this.initUCarSDK();
                }
            }, 100);
            if (sIsServiceInitialized) {
                UCarAdapter.getInstance().allowGainAudioFocus();
            }
        }
    }

    @Override // androidx.activity.ComponentActivity
    public void onBackPressed() {
        if (!this.mIsCastSucceed || getSupportFragmentManager().findFragmentByTag(TAG_SURFACE_FRAGMENT) == null) {
            moveTaskToBack(true);
        }
    }

    private void checkCanDrawOverlays() {
        if (!Settings.canDrawOverlays(getApplicationContext())) {
            startActivityForResult(new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse("package:" + getPackageName())), 100);
        }
    }

    /* access modifiers changed from: protected */
    @Override // androidx.fragment.app.FragmentActivity
    public void onActivityResult(int i, int i2, Intent intent) {
        super.onActivityResult(i, i2, intent);
        checkCanDrawOverlays();
    }

    @Override // androidx.appcompat.app.AppCompatActivity, androidx.fragment.app.FragmentActivity
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        notifySwitchDayOrNight(configuration);
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void notifySwitchDayOrNight(Configuration configuration) {
        int i = configuration.uiMode & 48;
        if (i == 0 || i == 16) {
            UCarAdapter.getInstance().notifySwitchDayOrNight(UCarCommon.DayNightMode.DAY_MODE);
        } else if (i == 32) {
            UCarAdapter.getInstance().notifySwitchDayOrNight(UCarCommon.DayNightMode.NIGHT_MODE);
        }
    }

    private void changeStatusBarColor(int i) {
        getWindow().addFlags(Integer.MIN_VALUE);
        getWindow().clearFlags(67108864);
        getWindow().setStatusBarColor(i);
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void showSurfaceFragment(int i, int i2, int i3) {
        Log.i(TAG, "showSurfaceFragment");
        Fragment findFragmentByTag = getSupportFragmentManager().findFragmentByTag(TAG_SURFACE_FRAGMENT);
        int[] calcSurfaceWidthAndHeight = calcSurfaceWidthAndHeight(i2, i3);
        if (findFragmentByTag instanceof UCarSurfaceFragment) {
            ((UCarSurfaceFragment) findFragmentByTag).setParams(this.mDeviceId, i, calcSurfaceWidthAndHeight[0], calcSurfaceWidthAndHeight[1], this.mIsWorkInNormalCast);
            return;
        }
        UCarSurfaceFragment uCarSurfaceFragment = new UCarSurfaceFragment();
        uCarSurfaceFragment.setParams(this.mDeviceId, i, calcSurfaceWidthAndHeight[0], calcSurfaceWidthAndHeight[1], this.mIsWorkInNormalCast);
        FragmentTransaction beginTransaction = getSupportFragmentManager().beginTransaction();
        if (findFragmentByTag != null) {
            beginTransaction.remove(findFragmentByTag);
        }
        beginTransaction.add(R.id.fl_root, uCarSurfaceFragment, TAG_SURFACE_FRAGMENT).commitNowAllowingStateLoss();
        changeStatusBarColor(ContextCompat.getColor(getApplicationContext(), R.color.black));
        notifySwitchDayOrNight(getResources().getConfiguration());
    }

    private int[] calcSurfaceWidthAndHeight(int i, int i2) {
        float f = (float) i2;
        float f2 = (((float) i) * 1.0f) / f;
        int round = Math.round(f2 * f);
        int i3 = this.mFullDisplayHeight;
        if (i2 != i3) {
            round = Math.round((((float) i3) / f) * ((float) round));
            i2 = this.mFullDisplayHeight;
        }
        int i4 = this.mFullDisplayWidth;
        if (round > i4) {
            i2 = Math.round(((float) i4) / f2);
            round = i4;
        }
        return new int[]{round, i2};
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private boolean hideSurfaceFragment() {
        Log.i(TAG, "hideSurfaceFragment");
        Fragment findFragmentByTag = getSupportFragmentManager().findFragmentByTag(TAG_SURFACE_FRAGMENT);
        if (findFragmentByTag instanceof UCarSurfaceFragment) {
            ((UCarSurfaceFragment) findFragmentByTag).closeByRemote();
        }
        if (findFragmentByTag == null) {
            return false;
        }
        getSupportFragmentManager().beginTransaction().remove(findFragmentByTag).commitNowAllowingStateLoss();
        return true;
    }

    private void showGuideFragment() {
        Log.i(TAG, "showGuideFragment");
        AnonymousClass12 r0 = new View.OnClickListener() {
            /* class com.ucarhu.demo.UCarDemoActivity.AnonymousClass12 */
            private int mClickCount = 0;
            private long mLastClickMillis = 0;

            public void onClick(View view) {
                if (this.mLastClickMillis == 0) {
                    this.mClickCount++;
                } else if (System.currentTimeMillis() - this.mLastClickMillis > 550) {
                    this.mClickCount = 1;
                } else {
                    int i = this.mClickCount + 1;
                    this.mClickCount = i;
                    if (i >= 3) {
                        this.mClickCount = 0;
                        UCarDemoActivity.this.mHandler.sendEmptyMessage(103);
                        UCarDemoActivity.this.showEmulatorDialog();
                    }
                }
                this.mLastClickMillis = System.currentTimeMillis();
            }
        };
        Fragment findFragmentByTag = getSupportFragmentManager().findFragmentByTag(TAG_GUIDE_FRAGMENT);
        if (findFragmentByTag instanceof UCarGuideFragment) {
            ((UCarGuideFragment) findFragmentByTag).setParams(this.mHandler, r0);
            return;
        }
        UCarGuideFragment uCarGuideFragment = new UCarGuideFragment();
        uCarGuideFragment.setParams(this.mHandler, r0);
        FragmentTransaction beginTransaction = getSupportFragmentManager().beginTransaction();
        if (findFragmentByTag != null) {
            beginTransaction.remove(findFragmentByTag);
        }
        Fragment findFragmentByTag2 = getSupportFragmentManager().findFragmentByTag(TAG_SURFACE_FRAGMENT);
        if (findFragmentByTag2 != null) {
            beginTransaction.remove(findFragmentByTag2);
        }
        Fragment findFragmentByTag3 = getSupportFragmentManager().findFragmentByTag(TAG_APP_LIST_FRAGMENT);
        if (findFragmentByTag3 != null) {
            beginTransaction.remove(findFragmentByTag3);
        }
        beginTransaction.add(R.id.fl_root, uCarGuideFragment, TAG_GUIDE_FRAGMENT).commitNowAllowingStateLoss();
        changeStatusBarColor(ContextCompat.getColor(getApplicationContext(), R.color.bg_color));
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private boolean hideGuideFragment() {
        Log.i(TAG, "hideGuideFragment");
        Fragment findFragmentByTag = getSupportFragmentManager().findFragmentByTag(TAG_GUIDE_FRAGMENT);
        if (findFragmentByTag == null) {
            return false;
        }
        getSupportFragmentManager().beginTransaction().remove(findFragmentByTag).commitNowAllowingStateLoss();
        return true;
    }

    private void showAppListFragment(List<UCarPackageInfo> list) {
        Log.i(TAG, "showAppListFragment");
        Fragment findFragmentByTag = getSupportFragmentManager().findFragmentByTag(TAG_APP_LIST_FRAGMENT);
        Rect rect = new Rect();
        getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
        int width = rect.width();
        int height = rect.height();
        UCarCommon.MobileDevice mobileDevice = UCarAdapter.getInstance().getMobileDevice(this.mDeviceId);
        if (findFragmentByTag instanceof UCarAppListFragment) {
            ((UCarAppListFragment) findFragmentByTag).setParams(getApplicationContext(), this.mHandler, height, width, mobileDevice.getProductName(), list);
            return;
        }
        UCarAppListFragment uCarAppListFragment = new UCarAppListFragment();
        uCarAppListFragment.setParams(getApplicationContext(), this.mHandler, height, width, mobileDevice.getProductName(), list);
        FragmentTransaction beginTransaction = getSupportFragmentManager().beginTransaction();
        if (findFragmentByTag != null) {
            beginTransaction.remove(findFragmentByTag);
        }
        beginTransaction.add(R.id.fl_root, uCarAppListFragment, TAG_APP_LIST_FRAGMENT).commitNowAllowingStateLoss();
        changeStatusBarColor(ContextCompat.getColor(getApplicationContext(), R.color.black));
        UCarAdapter.getInstance().pauseCast();
    }

    private boolean hideAppListFragment() {
        Log.i(TAG, "hideAppListFragment");
        Fragment findFragmentByTag = getSupportFragmentManager().findFragmentByTag(TAG_APP_LIST_FRAGMENT);
        if (findFragmentByTag == null) {
            return false;
        }
        getSupportFragmentManager().beginTransaction().remove(findFragmentByTag).commitNowAllowingStateLoss();
        return true;
    }

    private void updateRemoteAppList() {
        Log.i(TAG, "updateRemoteAppList");
        runOnAsyncThread(new Runnable() {
            /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$s8MtZ9vhJE1jl3o9BxCYZCGnq3g */

            public final void run() {
                UCarDemoActivity.this.lambda$updateRemoteAppList$41$UCarDemoActivity();
            }
        });
    }

    public /* synthetic */ void lambda$updateRemoteAppList$41$UCarDemoActivity() {
        ArrayList arrayList = new ArrayList();
        synchronized (this.mLock) {
            Iterator<UCarCommon.AppDetailInfo> it = this.mRemoteApps.iterator();
            while (it.hasNext()) {
                UCarCommon.AppDetailInfo next = it.next();
                UCarPackageInfo uCarPackageInfo = new UCarPackageInfo();
                uCarPackageInfo.setId(next.getGeneraIInfo().getAppId());
                if (next.getIcon() != null && next.getIcon().length > 0) {
                    uCarPackageInfo.setIconSize(next.getIcon().length);
                    uCarPackageInfo.setIcon(BitmapFactory.decodeByteArray(next.getIcon(), 0, next.getIcon().length));
                }
                uCarPackageInfo.setPackageName(next.getPackageName());
                uCarPackageInfo.setName(next.getGeneraIInfo().getLabel());
                arrayList.add(uCarPackageInfo);
            }
        }
        if (!isFinishing() && !isDestroyed()) {
            runOnUiThread(new Runnable(arrayList) {
                /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$hyxqzb4L8j1pJvZiB1AdejCHVvg */
                public final /* synthetic */ List f$1;

                {
                    this.f$1 = r2;
                }

                public final void run() {
                    UCarDemoActivity.this.lambda$null$40$UCarDemoActivity(this.f$1);
                }
            });
        }
    }

    public /* synthetic */ void lambda$null$40$UCarDemoActivity(List list) {
        if (!this.mIsCastSucceed) {
            Log.w(TAG, "ucar device disconnected, ignore this operation");
        } else if (list.size() == 1 && ((UCarPackageInfo) list.get(0)).getId() == 0) {
            this.mIsWorkInNormalCast = true;
            UCarAdapter.getInstance().startApp(this.mDeviceId, 0, true);
        } else {
            this.mIsWorkInNormalCast = false;
            hideGuideFragment();
            showAppListFragment(list);
        }
    }

    private void runOnAsyncThread(Runnable runnable) {
        if (!this.mService.isShutdown()) {
            this.mService.submit(runnable);
        } else {
            Log.e(TAG, "thread pool executor has been shutdown");
        }
    }

    public byte[] getBluetoothMac() {
        byte[] bArr = new byte[6];
        String address = ((BluetoothManager) getSystemService("bluetooth")).getAdapter().getAddress();
        String str = TAG;
        Log.i(str, "car mac:" + address + ", is connected before:" + UCarAdapter.existedCarBluetoothMac(address, getApplicationContext()));
        if (address != null) {
            String[] split = address.split(":");
            for (int i = 0; i < split.length; i++) {
                bArr[i] = (byte) Integer.parseInt(split[i], 16);
            }
        } else {
            Log.e(str, "Temporarily use random numbers as IDs, only for testing");
            new Random().nextBytes(bArr);
        }
        return bArr;
    }

    private byte[] generateCarId() {
        SharedPreferences sharedPreferences = getSharedPreferences(CAR_ID_PREFS, 0);
        String string = sharedPreferences.getString(CAR_ID_KEY, "");
        if (TextUtils.isEmpty(string)) {
            byte[] bluetoothMac = getBluetoothMac();
            String encodeToString = Base64.getEncoder().encodeToString(bluetoothMac);
            sharedPreferences.edit().putString(CAR_ID_KEY, encodeToString).apply();
            Log.d(TAG, "raw id = " + Arrays.toString(bluetoothMac));
            string = encodeToString;
        }
        Log.d(TAG, "id = " + string);
        return Base64.getDecoder().decode(string);
    }

    private void initDisplayMetrics() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        getWindowManager().getDefaultDisplay().getRealMetrics(displayMetrics);
        String str = TAG;
        Log.d(str, "device dpi = " + displayMetrics.densityDpi);
        this.mDisplayDensityDpi = displayMetrics.densityDpi;
        Rect rect = new Rect();
        getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
        this.mFullDisplayWidth = Math.max(rect.width(), rect.height());
        this.mFullDisplayHeight = Math.min(rect.width(), rect.height());
        Log.d(str, "display frame width = " + this.mFullDisplayWidth + ", height = " + this.mFullDisplayHeight);
        this.mFullDisplayWidth = (this.mFullDisplayWidth / 16) * 16;
        this.mFullDisplayHeight = (this.mFullDisplayHeight / 16) * 16;
        Log.d(str, "aligned width = " + this.mFullDisplayWidth + ", height = " + this.mFullDisplayHeight);
        this.mExpectedDisplayWidth = this.mFullDisplayWidth;
        this.mExpectedDisplayHeight = this.mFullDisplayHeight;
        Log.d(str, "use metrics: width = " + this.mExpectedDisplayWidth + ", height = " + this.mExpectedDisplayHeight + ", dpi = " + this.mDisplayDensityDpi);
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void initUCarSDK() {
        if (!sIsServiceInitialized) {
            initDisplayMetrics();
            byte[] generateCarId = generateCarId();
            String str = TAG;
            Log.d(str, "carId = " + Arrays.toString(generateCarId));
            this.mUCarConfig = new UCarConfig.Builder().setCarBrMac(generateCarId).setDpi(this.mConfigure ? this.mExpectedDpiByUser : DISPLAY_DENSITY_DPI).setRealDpi(this.mDisplayDensityDpi).setFps(this.mConfigure ? this.mExpectedFpsByUser : 30).setScreenWidth(this.mFullDisplayWidth).setScreenHeight(this.mFullDisplayHeight).setVideoDisplayWidth(this.mConfigure ? this.mExpectedDisplayWidthByUser : this.mExpectedDisplayWidth).setVideoDisplayHeight(this.mConfigure ? this.mExpectedDisplayHeightByUser : this.mExpectedDisplayHeight).setSupportP2P(true).setSupportCamera(true).setSupportSoftAP(this.mIsSupportApConnect).setSupportStereoRecord(true).setSupportedWorkModes(new UCarCommon.WorkMode.Builder().setSupportNormalCast(true).setSupportAppFullScreenCast(this.mIsSupportAppFusion).setSupportAppWindowCast(this.mIsSupportAppFusion).build()).setSupportPOINav(this.mIsSupportPOINavi).setSupportHevc(this.mIsSupportHevc).setAllowed5gChannels(this.mAllowed5GChannels).build();
            if (!UCarAdapter.getInstance().init(getApplicationContext(), this.mUCarConfig, new ICarInitCallback() {
                /* class com.ucarhu.demo.UCarDemoActivity.AnonymousClass13 */

                @Override // com.ucar.vehiclesdk.ICarInitCallback
                public void onInitSuccess() {
                    Log.i(UCarDemoActivity.TAG, "UCarAdapter init success");
                    boolean unused = UCarDemoActivity.sIsServiceInitialized = true;
                    UCarDemoActivity.this.registerCarEventListener();
                    UCarDemoActivity.this.mHandler.sendEmptyMessage(102);
                    UCarDemoActivity uCarDemoActivity = UCarDemoActivity.this;
                    uCarDemoActivity.notifySwitchDayOrNight(uCarDemoActivity.getResources().getConfiguration());
                }

                @Override // com.ucar.vehiclesdk.ICarInitCallback
                public void onInitFailed(int i) {
                    Log.e(UCarDemoActivity.TAG, "UCarAdapter init failed");
                    UCarDemoActivity.this.mHandler.post(new Runnable(i) {
                        /* class com.ucarhu.demo.$$Lambda$UCarDemoActivity$13$fwVpEB0_73ZXQzcyoOCB3xuyT7I */
                        public final /* synthetic */ int f$1;

                        {
                            this.f$1 = r2;
                        }

                        public final void run() {
                            UCarDemoActivity.AnonymousClass13.this.lambda$onInitFailed$42$UCarDemoActivity$13(this.f$1);
                        }
                    });
                }

                public /* synthetic */ void lambda$onInitFailed$42$UCarDemoActivity$13(int i) {
                    UCarDemoActivity.this.handleConnectFailed(i);
                }
            })) {
                Log.e(str, "init ucar sdk failed");
                finish();
            }
        }
    }

    private void backToHome() {
        if (this.mIsWorkInNormalCast) {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.addCategory("android.intent.category.HOME");
            startActivity(intent);
            return;
        }
        hideSurfaceFragment();
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void backToForeground() {
        Intent intent = new Intent(getApplicationContext(), UCarDemoActivity.class);
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.setFlags(268435456);
        startActivity(intent);
    }

    @Override // androidx.appcompat.app.AppCompatActivity
    public boolean onKeyDown(int i, KeyEvent keyEvent) {
        Log.i(TAG, "onKeyDown: " + keyEvent.toString());
        UCarAdapter.getInstance().sendKeyEvent(UCarCommon.KeyEventActionType.KEY_EVENT_ACTION_DOWN, UCarCommon.KeyCodeType.fromInt(keyEvent.getKeyCode()), keyEvent.getMetaState());
        return super.onKeyDown(i, keyEvent);
    }

    public boolean onKeyUp(int i, KeyEvent keyEvent) {
        Log.i(TAG, "onKeyUp: " + keyEvent.toString() + ", event action: " + keyEvent.getAction() + ". event key code: " + keyEvent.getKeyCode());
        UCarAdapter.getInstance().sendKeyEvent(UCarCommon.KeyEventActionType.KEY_EVENT_ACTION_UP, UCarCommon.KeyCodeType.fromInt(keyEvent.getKeyCode()), keyEvent.getMetaState());
        return super.onKeyUp(i, keyEvent);
    }
}
