package com.ucarhu.demo;

import android.os.Bundle;
import android.util.Log;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import java.util.Arrays;

public abstract class PermissionsReqActivity extends AppCompatActivity {
    private static final int PERMISSION_REQUEST_CODE = 239;
    private String[] permissions = new String[0];

    /* access modifiers changed from: protected */
    public abstract String[] getPermissions();

    /* access modifiers changed from: protected */
    public abstract void onPermissionsDenied();

    /* access modifiers changed from: protected */
    public abstract void onPermissionsGranted();

    /* access modifiers changed from: protected */
    @Override // androidx.appcompat.app.AppCompatActivity
    public void onPostCreate(Bundle bundle) {
        super.onPostCreate(bundle);
        String[] permissions2 = getPermissions();
        this.permissions = permissions2;
        if (!checkSelfPermissions(permissions2)) {
            ActivityCompat.requestPermissions(this, this.permissions, PERMISSION_REQUEST_CODE);
        } else {
            onPermissionsGranted();
        }
    }

    @Override // androidx.core.app.ActivityCompat.OnRequestPermissionsResultCallback, androidx.fragment.app.FragmentActivity
    public final void onRequestPermissionsResult(int i, String[] strArr, int[] iArr) {
        super.onRequestPermissionsResult(i, strArr, iArr);
        Log.d(getClass().getSimpleName(), "onRequestPermissionsResult: " + Arrays.toString(iArr));
        if (checkSelfPermissions(this.permissions)) {
            onPermissionsGranted();
        } else {
            onPermissionsDenied();
        }
    }

    private boolean checkSelfPermissions(String[] strArr) {
        if (strArr == null) {
            return true;
        }
        for (String str : strArr) {
            if (ActivityCompat.checkSelfPermission(this, str) != 0) {
                Log.d(getClass().getSimpleName(), "checkSelfPermissions: " + str + " does not granted");
                return false;
            }
        }
        return true;
    }
}
