package com.ucarhu.demo.CarBt;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import com.ucar.vehiclesdk.UCarAdapter;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class CarBtConnector {
    private static final int A2DP_SINK = 11;
    private static final String ACTION_A2DP_CONNECTION_STATE_CHANGED = "android.bluetooth.a2dp-sink.profile.action.CONNECTION_STATE_CHANGED";
    private static final String ACTION_AUDIO_STATE_CHANGED = "android.bluetooth.headsetclient.profile.action.AUDIO_STATE_CHANGED";
    private static final String ACTION_HEADSET_CLIENT_CONNECTION_STATE_CHANGED = "android.bluetooth.headsetclient.profile.action.CONNECTION_STATE_CHANGED";
    private static final int HEADSET_CLIENT = 16;
    private static final String TAG = "CarBtConnector";
    private static Class<?> sBluetoothA2dpSinkClass;
    private static Class<?> sBluetoothHeadsetClientClass;
    private Object mBluetoothA2dpSink;
    private BluetoothAdapter mBluetoothAdapter;
    private final BroadcastReceiver mBluetoothEventReceiver;
    private Object mBluetoothHeadSetClient;
    private final Context mContext;
    private BluetoothDevice mDisconnectedA2dpDevice;
    private BluetoothDevice mDisconnectedHeadSetDevice;
    private final AtomicBoolean mNeedBondCarlinkDevice = new AtomicBoolean(false);
    private final AtomicBoolean mNeedConnectCarlinkDevice = new AtomicBoolean(false);
    private final AtomicBoolean mNeedDisconnectA2DP = new AtomicBoolean(false);
    private final AtomicBoolean mNeedDisconnectHFP = new AtomicBoolean(false);
    private final ExecutorService mService = Executors.newSingleThreadExecutor();

    static {
        try {
            sBluetoothA2dpSinkClass = Class.forName("android.bluetooth.BluetoothA2dpSink");
            sBluetoothHeadsetClientClass = Class.forName("android.bluetooth.BluetoothHeadsetClient");
        } catch (ClassNotFoundException e) {
            Log.e(TAG, "bluetooth a2dp sink class not found.", e);
        }
    }

    public CarBtConnector(Context context) {
        AnonymousClass1 r0 = new BroadcastReceiver() {
            /* class com.ucarhu.demo.CarBt.CarBtConnector.AnonymousClass1 */

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.bluetooth.device.action.FOUND".equals(action)) {
                    BluetoothDevice bluetoothDevice = (BluetoothDevice) intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    Log.i(CarBtConnector.TAG, "device name: " + bluetoothDevice.getName() + "\n" + "device address: " + bluetoothDevice.getAddress() + "\n");
                    if (UCarAdapter.getInstance().isConnectedMDevice(bluetoothDevice.getAddress())) {
                        CarBtConnector.this.tryBondCarlinkPhone(bluetoothDevice);
                    }
                } else if ("android.bluetooth.adapter.action.DISCOVERY_STARTED".equals(action)) {
                    Log.i(CarBtConnector.TAG, "discover started");
                } else if ("android.bluetooth.adapter.action.DISCOVERY_FINISHED".equals(action)) {
                    Log.i(CarBtConnector.TAG, "discover finished");
                } else if ("android.bluetooth.device.action.BOND_STATE_CHANGED".equals(action)) {
                    BluetoothDevice bluetoothDevice2 = (BluetoothDevice) intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    switch (bluetoothDevice2.getBondState()) {
                        case 10:
                            Log.d(CarBtConnector.TAG, "bond none");
                            return;
                        case 11:
                            Log.d(CarBtConnector.TAG, "bonding......");
                            return;
                        case 12:
                            Log.d(CarBtConnector.TAG, "bonded");
                            CarBtConnector.this.rethinkBtBonded(bluetoothDevice2);
                            return;
                        default:
                            return;
                    }
                } else if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(action)) {
                    int intExtra = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
                    Log.i(CarBtConnector.TAG, "bluetooth state changed, new status: " + intExtra);
                    if (intExtra == 12) {
                        CarBtConnector.this.rethinkBtStateOn();
                    } else if (intExtra == 10) {
                        CarBtConnector.this.rethinkBtStateOff();
                    }
                } else if ("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED".equals(action)) {
                    int intExtra2 = intent.getIntExtra("android.bluetooth.adapter.extra.CONNECTION_STATE", 0);
                    BluetoothDevice bluetoothDevice3 = (BluetoothDevice) intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    Log.i(CarBtConnector.TAG, "connection state changed, state: " + intExtra2 + " device name: " + bluetoothDevice3.getName() + ", device address: " + bluetoothDevice3.getAddress());
                    if (intExtra2 == 2) {
                        Log.i(CarBtConnector.TAG, "connection state changed, state: " + intExtra2 + " device name: " + bluetoothDevice3.getName() + ", device address: " + bluetoothDevice3.getAddress());
                        CarBtConnector.this.rethinkDeviceConnected(bluetoothDevice3);
                    }
                } else if ("android.bluetooth.device.action.ACL_CONNECTED".equals(action)) {
                    BluetoothDevice bluetoothDevice4 = (BluetoothDevice) intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    Log.i(CarBtConnector.TAG, "acl connected, device name:" + bluetoothDevice4.getName() + ", device address:" + bluetoothDevice4.getAddress());
                    CarBtConnector.this.rethinkACLConnected(bluetoothDevice4);
                } else if ("android.bluetooth.device.action.ACL_DISCONNECTED".equals(action)) {
                    Log.i(CarBtConnector.TAG, "acl disconnected");
                } else if (CarBtConnector.ACTION_AUDIO_STATE_CHANGED.equals(action)) {
                    Log.i(CarBtConnector.TAG, "head set audio status changed: " + intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0));
                } else if (CarBtConnector.ACTION_A2DP_CONNECTION_STATE_CHANGED.equals(action)) {
                    int intExtra3 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                    BluetoothDevice bluetoothDevice5 = (BluetoothDevice) intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    Log.i(CarBtConnector.TAG, "a2dpState changed, state: " + intExtra3 + " device name: " + bluetoothDevice5.getName() + ", device address: " + bluetoothDevice5.getAddress());
                    if (intExtra3 == 2) {
                        CarBtConnector.this.rethinkA2DPConnected(bluetoothDevice5);
                    }
                } else if (CarBtConnector.ACTION_HEADSET_CLIENT_CONNECTION_STATE_CHANGED.equals(action)) {
                    int intExtra4 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                    BluetoothDevice bluetoothDevice6 = (BluetoothDevice) intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    Log.i(CarBtConnector.TAG, "hfp changed, state: " + intExtra4 + " device name: " + bluetoothDevice6.getName() + ", device address: " + bluetoothDevice6.getAddress());
                    if (intExtra4 == 2) {
                        CarBtConnector.this.rethinkHFPConnected(bluetoothDevice6);
                    }
                }
            }
        };
        this.mBluetoothEventReceiver = r0;
        this.mContext = context;
        BluetoothManager bluetoothManager = (BluetoothManager) context.getSystemService("bluetooth");
        if (bluetoothManager != null) {
            this.mBluetoothAdapter = bluetoothManager.getAdapter();
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
        intentFilter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        intentFilter.addAction("android.bluetooth.device.action.FOUND");
        intentFilter.addAction("android.bluetooth.device.action.BOND_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
        intentFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        intentFilter.addAction("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        intentFilter.addAction(ACTION_AUDIO_STATE_CHANGED);
        intentFilter.addAction(ACTION_A2DP_CONNECTION_STATE_CHANGED);
        intentFilter.addAction(ACTION_HEADSET_CLIENT_CONNECTION_STATE_CHANGED);
        context.registerReceiver(r0, intentFilter);
    }

    private void runOnAsyncThread(Runnable runnable) {
        if (!this.mService.isShutdown()) {
            this.mService.submit(runnable);
        } else {
            Log.e(TAG, "thread pool executor has been shutdown");
        }
    }

    public void clearStatus() {
        this.mNeedBondCarlinkDevice.set(false);
        this.mNeedConnectCarlinkDevice.set(false);
        this.mNeedDisconnectA2DP.set(false);
        this.mNeedDisconnectHFP.set(false);
        this.mDisconnectedHeadSetDevice = null;
        this.mDisconnectedA2dpDevice = null;
    }

    public void release() {
        try {
            this.mContext.unregisterReceiver(this.mBluetoothEventReceiver);
        } catch (Exception unused) {
        }
        this.mService.shutdown();
        clearStatus();
    }

    public void tryConnectHFPToCarlinkPhone() {
        runOnAsyncThread(new Runnable() {
            /* class com.ucarhu.demo.CarBt.$$Lambda$CarBtConnector$DNsHSrd5GsqjJB3_0IakRPNLa0 */

            public final void run() {
                CarBtConnector.this.lambda$tryConnectHFPToCarlinkPhone$6$CarBtConnector();
            }
        });
    }

    public /* synthetic */ void lambda$tryConnectHFPToCarlinkPhone$6$CarBtConnector() {
        Log.i(TAG, "try connect carlink phone");
        if (this.mBluetoothAdapter != null) {
            this.mNeedDisconnectHFP.set(false);
            this.mNeedConnectCarlinkDevice.set(true);
            if (!this.mBluetoothAdapter.isEnabled()) {
                checkBtState();
            } else {
                tryConnectHFPToCarlinkPhoneInner();
            }
        }
    }

    public void stopHFP() {
        runOnAsyncThread(new Runnable() {
            /* class com.ucarhu.demo.CarBt.$$Lambda$CarBtConnector$Jwy5uo24TgOHh3VyzYuho4tLI */

            public final void run() {
                CarBtConnector.this.lambda$stopHFP$7$CarBtConnector();
            }
        });
    }

    public /* synthetic */ void lambda$stopHFP$7$CarBtConnector() {
        this.mNeedDisconnectHFP.set(true);
        if (isHFPConnect()) {
            Log.i(TAG, "HFP is connected, need stop");
            Log.i(TAG, "stop profile HFP, result: " + stopBluetoothHeadSetClient());
            return;
        }
        Log.i(TAG, "HFP is not connected, no need to stop profile HFP");
    }

    public void stopA2DP() {
        runOnAsyncThread(new Runnable() {
            /* class com.ucarhu.demo.CarBt.$$Lambda$CarBtConnector$xVEWUsqh2ThC0dMHtIvm0yXdR7Q */

            public final void run() {
                CarBtConnector.this.lambda$stopA2DP$8$CarBtConnector();
            }
        });
    }

    public /* synthetic */ void lambda$stopA2DP$8$CarBtConnector() {
        this.mNeedDisconnectA2DP.set(true);
        if (isA2DPSinkConnect()) {
            Log.i(TAG, "A2DP is connected, need stop");
            Log.i(TAG, "stop profile A2DP, result: " + stopBluetoothA2DPSink());
            return;
        }
        Log.i(TAG, "A2DP is not connected, no need to stop profile A2DP_SINK");
    }

    public void tryReconnectHFPIfNeed() {
        runOnAsyncThread(new Runnable() {
            /* class com.ucarhu.demo.CarBt.$$Lambda$CarBtConnector$xhX7zPh1lCj_G9njOrr1QPucfsM */

            public final void run() {
                CarBtConnector.this.lambda$tryReconnectHFPIfNeed$9$CarBtConnector();
            }
        });
    }

    public /* synthetic */ void lambda$tryReconnectHFPIfNeed$9$CarBtConnector() {
        this.mNeedDisconnectHFP.set(false);
        if (this.mDisconnectedHeadSetDevice != null) {
            connectBluetoothHeadSetClient(this.mDisconnectedA2dpDevice);
            this.mDisconnectedHeadSetDevice = null;
        }
    }

    public void tryReconnectA2DPIfNeed() {
        runOnAsyncThread(new Runnable() {
            /* class com.ucarhu.demo.CarBt.$$Lambda$CarBtConnector$Vf1aTDN5NABnuOCa5TqdgAJWiw */

            public final void run() {
                CarBtConnector.this.lambda$tryReconnectA2DPIfNeed$10$CarBtConnector();
            }
        });
    }

    public /* synthetic */ void lambda$tryReconnectA2DPIfNeed$10$CarBtConnector() {
        this.mNeedDisconnectA2DP.set(false);
        BluetoothDevice bluetoothDevice = this.mDisconnectedA2dpDevice;
        if (bluetoothDevice != null) {
            connectBluetoothA2DPSink(bluetoothDevice);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void tryBondCarlinkPhone(BluetoothDevice bluetoothDevice) {
        runOnAsyncThread(new Runnable(bluetoothDevice) {
            /* class com.ucarhu.demo.CarBt.$$Lambda$CarBtConnector$uF7wlPl5BVaVC7w6HPYgUp4CpU */
            public final /* synthetic */ BluetoothDevice f$1;

            {
                this.f$1 = r2;
            }

            public final void run() {
                CarBtConnector.this.lambda$tryBondCarlinkPhone$11$CarBtConnector(this.f$1);
            }
        });
    }

    public /* synthetic */ void lambda$tryBondCarlinkPhone$11$CarBtConnector(BluetoothDevice bluetoothDevice) {
        if (this.mNeedBondCarlinkDevice.get()) {
            Log.i(TAG, "try bond mobile phone");
            this.mBluetoothAdapter.cancelDiscovery();
            Log.i(TAG, "try bond mobile phone result: " + createBond(bluetoothDevice));
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void rethinkDeviceConnected(BluetoothDevice bluetoothDevice) {
        runOnAsyncThread(new Runnable(bluetoothDevice) {
            /* class com.ucarhu.demo.CarBt.$$Lambda$CarBtConnector$ew7gTpvKvtefBmSr0p58ocNQz8 */
            public final /* synthetic */ BluetoothDevice f$1;

            {
                this.f$1 = r2;
            }

            public final void run() {
                CarBtConnector.this.lambda$rethinkDeviceConnected$12$CarBtConnector(this.f$1);
            }
        });
    }

    public /* synthetic */ void lambda$rethinkDeviceConnected$12$CarBtConnector(BluetoothDevice bluetoothDevice) {
        if (UCarAdapter.getInstance().isConnectedMDevice(bluetoothDevice.getAddress())) {
            Log.i(TAG, "connect to carlink device success");
            this.mNeedConnectCarlinkDevice.set(false);
            if (this.mNeedDisconnectA2DP.get()) {
                Log.i(TAG, "try stop A2DP profile of carlink device");
                Log.i(TAG, "stop A2DP profile of carlink device, result: " + stopBluetoothA2DPSink());
                return;
            }
            return;
        }
        Log.i(TAG, "user manually connected a new device, no need to reconnect carlink device when disconnected");
        clearStatus();
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void rethinkBtStateOn() {
        runOnAsyncThread(new Runnable() {
            /* class com.ucarhu.demo.CarBt.$$Lambda$CarBtConnector$uf9Nv6v7O_LUytbOlSK2jqfSW58 */

            public final void run() {
                CarBtConnector.this.lambda$rethinkBtStateOn$13$CarBtConnector();
            }
        });
    }

    public /* synthetic */ void lambda$rethinkBtStateOn$13$CarBtConnector() {
        if (this.mNeedConnectCarlinkDevice.get()) {
            tryConnectHFPToCarlinkPhoneInner();
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void rethinkBtStateOff() {
        runOnAsyncThread(new Runnable() {
            /* class com.ucarhu.demo.CarBt.$$Lambda$gGbMQ9S7mH8zd5UIfPLAiyN18zQ */

            public final void run() {
                CarBtConnector.this.clearStatus();
            }
        });
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void rethinkBtBonded(BluetoothDevice bluetoothDevice) {
        runOnAsyncThread(new Runnable(bluetoothDevice) {
            /* class com.ucarhu.demo.CarBt.$$Lambda$CarBtConnector$RnA_9iokI3W2pf7uP7R34sizyk */
            public final /* synthetic */ BluetoothDevice f$1;

            {
                this.f$1 = r2;
            }

            public final void run() {
                CarBtConnector.this.lambda$rethinkBtBonded$14$CarBtConnector(this.f$1);
            }
        });
    }

    public /* synthetic */ void lambda$rethinkBtBonded$14$CarBtConnector(BluetoothDevice bluetoothDevice) {
        if (this.mNeedBondCarlinkDevice.compareAndSet(true, false) && UCarAdapter.getInstance().isConnectedMDevice(bluetoothDevice.getAddress())) {
            connectBluetoothHeadSetClient(bluetoothDevice);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void rethinkACLConnected(BluetoothDevice bluetoothDevice) {
        rethinkDeviceConnected(bluetoothDevice);
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void rethinkA2DPConnected(BluetoothDevice bluetoothDevice) {
        runOnAsyncThread(new Runnable(bluetoothDevice) {
            /* class com.ucarhu.demo.CarBt.$$Lambda$CarBtConnector$WtNUR1yCT3u47UkkswFfLDznH8 */
            public final /* synthetic */ BluetoothDevice f$1;

            {
                this.f$1 = r2;
            }

            public final void run() {
                CarBtConnector.this.lambda$rethinkA2DPConnected$15$CarBtConnector(this.f$1);
            }
        });
    }

    public /* synthetic */ void lambda$rethinkA2DPConnected$15$CarBtConnector(BluetoothDevice bluetoothDevice) {
        if (!UCarAdapter.getInstance().isConnectedMDevice(bluetoothDevice.getAddress())) {
            Log.i(TAG, "current connected a2dp device is not connected carlink device");
        } else if (this.mNeedDisconnectA2DP.get()) {
            stopBluetoothA2DPSink();
        } else {
            Log.i(TAG, "no need to disconnect A2DP");
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void rethinkHFPConnected(BluetoothDevice bluetoothDevice) {
        runOnAsyncThread(new Runnable(bluetoothDevice) {
            /* class com.ucarhu.demo.CarBt.$$Lambda$CarBtConnector$DyOaPYvHN9t9nYAYqGla695d8i0 */
            public final /* synthetic */ BluetoothDevice f$1;

            {
                this.f$1 = r2;
            }

            public final void run() {
                CarBtConnector.this.lambda$rethinkHFPConnected$16$CarBtConnector(this.f$1);
            }
        });
    }

    public /* synthetic */ void lambda$rethinkHFPConnected$16$CarBtConnector(BluetoothDevice bluetoothDevice) {
        if (UCarAdapter.getInstance().isConnectedMDevice(bluetoothDevice.getAddress()) && this.mNeedDisconnectHFP.get()) {
            stopBluetoothHeadSetClient();
        }
    }

    private boolean isHFPConnect() {
        int profileConnectionState = this.mBluetoothAdapter.getProfileConnectionState(16);
        if (profileConnectionState == 2) {
            Log.i(TAG, "HFP CLIENT already connected");
            return true;
        }
        Log.i(TAG, "HFP CLIENT not connected, " + profileConnectionState);
        return false;
    }

    private boolean isA2DPSinkConnect() {
        int profileConnectionState = this.mBluetoothAdapter.getProfileConnectionState(11);
        if (profileConnectionState == 2) {
            Log.i(TAG, "A2DP SINK already connected");
            return true;
        }
        Log.i(TAG, "A2DP SINK not connected, " + profileConnectionState);
        return false;
    }

    private void checkBtState() {
        BluetoothAdapter bluetoothAdapter = this.mBluetoothAdapter;
        if (bluetoothAdapter != null && !bluetoothAdapter.isEnabled()) {
            Log.i(TAG, "Enabling Bluetooth Action: " + this.mBluetoothAdapter.enable());
        }
    }

    private void startDiscover() {
        if (this.mBluetoothAdapter.isDiscovering()) {
            this.mBluetoothAdapter.cancelDiscovery();
        }
        this.mBluetoothAdapter.startDiscovery();
    }

    public boolean createBond(BluetoothDevice bluetoothDevice) {
        try {
            return ((Boolean) BluetoothDevice.class.getMethod("createBond", new Class[0]).invoke(bluetoothDevice, new Object[0])).booleanValue();
        } catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Log.e(TAG, "createBond exception", e);
            return false;
        }
    }

    private BluetoothProfile getProfileProxy(final int i) {
        Log.i(TAG, "getProfileProxy: " + i);
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final BluetoothProfile[] bluetoothProfileArr = {null};
        this.mBluetoothAdapter.getProfileProxy(this.mContext, new BluetoothProfile.ServiceListener() {
            /* class com.ucarhu.demo.CarBt.CarBtConnector.AnonymousClass2 */

            public void onServiceConnected(int i, BluetoothProfile bluetoothProfile) {
                Log.i(CarBtConnector.TAG, "onServiceConnected, profile = " + i);
                bluetoothProfileArr[0] = bluetoothProfile;
                countDownLatch.countDown();
            }

            public void onServiceDisconnected(int i) {
                if (i == i) {
                    Log.i(CarBtConnector.TAG, "onServiceDisconnected, profile = " + i);
                }
            }
        }, i);
        try {
            if (countDownLatch.await(10, TimeUnit.SECONDS)) {
                Log.i(TAG, "getProfileProxy: " + i + " success");
                return bluetoothProfileArr[0];
            }
            Log.i(TAG, "getProfileProxy: " + i + " failed");
            return null;
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void tryConnectHFPToCarlinkPhoneInner() {
        int connectionState = getConnectionState(this.mBluetoothAdapter);
        if (connectionState == 1 || connectionState == 2) {
            Log.d(TAG, "There is already a connected hfp device, can't connect carlink phone");
            this.mNeedConnectCarlinkDevice.set(false);
            return;
        }
        BluetoothDevice carlinkDeviceIfBonded = getCarlinkDeviceIfBonded();
        if (carlinkDeviceIfBonded == null) {
            this.mNeedBondCarlinkDevice.set(true);
            startDiscover();
            return;
        }
        connectBluetoothHeadSetClient(carlinkDeviceIfBonded);
    }

    private BluetoothDevice getCarlinkDeviceIfBonded() {
        for (BluetoothDevice bluetoothDevice : this.mBluetoothAdapter.getBondedDevices()) {
            if (UCarAdapter.getInstance().isConnectedMDevice(bluetoothDevice.getAddress())) {
                return bluetoothDevice;
            }
        }
        return null;
    }

    private boolean stopBluetoothA2DPSink() {
        BluetoothProfile profileProxy = getProfileProxy(11);
        this.mBluetoothA2dpSink = profileProxy;
        if (profileProxy == null) {
            return false;
        }
        try {
            List list = (List) sBluetoothA2dpSinkClass.getMethod("getConnectedDevices", new Class[0]).invoke(this.mBluetoothA2dpSink, new Object[0]);
            if (list == null) {
                return false;
            }
            BluetoothDevice bluetoothDevice = null;
            Iterator it = list.iterator();
            while (true) {
                if (!it.hasNext()) {
                    break;
                }
                BluetoothDevice bluetoothDevice2 = (BluetoothDevice) it.next();
                Log.d(TAG, "A2DP profile connected device, name: " + bluetoothDevice2.getName() + ", address: " + bluetoothDevice2.getAddress());
                if (UCarAdapter.getInstance().isConnectedMDevice(bluetoothDevice2.getAddress())) {
                    bluetoothDevice = bluetoothDevice2;
                    break;
                }
            }
            if (bluetoothDevice != null) {
                try {
                    boolean booleanValue = ((Boolean) sBluetoothA2dpSinkClass.getMethod("disconnect", BluetoothDevice.class).invoke(this.mBluetoothA2dpSink, bluetoothDevice)).booleanValue();
                    if (booleanValue) {
                        this.mDisconnectedA2dpDevice = bluetoothDevice;
                    }
                    return booleanValue;
                } catch (Exception e) {
                    Log.e(TAG, "disconnect a2dp sink exception.", e);
                }
            }
            Log.i(TAG, "A2DP profile of carlink device is not already connected");
            return false;
        } catch (Exception e2) {
            Log.e(TAG, "get connected devices exception.", e2);
            return false;
        }
    }

    private boolean stopBluetoothHeadSetClient() {
        BluetoothProfile profileProxy = getProfileProxy(16);
        this.mBluetoothHeadSetClient = profileProxy;
        if (profileProxy == null) {
            return false;
        }
        try {
            List list = (List) sBluetoothHeadsetClientClass.getMethod("getConnectedDevices", new Class[0]).invoke(this.mBluetoothHeadSetClient, new Object[0]);
            if (list == null) {
                return false;
            }
            BluetoothDevice bluetoothDevice = null;
            Iterator it = list.iterator();
            while (true) {
                if (!it.hasNext()) {
                    break;
                }
                BluetoothDevice bluetoothDevice2 = (BluetoothDevice) it.next();
                if (UCarAdapter.getInstance().isConnectedMDevice(bluetoothDevice2.getAddress())) {
                    bluetoothDevice = bluetoothDevice2;
                    break;
                }
            }
            if (bluetoothDevice != null) {
                try {
                    boolean stopBluetoothHeadSetClientInner = stopBluetoothHeadSetClientInner(this.mBluetoothHeadSetClient, bluetoothDevice);
                    if (stopBluetoothHeadSetClientInner) {
                        this.mDisconnectedHeadSetDevice = bluetoothDevice;
                    }
                    return stopBluetoothHeadSetClientInner;
                } catch (Exception e) {
                    Log.e(TAG, "disconnect headset client exception.", e);
                }
            }
            Log.i(TAG, "HEADSET profile of carlink device is not already connected");
            return false;
        } catch (Exception e2) {
            Log.e(TAG, "get connected devices exception.", e2);
            return false;
        }
    }

    private boolean stopBluetoothHeadSetClientInner(Object obj, BluetoothDevice bluetoothDevice) {
        try {
            return ((Boolean) sBluetoothHeadsetClientClass.getMethod("disconnect", BluetoothDevice.class).invoke(obj, bluetoothDevice)).booleanValue();
        } catch (Exception e) {
            Log.e(TAG, "disconnect headset client exception.", e);
            return false;
        }
    }

    private boolean connectBluetoothHeadSetClient(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice != null) {
            Log.d(TAG, "try connect hfp device, address: " + bluetoothDevice.getAddress());
            BluetoothProfile profileProxy = getProfileProxy(16);
            this.mBluetoothHeadSetClient = profileProxy;
            if (profileProxy == null) {
                return false;
            }
            try {
                return ((Boolean) sBluetoothHeadsetClientClass.getMethod("connect", BluetoothDevice.class).invoke(this.mBluetoothHeadSetClient, bluetoothDevice)).booleanValue();
            } catch (Exception e) {
                Log.e(TAG, "connect headset client exception.", e);
            }
        }
        return false;
    }

    private boolean connectBluetoothA2DPSink(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice != null) {
            Log.d(TAG, "try connect a2dp device, address: " + bluetoothDevice.getAddress());
            BluetoothProfile profileProxy = getProfileProxy(11);
            this.mBluetoothA2dpSink = profileProxy;
            if (profileProxy == null) {
                return false;
            }
            try {
                return ((Boolean) sBluetoothA2dpSinkClass.getMethod("connect", BluetoothDevice.class).invoke(this.mBluetoothA2dpSink, bluetoothDevice)).booleanValue();
            } catch (Exception e) {
                Log.e(TAG, "connect a2dp sink exception.", e);
            }
        }
        return false;
    }

    private int getConnectionState(BluetoothAdapter bluetoothAdapter) {
        try {
            return ((Integer) BluetoothAdapter.class.getMethod("getConnectionState", new Class[0]).invoke(bluetoothAdapter, new Object[0])).intValue();
        } catch (Exception e) {
            Log.e(TAG, "connect a2dp sink exception.", e);
            return 0;
        }
    }
}
