package com.ucar.vehiclesdk.recorder;

import android.os.Parcel;
import android.os.Parcelable;
import com.ucar.databus.proto.UCarProto;
import com.ucar.vehiclesdk.UCarCommon;

public class AudioConfig implements Parcelable {
    public static final Parcelable.Creator<AudioConfig> CREATOR = new a();
    private int mChannel = 3;
    private int mFormat = 2;
    private int mSampleRate = UCarProto.SampleRate.SAMPLE_RATE_8000_VALUE;
    private int mSource = 3;

    public class a implements Parcelable.Creator<AudioConfig> {
        /* renamed from: a */
        public AudioConfig createFromParcel(Parcel parcel) {
            return new AudioConfig(parcel);
        }

        /* renamed from: a */
        public AudioConfig[] newArray(int i) {
            return new AudioConfig[i];
        }
    }

    public AudioConfig(int i, int i2, int i3, int i4) {
        this.mSampleRate = i;
        this.mFormat = i2;
        this.mSource = i3;
        this.mChannel = i4;
    }

    public AudioConfig(Parcel parcel) {
        this.mSampleRate = parcel.readInt();
        this.mFormat = parcel.readInt();
        this.mSource = parcel.readInt();
        this.mChannel = parcel.readInt();
    }

    public static AudioConfig getCarConfig(UCarCommon.AudioFormat audioFormat) {
        return new AudioConfig(audioFormat.getSampleRate(), audioFormat.getEncodingFormat(), 1, audioFormat.getChannelConfig());
    }

    public int describeContents() {
        return 0;
    }

    public int getChannel() {
        return this.mChannel;
    }

    public int getFormat() {
        return this.mFormat;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int getSource() {
        return this.mSource;
    }

    public void setChannel(int i) {
        this.mChannel = i;
    }

    public void setFormat(int i) {
        this.mFormat = i;
    }

    public void setSampleRate(int i) {
        this.mSampleRate = i;
    }

    public void setSource(int i) {
        this.mSource = i;
    }

    public String toString() {
        return "AudioConfig{sample rate=" + this.mSampleRate + ", format=" + this.mFormat + ", source=" + this.mSource + ", channel=" + this.mChannel + '}';
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(this.mSampleRate);
        parcel.writeInt(this.mFormat);
        parcel.writeInt(this.mSource);
        parcel.writeInt(this.mChannel);
    }
}
