package com.ucar.vehiclesdk;

import a.a.a.b;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.ucar.vehiclesdk.UCarCommon;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.util.Arrays;

public class UCarConfig implements Parcelable {
    private static final int BR_MAC_SIZE = 6;
    private static final int CAR_CUSTOM_FIELD_SIZE = 2;
    public static final Parcelable.Creator<UCarConfig> CREATOR = new Parcelable.Creator<UCarConfig>() {
        /* class com.ucar.vehiclesdk.UCarConfig.AnonymousClass1 */

        @Override // android.os.Parcelable.Creator
        public UCarConfig createFromParcel(Parcel parcel) {
            return new UCarConfig(parcel);
        }

        @Override // android.os.Parcelable.Creator
        public UCarConfig[] newArray(int i) {
            return new UCarConfig[i];
        }
    };
    private static final int DEFAULT_ADVERTISING_RSSI_THRESHOLD = -60;
    private static final int DEFAULT_DPI = 320;
    private static final int DEFAULT_FPS = 30;
    private static final int MAX_5G_CHANNEL = 165;
    private static final int MAX_DPI = 640;
    private static final int MAX_FPS = 60;
    private static final int MAX_PASSWORD_BYTES = 63;
    private static final int MAX_SSID_BYTES = 32;
    private static final int MIN_5G_CHANNEL = 36;
    private static final int MIN_ADVERTISING_RSSI_THRESHOLD = -80;
    private static final int MIN_DPI = 120;
    private static final int MIN_FPS = 15;
    private static final int MIN_PASSWORD_BYTES = 8;
    private static final int MIN_SSID_BYTES = 9;
    private static final String TAG = "UCarConfig";
    private int[] mAllowed5gChannels;
    private int mBleRSSIThreshold;
    private byte[] mCarBrMac;
    private byte[] mCarCustomField;
    private String mCcdFilePath;
    private int mDpi;
    private int mFps;
    private boolean mIsApStaCoexist;
    private boolean mIsReconfigureWifi;
    private boolean mIsSupportBackKey;
    private boolean mIsSupportCamera;
    private boolean mIsSupportHevc;
    private boolean mIsSupportHomeKey;
    private boolean mIsSupportLowLatencyDecodingMode;
    private boolean mIsSupportMic;
    private boolean mIsSupportP2P;
    private boolean mIsSupportPOINav;
    private boolean mIsSupportRealWifiAddress;
    private boolean mIsSupportRotation;
    private boolean mIsSupportSoftAP;
    private boolean mIsSupportStereoRecord;
    private boolean mIsSupportVoiceWaken;
    private String mPassword;
    private int mRealDpi;
    private int mScreenHeight;
    private int mScreenWidth;
    private String mSsid;
    private UCarCommon.WorkMode mSupportWorkModes;
    private int mVideoDisplayHeight;
    private int mVideoDisplayWidth;

    public static class Builder {
        private boolean A = false;
        private boolean B = false;
        private boolean C = false;
        private boolean D = false;

        /* renamed from: a  reason: collision with root package name */
        private byte[] f229a = new byte[6];
        private int b;
        private int c;
        private int d = 320;
        private int e = 320;
        private int f;
        private int g;
        private int h = 30;
        private boolean i = true;
        private boolean j = false;
        private boolean k = false;
        private String l;
        private String m;
        private boolean n = false;
        private int[] o = {36, 40, 44, 48, 149, 153, 157, 161, 165};
        private boolean p = false;
        private boolean q = true;
        private boolean r = true;
        private boolean s = true;
        private boolean t = true;
        private byte[] u = new byte[2];
        private boolean v = true;
        private String w;
        private boolean x = false;
        private UCarCommon.WorkMode y = UCarCommon.WorkMode.NORMAL_CAST;
        private int z = UCarConfig.DEFAULT_ADVERTISING_RSSI_THRESHOLD;

        public UCarConfig build() {
            return new UCarConfig(this);
        }

        public Builder from(UCarConfig uCarConfig) {
            this.f229a = uCarConfig.mCarBrMac;
            this.b = uCarConfig.mScreenWidth;
            this.c = uCarConfig.mScreenHeight;
            this.d = uCarConfig.mDpi;
            this.e = uCarConfig.mRealDpi;
            this.f = uCarConfig.mVideoDisplayWidth;
            this.g = uCarConfig.mVideoDisplayHeight;
            this.h = uCarConfig.mFps;
            this.i = uCarConfig.mIsSupportP2P;
            this.j = uCarConfig.mIsSupportSoftAP;
            this.k = uCarConfig.mIsApStaCoexist;
            this.l = uCarConfig.mSsid;
            this.m = uCarConfig.mPassword;
            this.o = uCarConfig.mAllowed5gChannels;
            this.p = uCarConfig.mIsSupportCamera;
            this.q = uCarConfig.mIsSupportMic;
            this.r = uCarConfig.mIsSupportLowLatencyDecodingMode;
            this.u = uCarConfig.mCarCustomField;
            this.v = uCarConfig.mIsSupportStereoRecord;
            this.w = uCarConfig.mCcdFilePath;
            this.x = uCarConfig.mIsSupportPOINav;
            this.y = uCarConfig.mSupportWorkModes;
            this.z = uCarConfig.mBleRSSIThreshold;
            this.A = uCarConfig.mIsSupportRotation;
            this.B = uCarConfig.mIsSupportHomeKey;
            this.C = uCarConfig.mIsSupportBackKey;
            this.D = uCarConfig.mIsSupportHevc;
            return this;
        }

        public Builder setAllowed5gChannels(int[] iArr) {
            if (iArr == null || iArr.length == 0) {
                throw new InvalidParameterException("channels can't be null");
            }
            Arrays.sort(iArr);
            if (iArr[0] < 36 || iArr[iArr.length - 1] > 165) {
                throw new InvalidParameterException("5G channel must be between 36 and 165");
            }
            this.o = iArr;
            return this;
        }

        public Builder setApStaCoexist(boolean z2) {
            this.k = z2;
            return this;
        }

        public Builder setBleRSSIThreshold(int i2) {
            if (i2 >= 0) {
                b.b(UCarConfig.TAG, "The bluetooth rssi threshold must be negative value!");
                throw new InvalidParameterException("Bluetooth rssi threshold is invalid");
            } else if (i2 > UCarConfig.MIN_ADVERTISING_RSSI_THRESHOLD) {
                this.z = i2;
                return this;
            } else {
                b.b(UCarConfig.TAG, "The bluetooth rssi threshold can not be less than -80");
                throw new InvalidParameterException("Bluetooth rssi threshold is invalid");
            }
        }

        public Builder setCarBrMac(byte[] bArr) {
            if (bArr == null || bArr.length != 6) {
                b.b(UCarConfig.TAG, "Car Br Mac is invalid, the length must be 6 size!");
                throw new InvalidParameterException("Car Br Mac is invalid");
            }
            System.arraycopy(bArr, 0, this.f229a, 0, 6);
            return this;
        }

        public Builder setCarCustomField(byte[] bArr) {
            if (bArr == null || bArr.length != 2) {
                b.b(UCarConfig.TAG, "Car custom filed is invalid, the length must be 2 size!");
                throw new InvalidParameterException("Car custom filed is invalid");
            }
            System.arraycopy(bArr, 0, this.u, 0, 2);
            return this;
        }

        public Builder setCcdFilePath(String str) {
            this.w = str;
            return this;
        }

        public Builder setDataTransMode(boolean z2) {
            b.b(UCarConfig.TAG, "On current protocol calls this method is not effect");
            return this;
        }

        public Builder setDpi(int i2) {
            if (i2 < 120 || i2 > UCarConfig.MAX_DPI) {
                throw new InvalidParameterException("dpi must be between 120 and 640");
            }
            this.d = i2;
            return this;
        }

        public Builder setFps(int i2) {
            if (i2 < 15 || i2 > 60) {
                throw new InvalidParameterException("fps must be between 15 and 60");
            }
            this.h = i2;
            return this;
        }

        public Builder setRealDpi(int i2) {
            if (i2 < 120 || i2 > UCarConfig.MAX_DPI) {
                throw new InvalidParameterException("real dpi must be between 120 and 640");
            }
            this.e = i2;
            return this;
        }

        public Builder setReconfigureWifi(boolean z2) {
            this.n = z2;
            return this;
        }

        public Builder setScreenHeight(int i2) {
            if (i2 >= 0) {
                this.c = i2;
                return this;
            }
            throw new InvalidParameterException("screen height cannot be negative!");
        }

        public Builder setScreenWidth(int i2) {
            if (i2 >= 0) {
                this.b = i2;
                return this;
            }
            throw new InvalidParameterException("screen width cannot be negative!");
        }

        public Builder setSupportBackKey(boolean z2) {
            this.C = z2;
            return this;
        }

        public Builder setSupportCamera(boolean z2) {
            this.p = z2;
            return this;
        }

        public Builder setSupportHevc(boolean z2) {
            this.D = z2;
            return this;
        }

        public Builder setSupportHomeKey(boolean z2) {
            this.B = z2;
            return this;
        }

        public Builder setSupportLowLatencyDecodingMode(boolean z2) {
            this.r = z2;
            return this;
        }

        public Builder setSupportMic(boolean z2) {
            this.q = z2;
            return this;
        }

        public Builder setSupportP2P(boolean z2) {
            this.i = z2;
            return this;
        }

        public Builder setSupportPOINav(boolean z2) {
            this.x = z2;
            return this;
        }

        public Builder setSupportRealWifiAddress(boolean z2) {
            this.t = z2;
            return this;
        }

        public Builder setSupportRotation(boolean z2) {
            this.A = z2;
            return this;
        }

        public Builder setSupportSoftAP(boolean z2) {
            this.j = z2;
            return this;
        }

        public Builder setSupportStereoRecord(boolean z2) {
            this.v = z2;
            return this;
        }

        public Builder setSupportVoiceWaken(boolean z2) {
            this.s = z2;
            return this;
        }

        public Builder setSupportedWorkModes(UCarCommon.WorkMode workMode) {
            this.y = workMode;
            return this;
        }

        public Builder setVideoDisplayHeight(int i2) {
            if (i2 >= 0) {
                this.g = i2;
                return this;
            }
            throw new InvalidParameterException("video display height cannot be negative!");
        }

        public Builder setVideoDisplayWidth(int i2) {
            if (i2 >= 0) {
                this.f = i2;
                return this;
            }
            throw new InvalidParameterException("video display height cannot be negative!");
        }

        public Builder setWifiPassword(String str) {
            if (TextUtils.isEmpty(str)) {
                throw new IllegalArgumentException("passphrase must be non-empty.");
            } else if (str.length() < 8 || str.length() > 63) {
                throw new IllegalArgumentException("The length of a passphrase must be between 8 and 63");
            } else {
                this.m = str;
                return this;
            }
        }

        public Builder setWifiSsid(String str) {
            if (TextUtils.isEmpty(str)) {
                throw new IllegalArgumentException("ssid must be non-empty.");
            } else if (str.getBytes(StandardCharsets.UTF_8).length < 9 || str.getBytes(StandardCharsets.UTF_8).length > 32) {
                throw new IllegalArgumentException("ssid byte length error! it should between 9 and 32");
            } else {
                this.l = str;
                return this;
            }
        }
    }

    private UCarConfig() {
        this.mCarBrMac = new byte[6];
        this.mAllowed5gChannels = new int[0];
        this.mCarCustomField = new byte[2];
        this.mIsSupportPOINav = false;
        this.mBleRSSIThreshold = DEFAULT_ADVERTISING_RSSI_THRESHOLD;
        this.mIsSupportRotation = false;
        this.mIsSupportHomeKey = false;
        this.mIsSupportBackKey = false;
    }

    private UCarConfig(Parcel parcel) {
        this.mCarBrMac = new byte[6];
        this.mAllowed5gChannels = new int[0];
        this.mCarCustomField = new byte[2];
        this.mIsSupportPOINav = false;
        this.mBleRSSIThreshold = DEFAULT_ADVERTISING_RSSI_THRESHOLD;
        this.mIsSupportRotation = false;
        this.mIsSupportHomeKey = false;
        this.mIsSupportBackKey = false;
        readFromParcel(parcel);
    }

    private UCarConfig(Builder builder) {
        this.mCarBrMac = new byte[6];
        this.mAllowed5gChannels = new int[0];
        this.mCarCustomField = new byte[2];
        this.mIsSupportPOINav = false;
        this.mBleRSSIThreshold = DEFAULT_ADVERTISING_RSSI_THRESHOLD;
        this.mIsSupportRotation = false;
        this.mIsSupportHomeKey = false;
        this.mIsSupportBackKey = false;
        if (builder.f229a != null) {
            this.mCarBrMac = Arrays.copyOf(builder.f229a, builder.f229a.length);
            this.mScreenWidth = builder.b;
            this.mScreenHeight = builder.c;
            this.mDpi = builder.d;
            this.mRealDpi = builder.e;
            this.mVideoDisplayWidth = builder.f;
            this.mVideoDisplayHeight = builder.g;
            this.mFps = builder.h;
            this.mIsSupportP2P = builder.i;
            this.mIsSupportSoftAP = builder.j;
            this.mIsApStaCoexist = builder.k;
            this.mSsid = builder.l;
            this.mPassword = builder.m;
            this.mIsReconfigureWifi = builder.n;
            this.mAllowed5gChannels = builder.o;
            this.mIsSupportCamera = builder.p;
            this.mIsSupportMic = builder.q;
            this.mIsSupportLowLatencyDecodingMode = builder.r;
            this.mIsSupportVoiceWaken = builder.s;
            this.mIsSupportRealWifiAddress = builder.t;
            if (builder.u != null) {
                this.mCarCustomField = Arrays.copyOf(builder.u, builder.u.length);
            }
            this.mIsSupportStereoRecord = builder.v;
            this.mCcdFilePath = builder.w;
            this.mIsSupportPOINav = builder.x;
            this.mSupportWorkModes = builder.y;
            this.mBleRSSIThreshold = builder.z;
            this.mIsSupportRotation = builder.A;
            this.mIsSupportHomeKey = builder.B;
            this.mIsSupportBackKey = builder.C;
            this.mIsSupportHevc = builder.D;
            return;
        }
        throw new InvalidParameterException("Car Br Mac is invalid");
    }

    public UCarConfig(UCarConfig uCarConfig) {
        this.mCarBrMac = new byte[6];
        this.mAllowed5gChannels = new int[0];
        this.mCarCustomField = new byte[2];
        this.mIsSupportPOINav = false;
        this.mBleRSSIThreshold = DEFAULT_ADVERTISING_RSSI_THRESHOLD;
        this.mIsSupportRotation = false;
        this.mIsSupportHomeKey = false;
        this.mIsSupportBackKey = false;
        byte[] bArr = uCarConfig.mCarBrMac;
        if (bArr != null) {
            this.mCarBrMac = Arrays.copyOf(bArr, 6);
        }
        this.mScreenWidth = uCarConfig.mScreenWidth;
        this.mScreenHeight = uCarConfig.mScreenHeight;
        this.mDpi = uCarConfig.mDpi;
        this.mRealDpi = uCarConfig.mRealDpi;
        this.mVideoDisplayWidth = uCarConfig.mVideoDisplayWidth;
        this.mVideoDisplayHeight = uCarConfig.mVideoDisplayHeight;
        this.mFps = uCarConfig.mFps;
        this.mIsSupportP2P = uCarConfig.mIsSupportP2P;
        this.mIsSupportSoftAP = uCarConfig.mIsSupportSoftAP;
        this.mIsApStaCoexist = uCarConfig.mIsApStaCoexist;
        this.mSsid = uCarConfig.mSsid;
        this.mPassword = uCarConfig.mPassword;
        this.mIsReconfigureWifi = uCarConfig.mIsReconfigureWifi;
        this.mAllowed5gChannels = uCarConfig.mAllowed5gChannels;
        this.mIsSupportCamera = uCarConfig.mIsSupportCamera;
        this.mIsSupportMic = uCarConfig.mIsSupportMic;
        this.mIsSupportLowLatencyDecodingMode = uCarConfig.mIsSupportLowLatencyDecodingMode;
        this.mIsSupportVoiceWaken = uCarConfig.mIsSupportVoiceWaken;
        this.mIsSupportRealWifiAddress = uCarConfig.mIsSupportRealWifiAddress;
        byte[] bArr2 = uCarConfig.mCarCustomField;
        if (bArr2 != null) {
            this.mCarCustomField = Arrays.copyOf(bArr2, 2);
        }
        this.mIsSupportStereoRecord = uCarConfig.mIsSupportStereoRecord;
        this.mCcdFilePath = uCarConfig.mCcdFilePath;
        this.mIsSupportPOINav = uCarConfig.mIsSupportPOINav;
        this.mSupportWorkModes = uCarConfig.mSupportWorkModes;
        this.mBleRSSIThreshold = uCarConfig.mBleRSSIThreshold;
        this.mIsSupportRotation = uCarConfig.mIsSupportRotation;
        this.mIsSupportHomeKey = uCarConfig.mIsSupportHomeKey;
        this.mIsSupportBackKey = uCarConfig.mIsSupportBackKey;
        this.mIsSupportHevc = uCarConfig.mIsSupportHevc;
    }

    public int describeContents() {
        return 0;
    }

    public int[] getAllowed5gChannels() {
        return this.mAllowed5gChannels;
    }

    public int getBleRSSIThreshold() {
        return this.mBleRSSIThreshold;
    }

    public byte[] getCarBrMac() {
        return this.mCarBrMac;
    }

    public byte[] getCarCustomField() {
        return this.mCarCustomField;
    }

    public String getCcdFilePath() {
        return this.mCcdFilePath;
    }

    public int getDpi() {
        return this.mDpi;
    }

    public int getFps() {
        return this.mFps;
    }

    public int getRealDpi() {
        return this.mRealDpi;
    }

    public int getScreenHeight() {
        return this.mScreenHeight;
    }

    public int getScreenWidth() {
        return this.mScreenWidth;
    }

    public UCarCommon.WorkMode getSupportWorkModes() {
        return this.mSupportWorkModes;
    }

    public int getSupportWorkModesInt() {
        return this.mSupportWorkModes.toInt();
    }

    public int getVideoDisplayHeight() {
        return this.mVideoDisplayHeight;
    }

    public int getVideoDisplayWidth() {
        return this.mVideoDisplayWidth;
    }

    public String getWifiPassword() {
        return this.mPassword;
    }

    public String getWifiSsid() {
        return this.mSsid;
    }

    public boolean isApStaCoexist() {
        return this.mIsApStaCoexist;
    }

    public boolean isIsSupportPOINav() {
        return this.mIsSupportPOINav;
    }

    public boolean isReconfigureWifi() {
        return this.mIsReconfigureWifi;
    }

    public boolean isSupportBackKey() {
        return this.mIsSupportBackKey;
    }

    public boolean isSupportCamera() {
        return this.mIsSupportCamera;
    }

    public boolean isSupportHevc() {
        return this.mIsSupportHevc;
    }

    public boolean isSupportHomeKey() {
        return this.mIsSupportHomeKey;
    }

    public boolean isSupportLowLatencyDecodingMode() {
        return this.mIsSupportLowLatencyDecodingMode;
    }

    public boolean isSupportMic() {
        return this.mIsSupportMic;
    }

    public boolean isSupportP2P() {
        return this.mIsSupportP2P;
    }

    public boolean isSupportRealWifiAddress() {
        return this.mIsSupportRealWifiAddress;
    }

    public boolean isSupportRotation() {
        return this.mIsSupportRotation;
    }

    public boolean isSupportSoftAP() {
        return this.mIsSupportSoftAP;
    }

    public boolean isSupportStereoRecord() {
        return this.mIsSupportStereoRecord;
    }

    public boolean isSupportVoiceWaken() {
        return this.mIsSupportVoiceWaken;
    }

    public void readFromParcel(Parcel parcel) {
        parcel.readByteArray(this.mCarBrMac);
        this.mScreenWidth = parcel.readInt();
        this.mScreenHeight = parcel.readInt();
        this.mDpi = parcel.readInt();
        this.mRealDpi = parcel.readInt();
        this.mVideoDisplayWidth = parcel.readInt();
        this.mVideoDisplayHeight = parcel.readInt();
        this.mFps = parcel.readInt();
        boolean z = false;
        this.mIsSupportP2P = parcel.readInt() == 1;
        this.mIsSupportSoftAP = parcel.readInt() == 1;
        this.mIsApStaCoexist = parcel.readInt() == 1;
        this.mSsid = parcel.readString();
        this.mPassword = parcel.readString();
        this.mIsReconfigureWifi = parcel.readInt() == 1;
        parcel.readIntArray(this.mAllowed5gChannels);
        this.mIsSupportCamera = parcel.readInt() == 1;
        this.mIsSupportMic = parcel.readInt() == 1;
        this.mIsSupportLowLatencyDecodingMode = parcel.readInt() == 1;
        this.mIsSupportVoiceWaken = parcel.readInt() == 1;
        this.mIsSupportRealWifiAddress = parcel.readInt() == 1;
        parcel.readByteArray(this.mCarCustomField);
        this.mIsSupportStereoRecord = parcel.readInt() == 1;
        this.mCcdFilePath = parcel.readString();
        this.mIsSupportPOINav = parcel.readInt() == 1;
        this.mSupportWorkModes = UCarCommon.WorkMode.fromInt(parcel.readInt());
        this.mBleRSSIThreshold = parcel.readInt();
        this.mIsSupportRotation = parcel.readInt() == 1;
        this.mIsSupportHomeKey = parcel.readInt() == 1;
        this.mIsSupportBackKey = parcel.readInt() == 1;
        if (parcel.readInt() == 1) {
            z = true;
        }
        this.mIsSupportHevc = z;
    }

    public String toString() {
        return "CarID: " + Arrays.toString(this.mCarBrMac) + "\nScreen Width: " + this.mScreenWidth + "\nScreen Height: " + this.mScreenHeight + "\nDpi: " + this.mDpi + "\nRealDpi: " + this.mRealDpi + "\nVideo Display Width: " + this.mVideoDisplayWidth + "\nVideo Display Height: " + this.mVideoDisplayHeight + "\nFPS: " + this.mFps + "\nSupport P2P: " + this.mIsSupportP2P + "\nSupport SoftAP: " + this.mIsSupportSoftAP + "\nSupport Ap Sta Coexist: " + this.mIsApStaCoexist + "\nSupport Reconfigure WifiInfo: " + this.mIsReconfigureWifi + "\nSupport Camera: " + this.mIsSupportCamera + "\nSupport Mic: " + this.mIsSupportMic + "\nSupport Low Latency Decoding Mode: " + this.mIsSupportLowLatencyDecodingMode + "\nSupport Voice Waken: " + this.mIsSupportVoiceWaken + "\nSupport Real Wifi Address: " + this.mIsSupportRealWifiAddress + "\nallowed 5g Channels: " + this.mAllowed5gChannels + "\nCustom Field: " + Arrays.toString(this.mCarCustomField) + "\nSupport Stereo Record: " + this.mIsSupportStereoRecord + "\nCcd File Path: " + this.mCcdFilePath + "Support POI Navigation: " + this.mIsSupportPOINav + "\nSupport Work Mode:" + this.mSupportWorkModes + "\nBluetooth Rssi Threshold: " + this.mBleRSSIThreshold + "\nSupport Rotation: " + this.mIsSupportHomeKey + "\nSupport Home Key: " + this.mIsSupportHomeKey + "\nSupport Back Key: " + this.mIsSupportBackKey + "\nSupport Hevc: " + this.mIsSupportHevc;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeByteArray(this.mCarBrMac);
        parcel.writeInt(this.mScreenWidth);
        parcel.writeInt(this.mScreenHeight);
        parcel.writeInt(this.mDpi);
        parcel.writeInt(this.mRealDpi);
        parcel.writeInt(this.mVideoDisplayWidth);
        parcel.writeInt(this.mVideoDisplayHeight);
        parcel.writeInt(this.mFps);
        parcel.writeInt(this.mIsSupportP2P ? 1 : 0);
        parcel.writeInt(this.mIsSupportSoftAP ? 1 : 0);
        parcel.writeInt(this.mIsApStaCoexist ? 1 : 0);
        parcel.writeString(this.mSsid);
        parcel.writeString(this.mPassword);
        parcel.writeInt(this.mIsReconfigureWifi ? 1 : 0);
        parcel.writeIntArray(this.mAllowed5gChannels);
        parcel.writeInt(this.mIsSupportCamera ? 1 : 0);
        parcel.writeInt(this.mIsSupportMic ? 1 : 0);
        parcel.writeInt(this.mIsSupportLowLatencyDecodingMode ? 1 : 0);
        parcel.writeInt(this.mIsSupportVoiceWaken ? 1 : 0);
        parcel.writeInt(this.mIsSupportRealWifiAddress ? 1 : 0);
        parcel.writeByteArray(this.mCarCustomField);
        parcel.writeInt(this.mIsSupportStereoRecord ? 1 : 0);
        parcel.writeString(this.mCcdFilePath);
        parcel.writeInt(this.mIsSupportPOINav ? 1 : 0);
        parcel.writeInt(this.mSupportWorkModes.toInt());
        parcel.writeInt(this.mBleRSSIThreshold);
        parcel.writeInt(this.mIsSupportRotation ? 1 : 0);
        parcel.writeInt(this.mIsSupportHomeKey ? 1 : 0);
        parcel.writeInt(this.mIsSupportBackKey ? 1 : 0);
        parcel.writeInt(this.mIsSupportHevc ? 1 : 0);
    }
}
