package com.ucar.vehiclesdk;

import android.os.Parcel;
import android.os.Parcelable;
import com.ucar.vehiclesdk.UCarCommon;

public class MDevice implements Parcelable {
    public static final int CONNECT_TYPE_DEFAULT = 1;
    public static final int CONNECT_TYPE_SOFTAP = 3;
    public static final int CONNECT_TYPE_USB = 2;
    public static final int CONNECT_TYPE_WIFIP2P = 1;
    public static final Parcelable.Creator<MDevice> CREATOR = new a();
    private static final int DEFAULT_PORT = 7236;
    private String mAddress = "";
    private int mConnectType = 1;
    private String mId = "-1";
    private String mModel = "GENERIC PHONE";
    private String mName = "UNKNOWN";
    private int mPort = DEFAULT_PORT;
    private String mProductName = "ICCOA Carlink";
    private int mProtocolVersion = 1;
    private int mSelectedWorkMode = UCarCommon.WorkMode.NORMAL_CAST.toInt();

    public class a implements Parcelable.Creator<MDevice> {
        /* renamed from: a */
        public MDevice createFromParcel(Parcel parcel) {
            return new MDevice(parcel);
        }

        /* renamed from: a */
        public MDevice[] newArray(int i) {
            return new MDevice[i];
        }
    }

    public MDevice() {
    }

    public MDevice(Parcel parcel) {
        this.mId = parcel.readString();
        this.mProductName = parcel.readString();
        this.mModel = parcel.readString();
        this.mName = parcel.readString();
        this.mAddress = parcel.readString();
        this.mPort = parcel.readInt();
        this.mConnectType = parcel.readInt();
        this.mSelectedWorkMode = parcel.readInt();
        this.mProtocolVersion = parcel.readInt();
    }

    public int describeContents() {
        return 0;
    }

    public String getAddress() {
        return this.mAddress;
    }

    public int getConnectType() {
        return this.mConnectType;
    }

    public String getId() {
        return this.mId;
    }

    public String getModel() {
        return this.mModel;
    }

    public String getName() {
        return this.mName;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getProductName() {
        return this.mProductName;
    }

    public int getProtocolVersion() {
        return this.mProtocolVersion;
    }

    public int getSelectedWorkMode() {
        return this.mSelectedWorkMode;
    }

    public boolean isWired() {
        return 2 == this.mConnectType;
    }

    public boolean isWireless() {
        int i = this.mConnectType;
        return 1 == i || 3 == i;
    }

    public void setAddress(String str) {
        this.mAddress = str;
    }

    public void setConnectType(int i) {
        this.mConnectType = i;
    }

    public void setId(String str) {
        this.mId = str;
    }

    public void setModel(String str) {
        this.mModel = str;
    }

    public void setName(String str) {
        this.mName = str;
    }

    public void setPort(int i) {
        this.mPort = i;
    }

    public void setProductName(String str) {
        if (str != null) {
            this.mProductName = str;
        }
    }

    public void setProtocolVersion(int i) {
        this.mProtocolVersion = i;
    }

    public void setSelectedWorkMode(int i) {
        this.mSelectedWorkMode = i;
    }

    public UCarCommon.MobileDevice toDeviceInfo() {
        return new UCarCommon.MobileDevice(this.mId, this.mProductName, this.mModel, this.mConnectType);
    }

    public String toString() {
        return "CarDevice{id='" + this.mId + '\'' + ", productName='" + this.mProductName + '\'' + ", model='" + this.mModel + '\'' + ", name='" + this.mName + '\'' + ", address='" + this.mAddress + '\'' + ", port='" + this.mPort + '\'' + ", connectType=" + this.mConnectType + ", selectedWorkMode=" + this.mSelectedWorkMode + ", protocolVersion=" + this.mProtocolVersion + '}';
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.mId);
        parcel.writeString(this.mProductName);
        parcel.writeString(this.mModel);
        parcel.writeString(this.mName);
        parcel.writeString(this.mAddress);
        parcel.writeInt(this.mPort);
        parcel.writeInt(this.mConnectType);
        parcel.writeInt(this.mSelectedWorkMode);
        parcel.writeInt(this.mProtocolVersion);
    }
}
