package com.share.connect.security;

import a.b.a.f.h;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomMasterTable;
import androidx.room.RoomOpenHelper;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class PeerDatabase_Impl extends PeerDatabase {
    private volatile PeerDao _peerDao;

    @Override // androidx.room.RoomDatabase
    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase writableDatabase = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            writableDatabase.execSQL("DELETE FROM `Peer`");
            super.setTransactionSuccessful();
        } finally {
            super.endTransaction();
            writableDatabase.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!writableDatabase.inTransaction()) {
                writableDatabase.execSQL("VACUUM");
            }
        }
    }

    @Override // androidx.room.RoomDatabase
    public InvalidationTracker createInvalidationTracker() {
        return new InvalidationTracker(this, new HashMap(0), new HashMap(0), "Peer");
    }

    @Override // androidx.room.RoomDatabase
    public SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration databaseConfiguration) {
        return databaseConfiguration.sqliteOpenHelperFactory.create(SupportSQLiteOpenHelper.Configuration.builder(databaseConfiguration.context).name(databaseConfiguration.name).callback(new RoomOpenHelper(databaseConfiguration, new RoomOpenHelper.Delegate(1) {
            /* class com.share.connect.security.PeerDatabase_Impl.AnonymousClass1 */

            @Override // androidx.room.RoomOpenHelper.Delegate
            public void createAllTables(SupportSQLiteDatabase supportSQLiteDatabase) {
                supportSQLiteDatabase.execSQL("CREATE TABLE IF NOT EXISTS `Peer` (`id` TEXT NOT NULL, `auth_key` TEXT, `connection_time` INTEGER NOT NULL, PRIMARY KEY(`id`))");
                supportSQLiteDatabase.execSQL(RoomMasterTable.CREATE_QUERY);
                supportSQLiteDatabase.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '4243c174af6db32a5c9f09d053c8940f')");
            }

            @Override // androidx.room.RoomOpenHelper.Delegate
            public void dropAllTables(SupportSQLiteDatabase supportSQLiteDatabase) {
                supportSQLiteDatabase.execSQL("DROP TABLE IF EXISTS `Peer`");
                if (PeerDatabase_Impl.this.mCallbacks != null) {
                    int size = PeerDatabase_Impl.this.mCallbacks.size();
                    for (int i = 0; i < size; i++) {
                        ((RoomDatabase.Callback) PeerDatabase_Impl.this.mCallbacks.get(i)).onDestructiveMigration(supportSQLiteDatabase);
                    }
                }
            }

            @Override // androidx.room.RoomOpenHelper.Delegate
            public void onCreate(SupportSQLiteDatabase supportSQLiteDatabase) {
                if (PeerDatabase_Impl.this.mCallbacks != null) {
                    int size = PeerDatabase_Impl.this.mCallbacks.size();
                    for (int i = 0; i < size; i++) {
                        ((RoomDatabase.Callback) PeerDatabase_Impl.this.mCallbacks.get(i)).onCreate(supportSQLiteDatabase);
                    }
                }
            }

            @Override // androidx.room.RoomOpenHelper.Delegate
            public void onOpen(SupportSQLiteDatabase supportSQLiteDatabase) {
                PeerDatabase_Impl.this.mDatabase = supportSQLiteDatabase;
                PeerDatabase_Impl.this.internalInitInvalidationTracker(supportSQLiteDatabase);
                if (PeerDatabase_Impl.this.mCallbacks != null) {
                    int size = PeerDatabase_Impl.this.mCallbacks.size();
                    for (int i = 0; i < size; i++) {
                        ((RoomDatabase.Callback) PeerDatabase_Impl.this.mCallbacks.get(i)).onOpen(supportSQLiteDatabase);
                    }
                }
            }

            @Override // androidx.room.RoomOpenHelper.Delegate
            public void onPostMigrate(SupportSQLiteDatabase supportSQLiteDatabase) {
            }

            @Override // androidx.room.RoomOpenHelper.Delegate
            public void onPreMigrate(SupportSQLiteDatabase supportSQLiteDatabase) {
                DBUtil.dropFtsSyncTriggers(supportSQLiteDatabase);
            }

            @Override // androidx.room.RoomOpenHelper.Delegate
            public RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase supportSQLiteDatabase) {
                HashMap hashMap = new HashMap(3);
                hashMap.put(h.a.f21a, new TableInfo.Column(h.a.f21a, "TEXT", true, 1, null, 1));
                hashMap.put("auth_key", new TableInfo.Column("auth_key", "TEXT", false, 0, null, 1));
                hashMap.put("connection_time", new TableInfo.Column("connection_time", "INTEGER", true, 0, null, 1));
                TableInfo tableInfo = new TableInfo("Peer", hashMap, new HashSet(0), new HashSet(0));
                TableInfo read = TableInfo.read(supportSQLiteDatabase, "Peer");
                return !tableInfo.equals(read) ? new RoomOpenHelper.ValidationResult(false, "Peer(com.share.connect.security.Peer).\n Expected:\n" + tableInfo + "\n Found:\n" + read) : new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "4243c174af6db32a5c9f09d053c8940f", "d4081c6b96ff6901349afea96b2e0acf")).build());
    }

    @Override // androidx.room.RoomDatabase
    public Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap hashMap = new HashMap();
        hashMap.put(PeerDao.class, PeerDao_Impl.getRequiredConverters());
        return hashMap;
    }

    @Override // com.share.connect.security.PeerDatabase
    public PeerDao peerDao() {
        PeerDao peerDao;
        if (this._peerDao != null) {
            return this._peerDao;
        }
        synchronized (this) {
            if (this._peerDao == null) {
                this._peerDao = new PeerDao_Impl(this);
            }
            peerDao = this._peerDao;
        }
        return peerDao;
    }
}
