package com.share.connect.security;

import a.b.a.f.h;
import a.b.a.h.b;
import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.Collections;
import java.util.List;

public final class PeerDao_Impl implements PeerDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<b> __insertionAdapterOfPeer;
    private final SharedSQLiteStatement __preparedStmtOfDelete;
    private final SharedSQLiteStatement __preparedStmtOfUpdateLast;

    public PeerDao_Impl(RoomDatabase roomDatabase) {
        this.__db = roomDatabase;
        this.__insertionAdapterOfPeer = new EntityInsertionAdapter<b>(roomDatabase) {
            /* class com.share.connect.security.PeerDao_Impl.AnonymousClass1 */

            public void bind(SupportSQLiteStatement supportSQLiteStatement, b bVar) {
                String str = bVar.f26a;
                if (str == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, str);
                }
                String str2 = bVar.b;
                if (str2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, str2);
                }
                supportSQLiteStatement.bindLong(3, bVar.c);
            }

            @Override // androidx.room.SharedSQLiteStatement
            public String createQuery() {
                return "INSERT OR REPLACE INTO `Peer` (`id`,`auth_key`,`connection_time`) VALUES (?,?,?)";
            }
        };
        this.__preparedStmtOfUpdateLast = new SharedSQLiteStatement(roomDatabase) {
            /* class com.share.connect.security.PeerDao_Impl.AnonymousClass2 */

            @Override // androidx.room.SharedSQLiteStatement
            public String createQuery() {
                return "UPDATE peer SET connection_time= CASE WHEN id=? THEN 1 ELSE 0 END";
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(roomDatabase) {
            /* class com.share.connect.security.PeerDao_Impl.AnonymousClass3 */

            @Override // androidx.room.SharedSQLiteStatement
            public String createQuery() {
                return "DELETE FROM peer WHERE id=?";
            }
        };
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    @Override // com.share.connect.security.PeerDao
    public void delete(String str) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement acquire = this.__preparedStmtOfDelete.acquire();
        if (str == null) {
            acquire.bindNull(1);
        } else {
            acquire.bindString(1, str);
        }
        this.__db.beginTransaction();
        try {
            acquire.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        } finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDelete.release(acquire);
        }
    }

    @Override // com.share.connect.security.PeerDao
    public b get(String str) {
        RoomSQLiteQuery acquire = RoomSQLiteQuery.acquire("SELECT * FROM peer WHERE id=?", 1);
        if (str == null) {
            acquire.bindNull(1);
        } else {
            acquire.bindString(1, str);
        }
        this.__db.assertNotSuspendingTransaction();
        b bVar = null;
        Cursor query = DBUtil.query(this.__db, acquire, false, null);
        try {
            int columnIndexOrThrow = CursorUtil.getColumnIndexOrThrow(query, h.a.f21a);
            int columnIndexOrThrow2 = CursorUtil.getColumnIndexOrThrow(query, "auth_key");
            int columnIndexOrThrow3 = CursorUtil.getColumnIndexOrThrow(query, "connection_time");
            if (query.moveToFirst()) {
                b bVar2 = new b();
                if (query.isNull(columnIndexOrThrow)) {
                    bVar2.f26a = null;
                } else {
                    bVar2.f26a = query.getString(columnIndexOrThrow);
                }
                if (query.isNull(columnIndexOrThrow2)) {
                    bVar2.b = null;
                } else {
                    bVar2.b = query.getString(columnIndexOrThrow2);
                }
                bVar2.c = query.getLong(columnIndexOrThrow3);
                bVar = bVar2;
            }
            return bVar;
        } finally {
            query.close();
            acquire.release();
        }
    }

    @Override // com.share.connect.security.PeerDao
    public b getLast() {
        RoomSQLiteQuery acquire = RoomSQLiteQuery.acquire("SELECT * FROM peer ORDER BY connection_time DESC LIMIT 1", 0);
        this.__db.assertNotSuspendingTransaction();
        b bVar = null;
        Cursor query = DBUtil.query(this.__db, acquire, false, null);
        try {
            int columnIndexOrThrow = CursorUtil.getColumnIndexOrThrow(query, h.a.f21a);
            int columnIndexOrThrow2 = CursorUtil.getColumnIndexOrThrow(query, "auth_key");
            int columnIndexOrThrow3 = CursorUtil.getColumnIndexOrThrow(query, "connection_time");
            if (query.moveToFirst()) {
                b bVar2 = new b();
                if (query.isNull(columnIndexOrThrow)) {
                    bVar2.f26a = null;
                } else {
                    bVar2.f26a = query.getString(columnIndexOrThrow);
                }
                if (query.isNull(columnIndexOrThrow2)) {
                    bVar2.b = null;
                } else {
                    bVar2.b = query.getString(columnIndexOrThrow2);
                }
                bVar2.c = query.getLong(columnIndexOrThrow3);
                bVar = bVar2;
            }
            return bVar;
        } finally {
            query.close();
            acquire.release();
        }
    }

    @Override // com.share.connect.security.PeerDao
    public long insert(b bVar) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long insertAndReturnId = this.__insertionAdapterOfPeer.insertAndReturnId(bVar);
            this.__db.setTransactionSuccessful();
            return insertAndReturnId;
        } finally {
            this.__db.endTransaction();
        }
    }

    @Override // com.share.connect.security.PeerDao
    public int updateLast(String str) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement acquire = this.__preparedStmtOfUpdateLast.acquire();
        if (str == null) {
            acquire.bindNull(1);
        } else {
            acquire.bindString(1, str);
        }
        this.__db.beginTransaction();
        try {
            int executeUpdateDelete = acquire.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            return executeUpdateDelete;
        } finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateLast.release(acquire);
        }
    }
}
