package com.share.connect.ble;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.share.connect.ble.BluetoothLeObserver;
import java.util.Map;

public interface IBluetoothLe extends IInterface {

    public static class a implements IBluetoothLe {
        @Override // com.share.connect.ble.IBluetoothLe
        public void allowProcessNewConnection() throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }

        @Override // com.share.connect.ble.IBluetoothLe
        public void close() throws RemoteException {
        }

        @Override // com.share.connect.ble.IBluetoothLe
        public boolean connect(String str) throws RemoteException {
            return false;
        }

        @Override // com.share.connect.ble.IBluetoothLe
        public void connectDone() throws RemoteException {
        }

        @Override // com.share.connect.ble.IBluetoothLe
        public void disconnect() throws RemoteException {
        }

        @Override // com.share.connect.ble.IBluetoothLe
        public void disconnectWithoutState() throws RemoteException {
        }

        @Override // com.share.connect.ble.IBluetoothLe
        public Map getDevicesSignal(int i, int i2) throws RemoteException {
            return null;
        }

        @Override // com.share.connect.ble.IBluetoothLe
        public boolean isDeviceInMatch(String str) throws RemoteException {
            return false;
        }

        @Override // com.share.connect.ble.IBluetoothLe
        public void notifyServerInfo(String str, String str2, String str3, int i, int i2) throws RemoteException {
        }

        @Override // com.share.connect.ble.IBluetoothLe
        public void open(String str, String str2, String str3, String str4, String str5, String str6, boolean z, int i) throws RemoteException {
        }

        @Override // com.share.connect.ble.IBluetoothLe
        public void registerBluetoothLeObserver(BluetoothLeObserver bluetoothLeObserver) throws RemoteException {
        }

        @Override // com.share.connect.ble.IBluetoothLe
        public void setBandSupported(int i) throws RemoteException {
        }

        @Override // com.share.connect.ble.IBluetoothLe
        public void setP2pDeviceMac(String str) throws RemoteException {
        }

        @Override // com.share.connect.ble.IBluetoothLe
        public void startScan() throws RemoteException {
        }

        @Override // com.share.connect.ble.IBluetoothLe
        public void stopAdvertise() throws RemoteException {
        }

        @Override // com.share.connect.ble.IBluetoothLe
        public void stopScan() throws RemoteException {
        }

        @Override // com.share.connect.ble.IBluetoothLe
        public void unregisterBluetoothLeObserver(BluetoothLeObserver bluetoothLeObserver) throws RemoteException {
        }
    }

    public static abstract class b extends Binder implements IBluetoothLe {

        /* renamed from: a  reason: collision with root package name */
        private static final String f188a = "com.share.connect.ble.IBluetoothLe";
        public static final int b = 1;
        public static final int c = 2;
        public static final int d = 3;
        public static final int e = 4;
        public static final int f = 5;
        public static final int g = 6;
        public static final int h = 7;
        public static final int i = 8;
        public static final int j = 9;
        public static final int k = 10;
        public static final int l = 11;
        public static final int m = 12;
        public static final int n = 13;
        public static final int o = 14;
        public static final int p = 15;
        public static final int q = 16;
        public static final int r = 17;

        public static class a implements IBluetoothLe {
            public static IBluetoothLe b;

            /* renamed from: a  reason: collision with root package name */
            private IBinder f189a;

            public a(IBinder iBinder) {
                this.f189a = iBinder;
            }

            public String a() {
                return b.f188a;
            }

            @Override // com.share.connect.ble.IBluetoothLe
            public void allowProcessNewConnection() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f188a);
                    if (this.f189a.transact(17, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().allowProcessNewConnection();
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            public IBinder asBinder() {
                return this.f189a;
            }

            @Override // com.share.connect.ble.IBluetoothLe
            public void close() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f188a);
                    if (this.f189a.transact(2, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().close();
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.IBluetoothLe
            public boolean connect(String str) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f188a);
                    obtain.writeString(str);
                    boolean z = false;
                    if (!this.f189a.transact(7, obtain, obtain2, 0) && b.a() != null) {
                        return b.a().connect(str);
                    }
                    obtain2.readException();
                    if (obtain2.readInt() != 0) {
                        z = true;
                    }
                    obtain2.recycle();
                    obtain.recycle();
                    return z;
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.IBluetoothLe
            public void connectDone() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f188a);
                    if (this.f189a.transact(9, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().connectDone();
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.IBluetoothLe
            public void disconnect() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f188a);
                    if (this.f189a.transact(8, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().disconnect();
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.IBluetoothLe
            public void disconnectWithoutState() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f188a);
                    if (this.f189a.transact(10, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().disconnectWithoutState();
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.IBluetoothLe
            public Map getDevicesSignal(int i, int i2) throws RemoteException {
                Map readHashMap;
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f188a);
                    obtain.writeInt(i);
                    obtain.writeInt(i2);
                    if (this.f189a.transact(6, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                        readHashMap = obtain2.readHashMap(getClass().getClassLoader());
                    } else {
                        readHashMap = b.a().getDevicesSignal(i, i2);
                    }
                    return readHashMap;
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.IBluetoothLe
            public boolean isDeviceInMatch(String str) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f188a);
                    obtain.writeString(str);
                    boolean z = false;
                    if (!this.f189a.transact(5, obtain, obtain2, 0) && b.a() != null) {
                        return b.a().isDeviceInMatch(str);
                    }
                    obtain2.readException();
                    if (obtain2.readInt() != 0) {
                        z = true;
                    }
                    obtain2.recycle();
                    obtain.recycle();
                    return z;
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.IBluetoothLe
            public void notifyServerInfo(String str, String str2, String str3, int i, int i2) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f188a);
                    obtain.writeString(str);
                    obtain.writeString(str2);
                    obtain.writeString(str3);
                    obtain.writeInt(i);
                    obtain.writeInt(i2);
                    if (this.f189a.transact(15, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().notifyServerInfo(str, str2, str3, i, i2);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.IBluetoothLe
            public void open(String str, String str2, String str3, String str4, String str5, String str6, boolean z, int i) throws RemoteException {
                Throwable th;
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f188a);
                    obtain.writeString(str);
                    obtain.writeString(str2);
                    obtain.writeString(str3);
                    obtain.writeString(str4);
                    obtain.writeString(str5);
                    obtain.writeString(str6);
                    obtain.writeInt(z ? 1 : 0);
                    obtain.writeInt(i);
                    try {
                        if (this.f189a.transact(1, obtain, obtain2, 0) || b.a() == null) {
                            obtain2.readException();
                        } else {
                            b.a().open(str, str2, str3, str4, str5, str6, z, i);
                        }
                        obtain2.recycle();
                        obtain.recycle();
                    } catch (Throwable th2) {
                        th = th2;
                        obtain2.recycle();
                        obtain.recycle();
                        throw th;
                    }
                } catch (Throwable th3) {
                    th = th3;
                    obtain2.recycle();
                    obtain.recycle();
                    throw th;
                }
            }

            @Override // com.share.connect.ble.IBluetoothLe
            public void registerBluetoothLeObserver(BluetoothLeObserver bluetoothLeObserver) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f188a);
                    obtain.writeStrongBinder(bluetoothLeObserver != null ? bluetoothLeObserver.asBinder() : null);
                    if (this.f189a.transact(11, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().registerBluetoothLeObserver(bluetoothLeObserver);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.IBluetoothLe
            public void setBandSupported(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f188a);
                    obtain.writeInt(i);
                    if (this.f189a.transact(13, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().setBandSupported(i);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.IBluetoothLe
            public void setP2pDeviceMac(String str) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f188a);
                    obtain.writeString(str);
                    if (this.f189a.transact(14, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().setP2pDeviceMac(str);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.IBluetoothLe
            public void startScan() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f188a);
                    if (this.f189a.transact(3, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().startScan();
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.IBluetoothLe
            public void stopAdvertise() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f188a);
                    if (this.f189a.transact(16, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().stopAdvertise();
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.IBluetoothLe
            public void stopScan() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f188a);
                    if (this.f189a.transact(4, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().stopScan();
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.IBluetoothLe
            public void unregisterBluetoothLeObserver(BluetoothLeObserver bluetoothLeObserver) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f188a);
                    obtain.writeStrongBinder(bluetoothLeObserver != null ? bluetoothLeObserver.asBinder() : null);
                    if (this.f189a.transact(12, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().unregisterBluetoothLeObserver(bluetoothLeObserver);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }
        }

        public b() {
            attachInterface(this, f188a);
        }

        public static IBluetoothLe a() {
            return a.b;
        }

        public static IBluetoothLe a(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface queryLocalInterface = iBinder.queryLocalInterface(f188a);
            return (queryLocalInterface == null || !(queryLocalInterface instanceof IBluetoothLe)) ? new a(iBinder) : (IBluetoothLe) queryLocalInterface;
        }

        public static boolean a(IBluetoothLe iBluetoothLe) {
            if (a.b != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            } else if (iBluetoothLe == null) {
                return false;
            } else {
                a.b = iBluetoothLe;
                return true;
            }
        }

        public IBinder asBinder() {
            return this;
        }

        @Override // android.os.Binder
        public boolean onTransact(int i2, Parcel parcel, Parcel parcel2, int i3) throws RemoteException {
            if (i2 != 1598968902) {
                switch (i2) {
                    case 1:
                        parcel.enforceInterface(f188a);
                        open(parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readInt() != 0, parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case 2:
                        parcel.enforceInterface(f188a);
                        close();
                        parcel2.writeNoException();
                        return true;
                    case 3:
                        parcel.enforceInterface(f188a);
                        startScan();
                        parcel2.writeNoException();
                        return true;
                    case 4:
                        parcel.enforceInterface(f188a);
                        stopScan();
                        parcel2.writeNoException();
                        return true;
                    case 5:
                        parcel.enforceInterface(f188a);
                        boolean isDeviceInMatch = isDeviceInMatch(parcel.readString());
                        parcel2.writeNoException();
                        parcel2.writeInt(isDeviceInMatch ? 1 : 0);
                        return true;
                    case 6:
                        parcel.enforceInterface(f188a);
                        Map devicesSignal = getDevicesSignal(parcel.readInt(), parcel.readInt());
                        parcel2.writeNoException();
                        parcel2.writeMap(devicesSignal);
                        return true;
                    case 7:
                        parcel.enforceInterface(f188a);
                        boolean connect = connect(parcel.readString());
                        parcel2.writeNoException();
                        parcel2.writeInt(connect ? 1 : 0);
                        return true;
                    case 8:
                        parcel.enforceInterface(f188a);
                        disconnect();
                        parcel2.writeNoException();
                        return true;
                    case 9:
                        parcel.enforceInterface(f188a);
                        connectDone();
                        parcel2.writeNoException();
                        return true;
                    case 10:
                        parcel.enforceInterface(f188a);
                        disconnectWithoutState();
                        parcel2.writeNoException();
                        return true;
                    case 11:
                        parcel.enforceInterface(f188a);
                        registerBluetoothLeObserver(BluetoothLeObserver.b.a(parcel.readStrongBinder()));
                        parcel2.writeNoException();
                        return true;
                    case 12:
                        parcel.enforceInterface(f188a);
                        unregisterBluetoothLeObserver(BluetoothLeObserver.b.a(parcel.readStrongBinder()));
                        parcel2.writeNoException();
                        return true;
                    case 13:
                        parcel.enforceInterface(f188a);
                        setBandSupported(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case 14:
                        parcel.enforceInterface(f188a);
                        setP2pDeviceMac(parcel.readString());
                        parcel2.writeNoException();
                        return true;
                    case 15:
                        parcel.enforceInterface(f188a);
                        notifyServerInfo(parcel.readString(), parcel.readString(), parcel.readString(), parcel.readInt(), parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case 16:
                        parcel.enforceInterface(f188a);
                        stopAdvertise();
                        parcel2.writeNoException();
                        return true;
                    case 17:
                        parcel.enforceInterface(f188a);
                        allowProcessNewConnection();
                        parcel2.writeNoException();
                        return true;
                    default:
                        return super.onTransact(i2, parcel, parcel2, i3);
                }
            } else {
                parcel2.writeString(f188a);
                return true;
            }
        }
    }

    void allowProcessNewConnection() throws RemoteException;

    void close() throws RemoteException;

    boolean connect(String str) throws RemoteException;

    void connectDone() throws RemoteException;

    void disconnect() throws RemoteException;

    void disconnectWithoutState() throws RemoteException;

    Map getDevicesSignal(int i, int i2) throws RemoteException;

    boolean isDeviceInMatch(String str) throws RemoteException;

    void notifyServerInfo(String str, String str2, String str3, int i, int i2) throws RemoteException;

    void open(String str, String str2, String str3, String str4, String str5, String str6, boolean z, int i) throws RemoteException;

    void registerBluetoothLeObserver(BluetoothLeObserver bluetoothLeObserver) throws RemoteException;

    void setBandSupported(int i) throws RemoteException;

    void setP2pDeviceMac(String str) throws RemoteException;

    void startScan() throws RemoteException;

    void stopAdvertise() throws RemoteException;

    void stopScan() throws RemoteException;

    void unregisterBluetoothLeObserver(BluetoothLeObserver bluetoothLeObserver) throws RemoteException;
}
