package com.share.connect.ble;

import a.a.a.b;
import a.b.a.f.c;
import a.b.a.f.h;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.text.TextUtils;
import android.util.Log;
import androidx.collection.ArrayMap;
import com.share.connect.Device;

public class DeviceCache {
    private static final String c = "DeviceCache";

    /* renamed from: a  reason: collision with root package name */
    private a f187a;
    private ArrayMap<String, BtDevice> b = new ArrayMap<>();

    public class BtDevice extends Device {
        private int mSignal;
        private String mac;

        public BtDevice() {
        }

        public String getMac() {
            return this.mac;
        }

        public int getSignal() {
            return this.mSignal;
        }

        public BtDevice setMac(String str) {
            this.mac = str;
            return this;
        }

        public BtDevice setSignal(int i) {
            this.mSignal = i;
            return this;
        }
    }

    public interface a {
        void a(BtDevice btDevice);

        void b(BtDevice btDevice);
    }

    private void a(BtDevice btDevice) {
        String str = btDevice.mac;
        String vin = btDevice.getVin();
        String pName = btDevice.getPName();
        boolean a2 = a(vin);
        boolean b2 = b(str);
        if (!a2) {
            this.b.put(vin, btDevice);
        } else if (!b2) {
            BtDevice btDevice2 = this.b.get(vin);
            this.b.put(vin, btDevice);
            if (btDevice2 == null || TextUtils.equals(btDevice2.getPName(), pName)) {
                return;
            }
        } else {
            return;
        }
        this.f187a.a(btDevice);
    }

    private boolean a(ScanResult scanResult) {
        String str;
        ScanRecord scanRecord = scanResult.getScanRecord();
        if (scanRecord == null) {
            str = "ScanRecord is null.";
        } else if (scanResult.getDevice() == null) {
            str = "BluetoothDevice is null.";
        } else {
            if ((scanRecord.getServiceUuids() != null ? scanRecord.getServiceUuids().get(0) : null) != null) {
                return true;
            }
            str = "Service UUID is null, it shouldn't happen.";
        }
        b.b(c, str);
        return false;
    }

    private boolean b(String str) {
        for (BtDevice btDevice : this.b.values()) {
            if (TextUtils.equals(str, btDevice.mac)) {
                return true;
            }
        }
        return false;
    }

    private BtDevice c(String str) {
        for (BtDevice btDevice : this.b.values()) {
            if (TextUtils.equals(str, btDevice.mac)) {
                return btDevice;
            }
        }
        return null;
    }

    private BtDevice d(ScanResult scanResult) {
        String b2 = c.b(scanResult.getScanRecord().getServiceData(h.b.c));
        String b3 = c.b(scanResult.getScanRecord().getServiceData(h.b.d));
        if (TextUtils.isEmpty(b2) || TextUtils.isEmpty(b3)) {
            b.e(c, "Package data missing, illegal content:\n" + c.a(scanResult.getScanRecord().getBytes()));
            return null;
        }
        Log.d(c, String.format("parse: id=%s, name=%s", b2, b3));
        BtDevice btDevice = new BtDevice();
        btDevice.setVin(b2).setPName(b3);
        btDevice.setSignal(scanResult.getRssi());
        btDevice.setMac(scanResult.getDevice().getAddress());
        return btDevice;
    }

    private void e(String str) {
        do {
            BtDevice c2 = c(str);
            if (c2 != null) {
                this.b.remove(c2.getVin());
                this.f187a.b(c2);
            }
        } while (c(str) != null);
    }

    public ArrayMap<String, Integer> a() {
        ArrayMap<String, Integer> arrayMap = new ArrayMap<>();
        for (BtDevice btDevice : this.b.values()) {
            arrayMap.put(btDevice.getVin(), Integer.valueOf(btDevice.getSignal()));
        }
        return arrayMap;
    }

    public void a(a aVar) {
        this.f187a = aVar;
    }

    public boolean a(String str) {
        return this.b.containsKey(str);
    }

    public void b(ScanResult scanResult) {
        if (a(scanResult)) {
            e(scanResult.getDevice().getAddress());
        }
    }

    public void c(ScanResult scanResult) {
        BtDevice d;
        if (a(scanResult)) {
            try {
                if (h.b.b.equals(scanResult.getScanRecord().getServiceUuids().get(0)) && (d = d(scanResult)) != null) {
                    a(d);
                }
            } catch (Exception e) {
                b.b(c, "Parse data error: " + e.getMessage() + ", ignored.");
            }
        }
    }

    public String d(String str) {
        BtDevice btDevice = this.b.get(str);
        if (btDevice != null) {
            return btDevice.mac;
        }
        b.e(c, "Try to get mac with an id which is not exist.");
        return "";
    }
}
