package com.share.connect.ble;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.share.connect.Device;

public interface BluetoothLeObserver extends IInterface {

    public static class a implements BluetoothLeObserver {
        public IBinder asBinder() {
            return null;
        }

        @Override // com.share.connect.ble.BluetoothLeObserver
        public void onClientInfoReceived(String str, String str2, String str3, int i, String str4, int i2, String str5, int i3) throws RemoteException {
        }

        @Override // com.share.connect.ble.BluetoothLeObserver
        public void onDeviceLost(Device device) throws RemoteException {
        }

        @Override // com.share.connect.ble.BluetoothLeObserver
        public void onDeviceMatch(Device device) throws RemoteException {
        }

        @Override // com.share.connect.ble.BluetoothLeObserver
        public void onFailure(int i, int i2) throws RemoteException {
        }

        @Override // com.share.connect.ble.BluetoothLeObserver
        public void onPinAvailable(String str) throws RemoteException {
        }

        @Override // com.share.connect.ble.BluetoothLeObserver
        public void onServerAddressSent() throws RemoteException {
        }

        @Override // com.share.connect.ble.BluetoothLeObserver
        public void onServerInfoReceived(String str, String str2, String str3, int i) throws RemoteException {
        }

        @Override // com.share.connect.ble.BluetoothLeObserver
        public void onSuccess(int i) throws RemoteException {
        }
    }

    public static abstract class b extends Binder implements BluetoothLeObserver {

        /* renamed from: a  reason: collision with root package name */
        private static final String f172a = "com.share.connect.ble.BluetoothLeObserver";
        public static final int b = 1;
        public static final int c = 2;
        public static final int d = 3;
        public static final int e = 4;
        public static final int f = 5;
        public static final int g = 6;
        public static final int h = 7;
        public static final int i = 8;

        public static class a implements BluetoothLeObserver {
            public static BluetoothLeObserver b;

            /* renamed from: a  reason: collision with root package name */
            private IBinder f173a;

            public a(IBinder iBinder) {
                this.f173a = iBinder;
            }

            public String a() {
                return b.f172a;
            }

            public IBinder asBinder() {
                return this.f173a;
            }

            @Override // com.share.connect.ble.BluetoothLeObserver
            public void onClientInfoReceived(String str, String str2, String str3, int i, String str4, int i2, String str5, int i3) throws RemoteException {
                Throwable th;
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f172a);
                    obtain.writeString(str);
                    obtain.writeString(str2);
                    obtain.writeString(str3);
                    obtain.writeInt(i);
                    obtain.writeString(str4);
                    obtain.writeInt(i2);
                    obtain.writeString(str5);
                    obtain.writeInt(i3);
                    try {
                        if (this.f173a.transact(7, obtain, obtain2, 0) || b.a() == null) {
                            obtain2.readException();
                        } else {
                            b.a().onClientInfoReceived(str, str2, str3, i, str4, i2, str5, i3);
                        }
                        obtain2.recycle();
                        obtain.recycle();
                    } catch (Throwable th2) {
                        th = th2;
                        obtain2.recycle();
                        obtain.recycle();
                        throw th;
                    }
                } catch (Throwable th3) {
                    th = th3;
                    obtain2.recycle();
                    obtain.recycle();
                    throw th;
                }
            }

            @Override // com.share.connect.ble.BluetoothLeObserver
            public void onDeviceLost(Device device) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f172a);
                    if (device != null) {
                        obtain.writeInt(1);
                        device.writeToParcel(obtain, 0);
                    } else {
                        obtain.writeInt(0);
                    }
                    if (this.f173a.transact(4, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().onDeviceLost(device);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.BluetoothLeObserver
            public void onDeviceMatch(Device device) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f172a);
                    if (device != null) {
                        obtain.writeInt(1);
                        device.writeToParcel(obtain, 0);
                    } else {
                        obtain.writeInt(0);
                    }
                    if (this.f173a.transact(3, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().onDeviceMatch(device);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.BluetoothLeObserver
            public void onFailure(int i, int i2) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f172a);
                    obtain.writeInt(i);
                    obtain.writeInt(i2);
                    if (this.f173a.transact(2, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().onFailure(i, i2);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.BluetoothLeObserver
            public void onPinAvailable(String str) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f172a);
                    obtain.writeString(str);
                    if (this.f173a.transact(5, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().onPinAvailable(str);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.BluetoothLeObserver
            public void onServerAddressSent() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f172a);
                    if (this.f173a.transact(8, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().onServerAddressSent();
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.BluetoothLeObserver
            public void onServerInfoReceived(String str, String str2, String str3, int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f172a);
                    obtain.writeString(str);
                    obtain.writeString(str2);
                    obtain.writeString(str3);
                    obtain.writeInt(i);
                    if (this.f173a.transact(6, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().onServerInfoReceived(str, str2, str3, i);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ble.BluetoothLeObserver
            public void onSuccess(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(b.f172a);
                    obtain.writeInt(i);
                    if (this.f173a.transact(1, obtain, obtain2, 0) || b.a() == null) {
                        obtain2.readException();
                    } else {
                        b.a().onSuccess(i);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }
        }

        public b() {
            attachInterface(this, f172a);
        }

        public static BluetoothLeObserver a() {
            return a.b;
        }

        public static BluetoothLeObserver a(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface queryLocalInterface = iBinder.queryLocalInterface(f172a);
            return (queryLocalInterface == null || !(queryLocalInterface instanceof BluetoothLeObserver)) ? new a(iBinder) : (BluetoothLeObserver) queryLocalInterface;
        }

        public static boolean a(BluetoothLeObserver bluetoothLeObserver) {
            if (a.b != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            } else if (bluetoothLeObserver == null) {
                return false;
            } else {
                a.b = bluetoothLeObserver;
                return true;
            }
        }

        public IBinder asBinder() {
            return this;
        }

        @Override // android.os.Binder
        public boolean onTransact(int i2, Parcel parcel, Parcel parcel2, int i3) throws RemoteException {
            if (i2 != 1598968902) {
                Device device = null;
                switch (i2) {
                    case 1:
                        parcel.enforceInterface(f172a);
                        onSuccess(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case 2:
                        parcel.enforceInterface(f172a);
                        onFailure(parcel.readInt(), parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case 3:
                        parcel.enforceInterface(f172a);
                        if (parcel.readInt() != 0) {
                            device = Device.CREATOR.createFromParcel(parcel);
                        }
                        onDeviceMatch(device);
                        parcel2.writeNoException();
                        return true;
                    case 4:
                        parcel.enforceInterface(f172a);
                        if (parcel.readInt() != 0) {
                            device = Device.CREATOR.createFromParcel(parcel);
                        }
                        onDeviceLost(device);
                        parcel2.writeNoException();
                        return true;
                    case 5:
                        parcel.enforceInterface(f172a);
                        onPinAvailable(parcel.readString());
                        parcel2.writeNoException();
                        return true;
                    case 6:
                        parcel.enforceInterface(f172a);
                        onServerInfoReceived(parcel.readString(), parcel.readString(), parcel.readString(), parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case 7:
                        parcel.enforceInterface(f172a);
                        onClientInfoReceived(parcel.readString(), parcel.readString(), parcel.readString(), parcel.readInt(), parcel.readString(), parcel.readInt(), parcel.readString(), parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case 8:
                        parcel.enforceInterface(f172a);
                        onServerAddressSent();
                        parcel2.writeNoException();
                        return true;
                    default:
                        return super.onTransact(i2, parcel, parcel2, i3);
                }
            } else {
                parcel2.writeString(f172a);
                return true;
            }
        }
    }

    void onClientInfoReceived(String str, String str2, String str3, int i, String str4, int i2, String str5, int i3) throws RemoteException;

    void onDeviceLost(Device device) throws RemoteException;

    void onDeviceMatch(Device device) throws RemoteException;

    void onFailure(int i, int i2) throws RemoteException;

    void onPinAvailable(String str) throws RemoteException;

    void onServerAddressSent() throws RemoteException;

    void onServerInfoReceived(String str, String str2, String str3, int i) throws RemoteException;

    void onSuccess(int i) throws RemoteException;
}
