package com.share.connect;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ShareLinkObserver extends IInterface {

    public static class Default implements ShareLinkObserver {
        public IBinder asBinder() {
            return null;
        }

        @Override // com.share.connect.ShareLinkObserver
        public void onAuthenticationOk() throws RemoteException {
        }

        @Override // com.share.connect.ShareLinkObserver
        public void onConnectFailed(int i) throws RemoteException {
        }

        @Override // com.share.connect.ShareLinkObserver
        public void onConnected() throws RemoteException {
        }

        @Override // com.share.connect.ShareLinkObserver
        public void onDeviceDiscover(boolean z, Device device) throws RemoteException {
        }

        @Override // com.share.connect.ShareLinkObserver
        public void onDisconnected(boolean z) throws RemoteException {
        }

        @Override // com.share.connect.ShareLinkObserver
        public void onOpenResult(boolean z) throws RemoteException {
        }

        @Override // com.share.connect.ShareLinkObserver
        public void onProgress(int i) throws RemoteException {
        }

        @Override // com.share.connect.ShareLinkObserver
        public void onReconfigureWifi(WifiOwnerConfig wifiOwnerConfig) throws RemoteException {
        }

        @Override // com.share.connect.ShareLinkObserver
        public void onScanResult(boolean z) throws RemoteException {
        }

        @Override // com.share.connect.ShareLinkObserver
        public int onSelectWorkMode(int i) throws RemoteException {
            return 0;
        }

        @Override // com.share.connect.ShareLinkObserver
        public void onUserInterventionNeeded(boolean z) throws RemoteException {
        }

        @Override // com.share.connect.ShareLinkObserver
        public void receivedClientAddress(String str, int i) throws RemoteException {
        }

        @Override // com.share.connect.ShareLinkObserver
        public void receivedClientHello(String str, String str2, String str3, String str4, int i) throws RemoteException {
        }

        @Override // com.share.connect.ShareLinkObserver
        public void receivedClientInfo(String str) throws RemoteException {
        }
    }

    public static abstract class Stub extends Binder implements ShareLinkObserver {
        private static final String DESCRIPTOR = "com.share.connect.ShareLinkObserver";
        public static final int TRANSACTION_onAuthenticationOk = 8;
        public static final int TRANSACTION_onConnectFailed = 11;
        public static final int TRANSACTION_onConnected = 5;
        public static final int TRANSACTION_onDeviceDiscover = 3;
        public static final int TRANSACTION_onDisconnected = 10;
        public static final int TRANSACTION_onOpenResult = 1;
        public static final int TRANSACTION_onProgress = 12;
        public static final int TRANSACTION_onReconfigureWifi = 9;
        public static final int TRANSACTION_onScanResult = 2;
        public static final int TRANSACTION_onSelectWorkMode = 14;
        public static final int TRANSACTION_onUserInterventionNeeded = 13;
        public static final int TRANSACTION_receivedClientAddress = 6;
        public static final int TRANSACTION_receivedClientHello = 7;
        public static final int TRANSACTION_receivedClientInfo = 4;

        public static class Proxy implements ShareLinkObserver {
            public static ShareLinkObserver sDefaultImpl;
            private IBinder mRemote;

            public Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override // com.share.connect.ShareLinkObserver
            public void onAuthenticationOk() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (this.mRemote.transact(8, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().onAuthenticationOk();
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ShareLinkObserver
            public void onConnectFailed(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    if (this.mRemote.transact(11, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().onConnectFailed(i);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ShareLinkObserver
            public void onConnected() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (this.mRemote.transact(5, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().onConnected();
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ShareLinkObserver
            public void onDeviceDiscover(boolean z, Device device) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(z ? 1 : 0);
                    if (device != null) {
                        obtain.writeInt(1);
                        device.writeToParcel(obtain, 0);
                    } else {
                        obtain.writeInt(0);
                    }
                    if (this.mRemote.transact(3, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().onDeviceDiscover(z, device);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ShareLinkObserver
            public void onDisconnected(boolean z) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(z ? 1 : 0);
                    if (this.mRemote.transact(10, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().onDisconnected(z);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ShareLinkObserver
            public void onOpenResult(boolean z) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(z ? 1 : 0);
                    if (this.mRemote.transact(1, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().onOpenResult(z);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ShareLinkObserver
            public void onProgress(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    if (this.mRemote.transact(12, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().onProgress(i);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ShareLinkObserver
            public void onReconfigureWifi(WifiOwnerConfig wifiOwnerConfig) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (wifiOwnerConfig != null) {
                        obtain.writeInt(1);
                        wifiOwnerConfig.writeToParcel(obtain, 0);
                    } else {
                        obtain.writeInt(0);
                    }
                    if (this.mRemote.transact(9, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                        if (obtain2.readInt() != 0) {
                            wifiOwnerConfig.readFromParcel(obtain2);
                        }
                    } else {
                        Stub.getDefaultImpl().onReconfigureWifi(wifiOwnerConfig);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ShareLinkObserver
            public void onScanResult(boolean z) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(z ? 1 : 0);
                    if (this.mRemote.transact(2, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().onScanResult(z);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ShareLinkObserver
            public int onSelectWorkMode(int i) throws RemoteException {
                int readInt;
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    if (this.mRemote.transact(14, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                        readInt = obtain2.readInt();
                    } else {
                        readInt = Stub.getDefaultImpl().onSelectWorkMode(i);
                    }
                    return readInt;
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ShareLinkObserver
            public void onUserInterventionNeeded(boolean z) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(z ? 1 : 0);
                    if (this.mRemote.transact(13, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().onUserInterventionNeeded(z);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ShareLinkObserver
            public void receivedClientAddress(String str, int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeString(str);
                    obtain.writeInt(i);
                    if (this.mRemote.transact(6, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().receivedClientAddress(str, i);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ShareLinkObserver
            public void receivedClientHello(String str, String str2, String str3, String str4, int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeString(str);
                    obtain.writeString(str2);
                    obtain.writeString(str3);
                    obtain.writeString(str4);
                    obtain.writeInt(i);
                    if (this.mRemote.transact(7, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().receivedClientHello(str, str2, str3, str4, i);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.ShareLinkObserver
            public void receivedClientInfo(String str) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeString(str);
                    if (this.mRemote.transact(4, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().receivedClientInfo(str);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }
        }

        public Stub() {
            attachInterface(this, DESCRIPTOR);
        }

        public static ShareLinkObserver asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface queryLocalInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            return (queryLocalInterface == null || !(queryLocalInterface instanceof ShareLinkObserver)) ? new Proxy(iBinder) : (ShareLinkObserver) queryLocalInterface;
        }

        public static ShareLinkObserver getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        public static boolean setDefaultImpl(ShareLinkObserver shareLinkObserver) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            } else if (shareLinkObserver == null) {
                return false;
            } else {
                Proxy.sDefaultImpl = shareLinkObserver;
                return true;
            }
        }

        public IBinder asBinder() {
            return this;
        }

        @Override // android.os.Binder
        public boolean onTransact(int i, Parcel parcel, Parcel parcel2, int i2) throws RemoteException {
            if (i != 1598968902) {
                Device device = null;
                WifiOwnerConfig wifiOwnerConfig = null;
                boolean z = false;
                switch (i) {
                    case 1:
                        parcel.enforceInterface(DESCRIPTOR);
                        if (parcel.readInt() != 0) {
                            z = true;
                        }
                        onOpenResult(z);
                        parcel2.writeNoException();
                        return true;
                    case 2:
                        parcel.enforceInterface(DESCRIPTOR);
                        if (parcel.readInt() != 0) {
                            z = true;
                        }
                        onScanResult(z);
                        parcel2.writeNoException();
                        return true;
                    case 3:
                        parcel.enforceInterface(DESCRIPTOR);
                        if (parcel.readInt() != 0) {
                            z = true;
                        }
                        if (parcel.readInt() != 0) {
                            device = Device.CREATOR.createFromParcel(parcel);
                        }
                        onDeviceDiscover(z, device);
                        parcel2.writeNoException();
                        return true;
                    case 4:
                        parcel.enforceInterface(DESCRIPTOR);
                        receivedClientInfo(parcel.readString());
                        parcel2.writeNoException();
                        return true;
                    case 5:
                        parcel.enforceInterface(DESCRIPTOR);
                        onConnected();
                        parcel2.writeNoException();
                        return true;
                    case 6:
                        parcel.enforceInterface(DESCRIPTOR);
                        receivedClientAddress(parcel.readString(), parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case 7:
                        parcel.enforceInterface(DESCRIPTOR);
                        receivedClientHello(parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case 8:
                        parcel.enforceInterface(DESCRIPTOR);
                        onAuthenticationOk();
                        parcel2.writeNoException();
                        return true;
                    case 9:
                        parcel.enforceInterface(DESCRIPTOR);
                        if (parcel.readInt() != 0) {
                            wifiOwnerConfig = WifiOwnerConfig.CREATOR.createFromParcel(parcel);
                        }
                        onReconfigureWifi(wifiOwnerConfig);
                        parcel2.writeNoException();
                        if (wifiOwnerConfig != null) {
                            parcel2.writeInt(1);
                            wifiOwnerConfig.writeToParcel(parcel2, 1);
                        } else {
                            parcel2.writeInt(0);
                        }
                        return true;
                    case 10:
                        parcel.enforceInterface(DESCRIPTOR);
                        if (parcel.readInt() != 0) {
                            z = true;
                        }
                        onDisconnected(z);
                        parcel2.writeNoException();
                        return true;
                    case 11:
                        parcel.enforceInterface(DESCRIPTOR);
                        onConnectFailed(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case 12:
                        parcel.enforceInterface(DESCRIPTOR);
                        onProgress(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    case 13:
                        parcel.enforceInterface(DESCRIPTOR);
                        if (parcel.readInt() != 0) {
                            z = true;
                        }
                        onUserInterventionNeeded(z);
                        parcel2.writeNoException();
                        return true;
                    case 14:
                        parcel.enforceInterface(DESCRIPTOR);
                        int onSelectWorkMode = onSelectWorkMode(parcel.readInt());
                        parcel2.writeNoException();
                        parcel2.writeInt(onSelectWorkMode);
                        return true;
                    default:
                        return super.onTransact(i, parcel, parcel2, i2);
                }
            } else {
                parcel2.writeString(DESCRIPTOR);
                return true;
            }
        }
    }

    void onAuthenticationOk() throws RemoteException;

    void onConnectFailed(int i) throws RemoteException;

    void onConnected() throws RemoteException;

    void onDeviceDiscover(boolean z, Device device) throws RemoteException;

    void onDisconnected(boolean z) throws RemoteException;

    void onOpenResult(boolean z) throws RemoteException;

    void onProgress(int i) throws RemoteException;

    void onReconfigureWifi(WifiOwnerConfig wifiOwnerConfig) throws RemoteException;

    void onScanResult(boolean z) throws RemoteException;

    int onSelectWorkMode(int i) throws RemoteException;

    void onUserInterventionNeeded(boolean z) throws RemoteException;

    void receivedClientAddress(String str, int i) throws RemoteException;

    void receivedClientHello(String str, String str2, String str3, String str4, int i) throws RemoteException;

    void receivedClientInfo(String str) throws RemoteException;
}
