package com.share.connect;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.share.connect.ShareLinkObserver;
import java.util.Map;

public interface IShareLinkManager extends IInterface {

    public static class Default implements IShareLinkManager {
        public IBinder asBinder() {
            return null;
        }

        @Override // com.share.connect.IShareLinkManager
        public void close() throws RemoteException {
        }

        @Override // com.share.connect.IShareLinkManager
        public void connect(String str) throws RemoteException {
        }

        @Override // com.share.connect.IShareLinkManager
        public void disconnect() throws RemoteException {
        }

        @Override // com.share.connect.IShareLinkManager
        public void disconnectBle() throws RemoteException {
        }

        @Override // com.share.connect.IShareLinkManager
        public void enableUsbDeviceScanning(boolean z) throws RemoteException {
        }

        @Override // com.share.connect.IShareLinkManager
        public Map getDevicesSignal(int i, int i2) throws RemoteException {
            return null;
        }

        @Override // com.share.connect.IShareLinkManager
        public boolean isDeviceInMatch(String str) throws RemoteException {
            return false;
        }

        @Override // com.share.connect.IShareLinkManager
        public void open(boolean z, int i, int[] iArr, boolean z2, int i2, String str, String str2, boolean z3, boolean z4, String str3) throws RemoteException {
        }

        @Override // com.share.connect.IShareLinkManager
        public void registerLinkObserver(ShareLinkObserver shareLinkObserver) throws RemoteException {
        }

        @Override // com.share.connect.IShareLinkManager
        public void startScan() throws RemoteException {
        }

        @Override // com.share.connect.IShareLinkManager
        public void stopAdvertise() throws RemoteException {
        }

        @Override // com.share.connect.IShareLinkManager
        public void stopScan() throws RemoteException {
        }

        @Override // com.share.connect.IShareLinkManager
        public void unregisterLinkObserver(ShareLinkObserver shareLinkObserver) throws RemoteException {
        }

        @Override // com.share.connect.IShareLinkManager
        public void updateDayOrNightMode(int i) throws RemoteException {
        }

        @Override // com.share.connect.IShareLinkManager
        public void updatePinCode(String str) throws RemoteException {
        }
    }

    public static abstract class Stub extends Binder implements IShareLinkManager {
        private static final String DESCRIPTOR = "com.share.connect.IShareLinkManager";
        public static final int TRANSACTION_close = 2;
        public static final int TRANSACTION_connect = 8;
        public static final int TRANSACTION_disconnect = 9;
        public static final int TRANSACTION_disconnectBle = 10;
        public static final int TRANSACTION_enableUsbDeviceScanning = 7;
        public static final int TRANSACTION_getDevicesSignal = 6;
        public static final int TRANSACTION_isDeviceInMatch = 5;
        public static final int TRANSACTION_open = 1;
        public static final int TRANSACTION_registerLinkObserver = 11;
        public static final int TRANSACTION_startScan = 3;
        public static final int TRANSACTION_stopAdvertise = 13;
        public static final int TRANSACTION_stopScan = 4;
        public static final int TRANSACTION_unregisterLinkObserver = 12;
        public static final int TRANSACTION_updateDayOrNightMode = 15;
        public static final int TRANSACTION_updatePinCode = 14;

        public static class Proxy implements IShareLinkManager {
            public static IShareLinkManager sDefaultImpl;
            private IBinder mRemote;

            public Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override // com.share.connect.IShareLinkManager
            public void close() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (this.mRemote.transact(2, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().close();
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.IShareLinkManager
            public void connect(String str) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeString(str);
                    if (this.mRemote.transact(8, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().connect(str);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.IShareLinkManager
            public void disconnect() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (this.mRemote.transact(9, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().disconnect();
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.IShareLinkManager
            public void disconnectBle() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (this.mRemote.transact(10, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().disconnectBle();
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.IShareLinkManager
            public void enableUsbDeviceScanning(boolean z) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(z ? 1 : 0);
                    if (this.mRemote.transact(7, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().enableUsbDeviceScanning(z);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.IShareLinkManager
            public Map getDevicesSignal(int i, int i2) throws RemoteException {
                Map readHashMap;
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    obtain.writeInt(i2);
                    if (this.mRemote.transact(6, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                        readHashMap = obtain2.readHashMap(getClass().getClassLoader());
                    } else {
                        readHashMap = Stub.getDefaultImpl().getDevicesSignal(i, i2);
                    }
                    return readHashMap;
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override // com.share.connect.IShareLinkManager
            public boolean isDeviceInMatch(String str) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeString(str);
                    boolean z = false;
                    if (!this.mRemote.transact(5, obtain, obtain2, 0) && Stub.getDefaultImpl() != null) {
                        return Stub.getDefaultImpl().isDeviceInMatch(str);
                    }
                    obtain2.readException();
                    if (obtain2.readInt() != 0) {
                        z = true;
                    }
                    obtain2.recycle();
                    obtain.recycle();
                    return z;
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.IShareLinkManager
            public void open(boolean z, int i, int[] iArr, boolean z2, int i2, String str, String str2, boolean z3, boolean z4, String str3) throws RemoteException {
                Throwable th;
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(z ? 1 : 0);
                    obtain.writeInt(i);
                    obtain.writeIntArray(iArr);
                    obtain.writeInt(z2 ? 1 : 0);
                    obtain.writeInt(i2);
                    obtain.writeString(str);
                    obtain.writeString(str2);
                    obtain.writeInt(z3 ? 1 : 0);
                    obtain.writeInt(z4 ? 1 : 0);
                    obtain.writeString(str3);
                    try {
                        if (this.mRemote.transact(1, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                            obtain2.readException();
                        } else {
                            Stub.getDefaultImpl().open(z, i, iArr, z2, i2, str, str2, z3, z4, str3);
                        }
                        obtain2.recycle();
                        obtain.recycle();
                    } catch (Throwable th2) {
                        th = th2;
                        obtain2.recycle();
                        obtain.recycle();
                        throw th;
                    }
                } catch (Throwable th3) {
                    th = th3;
                    obtain2.recycle();
                    obtain.recycle();
                    throw th;
                }
            }

            @Override // com.share.connect.IShareLinkManager
            public void registerLinkObserver(ShareLinkObserver shareLinkObserver) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeStrongBinder(shareLinkObserver != null ? shareLinkObserver.asBinder() : null);
                    if (this.mRemote.transact(11, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().registerLinkObserver(shareLinkObserver);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.IShareLinkManager
            public void startScan() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (this.mRemote.transact(3, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().startScan();
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.IShareLinkManager
            public void stopAdvertise() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (this.mRemote.transact(13, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().stopAdvertise();
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.IShareLinkManager
            public void stopScan() throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (this.mRemote.transact(4, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().stopScan();
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.IShareLinkManager
            public void unregisterLinkObserver(ShareLinkObserver shareLinkObserver) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeStrongBinder(shareLinkObserver != null ? shareLinkObserver.asBinder() : null);
                    if (this.mRemote.transact(12, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().unregisterLinkObserver(shareLinkObserver);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.IShareLinkManager
            public void updateDayOrNightMode(int i) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeInt(i);
                    if (this.mRemote.transact(15, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().updateDayOrNightMode(i);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }

            @Override // com.share.connect.IShareLinkManager
            public void updatePinCode(String str) throws RemoteException {
                Parcel obtain = Parcel.obtain();
                Parcel obtain2 = Parcel.obtain();
                try {
                    obtain.writeInterfaceToken(Stub.DESCRIPTOR);
                    obtain.writeString(str);
                    if (this.mRemote.transact(14, obtain, obtain2, 0) || Stub.getDefaultImpl() == null) {
                        obtain2.readException();
                    } else {
                        Stub.getDefaultImpl().updatePinCode(str);
                    }
                } finally {
                    obtain2.recycle();
                    obtain.recycle();
                }
            }
        }

        public Stub() {
            attachInterface(this, DESCRIPTOR);
        }

        public static IShareLinkManager asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface queryLocalInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            return (queryLocalInterface == null || !(queryLocalInterface instanceof IShareLinkManager)) ? new Proxy(iBinder) : (IShareLinkManager) queryLocalInterface;
        }

        public static IShareLinkManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        public static boolean setDefaultImpl(IShareLinkManager iShareLinkManager) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            } else if (iShareLinkManager == null) {
                return false;
            } else {
                Proxy.sDefaultImpl = iShareLinkManager;
                return true;
            }
        }

        public IBinder asBinder() {
            return this;
        }

        @Override // android.os.Binder
        public boolean onTransact(int i, Parcel parcel, Parcel parcel2, int i2) throws RemoteException {
            if (i != 1598968902) {
                boolean z = false;
                switch (i) {
                    case 1:
                        parcel.enforceInterface(DESCRIPTOR);
                        open(parcel.readInt() != 0, parcel.readInt(), parcel.createIntArray(), parcel.readInt() != 0, parcel.readInt(), parcel.readString(), parcel.readString(), parcel.readInt() != 0, parcel.readInt() != 0, parcel.readString());
                        parcel2.writeNoException();
                        return true;
                    case 2:
                        parcel.enforceInterface(DESCRIPTOR);
                        close();
                        parcel2.writeNoException();
                        return true;
                    case 3:
                        parcel.enforceInterface(DESCRIPTOR);
                        startScan();
                        parcel2.writeNoException();
                        return true;
                    case 4:
                        parcel.enforceInterface(DESCRIPTOR);
                        stopScan();
                        parcel2.writeNoException();
                        return true;
                    case 5:
                        parcel.enforceInterface(DESCRIPTOR);
                        boolean isDeviceInMatch = isDeviceInMatch(parcel.readString());
                        parcel2.writeNoException();
                        parcel2.writeInt(isDeviceInMatch ? 1 : 0);
                        return true;
                    case 6:
                        parcel.enforceInterface(DESCRIPTOR);
                        Map devicesSignal = getDevicesSignal(parcel.readInt(), parcel.readInt());
                        parcel2.writeNoException();
                        parcel2.writeMap(devicesSignal);
                        return true;
                    case 7:
                        parcel.enforceInterface(DESCRIPTOR);
                        if (parcel.readInt() != 0) {
                            z = true;
                        }
                        enableUsbDeviceScanning(z);
                        parcel2.writeNoException();
                        return true;
                    case 8:
                        parcel.enforceInterface(DESCRIPTOR);
                        connect(parcel.readString());
                        parcel2.writeNoException();
                        return true;
                    case 9:
                        parcel.enforceInterface(DESCRIPTOR);
                        disconnect();
                        parcel2.writeNoException();
                        return true;
                    case 10:
                        parcel.enforceInterface(DESCRIPTOR);
                        disconnectBle();
                        parcel2.writeNoException();
                        return true;
                    case 11:
                        parcel.enforceInterface(DESCRIPTOR);
                        registerLinkObserver(ShareLinkObserver.Stub.asInterface(parcel.readStrongBinder()));
                        parcel2.writeNoException();
                        return true;
                    case 12:
                        parcel.enforceInterface(DESCRIPTOR);
                        unregisterLinkObserver(ShareLinkObserver.Stub.asInterface(parcel.readStrongBinder()));
                        parcel2.writeNoException();
                        return true;
                    case 13:
                        parcel.enforceInterface(DESCRIPTOR);
                        stopAdvertise();
                        parcel2.writeNoException();
                        return true;
                    case 14:
                        parcel.enforceInterface(DESCRIPTOR);
                        updatePinCode(parcel.readString());
                        parcel2.writeNoException();
                        return true;
                    case 15:
                        parcel.enforceInterface(DESCRIPTOR);
                        updateDayOrNightMode(parcel.readInt());
                        parcel2.writeNoException();
                        return true;
                    default:
                        return super.onTransact(i, parcel, parcel2, i2);
                }
            } else {
                parcel2.writeString(DESCRIPTOR);
                return true;
            }
        }
    }

    void close() throws RemoteException;

    void connect(String str) throws RemoteException;

    void disconnect() throws RemoteException;

    void disconnectBle() throws RemoteException;

    void enableUsbDeviceScanning(boolean z) throws RemoteException;

    Map getDevicesSignal(int i, int i2) throws RemoteException;

    boolean isDeviceInMatch(String str) throws RemoteException;

    void open(boolean z, int i, int[] iArr, boolean z2, int i2, String str, String str2, boolean z3, boolean z4, String str3) throws RemoteException;

    void registerLinkObserver(ShareLinkObserver shareLinkObserver) throws RemoteException;

    void startScan() throws RemoteException;

    void stopAdvertise() throws RemoteException;

    void stopScan() throws RemoteException;

    void unregisterLinkObserver(ShareLinkObserver shareLinkObserver) throws RemoteException;

    void updateDayOrNightMode(int i) throws RemoteException;

    void updatePinCode(String str) throws RemoteException;
}
