package com.google.crypto.tink.shaded.protobuf;

public final class DiscardUnknownFieldsParser {
    public static final <T extends Message> Parser<T> wrap(final Parser<T> parser) {
        return new AbstractParser<T>() {
            /* class com.google.crypto.tink.shaded.protobuf.DiscardUnknownFieldsParser.AnonymousClass1 */

            @Override // com.google.crypto.tink.shaded.protobuf.Parser
            public T parsePartialFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
                try {
                    codedInputStream.discardUnknownFields();
                    return (T) ((Message) Parser.this.parsePartialFrom(codedInputStream, extensionRegistryLite));
                } finally {
                    codedInputStream.unsetDiscardUnknownFields();
                }
            }
        };
    }

    private DiscardUnknownFieldsParser() {
    }
}
