package com.google.crypto.tink.shaded.protobuf;

import com.google.crypto.tink.shaded.protobuf.Descriptors;
import com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3;
import com.google.crypto.tink.shaded.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class BytesValue extends GeneratedMessageV3 implements BytesValueOrBuilder {
    private static final BytesValue DEFAULT_INSTANCE = new BytesValue();
    private static final Parser<BytesValue> PARSER = new AbstractParser<BytesValue>() {
        /* class com.google.crypto.tink.shaded.protobuf.BytesValue.AnonymousClass1 */

        @Override // com.google.crypto.tink.shaded.protobuf.Parser
        public BytesValue parsePartialFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return new BytesValue(codedInputStream, extensionRegistryLite);
        }
    };
    public static final int VALUE_FIELD_NUMBER = 1;
    private static final long serialVersionUID = 0;
    private byte memoizedIsInitialized;
    private ByteString value_;

    private BytesValue(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
        this.memoizedIsInitialized = -1;
    }

    private BytesValue() {
        this.memoizedIsInitialized = -1;
        this.value_ = ByteString.EMPTY;
    }

    /* access modifiers changed from: protected */
    @Override // com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3
    public Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unusedPrivateParameter) {
        return new BytesValue();
    }

    @Override // com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3, com.google.crypto.tink.shaded.protobuf.MessageOrBuilder
    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private BytesValue(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        this();
        Objects.requireNonNull(extensionRegistryLite);
        UnknownFieldSet.Builder newBuilder = UnknownFieldSet.newBuilder();
        boolean z = false;
        while (!z) {
            try {
                int readTag = codedInputStream.readTag();
                if (readTag != 0) {
                    if (readTag == 10) {
                        this.value_ = codedInputStream.readBytes();
                    } else if (!parseUnknownField(codedInputStream, newBuilder, extensionRegistryLite, readTag)) {
                    }
                }
                z = true;
            } catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(this);
            } catch (IOException e2) {
                throw new InvalidProtocolBufferException(e2).setUnfinishedMessage(this);
            } catch (Throwable th) {
                this.unknownFields = newBuilder.build();
                makeExtensionsImmutable();
                throw th;
            }
        }
        this.unknownFields = newBuilder.build();
        makeExtensionsImmutable();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return WrappersProto.internal_static_google_protobuf_BytesValue_descriptor;
    }

    /* access modifiers changed from: protected */
    @Override // com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3
    public GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return WrappersProto.internal_static_google_protobuf_BytesValue_fieldAccessorTable.ensureFieldAccessorsInitialized(BytesValue.class, Builder.class);
    }

    @Override // com.google.crypto.tink.shaded.protobuf.BytesValueOrBuilder
    public ByteString getValue() {
        return this.value_;
    }

    @Override // com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3, com.google.crypto.tink.shaded.protobuf.AbstractMessage, com.google.crypto.tink.shaded.protobuf.MessageLiteOrBuilder
    public final boolean isInitialized() {
        byte b = this.memoizedIsInitialized;
        if (b == 1) {
            return true;
        }
        if (b == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    @Override // com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3, com.google.crypto.tink.shaded.protobuf.AbstractMessage, com.google.crypto.tink.shaded.protobuf.MessageLite
    public void writeTo(CodedOutputStream codedOutputStream) throws IOException {
        if (!this.value_.isEmpty()) {
            codedOutputStream.writeBytes(1, this.value_);
        }
        this.unknownFields.writeTo(codedOutputStream);
    }

    @Override // com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3, com.google.crypto.tink.shaded.protobuf.AbstractMessage, com.google.crypto.tink.shaded.protobuf.MessageLite
    public int getSerializedSize() {
        int i = this.memoizedSize;
        if (i != -1) {
            return i;
        }
        int i2 = 0;
        if (!this.value_.isEmpty()) {
            i2 = 0 + CodedOutputStream.computeBytesSize(1, this.value_);
        }
        int serializedSize = i2 + this.unknownFields.getSerializedSize();
        this.memoizedSize = serializedSize;
        return serializedSize;
    }

    @Override // com.google.crypto.tink.shaded.protobuf.Message, com.google.crypto.tink.shaded.protobuf.AbstractMessage
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BytesValue)) {
            return super.equals(obj);
        }
        BytesValue bytesValue = (BytesValue) obj;
        if (getValue().equals(bytesValue.getValue()) && this.unknownFields.equals(bytesValue.unknownFields)) {
            return true;
        }
        return false;
    }

    @Override // com.google.crypto.tink.shaded.protobuf.Message, com.google.crypto.tink.shaded.protobuf.AbstractMessage
    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hashCode = ((((((779 + getDescriptor().hashCode()) * 37) + 1) * 53) + getValue().hashCode()) * 29) + this.unknownFields.hashCode();
        this.memoizedHashCode = hashCode;
        return hashCode;
    }

    public static BytesValue parseFrom(ByteBuffer byteBuffer) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(byteBuffer);
    }

    public static BytesValue parseFrom(ByteBuffer byteBuffer, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(byteBuffer, extensionRegistryLite);
    }

    public static BytesValue parseFrom(ByteString byteString) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(byteString);
    }

    public static BytesValue parseFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(byteString, extensionRegistryLite);
    }

    public static BytesValue parseFrom(byte[] bArr) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(bArr);
    }

    public static BytesValue parseFrom(byte[] bArr, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(bArr, extensionRegistryLite);
    }

    public static BytesValue parseFrom(InputStream inputStream) throws IOException {
        return (BytesValue) GeneratedMessageV3.parseWithIOException(PARSER, inputStream);
    }

    public static BytesValue parseFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        return (BytesValue) GeneratedMessageV3.parseWithIOException(PARSER, inputStream, extensionRegistryLite);
    }

    public static BytesValue parseDelimitedFrom(InputStream inputStream) throws IOException {
        return (BytesValue) GeneratedMessageV3.parseDelimitedWithIOException(PARSER, inputStream);
    }

    public static BytesValue parseDelimitedFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        return (BytesValue) GeneratedMessageV3.parseDelimitedWithIOException(PARSER, inputStream, extensionRegistryLite);
    }

    public static BytesValue parseFrom(CodedInputStream codedInputStream) throws IOException {
        return (BytesValue) GeneratedMessageV3.parseWithIOException(PARSER, codedInputStream);
    }

    public static BytesValue parseFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        return (BytesValue) GeneratedMessageV3.parseWithIOException(PARSER, codedInputStream, extensionRegistryLite);
    }

    @Override // com.google.crypto.tink.shaded.protobuf.Message, com.google.crypto.tink.shaded.protobuf.Message, com.google.crypto.tink.shaded.protobuf.MessageLite
    public Builder newBuilderForType() {
        return newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(BytesValue bytesValue) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(bytesValue);
    }

    @Override // com.google.crypto.tink.shaded.protobuf.Message, com.google.crypto.tink.shaded.protobuf.Message, com.google.crypto.tink.shaded.protobuf.MessageLite
    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    /* access modifiers changed from: protected */
    @Override // com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3
    public Builder newBuilderForType(GeneratedMessageV3.BuilderParent builderParent) {
        return new Builder(builderParent);
    }

    public static final class Builder extends GeneratedMessageV3.Builder<Builder> implements BytesValueOrBuilder {
        private ByteString value_;

        @Override // com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.MessageLiteOrBuilder
        public final boolean isInitialized() {
            return true;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return WrappersProto.internal_static_google_protobuf_BytesValue_descriptor;
        }

        /* access modifiers changed from: protected */
        @Override // com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder
        public GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return WrappersProto.internal_static_google_protobuf_BytesValue_fieldAccessorTable.ensureFieldAccessorsInitialized(BytesValue.class, Builder.class);
        }

        private Builder() {
            this.value_ = ByteString.EMPTY;
            maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent builderParent) {
            super(builderParent);
            this.value_ = ByteString.EMPTY;
            maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            boolean z = GeneratedMessageV3.alwaysUseFieldBuilders;
        }

        @Override // com.google.crypto.tink.shaded.protobuf.AbstractMessage.Builder, com.google.crypto.tink.shaded.protobuf.AbstractMessage.Builder, com.google.crypto.tink.shaded.protobuf.AbstractMessage.Builder, com.google.crypto.tink.shaded.protobuf.Message.Builder, com.google.crypto.tink.shaded.protobuf.Message.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.MessageLite.Builder
        public Builder clear() {
            super.clear();
            this.value_ = ByteString.EMPTY;
            return this;
        }

        @Override // com.google.crypto.tink.shaded.protobuf.Message.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.MessageOrBuilder
        public Descriptors.Descriptor getDescriptorForType() {
            return WrappersProto.internal_static_google_protobuf_BytesValue_descriptor;
        }

        @Override // com.google.crypto.tink.shaded.protobuf.MessageLiteOrBuilder, com.google.crypto.tink.shaded.protobuf.MessageOrBuilder, com.google.crypto.tink.shaded.protobuf.MessageOrBuilder
        public BytesValue getDefaultInstanceForType() {
            return BytesValue.getDefaultInstance();
        }

        @Override // com.google.crypto.tink.shaded.protobuf.Message.Builder, com.google.crypto.tink.shaded.protobuf.Message.Builder, com.google.crypto.tink.shaded.protobuf.MessageLite.Builder
        public BytesValue build() {
            BytesValue buildPartial = buildPartial();
            if (buildPartial.isInitialized()) {
                return buildPartial;
            }
            throw newUninitializedMessageException((Message) buildPartial);
        }

        @Override // com.google.crypto.tink.shaded.protobuf.Message.Builder, com.google.crypto.tink.shaded.protobuf.Message.Builder, com.google.crypto.tink.shaded.protobuf.MessageLite.Builder
        public BytesValue buildPartial() {
            BytesValue bytesValue = new BytesValue(this);
            bytesValue.value_ = this.value_;
            onBuilt();
            return bytesValue;
        }

        @Override // com.google.crypto.tink.shaded.protobuf.AbstractMessageLite.Builder, com.google.crypto.tink.shaded.protobuf.AbstractMessageLite.Builder, com.google.crypto.tink.shaded.protobuf.AbstractMessageLite.Builder, com.google.crypto.tink.shaded.protobuf.AbstractMessage.Builder, com.google.crypto.tink.shaded.protobuf.AbstractMessage.Builder, com.google.crypto.tink.shaded.protobuf.AbstractMessage.Builder, com.google.crypto.tink.shaded.protobuf.AbstractMessage.Builder, com.google.crypto.tink.shaded.protobuf.AbstractMessage.Builder, com.google.crypto.tink.shaded.protobuf.Message.Builder, com.google.crypto.tink.shaded.protobuf.Message.Builder, java.lang.Object, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.MessageLite.Builder
        public Builder clone() {
            return (Builder) super.clone();
        }

        @Override // com.google.crypto.tink.shaded.protobuf.Message.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder
        public Builder setField(Descriptors.FieldDescriptor fieldDescriptor, Object obj) {
            return (Builder) super.setField(fieldDescriptor, obj);
        }

        @Override // com.google.crypto.tink.shaded.protobuf.Message.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder
        public Builder clearField(Descriptors.FieldDescriptor fieldDescriptor) {
            return (Builder) super.clearField(fieldDescriptor);
        }

        @Override // com.google.crypto.tink.shaded.protobuf.AbstractMessage.Builder, com.google.crypto.tink.shaded.protobuf.AbstractMessage.Builder, com.google.crypto.tink.shaded.protobuf.Message.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder
        public Builder clearOneof(Descriptors.OneofDescriptor oneofDescriptor) {
            return (Builder) super.clearOneof(oneofDescriptor);
        }

        @Override // com.google.crypto.tink.shaded.protobuf.Message.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder
        public Builder setRepeatedField(Descriptors.FieldDescriptor fieldDescriptor, int i, Object obj) {
            return (Builder) super.setRepeatedField(fieldDescriptor, i, obj);
        }

        @Override // com.google.crypto.tink.shaded.protobuf.Message.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder
        public Builder addRepeatedField(Descriptors.FieldDescriptor fieldDescriptor, Object obj) {
            return (Builder) super.addRepeatedField(fieldDescriptor, obj);
        }

        @Override // com.google.crypto.tink.shaded.protobuf.AbstractMessage.Builder, com.google.crypto.tink.shaded.protobuf.AbstractMessage.Builder, com.google.crypto.tink.shaded.protobuf.Message.Builder
        public Builder mergeFrom(Message message) {
            if (message instanceof BytesValue) {
                return mergeFrom((BytesValue) message);
            }
            super.mergeFrom(message);
            return this;
        }

        public Builder mergeFrom(BytesValue bytesValue) {
            if (bytesValue == BytesValue.getDefaultInstance()) {
                return this;
            }
            if (bytesValue.getValue() != ByteString.EMPTY) {
                setValue(bytesValue.getValue());
            }
            mergeUnknownFields(bytesValue.unknownFields);
            onChanged();
            return this;
        }

        /* JADX WARNING: Removed duplicated region for block: B:16:0x0023  */
        @Override // com.google.crypto.tink.shaded.protobuf.AbstractMessageLite.Builder, com.google.crypto.tink.shaded.protobuf.AbstractMessageLite.Builder, com.google.crypto.tink.shaded.protobuf.AbstractMessage.Builder, com.google.crypto.tink.shaded.protobuf.AbstractMessage.Builder, com.google.crypto.tink.shaded.protobuf.AbstractMessage.Builder, com.google.crypto.tink.shaded.protobuf.AbstractMessage.Builder, com.google.crypto.tink.shaded.protobuf.Message.Builder, com.google.crypto.tink.shaded.protobuf.Message.Builder, com.google.crypto.tink.shaded.protobuf.MessageLite.Builder
        public Builder mergeFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            Throwable th;
            BytesValue bytesValue;
            BytesValue bytesValue2 = null;
            try {
                BytesValue bytesValue3 = (BytesValue) BytesValue.PARSER.parsePartialFrom(codedInputStream, extensionRegistryLite);
                if (bytesValue3 != null) {
                    mergeFrom(bytesValue3);
                }
                return this;
            } catch (InvalidProtocolBufferException e) {
                bytesValue = (BytesValue) e.getUnfinishedMessage();
                throw e.unwrapIOException();
            } catch (Throwable th2) {
                th = th2;
                bytesValue2 = bytesValue;
                if (bytesValue2 != null) {
                }
                throw th;
            }
        }

        @Override // com.google.crypto.tink.shaded.protobuf.BytesValueOrBuilder
        public ByteString getValue() {
            return this.value_;
        }

        public Builder setValue(ByteString byteString) {
            Objects.requireNonNull(byteString);
            this.value_ = byteString;
            onChanged();
            return this;
        }

        public Builder clearValue() {
            this.value_ = BytesValue.getDefaultInstance().getValue();
            onChanged();
            return this;
        }

        @Override // com.google.crypto.tink.shaded.protobuf.Message.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder
        public final Builder setUnknownFields(UnknownFieldSet unknownFieldSet) {
            return (Builder) super.setUnknownFields(unknownFieldSet);
        }

        @Override // com.google.crypto.tink.shaded.protobuf.AbstractMessage.Builder, com.google.crypto.tink.shaded.protobuf.AbstractMessage.Builder, com.google.crypto.tink.shaded.protobuf.Message.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder, com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3.Builder
        public final Builder mergeUnknownFields(UnknownFieldSet unknownFieldSet) {
            return (Builder) super.mergeUnknownFields(unknownFieldSet);
        }
    }

    public static BytesValue getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static BytesValue of(ByteString byteString) {
        return newBuilder().setValue(byteString).build();
    }

    public static Parser<BytesValue> parser() {
        return PARSER;
    }

    @Override // com.google.crypto.tink.shaded.protobuf.GeneratedMessageV3, com.google.crypto.tink.shaded.protobuf.Message, com.google.crypto.tink.shaded.protobuf.MessageLite
    public Parser<BytesValue> getParserForType() {
        return PARSER;
    }

    @Override // com.google.crypto.tink.shaded.protobuf.MessageLiteOrBuilder, com.google.crypto.tink.shaded.protobuf.MessageOrBuilder, com.google.crypto.tink.shaded.protobuf.MessageOrBuilder
    public BytesValue getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }
}
