package com.google.crypto.tink.config;

public final class TinkFips {

    public enum AlgorithmFipsCompatibility {
        ALGORITHM_NOT_FIPS {
            @Override // com.google.crypto.tink.config.TinkFips.AlgorithmFipsCompatibility
            public boolean isCompatible() {
                return !TinkFipsStatus.useOnlyFips();
            }
        },
        ALGORITHM_REQUIRES_BORINGCRYPTO {
            @Override // com.google.crypto.tink.config.TinkFips.AlgorithmFipsCompatibility
            public boolean isCompatible() {
                return !TinkFipsStatus.useOnlyFips() || TinkFipsStatus.fipsModuleAvailable();
            }
        };

        public abstract boolean isCompatible();
    }

    public static boolean useOnlyFips() {
        return TinkFipsStatus.useOnlyFips();
    }

    public static boolean fipsModuleAvailable() {
        return TinkFipsStatus.fipsModuleAvailable();
    }

    private TinkFips() {
    }
}
