package com.google.common.util.concurrent;

import java.util.concurrent.locks.LockSupport;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

/* access modifiers changed from: package-private */
public final class OverflowAvoidingLockSupport {
    static final long MAX_NANOSECONDS_THRESHOLD = 2147483647999999999L;

    private OverflowAvoidingLockSupport() {
    }

    static void parkNanos(@NullableDecl Object obj, long j) {
        LockSupport.parkNanos(obj, Math.min(j, (long) MAX_NANOSECONDS_THRESHOLD));
    }
}
