package a.c.b.b0;

import a.c.b.g;
import a.c.b.k;
import com.google.common.primitives.Bytes;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class a {
    private static final String e = "SecurityManager";
    private static final int f = 4;
    private static final int g = 16;
    private static final Map<String, SecretKey> h = new ConcurrentHashMap();

    /* renamed from: a  reason: collision with root package name */
    private String f66a;
    private SecureRandom b;
    private Cipher c;
    private Cipher d;

    public a() {
        this("session_key");
    }

    public a(String str) {
        try {
            this.f66a = str;
            this.c = Cipher.getInstance("AES/GCM/NoPadding");
            this.d = Cipher.getInstance("AES/GCM/NoPadding");
            this.b = SecureRandom.getInstance("SHA1PRNG");
        } catch (Exception e2) {
            k.a().b(e, "Init SecurityManager error.", e2);
        }
    }

    private static int a(byte[] bArr, int i, int i2) {
        return ByteBuffer.wrap(bArr, i, i2).order(ByteOrder.BIG_ENDIAN).getInt();
    }

    private void a(SecretKey secretKey) {
        if (secretKey == null) {
            throw new SecurityException("no session key: " + this.f66a);
        } else if (this.d == null) {
            throw new SecurityException("encryption cipher is not created");
        } else if (this.b == null) {
            throw new SecurityException("random generator is not created");
        }
    }

    public static void a(byte[] bArr, String str) {
        h.put(str, new SecretKeySpec(bArr, "AES"));
    }

    private static byte[] a(int i) {
        return ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(i).array();
    }

    public static byte[] a(String str) {
        SecretKey secretKey = h.get(str);
        if (secretKey != null) {
            return secretKey.getEncoded();
        }
        return null;
    }

    public ByteBuffer a(ByteBuffer byteBuffer) {
        return a(byteBuffer, true);
    }

    public ByteBuffer a(ByteBuffer byteBuffer, boolean z) {
        if (byteBuffer == null || byteBuffer.remaining() == 0) {
            return g.b;
        }
        SecretKey secretKey = h.get(this.f66a);
        synchronized (this) {
            try {
                a(secretKey);
                int i = byteBuffer.getInt();
                byte[] a2 = g.a(i);
                byteBuffer.get(a2, 0, i);
                this.d.init(2, secretKey, new GCMParameterSpec(128, a2, 0, i));
                int i2 = byteBuffer.getInt();
                byte[] a3 = g.a(i2);
                byteBuffer.get(a3, 0, i2);
                int outputSize = this.d.getOutputSize(i2);
                ByteBuffer allocate = z ? ByteBuffer.allocate(outputSize) : g.b(outputSize);
                if (allocate == null) {
                    k.a().b(e, "decrypt: allocate buffer error:" + outputSize);
                    return g.b;
                }
                this.d.doFinal(ByteBuffer.wrap(a3, 0, i2), allocate);
                allocate.flip();
                return allocate;
            } catch (Exception e2) {
                k.a().b(e, "decrypt error.", e2);
                return g.b;
            }
        }
    }

    public byte[] a(byte[] bArr) {
        byte[] byteArray;
        SecretKey secretKey = h.get(this.f66a);
        synchronized (this) {
            try {
                a(secretKey);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int i = 0;
                while (i < bArr.length) {
                    int a2 = a(bArr, i, 4);
                    int i2 = i + 4;
                    this.d.init(2, secretKey, new GCMParameterSpec(128, bArr, i2, a2));
                    int i3 = i2 + a2;
                    int a3 = a(bArr, i3, 4);
                    byteArrayOutputStream.write(this.d.doFinal(bArr, i3 + 4, a3));
                    i += a2 + 4 + 4 + a3;
                }
                byteArray = byteArrayOutputStream.toByteArray();
            } catch (Exception e2) {
                k.a().b(e, "decrypt error.", e2);
                return new byte[0];
            } catch (Throwable th) {
                throw th;
            }
        }
        return byteArray;
    }

    public ByteBuffer b(ByteBuffer byteBuffer) {
        SecretKey secretKey = h.get(this.f66a);
        if (byteBuffer == null || byteBuffer.remaining() == 0) {
            return g.b;
        }
        synchronized (this) {
            try {
                a(secretKey);
                this.c.init(1, secretKey, this.b);
                byte[] iv = this.c.getIV();
                int outputSize = this.c.getOutputSize(byteBuffer.remaining());
                if (iv == null) {
                    throw new SecurityException("invalid IV for encryption");
                } else if (outputSize > 0) {
                    int length = iv.length + 4 + 4 + outputSize;
                    ByteBuffer b2 = g.b(length);
                    if (b2 == null) {
                        k.a().b(e, "encrypt: alloc buffer error:" + length);
                        return g.b;
                    }
                    b2.putInt(iv.length);
                    b2.put(iv);
                    b2.putInt(outputSize);
                    this.c.doFinal(byteBuffer, b2);
                    b2.flip();
                    return b2;
                } else {
                    throw new SecurityException("encryption returns nothing");
                }
            } catch (Exception e2) {
                k.a().b(e, "encrypt error.", e2);
                return g.b;
            }
        }
    }

    public byte[] b(byte[] bArr) {
        byte[] concat;
        SecretKey secretKey = h.get(this.f66a);
        synchronized (this) {
            try {
                a(secretKey);
                this.c.init(1, secretKey, this.b);
                byte[] iv = this.c.getIV();
                byte[] doFinal = this.c.doFinal(bArr);
                if (iv == null) {
                    throw new SecurityException("invalid IV for encryption");
                } else if (doFinal != null) {
                    concat = Bytes.concat(a(iv.length), iv, a(doFinal.length), doFinal);
                } else {
                    throw new SecurityException("encryption returns nothing");
                }
            } catch (Exception e2) {
                k.a().b(e, "encrypt error.", e2);
                return new byte[0];
            }
        }
        return concat;
    }
}
