package a.b.a.k;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.WifiP2pInfo;
import java.util.Collection;

public class d extends BroadcastReceiver {
    private static final String e = "WifiP2pStateReceiver";

    /* renamed from: a  reason: collision with root package name */
    private boolean f46a = false;
    private b b;
    private a c;
    private c d;

    public interface a {
        void a(WifiP2pInfo wifiP2pInfo, WifiP2pGroup wifiP2pGroup, NetworkInfo networkInfo);
    }

    public interface b {
        void a(WifiP2pDeviceList wifiP2pDeviceList);
    }

    public interface c {
        void a(WifiP2pDevice wifiP2pDevice);
    }

    private IntentFilter a() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.wifi.p2p.STATE_CHANGED");
        intentFilter.addAction("android.net.wifi.p2p.PEERS_CHANGED");
        intentFilter.addAction("android.net.wifi.p2p.CONNECTION_STATE_CHANGE");
        intentFilter.addAction("android.net.wifi.p2p.THIS_DEVICE_CHANGED");
        return intentFilter;
    }

    private String a(Collection<WifiP2pDevice> collection) {
        StringBuilder sb = new StringBuilder();
        if (collection != null && !collection.isEmpty()) {
            for (WifiP2pDevice wifiP2pDevice : collection) {
                sb.append(wifiP2pDevice.deviceName).append(", ").append(wifiP2pDevice.deviceAddress).append(", ").append(wifiP2pDevice.status).append("\n");
            }
        }
        return sb.toString();
    }

    public void a(a aVar) {
        this.c = aVar;
    }

    public void a(b bVar) {
        this.b = bVar;
    }

    public void a(c cVar) {
        this.d = cVar;
    }

    public synchronized void a(Context context, boolean z) {
        if (z) {
            if (this.f46a) {
                try {
                    context.getApplicationContext().unregisterReceiver(this);
                } catch (IllegalArgumentException e2) {
                    a.a.a.b.b(e, e2.toString());
                }
            }
            context.getApplicationContext().registerReceiver(this, a());
        } else {
            try {
                context.getApplicationContext().unregisterReceiver(this);
            } catch (IllegalArgumentException e3) {
                a.a.a.b.b(e, e3.toString());
            }
        }
        this.f46a = z;
    }

    public void onReceive(Context context, Intent intent) {
        String str;
        String action = intent.getAction();
        a.a.a.b.c(e, "WifiP2pStateReceiver: action:" + action + ", isInitialStickyBroadcast=" + isInitialStickyBroadcast());
        if ("android.net.wifi.p2p.STATE_CHANGED".equals(action)) {
            str = "onReceive: STATE_CHANGED " + intent.getIntExtra("wifi_p2p_state", -1);
        } else if ("android.net.wifi.p2p.PEERS_CHANGED".equals(action)) {
            WifiP2pDeviceList wifiP2pDeviceList = (WifiP2pDeviceList) intent.getParcelableExtra("wifiP2pDeviceList");
            if (wifiP2pDeviceList != null) {
                StringBuilder sb = new StringBuilder("Peers changed: ");
                for (WifiP2pDevice wifiP2pDevice : wifiP2pDeviceList.getDeviceList()) {
                    sb.append("\n").append(wifiP2pDevice.deviceAddress).append(" ").append(wifiP2pDevice.deviceName);
                }
                a.a.a.b.c(e, sb.toString());
                b bVar = this.b;
                if (bVar != null) {
                    bVar.a(wifiP2pDeviceList);
                    return;
                }
                return;
            }
            str = "onReceive: WIFI_P2P_PEERS_CHANGED_ACTION deviceList is null ";
        } else if ("android.net.wifi.p2p.CONNECTION_STATE_CHANGE".equals(action)) {
            WifiP2pInfo wifiP2pInfo = (WifiP2pInfo) intent.getParcelableExtra("wifiP2pInfo");
            WifiP2pGroup wifiP2pGroup = (WifiP2pGroup) intent.getParcelableExtra("p2pGroupInfo");
            NetworkInfo networkInfo = (NetworkInfo) intent.getParcelableExtra("networkInfo");
            boolean z = true;
            StringBuilder append = new StringBuilder().append("Null check: p2pInfo: ").append(wifiP2pInfo != null).append(", wifiP2pGroup: ").append(wifiP2pGroup != null).append(", networkInfo: ");
            if (networkInfo == null) {
                z = false;
            }
            a.a.a.b.c(e, append.append(z).toString());
            if (wifiP2pInfo != null) {
                a.a.a.b.c(e, "p2pInfo: groupFormed: " + wifiP2pInfo.groupFormed + ", isGroupOwner: " + wifiP2pInfo.isGroupOwner);
            }
            if (wifiP2pGroup != null) {
                a.a.a.b.c(e, "networkInfo: " + networkInfo + "\nwifiP2pGroup: " + wifiP2pGroup.getNetworkName() + ", " + (wifiP2pGroup.getOwner() != null ? wifiP2pGroup.getOwner().deviceAddress : "null") + "\nClient: " + a(wifiP2pGroup.getClientList()));
            }
            a aVar = this.c;
            if (aVar != null) {
                aVar.a(wifiP2pInfo, wifiP2pGroup, networkInfo);
                return;
            }
            return;
        } else if ("android.net.wifi.p2p.THIS_DEVICE_CHANGED".equals(action)) {
            WifiP2pDevice wifiP2pDevice2 = (WifiP2pDevice) intent.getParcelableExtra("wifiP2pDevice");
            if (wifiP2pDevice2 != null) {
                c cVar = this.d;
                if (cVar != null) {
                    cVar.a(wifiP2pDevice2);
                    return;
                }
                return;
            }
            a.a.a.b.a(e, "wifiP2pDevice is null");
            return;
        } else {
            return;
        }
        a.a.a.b.c(e, str);
    }
}
