package a.b.a.f;

import android.os.ParcelUuid;
import androidx.core.view.MotionEventCompat;
import androidx.core.view.ViewCompat;
import com.google.common.primitives.UnsignedBytes;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;

public class e {

    /* renamed from: a  reason: collision with root package name */
    public static final ParcelUuid f14a = ParcelUuid.fromString("00000000-0000-1000-8000-00805F9B34FB");
    public static final int b = 2;
    public static final int c = 4;
    public static final int d = 16;

    public static int a(ParcelUuid parcelUuid) {
        return (int) ((parcelUuid.getUuid().getMostSignificantBits() & -4294967296L) >>> 32);
    }

    public static ParcelUuid a(byte[] bArr) {
        long j;
        if (bArr != null) {
            int length = bArr.length;
            if (length != 2 && length != 4 && length != 16) {
                throw new IllegalArgumentException("uuidBytes length invalid - " + length);
            } else if (length == 16) {
                ByteBuffer order = ByteBuffer.wrap(bArr).order(ByteOrder.LITTLE_ENDIAN);
                return new ParcelUuid(new UUID(order.getLong(8), order.getLong(0)));
            } else {
                if (length == 2) {
                    j = ((long) (bArr[0] & UnsignedBytes.MAX_VALUE)) + ((long) ((bArr[1] & UnsignedBytes.MAX_VALUE) << 8));
                } else {
                    j = ((long) ((bArr[3] & UnsignedBytes.MAX_VALUE) << 24)) + ((long) (bArr[0] & UnsignedBytes.MAX_VALUE)) + ((long) ((bArr[1] & UnsignedBytes.MAX_VALUE) << 8)) + ((long) ((bArr[2] & UnsignedBytes.MAX_VALUE) << 16));
                }
                ParcelUuid parcelUuid = f14a;
                return new ParcelUuid(new UUID(parcelUuid.getUuid().getMostSignificantBits() + (j << 32), parcelUuid.getUuid().getLeastSignificantBits()));
            }
        } else {
            throw new IllegalArgumentException("uuidBytes cannot be null");
        }
    }

    public static boolean b(ParcelUuid parcelUuid) {
        UUID uuid = parcelUuid.getUuid();
        return uuid.getLeastSignificantBits() == f14a.getUuid().getLeastSignificantBits() && (uuid.getMostSignificantBits() & -281470681743361L) == 4096;
    }

    public static boolean c(ParcelUuid parcelUuid) {
        UUID uuid = parcelUuid.getUuid();
        return uuid.getLeastSignificantBits() == f14a.getUuid().getLeastSignificantBits() && !b(parcelUuid) && (uuid.getMostSignificantBits() & 4294967295L) == 4096;
    }

    public static byte[] d(ParcelUuid parcelUuid) {
        if (parcelUuid == null) {
            throw new IllegalArgumentException("uuid cannot be null");
        } else if (b(parcelUuid)) {
            int a2 = a(parcelUuid);
            return new byte[]{(byte) (a2 & 255), (byte) ((a2 & MotionEventCompat.ACTION_POINTER_INDEX_MASK) >> 8)};
        } else if (c(parcelUuid)) {
            int a3 = a(parcelUuid);
            return new byte[]{(byte) (a3 & 255), (byte) ((65280 & a3) >> 8), (byte) ((16711680 & a3) >> 16), (byte) ((a3 & ViewCompat.MEASURED_STATE_MASK) >> 24)};
        } else {
            long mostSignificantBits = parcelUuid.getUuid().getMostSignificantBits();
            long leastSignificantBits = parcelUuid.getUuid().getLeastSignificantBits();
            byte[] bArr = new byte[16];
            ByteBuffer order = ByteBuffer.wrap(bArr).order(ByteOrder.LITTLE_ENDIAN);
            order.putLong(8, mostSignificantBits);
            order.putLong(0, leastSignificantBits);
            return bArr;
        }
    }
}
